/*
 * Decompiled with CFR 0.152.
 */
package windows;

import Beans.ScripHistoryBean;
import Beans.ScripHistoryDetailBean;
import BeansContainer.ScripHistoryContainer;
import Utilities.LogsTC;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import com.google.gson.Gson;
import common.gui.component.NxGHeaderPanel;
import common.gui.component.NxGTable;
import common.gui.util.CompressManager;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import kse.gui.model.ScripHistoryModel;
import kse.gui.render.ScripHistoryRender;
import languages.LanguageCentre;
import languages.LanguageConstant;
import org.jdesktop.swingx.JXDatePicker;

public class ScripHistory
extends JPanel {
    private AutoCompleteSupport autoCom;
    private Vector<String> column = new Vector();
    private Vector<ScripHistoryBean> rows = new Vector();
    private ScripHistoryModel model = null;
    private ScripHistoryRender render = null;
    private AutoCompleteSupport autoCompleteScrip;
    Gson gson = new Gson();
    private LanguageCentre languageCentre = new LanguageCentre();
    private JButton btnGet;
    public JComboBox cbScrip;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JLabel lblAccount;
    private JLabel lblMaxChange;
    private JLabel lblMaxClose;
    private JLabel lblMaxDateChange;
    private JLabel lblMaxDateClose;
    private JLabel lblMaxDateHigh;
    private JLabel lblMaxDateLow;
    private JLabel lblMaxDateOpen;
    private JLabel lblMaxDateTotalVolume;
    private JLabel lblMaxHigh;
    private JLabel lblMaxLow;
    private JLabel lblMaxOpen;
    private JLabel lblMaxTotalVolume;
    private JLabel lblMinChange;
    private JLabel lblMinClose;
    private JLabel lblMinDateChange;
    private JLabel lblMinDateClose;
    private JLabel lblMinDateHigh;
    private JLabel lblMinDateLow;
    private JLabel lblMinDateOpen;
    private JLabel lblMinDateTotalVolume;
    private JLabel lblMinHigh;
    private JLabel lblMinLow;
    private JLabel lblMinOpen;
    private JLabel lblMinTotalVolume;
    private JLabel lblMsg;
    private NxGHeaderPanel pnlBG;
    private NxGHeaderPanel pnlMax;
    private NxGHeaderPanel pnlMaxDate;
    private NxGHeaderPanel pnlMin;
    private NxGHeaderPanel pnlMinDate;
    private NxGTable table;
    public JXDatePicker txtFromDate;
    public JXDatePicker txtToDate;

    public ScripHistory() {
        this.initComponents();
        this.initTable();
        this.txtFromDate.setFormats(new DateFormat[]{LogsTC.dateFormatAcc});
        this.txtToDate.setFormats(new DateFormat[]{LogsTC.dateFormatAcc});
        this.txtFromDate.setDate(new Date(System.currentTimeMillis()));
        this.txtToDate.setDate(new Date(System.currentTimeMillis()));
        this.pnlMin.setHeading("Minimum");
        this.pnlMinDate.setHeading("Date");
        this.pnlMax.setHeading("Maximum");
        this.pnlMaxDate.setHeading("Date");
        this.pnlMin.getHeaderIconLabelLeft().setVisible(false);
        this.pnlMinDate.getHeaderIconLabelLeft().setVisible(false);
        this.pnlMax.getHeaderIconLabelLeft().setVisible(false);
        this.pnlMaxDate.getHeaderIconLabelLeft().setVisible(false);
        this.pnlBG.getHeaderIconLabelLeft().setVisible(false);
        this.pnlMin.getHeaderIconLabelRigth().setVisible(false);
        this.pnlMinDate.getHeaderIconLabelRigth().setVisible(false);
        this.pnlMax.getHeaderIconLabelRigth().setVisible(false);
        this.pnlMaxDate.getHeaderIconLabelRigth().setVisible(false);
        this.pnlBG.getHeaderIconLabelRigth().setVisible(false);
        this.pnlMin.getSeparator().setVisible(false);
        this.pnlMinDate.getSeparator().setVisible(false);
        this.pnlMax.getSeparator().setVisible(false);
        this.pnlMaxDate.getSeparator().setVisible(false);
        this.pnlBG.getSeparator().setVisible(false);
        this.pnlBG.setGradientColor(UIManager.getDefaults().getColor("InternalFrame.activeTitleGradient"), UIManager.getDefaults().getColor("InternalFrame.activeTitleGradient").brighter());
        this.setAllScrip();
    }

    private void initTable() {
        this.column.add("Date");
        this.column.add("LDCP");
        this.column.add("Open");
        this.column.add("High");
        this.column.add("Low");
        this.column.add("Close");
        this.column.add("Total Volume");
        this.model = new ScripHistoryModel(this.rows, this.column);
        this.table.setModel((TableModel)this.model);
        this.table.setColumnControlVisible(true);
        this.table.setSelectionMode(0);
        this.table.setSortable(false);
        this.table.getTableHeader().setReorderingAllowed(true);
        this.setRender();
    }

    private void setRender() {
        this.render = new ScripHistoryRender();
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            this.table.getColumn(i).setCellRenderer((TableCellRenderer)this.render);
        }
    }

    public void setAllScrip() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (ScripHistory.this.autoCompleteScrip != null && ScripHistory.this.autoCompleteScrip.isInstalled()) {
                        ScripHistory.this.autoCompleteScrip.uninstall();
                    }
                    Vector allScrip = new Vector(LogCommon.SymbolAndSymbolName.keySet());
                    Collections.sort(allScrip);
                    ScripHistory.this.cbScrip.setModel(new DefaultComboBoxModel(allScrip));
                    ScripHistory.this.autoCompleteScrip = AutoCompleteSupport.install((JComboBox)ScripHistory.this.cbScrip, (EventList)GlazedLists.eventListOf((Object[])allScrip.toArray()));
                    ScripHistory.this.cbScrip.setSelectedIndex(0);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.table = new NxGTable();
        this.lblAccount = new JLabel();
        this.cbScrip = new JComboBox();
        this.btnGet = new JButton();
        this.lblMsg = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabel3 = new JLabel();
        this.txtFromDate = new JXDatePicker();
        this.jLabel4 = new JLabel();
        this.txtToDate = new JXDatePicker();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.lblMinDateTotalVolume = new JLabel();
        this.lblMinDateChange = new JLabel();
        this.lblMinDateOpen = new JLabel();
        this.lblMinDateHigh = new JLabel();
        this.lblMinDateLow = new JLabel();
        this.lblMinDateClose = new JLabel();
        this.lblMinTotalVolume = new JLabel();
        this.lblMinChange = new JLabel();
        this.lblMinOpen = new JLabel();
        this.lblMinHigh = new JLabel();
        this.lblMinLow = new JLabel();
        this.lblMinClose = new JLabel();
        this.lblMaxTotalVolume = new JLabel();
        this.lblMaxChange = new JLabel();
        this.lblMaxOpen = new JLabel();
        this.lblMaxHigh = new JLabel();
        this.lblMaxLow = new JLabel();
        this.lblMaxClose = new JLabel();
        this.lblMaxDateTotalVolume = new JLabel();
        this.lblMaxDateChange = new JLabel();
        this.lblMaxDateOpen = new JLabel();
        this.lblMaxDateHigh = new JLabel();
        this.lblMaxDateLow = new JLabel();
        this.lblMaxDateClose = new JLabel();
        this.pnlMaxDate = new NxGHeaderPanel();
        this.pnlMinDate = new NxGHeaderPanel();
        this.pnlMax = new NxGHeaderPanel();
        this.pnlMin = new NxGHeaderPanel();
        this.pnlBG = new NxGHeaderPanel();
        this.setLayout(null);
        this.table.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView((Component)this.table);
        this.add(this.jScrollPane1);
        this.jScrollPane1.setBounds(10, 35, 560, 220);
        this.lblAccount.setHorizontalAlignment(2);
        this.lblAccount.setText("Scrip");
        this.add(this.lblAccount);
        this.lblAccount.setBounds(10, 7, 40, 22);
        this.cbScrip.setEditable(true);
        this.cbScrip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScripHistory.this.cbScripActionPerformed(evt);
            }
        });
        this.add(this.cbScrip);
        this.cbScrip.setBounds(50, 7, 100, 22);
        this.btnGet.setIcon(new ImageIcon(this.getClass().getResource("/Images/get.png")));
        this.btnGet.setText("Get");
        this.btnGet.setMaximumSize(new Dimension(49, 22));
        this.btnGet.setMinimumSize(new Dimension(49, 22));
        this.btnGet.setName("ScripHistory -> btnGet");
        this.btnGet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScripHistory.this.btnGetActionPerformed(evt);
            }
        });
        this.add(this.btnGet);
        this.btnGet.setBounds(500, 7, 70, 22);
        this.add(this.lblMsg);
        this.lblMsg.setBounds(10, 450, 525, 16);
        this.add(this.jSeparator1);
        this.jSeparator1.setBounds(0, 440, 585, 2);
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText("From Date");
        this.add(this.jLabel3);
        this.jLabel3.setBounds(150, 7, 70, 22);
        this.txtFromDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScripHistory.this.txtFromDateActionPerformed(evt);
            }
        });
        this.add((Component)this.txtFromDate);
        this.txtFromDate.setBounds(220, 7, 110, 22);
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setText("To Date");
        this.add(this.jLabel4);
        this.jLabel4.setBounds(330, 7, 60, 22);
        this.txtToDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScripHistory.this.txtToDateActionPerformed(evt);
            }
        });
        this.add((Component)this.txtToDate);
        this.txtToDate.setBounds(390, 7, 110, 22);
        this.jPanel1.setLayout(null);
        this.jLabel1.setBackground(UIManager.getDefaults().getColor("InternalFrame.activeTitleGradient"));
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText(" Total Volume");
        this.jLabel1.setOpaque(true);
        this.jPanel1.add(this.jLabel1);
        this.jLabel1.setBounds(10, 140, 100, 20);
        this.jLabel6.setBackground(UIManager.getDefaults().getColor("InternalFrame.activeTitleGradient"));
        this.jLabel6.setFont(new Font("Tahoma", 1, 11));
        this.jLabel6.setText(" Open");
        this.jLabel6.setOpaque(true);
        this.jPanel1.add(this.jLabel6);
        this.jLabel6.setBounds(10, 60, 100, 20);
        this.jLabel7.setBackground(UIManager.getDefaults().getColor("InternalFrame.activeTitleGradient"));
        this.jLabel7.setFont(new Font("Tahoma", 1, 11));
        this.jLabel7.setText(" High");
        this.jLabel7.setOpaque(true);
        this.jPanel1.add(this.jLabel7);
        this.jLabel7.setBounds(10, 80, 100, 20);
        this.jLabel8.setBackground(UIManager.getDefaults().getColor("InternalFrame.activeTitleGradient"));
        this.jLabel8.setFont(new Font("Tahoma", 1, 11));
        this.jLabel8.setText(" Low");
        this.jLabel8.setOpaque(true);
        this.jPanel1.add(this.jLabel8);
        this.jLabel8.setBounds(10, 100, 100, 20);
        this.jLabel9.setBackground(UIManager.getDefaults().getColor("InternalFrame.activeTitleGradient"));
        this.jLabel9.setFont(new Font("Tahoma", 1, 11));
        this.jLabel9.setText(" Close");
        this.jLabel9.setOpaque(true);
        this.jPanel1.add(this.jLabel9);
        this.jLabel9.setBounds(10, 120, 100, 20);
        this.jLabel10.setBackground(UIManager.getDefaults().getColor("InternalFrame.activeTitleGradient"));
        this.jLabel10.setFont(new Font("Tahoma", 1, 11));
        this.jLabel10.setText("Change");
        this.jLabel10.setOpaque(true);
        this.jPanel1.add(this.jLabel10);
        this.jLabel10.setBounds(10, 40, 100, 20);
        this.lblMinDateTotalVolume.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jPanel1.add(this.lblMinDateTotalVolume);
        this.lblMinDateTotalVolume.setBounds(120, 140, 100, 20);
        this.lblMinDateChange.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jPanel1.add(this.lblMinDateChange);
        this.lblMinDateChange.setBounds(120, 40, 100, 20);
        this.lblMinDateOpen.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jPanel1.add(this.lblMinDateOpen);
        this.lblMinDateOpen.setBounds(120, 60, 100, 20);
        this.lblMinDateHigh.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jPanel1.add(this.lblMinDateHigh);
        this.lblMinDateHigh.setBounds(120, 80, 100, 20);
        this.lblMinDateLow.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jPanel1.add(this.lblMinDateLow);
        this.lblMinDateLow.setBounds(120, 100, 100, 20);
        this.lblMinDateClose.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jPanel1.add(this.lblMinDateClose);
        this.lblMinDateClose.setBounds(120, 120, 100, 20);
        this.lblMinTotalVolume.setForeground(new Color(255, 0, 0));
        this.lblMinTotalVolume.setHorizontalAlignment(4);
        this.lblMinTotalVolume.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jPanel1.add(this.lblMinTotalVolume);
        this.lblMinTotalVolume.setBounds(230, 140, 100, 20);
        this.lblMinChange.setForeground(new Color(255, 0, 0));
        this.lblMinChange.setHorizontalAlignment(4);
        this.lblMinChange.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jPanel1.add(this.lblMinChange);
        this.lblMinChange.setBounds(230, 40, 100, 20);
        this.lblMinOpen.setForeground(new Color(255, 0, 0));
        this.lblMinOpen.setHorizontalAlignment(4);
        this.lblMinOpen.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jPanel1.add(this.lblMinOpen);
        this.lblMinOpen.setBounds(230, 60, 100, 20);
        this.lblMinHigh.setForeground(new Color(255, 0, 0));
        this.lblMinHigh.setHorizontalAlignment(4);
        this.lblMinHigh.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jPanel1.add(this.lblMinHigh);
        this.lblMinHigh.setBounds(230, 80, 100, 20);
        this.lblMinLow.setForeground(new Color(255, 0, 0));
        this.lblMinLow.setHorizontalAlignment(4);
        this.lblMinLow.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jPanel1.add(this.lblMinLow);
        this.lblMinLow.setBounds(230, 100, 100, 20);
        this.lblMinClose.setForeground(new Color(255, 0, 0));
        this.lblMinClose.setHorizontalAlignment(4);
        this.lblMinClose.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jPanel1.add(this.lblMinClose);
        this.lblMinClose.setBounds(230, 120, 100, 20);
        this.lblMaxTotalVolume.setForeground(new Color(0, 153, 0));
        this.lblMaxTotalVolume.setHorizontalAlignment(4);
        this.lblMaxTotalVolume.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jPanel1.add(this.lblMaxTotalVolume);
        this.lblMaxTotalVolume.setBounds(340, 140, 100, 20);
        this.lblMaxChange.setForeground(new Color(0, 153, 0));
        this.lblMaxChange.setHorizontalAlignment(4);
        this.lblMaxChange.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jPanel1.add(this.lblMaxChange);
        this.lblMaxChange.setBounds(340, 40, 100, 20);
        this.lblMaxOpen.setForeground(new Color(0, 153, 0));
        this.lblMaxOpen.setHorizontalAlignment(4);
        this.lblMaxOpen.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jPanel1.add(this.lblMaxOpen);
        this.lblMaxOpen.setBounds(340, 60, 100, 20);
        this.lblMaxHigh.setForeground(new Color(0, 153, 0));
        this.lblMaxHigh.setHorizontalAlignment(4);
        this.lblMaxHigh.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jPanel1.add(this.lblMaxHigh);
        this.lblMaxHigh.setBounds(340, 80, 100, 20);
        this.lblMaxLow.setForeground(new Color(0, 153, 0));
        this.lblMaxLow.setHorizontalAlignment(4);
        this.lblMaxLow.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jPanel1.add(this.lblMaxLow);
        this.lblMaxLow.setBounds(340, 100, 100, 20);
        this.lblMaxClose.setForeground(new Color(0, 153, 0));
        this.lblMaxClose.setHorizontalAlignment(4);
        this.lblMaxClose.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jPanel1.add(this.lblMaxClose);
        this.lblMaxClose.setBounds(340, 120, 100, 20);
        this.lblMaxDateTotalVolume.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jPanel1.add(this.lblMaxDateTotalVolume);
        this.lblMaxDateTotalVolume.setBounds(450, 140, 100, 20);
        this.lblMaxDateChange.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jPanel1.add(this.lblMaxDateChange);
        this.lblMaxDateChange.setBounds(450, 40, 100, 20);
        this.lblMaxDateOpen.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jPanel1.add(this.lblMaxDateOpen);
        this.lblMaxDateOpen.setBounds(450, 60, 100, 20);
        this.lblMaxDateHigh.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jPanel1.add(this.lblMaxDateHigh);
        this.lblMaxDateHigh.setBounds(450, 80, 100, 20);
        this.lblMaxDateLow.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jPanel1.add(this.lblMaxDateLow);
        this.lblMaxDateLow.setBounds(450, 100, 100, 20);
        this.lblMaxDateClose.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204)));
        this.jPanel1.add(this.lblMaxDateClose);
        this.lblMaxDateClose.setBounds(450, 120, 100, 20);
        this.jPanel1.add((Component)this.pnlMaxDate);
        this.pnlMaxDate.setBounds(450, 10, 100, 31);
        this.jPanel1.add((Component)this.pnlMinDate);
        this.pnlMinDate.setBounds(120, 10, 100, 31);
        this.jPanel1.add((Component)this.pnlMax);
        this.pnlMax.setBounds(340, 10, 100, 31);
        this.jPanel1.add((Component)this.pnlMin);
        this.pnlMin.setBounds(230, 10, 100, 31);
        this.pnlBG.setBorder((Border)BorderFactory.createTitledBorder(null, "", 0, 0, new Font("Tahoma", 0, 11), new Color(204, 204, 204)));
        this.jPanel1.add((Component)this.pnlBG);
        this.pnlBG.setBounds(0, 0, 560, 170);
        this.add(this.jPanel1);
        this.jPanel1.setBounds(10, 260, 560, 170);
    }

    private void btnGetActionPerformed(ActionEvent evt) {
        this.getData();
    }

    private void cbScripActionPerformed(ActionEvent evt) {
        if (evt.getModifiers() == 16 || evt.getActionCommand().equalsIgnoreCase("comboBoxEdited")) {
            this.txtFromDate.requestFocus();
        }
    }

    private void txtFromDateActionPerformed(ActionEvent evt) {
        this.txtToDate.requestFocus();
    }

    private void txtToDateActionPerformed(ActionEvent evt) {
        this.getData();
    }

    private void getData() {
        if (this.checkValidate()) {
            new Thread("ScripHistory"){

                @Override
                public void run() {
                    try {
                        ScripHistory.this.clearAllValues();
                        Util.setMessage((JLabel)ScripHistory.this.lblMsg, (MessageType)MessageType.Loading, (String)ScripHistory.this.languageCentre.getValue(LanguageConstant.Loading));
                        String fromdate = LogsTC.dateFormatAcc.format(ScripHistory.this.txtFromDate.getDate());
                        String todate = LogsTC.dateFormatAcc.format(ScripHistory.this.txtToDate.getDate());
                        byte[] data = WebService.getInstance().getPort().getOrderHistory(LogCommon.UserID, ScripHistory.this.cbScrip.getSelectedItem().toString().trim(), fromdate, todate, "", "", "", "ScripHistory");
                        String result = CompressManager.unzipStringFromBytes((byte[])data);
                        ScripHistory.this.setData(result);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        Util.setMessage((JLabel)ScripHistory.this.lblMsg, (MessageType)MessageType.Error, (String)"Error in loading data");
                    }
                }
            }.start();
        }
    }

    private void clearAllValues() {
        this.rows.clear();
        this.tableDataChange();
        this.lblMinChange.setText("");
        this.lblMaxChange.setText("");
        this.lblMinDateChange.setText("");
        this.lblMaxDateChange.setText("");
        this.lblMinOpen.setText("");
        this.lblMaxOpen.setText("");
        this.lblMinDateOpen.setText("");
        this.lblMaxDateOpen.setText("");
        this.lblMinHigh.setText("");
        this.lblMaxHigh.setText("");
        this.lblMinDateHigh.setText("");
        this.lblMaxDateHigh.setText("");
        this.lblMinLow.setText("");
        this.lblMaxLow.setText("");
        this.lblMinDateLow.setText("");
        this.lblMaxDateLow.setText("");
        this.lblMinClose.setText("");
        this.lblMaxClose.setText("");
        this.lblMinDateClose.setText("");
        this.lblMaxDateClose.setText("");
        this.lblMinTotalVolume.setText("");
        this.lblMaxTotalVolume.setText("");
        this.lblMinDateTotalVolume.setText("");
        this.lblMaxDateTotalVolume.setText("");
    }

    private synchronized void setData(String result) {
        this.rows.clear();
        Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.EMPTY, (String)"");
        if (result != null) {
            ScripHistoryContainer c = (ScripHistoryContainer)this.gson.fromJson(result, ScripHistoryContainer.class);
            this.rows.addAll(c.list);
            for (int i = 0; i < c.listDetail.size(); ++i) {
                ScripHistoryDetailBean object = (ScripHistoryDetailBean)c.listDetail.get(i);
                if (object.getHead().equalsIgnoreCase("LDCP")) {
                    this.lblMinChange.setText(Util.format2digit((String)(object.getMin() + "")) + " ");
                    this.lblMaxChange.setText(Util.format2digit((String)(object.getMax() + "")) + " ");
                    this.lblMinDateChange.setText(" " + Util.formatDate((Date)object.getMinDate()));
                    this.lblMaxDateChange.setText(" " + Util.formatDate((Date)object.getMaxDate()));
                    continue;
                }
                if (object.getHead().equalsIgnoreCase("Open")) {
                    this.lblMinOpen.setText(Util.format2digit((String)(object.getMin() + "")) + " ");
                    this.lblMaxOpen.setText(Util.format2digit((String)(object.getMax() + "")) + " ");
                    this.lblMinDateOpen.setText(" " + Util.formatDate((Date)object.getMinDate()));
                    this.lblMaxDateOpen.setText(" " + Util.formatDate((Date)object.getMaxDate()));
                    continue;
                }
                if (object.getHead().equalsIgnoreCase("High")) {
                    this.lblMinHigh.setText(Util.format2digit((String)(object.getMin() + "")) + " ");
                    this.lblMaxHigh.setText(Util.format2digit((String)(object.getMax() + "")) + " ");
                    this.lblMinDateHigh.setText(" " + Util.formatDate((Date)object.getMinDate()));
                    this.lblMaxDateHigh.setText(" " + Util.formatDate((Date)object.getMaxDate()));
                    continue;
                }
                if (object.getHead().equalsIgnoreCase("Low")) {
                    this.lblMinLow.setText(Util.format2digit((String)(object.getMin() + "")) + " ");
                    this.lblMaxLow.setText(Util.format2digit((String)(object.getMax() + "")) + " ");
                    this.lblMinDateLow.setText(" " + Util.formatDate((Date)object.getMinDate()));
                    this.lblMaxDateLow.setText(" " + Util.formatDate((Date)object.getMaxDate()));
                    continue;
                }
                if (object.getHead().equalsIgnoreCase("Close")) {
                    this.lblMinClose.setText(Util.format2digit((String)(object.getMin() + "")) + " ");
                    this.lblMaxClose.setText(Util.format2digit((String)(object.getMax() + "")) + " ");
                    this.lblMinDateClose.setText(" " + Util.formatDate((Date)object.getMinDate()));
                    this.lblMaxDateClose.setText(" " + Util.formatDate((Date)object.getMaxDate()));
                    continue;
                }
                if (!object.getHead().equalsIgnoreCase("Total Volume")) continue;
                this.lblMinTotalVolume.setText(Util.format0digit((String)(object.getMin() + "")) + " ");
                this.lblMaxTotalVolume.setText(Util.format0digit((String)(object.getMax() + "")) + " ");
                this.lblMinDateTotalVolume.setText(" " + Util.formatDate((Date)object.getMinDate()));
                this.lblMaxDateTotalVolume.setText(" " + Util.formatDate((Date)object.getMaxDate()));
            }
            this.tableDataChange();
            if (this.rows.size() <= 0) {
                Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Information, (String)"No record found");
            }
        } else {
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Information, (String)"No record found");
        }
        this.tableDataChange();
    }

    private boolean checkValidate() {
        if (this.cbScrip.getSelectedItem() == null) {
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Information, (String)"Please select scrip");
            this.cbScrip.requestFocus();
            return true;
        }
        if (this.cbScrip.getSelectedItem().toString().trim().length() <= 0) {
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Information, (String)"Please select scrip");
            this.cbScrip.requestFocus();
            return true;
        }
        if (this.txtFromDate.getDate() == null) {
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Information, (String)"Please select From date.");
            this.txtFromDate.requestFocus();
            return false;
        }
        if (this.txtToDate.getDate() == null) {
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Information, (String)"Please select To date.");
            this.txtFromDate.requestFocus();
            return false;
        }
        if (this.txtToDate.getDate().compareTo(this.txtFromDate.getDate()) < 0) {
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Error, (String)"From date should be greater then or equal to To date.");
            this.txtFromDate.requestFocus();
            return false;
        }
        return true;
    }

    private void tableDataChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.model.fireTableDataChanged();
            this.table.addNotify();
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScripHistory.this.model.fireTableDataChanged();
                    ScripHistory.this.table.addNotify();
                    ScripHistory.this.table.repaint();
                }
            });
        }
    }
}

