/*
 * Decompiled with CFR 0.152.
 */
package windows;

import CustomComponent.ToolBarArrowButton;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import Utilities.LoginStatus;
import Utilities.UtilTC;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.ImageUtil;
import common.gui.util.LogCommon;
import common.gui.util.LoginMode;
import common.gui.util.Title;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import kse.util.LogsKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;
import pmex.gui.util.LogsPMEX;

public class ToolBar
extends JToolBar {
    private static final String CLOCK_FONT_RESOURCE = "DS-DIGIB.TTF";
    public TradeCast tradeCast = null;
    private Mediator mediator = Mediator.getInstance();
    private JLabel userName;
    JPopupMenu HouseMenu = new JPopupMenu();
    private boolean isSwitch = true;
    public Icon ProfileSwitch = new ImageIcon(this.getClass().getResource("/Images/switch16.png"));
    private ArrayList unremoveButton = new ArrayList();
    public JToggleButton btnProfileSwitch = new JToggleButton();
    private LanguageCentre languageCentre = new LanguageCentre();

    public ToolBar() {
        this.tradeCast = TradeCast.getInstance();
        this.setFloatable(false);
        this.setRollover(true);
        this.setPreferredSize(new Dimension(8000, 25));
        this.userName = new JLabel(LogCommon.UserID);
        this.userName.setForeground(new Color(167, 47, 31));
        if (AppConfig.loginMode == LoginMode.KSEPMEX) {
            this.setSwitchButton();
            this.SetCommonButtonTop();
            if (LogCommon.toolBarProfile.equalsIgnoreCase("PMEX")) {
                this.initPMEX();
                this.setCommonButtonBottom();
            } else {
                this.initKSE();
                this.setCommonButtonBottom();
            }
        } else if (AppConfig.loginMode == LoginMode.KSE) {
            this.SetCommonButtonTop();
            this.initKSE();
            this.setCommonButtonBottom();
        } else if (AppConfig.loginMode == LoginMode.PMEX) {
            this.SetCommonButtonTop();
            this.initPMEX();
            this.setCommonButtonBottom();
        }
    }

    private void initKSE() {
        int ScreenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        this.add(this.CreateToolBarButton("/Images/Buy.png", FormName.Buy, LanguageConstant.Buy, true, this.languageCentre.getValue(LanguageConstant.Buy) + " (F4)"));
        this.add(this.CreateToolBarButton("/Images/Sell.png", FormName.Sell, LanguageConstant.Sell, true, this.languageCentre.getValue(LanguageConstant.Sell) + " (F5)"));
        this.addSeparator();
        this.add(this.CreateToolBarButton("/Images/bunchOrders.png", FormName.BunchOrder, LanguageConstant.BunchOrder, true, this.languageCentre.getValue(LanguageConstant.BunchOrder) + " (F6)"));
        if (AppConfig.isShortSell) {
            this.add(this.CreateToolBarButton("/Images/ShortSell.png", FormName.ShortSell, LanguageConstant.ShortSell, true, this.languageCentre.getValue(LanguageConstant.ShortSell) + " (F8)"));
            this.addSeparator();
        }
        this.add(this.CreateToolBarButton("/Images/Change.png", FormName.ChangeOrder, LanguageConstant.ChangeOrder, true, this.languageCentre.getValue(LanguageConstant.ChangeOrder) + " (F9)"));
        this.addSeparator();
        this.add(this.CreateToolBarButton("/Images/Cancel.png", FormName.Cancel, LanguageConstant.Cancel, true, this.languageCentre.getValue(LanguageConstant.Cancel) + " (F11)"));
        this.addSeparator();
        this.add(this.CreateToolBarButton("/Images/MBP.png", FormName.MBP, LanguageConstant.MarketDepthByPrice, false, this.languageCentre.getValue(LanguageConstant.MarketDepthByPrice) + " (Ctrl + F2)"));
        this.add(this.CreateToolBarButton("/Images/MBO.png", FormName.MBO, LanguageConstant.MarketDepthByOrder, false, this.languageCentre.getValue(LanguageConstant.MarketDepthByOrder) + " (Ctrl + F3)"));
        this.add(this.CreateToolBarButton("/Images/detailQuote.png", FormName.DetailedQuote, LanguageConstant.DetailedQuote, true, this.languageCentre.getValue(LanguageConstant.DetailedQuote) + " (Ctrl + F4)"));
        this.addSeparator();
        if (ScreenWidth > 1024) {
            this.add(this.CreateToolBarButton("/Images/symDetail2.png", FormName.ScripBrowse, LanguageConstant.ScripBrowse, true, this.languageCentre.getValue(LanguageConstant.ScripBrowse) + " (F3)"));
            this.add(this.CreateToolBarButton("/Images/topMovers.png", FormName.TopMovers, LanguageConstant.Top30Movers, true, this.languageCentre.getValue(LanguageConstant.Top30Movers) + " (Ctrl + T)"));
            this.add(this.CreateToolBarButton("/Images/sectorPer.png", FormName.SectorPerformance, LanguageConstant.SectorPerformance, true, this.languageCentre.getValue(LanguageConstant.SectorPerformance) + " (Ctrl + S)"));
            this.addSeparator();
        }
        this.add(this.CreateToolBarButton("/Images/ExposureWatch.png", FormName.ExposureWatch, LanguageConstant.ExposureWatch, true, this.languageCentre.getValue(LanguageConstant.ExposureWatch) + " (F2)"));
        this.addSeparator();
        this.add(this.CreateToolBarButton("/Images/OutstandingLog.png", FormName.OutstandingLog, LanguageConstant.OutstandingLog, false, this.languageCentre.getValue(LanguageConstant.OutstandingLog) + " (Ctrl + F5)"));
        this.add(this.CreateToolBarButton("/Images/TradeLog.png", FormName.TradeLog, LanguageConstant.TradeLog, false, this.languageCentre.getValue(LanguageConstant.TradeLog) + " (Ctrl + F6)"));
        this.add(this.CreateToolBarButton("/Images/ActivityLog.png", FormName.ActivityLog, LanguageConstant.ActivityLog, false, this.languageCentre.getValue(LanguageConstant.ActivityLog) + " (Ctrl + F7)"));
        this.add(this.CreateToolBarButton("/Images/dailyRept.png", FormName.DailyReport, LanguageConstant.DailyTradeReport, true, this.languageCentre.getValue(LanguageConstant.DailyTradeReport) + " (Ctrl + F8)"));
        this.addSeparator();
        if (AppConfig.isAccountStatement) {
            this.add(this.CreateToolBarButton("/Images/accountStatement.png", FormName.AccountStatement, LanguageConstant.AccountStatement, true, this.languageCentre.getValue(LanguageConstant.AccountStatement) + " (Alt + A)"));
        }
        if (AppConfig.isOrderHistory) {
            this.add(this.CreateToolBarButton("/Images/orderHistory.png", FormName.OrderHistory, LanguageConstant.OrderHistory, true, this.languageCentre.getValue(LanguageConstant.OrderHistory) + " (Alt + O)"));
        }
        if (AppConfig.isCashWithdrawal) {
            this.add(this.CreateToolBarButton("/Images/withdrawlStatement.png", FormName.WithDrawStatement, LanguageConstant.CashWithdrawalStatement, true, this.languageCentre.getValue(LanguageConstant.CashWithdrawalStatement) + " (Alt + W)"));
            this.addSeparator();
            this.add(this.CreateToolBarButton("/Images/WithdrawlRequest.png", FormName.WithdrawlRequest, LanguageConstant.CashWithdrawalRequest, true, this.languageCentre.getValue(LanguageConstant.CashWithdrawalRequest) + " (Alt + R)"));
        }
        if (AppConfig.JSinternalBankFundTransfer) {
            this.add(this.CreateToolBarButton("/Images/MenuFundTransfer.png", FormName.JSinternalBankFundTransfer, LanguageConstant.JSinternalBankFundTransfer, true, this.languageCentre.getValue(LanguageConstant.JSinternalBankFundTransfer)));
        }
        this.addSeparator();
        if (AppConfig.GraphURL.length() > 0) {
            ToolBarArrowButton btn = new ToolBarArrowButton(5);
            btn.setToolTipText(this.languageCentre.getValue(LanguageConstant.GraphsAndCharts) + " (Ctrl + G)");
            btn.RegisterPopMenu(new String[]{LanguageConstant.ScripGraph, LanguageConstant.IndexGraph}, new String[]{"/Images/scripgraph.png", "/Images/indexgraph.png"});
            btn.addListener(new ToolBarArrowButton.ArrowButtonActionListener(){

                @Override
                public void popupActionPerformed(ToolBarArrowButton.ArrowButtonActionEvent e) {
                }

                @Override
                public void actionPerformed(ToolBarArrowButton.ArrowButtonActionEvent e) {
                    if (e.Text.equalsIgnoreCase(LanguageConstant.ScripGraph)) {
                        ToolBar.this.tradeCast.ShowGraphWindow(FormName.GraphsAndCharts, LanguageConstant.GraphsAndCharts, "", "");
                    } else if (e.Text.equalsIgnoreCase(LanguageConstant.IndexGraph)) {
                        ToolBar.this.tradeCast.ShowGraphWindow(FormName.IndexGraph, LanguageConstant.IndexGraph, "", "");
                    }
                }
            });
            this.add(btn);
        }
        this.addSeparator();
    }

    private void initPMEX() {
        this.add(this.CreateToolBarButton("/common/gui/images/marketWatch16.png", FormName.PMEX_MarketWatch, "Commodity Watches", false, "Commodity Watches (Shift + F12)"));
        this.add(this.CreateToolBarButton("/common/gui/images/matrix16.png", FormName.PMEX_Matrix, Title.PMEX_Matirx, false, Title.PMEX_Matirx + " (Shift + F11)"));
        this.add(this.CreateToolBarButton("/Images/message.png", FormName.MessageWindow, LanguageConstant.MessageWindow, false, this.languageCentre.getValue(LanguageConstant.MessageWindow) + " (Ctrl + F12)"));
        this.addSeparator();
        this.add(this.CreateToolBarButton("/common/gui/images/bid16.png", FormName.PMEX_Buy, Title.PMEX_Buy, true, Title.PMEX_Buy + " (Shift + F4)"));
        this.add(this.CreateToolBarButton("/common/gui/images/ask16.png", FormName.PMEX_Sell, Title.PMEX_Sell, true, Title.PMEX_Sell + " (Shift + F5)"));
        this.addSeparator();
        this.add(this.CreateToolBarButton("/pmex/gui/images/fastOrder16x16.png", FormName.PMEX_FastOrder, Title.PMEX_FastOrder, true, Title.PMEX_FastOrder + " (Shift + F6)"));
        this.addSeparator();
        this.add(this.CreateToolBarButton("/common/gui/images/marketDeptByPrice16.png", FormName.PMEX_MBP, Title.PMEX_MarketDepthByPrice, true, Title.PMEX_MarketDepthByPrice + " (Alt + F2)"));
        this.setLadderWindow();
        this.addSeparator();
        this.add(this.CreateToolBarButton("/common/gui/images/topMovers16.png", FormName.PMEX_TopMovers, Title.PMEX_TopMovers, true, Title.PMEX_TopMovers + " (Alt + T)"));
        this.add(this.CreateToolBarButton("/common/gui/images/contractBrowse16.png", FormName.ContractBrowse, Title.PMEX_ContractBrowse, true, Title.PMEX_ContractBrowse + " (Shift + F3)"));
        this.addSeparator();
        this.add(this.CreateToolBarButton("/common/gui/images/netposition16x16.png", FormName.PMEX_BuyingPower, Title.PMEX_BuyingPower, true, Title.PMEX_BuyingPower + " (Shift + F2)"));
        this.add(this.CreateToolBarButton("/pmex/gui/images/riskWatch16x16.png", FormName.PMEX_RiskWatch, Title.PMEX_RiskWatch, true, Title.PMEX_RiskWatch + ""));
        this.addSeparator();
        this.add(this.CreateToolBarButton("/common/gui/images/workingOrders16.png", FormName.PMEX_WorkingOrder, Title.PMEX_WorkingOrder, false, Title.PMEX_WorkingOrder + " (Alt + F5)"));
        this.add(this.CreateToolBarButton("/common/gui/images/tradedOrders16.png", FormName.PMEX_TradeOrder, Title.PMEX_TradedOrder, false, Title.PMEX_TradedOrder + " (Alt + F6)"));
        this.add(this.CreateToolBarButton("/common/gui/images/orderActivity16.png", FormName.PMEX_OrderActivity, Title.PMEX_OrderActivity, false, Title.PMEX_OrderActivity + " (Alt + F7)"));
        this.addSeparator();
    }

    private void setLadderWindow() {
        if (AppConfig.loginMode == LoginMode.PMEX) {
            this.add(this.CreateToolBarButton("/common/gui/images/ladder16.png", FormName.PMEX_Ladder_Dock, Title.PMEX_Ladder_Dock, false, Title.PMEX_Ladder_Dock + " "));
        } else if (AppConfig.loginMode == LoginMode.KSEPMEX) {
            this.add(this.CreateToolBarButton("/common/gui/images/ladder16.png", FormName.PMEX_Ladder, Title.PMEX_Ladder, true, Title.PMEX_Ladder + " (Alt + F3) "));
        }
    }

    private void setSwitchButton() {
        try {
            if (LogCommon.toolBarProfile.equalsIgnoreCase("PMEX")) {
                this.btnProfileSwitch.setSelected(true);
                this.isSwitch = false;
                this.btnProfileSwitch.setToolTipText("Switch to Equity Toolbar");
            } else {
                this.btnProfileSwitch.setToolTipText("Switch to Commodity Toolbar");
            }
            this.btnProfileSwitch.setFocusable(false);
            this.btnProfileSwitch.setHorizontalTextPosition(2);
            this.btnProfileSwitch.setMaximumSize(new Dimension(25, 25));
            this.btnProfileSwitch.setMinimumSize(new Dimension(25, 25));
            this.btnProfileSwitch.setPreferredSize(new Dimension(25, 25));
            this.btnProfileSwitch.setVerticalTextPosition(1);
            this.btnProfileSwitch.setIcon(this.ProfileSwitch);
            this.btnProfileSwitch.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    ToolBar.this.switchProfile(ToolBar.this.isSwitch);
                    ToolBar.this.isSwitch = !ToolBar.this.isSwitch;
                }
            });
            this.add(this.btnProfileSwitch);
            JSeparator sep = new JSeparator(1);
            sep.setMaximumSize(new Dimension(3, 20));
            this.add(sep);
            this.unremoveButton.add(this.btnProfileSwitch);
            this.unremoveButton.add(sep);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void SetCommonButtonTop() {
        JButton btnPre = this.CreateToolBarButton("/Images/prefrences.png", FormName.Prefernces, LanguageConstant.Preferences, true, this.languageCentre.getValue(LanguageConstant.Preferences) + " (Ctrl + P)");
        JButton btnCngPass = this.CreateToolBarButton("/Images/password.png", FormName.Prefernces, LanguageConstant.ChangePassword, true, this.languageCentre.getValue(LanguageConstant.ChangePassword) + " (Alt + P)");
        JButton btnCngPIN = this.CreateToolBarButton("/Images/pincode.png", FormName.Prefernces, LanguageConstant.ChangePIN, true, this.languageCentre.getValue(LanguageConstant.ChangePIN) + " (Alt + C)");
        JSeparator sep = new JSeparator(1);
        sep.setMaximumSize(new Dimension(3, 20));
        this.add(btnPre);
        this.add(btnCngPass);
        this.add(btnCngPIN);
        this.add(sep);
        this.unremoveButton.add(btnPre);
        this.unremoveButton.add(btnCngPass);
        this.unremoveButton.add(btnCngPIN);
        this.unremoveButton.add(sep);
    }

    private void setCommonButtonBottom() {
        JLabel lblDisplay = new JLabel("00:00:00");
        JButton btnReset = new JButton();
        btnReset.setIcon(new ImageIcon(this.getClass().getResource("/Images/restoreDefault.png")));
        btnReset.setText(this.languageCentre.getValue(LanguageConstant.RestoreDefaultLayout));
        btnReset.setFocusable(false);
        btnReset.setToolTipText(this.languageCentre.getValue(LanguageConstant.RestoreDefaultLayout) + " (Ctrl + R)");
        btnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolBar.this.tradeCast.setDefaultLayout();
            }
        });
        this.add(btnReset);
        this.addSeparator();
        if (AppConfig.isCapitalAnalaytic) {
            JButton btnCapitalAnalytic = new JButton();
            btnCapitalAnalytic.setIcon(new ImageIcon(this.getClass().getResource("/Images/capitalanalytics.png")));
            btnCapitalAnalytic.setFocusable(false);
            btnCapitalAnalytic.setText(Title.CapitalAnalytics);
            btnCapitalAnalytic.setToolTipText(Title.CapitalAnalytics);
            btnCapitalAnalytic.setVerticalTextPosition(0);
            btnCapitalAnalytic.setFocusable(false);
            btnCapitalAnalytic.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (LogCommon.isDisclaimerAccepted) {
                        ToolBar.this.tradeCast.connectAndOpenAnalytics("");
                    } else {
                        LogCommon.isScripWiseAnalytics = false;
                        ToolBar.this.tradeCast.ShowDynamicForm(FormName.CapitalAnalytics, Title.CapitalAnalytics);
                    }
                }
            });
            this.add(btnCapitalAnalytic);
            this.addSeparator();
        }
        if (AppConfig.isInvestorLounge) {
            JButton btnInvestorLounge = new JButton();
            btnInvestorLounge.setIcon(new ImageIcon(this.getClass().getResource("/Images/investorLounge.png")));
            btnInvestorLounge.setFocusable(false);
            btnInvestorLounge.setText(Title.InvestorLounge);
            btnInvestorLounge.setToolTipText(Title.InvestorLounge);
            btnInvestorLounge.setVerticalTextPosition(0);
            btnInvestorLounge.setFocusable(false);
            btnInvestorLounge.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ToolBar.this.tradeCast.ShowDynamicForm(FormName.InvestorLounge, Title.InvestorLounge);
                }
            });
            this.add(btnInvestorLounge);
            this.addSeparator();
        }
        if (AppConfig.isMaiers) {
            JButton btnMaiers = new JButton();
            try {
                if (AppConfig.houseIcon == null) {
                    AppConfig.houseIcon = ImageUtil.downloadImage((String)(AppConfig.TradeCastURL + "/HouseImages/small.png"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (AppConfig.houseIcon != null) {
                btnMaiers.setIcon(new ImageIcon(AppConfig.houseIcon));
            }
            btnMaiers.setFocusable(false);
            btnMaiers.setText(Title.Maiers);
            btnMaiers.setToolTipText(Title.Maiers);
            btnMaiers.setVerticalTextPosition(0);
            btnMaiers.setFocusable(false);
            btnMaiers.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ToolBar.this.mediator.openURLinOSBrowser(AppConfig.AnalyticsOpenURL_Maiers + LogCommon.UserID);
                }
            });
            this.add(btnMaiers);
            this.addSeparator();
        }
        if (AppConfig.ResreachMenuText.trim().length() > 0) {
            JMenuItem resreachMenu = new JMenuItem(AppConfig.ResreachMenuText);
            resreachMenu.setToolTipText(AppConfig.ResreachMenuLink);
            resreachMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ToolBar.this.mediator.openURLinOSBrowser(AppConfig.ResreachMenuLink);
                }
            });
            this.HouseMenu.add(resreachMenu);
            final JButton btnResreach = new JButton();
            btnResreach.setIcon(null);
            try {
                if (AppConfig.houseIcon == null) {
                    AppConfig.houseIcon = ImageUtil.downloadImage((String)(AppConfig.TradeCastURL + "/HouseImages/small.png"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (AppConfig.houseIcon != null) {
                btnResreach.setIcon(new ImageIcon(AppConfig.houseIcon));
            }
            btnResreach.setFocusable(false);
            btnResreach.setVerticalTextPosition(0);
            btnResreach.setToolTipText(AppConfig.houseName);
            btnResreach.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    ToolBar.this.HouseMenu.show(btnResreach, evt.getX() + 2, evt.getY() + 7);
                }
            });
            this.add(btnResreach);
        }
        this.add(this.CreateToolBarButton("/Images/keys.png", FormName.ShortcutKeys, LanguageConstant.ShortcutKeys, true, this.languageCentre.getValue(LanguageConstant.ShortcutKeys) + " (F1)"));
        JButton btnAbout = new JButton();
        btnAbout.setIcon(new ImageIcon(this.getClass().getResource("/Images/About.png")));
        btnAbout.setFocusable(false);
        btnAbout.setToolTipText(this.languageCentre.getValue(LanguageConstant.AboutTradeCast) + " (Ctrl + A)");
        btnAbout.setVerticalTextPosition(0);
        btnAbout.setFocusable(false);
        btnAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolBar.this.mediator.OpenAboutWindow();
            }
        });
        this.add(btnAbout);
        lblDisplay.setFocusable(false);
        this.userName.setFont(this.userName.getFont().deriveFont(1));
        this.userName.setIcon(new ImageIcon(this.getClass().getResource("/Images/user2.png")));
        JButton logout = new JButton();
        logout.setIcon(new ImageIcon(this.getClass().getResource("/Images/logout.png")));
        logout.setToolTipText(this.languageCentre.getValue(LanguageConstant.Logout) + " (Alt + F4)");
        logout.setFocusable(false);
        logout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolBar.this.tradeCast.Close();
            }
        });
        lblDisplay.setHorizontalAlignment(4);
        lblDisplay.setMinimumSize(new Dimension(55, 18));
        lblDisplay.setMaximumSize(new Dimension(55, 18));
        lblDisplay.setPreferredSize(new Dimension(55, 18));
        lblDisplay.setBackground(Color.BLACK);
        lblDisplay.setForeground(new Color(194, 225, 243));
        lblDisplay.setOpaque(true);
        lblDisplay.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(210, 113, 85)));
        try {
            Font clockFont = this.loadFont(CLOCK_FONT_RESOURCE, 14.0f);
            lblDisplay.setFont(clockFont);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        JLabel lblServerTime = new JLabel("00:00:00");
        lblServerTime.setToolTipText("Server Time");
        lblServerTime.setFocusable(false);
        lblServerTime.setHorizontalAlignment(4);
        lblServerTime.setMinimumSize(new Dimension(57, 18));
        lblServerTime.setMaximumSize(new Dimension(57, 18));
        lblServerTime.setPreferredSize(new Dimension(57, 18));
        lblServerTime.setBackground(Color.BLACK);
        lblServerTime.setForeground(new Color(194, 225, 243));
        lblServerTime.setOpaque(true);
        lblServerTime.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(210, 113, 85)));
        try {
            Font clockFont = this.loadFont(CLOCK_FONT_RESOURCE, 14.0f);
            lblServerTime.setFont(clockFont);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.mediator.setServerTimeLabel(lblServerTime);
        this.userName.setHorizontalAlignment(4);
        this.add(Box.createHorizontalGlue());
        this.add(new JLabel("  "));
        this.addSeparator();
        this.add(this.userName);
        this.addSeparator();
        this.add(lblServerTime);
        this.addSeparator();
        this.add(lblDisplay);
        this.addSeparator();
        this.add(logout);
        LoginStatus loginstatus = new LoginStatus(lblDisplay);
    }

    private Font loadFont(String name, float fontSize) throws FontFormatException, IOException {
        try {
            return UtilTC.loadFont(name, fontSize);
        }
        catch (FontFormatException e) {
            throw e;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    private void switchProfile(boolean b) {
        try {
            this.repaint();
            this.removeAllButtons();
            if (b) {
                LogCommon.toolBarProfile = "PMEX";
                this.initPMEX();
                this.setCommonButtonBottom();
                this.btnProfileSwitch.setToolTipText("Switch to Equity Toolbar");
            } else {
                LogCommon.toolBarProfile = "KSE";
                this.initKSE();
                this.setCommonButtonBottom();
                this.btnProfileSwitch.setToolTipText("Switch to Commodity Toolbar");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private JButton CreateToolBarButton(String IconPath, final FormName frmName, final String finalFormTitle, boolean isDynamic, String tooltiptext) {
        JButton btn = new JButton();
        btn.setIcon(new ImageIcon(this.getClass().getResource(IconPath)));
        btn.setFocusable(false);
        btn.setVerticalTextPosition(0);
        btn.setToolTipText(tooltiptext);
        btn.setActionCommand(finalFormTitle);
        btn.setName("ToolBar -> " + finalFormTitle);
        final String id = finalFormTitle;
        if (isDynamic) {
            FormName finalfrmName = frmName;
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (frmName == FormName.PMEX_Ladder) {
                                TradeCast.getInstance().ShowLadderWindow(FormName.PMEX_Ladder, Title.PMEX_Ladder, LogsPMEX.SelectedSymbol);
                            } else if (frmName == FormName.PMEX_MBP) {
                                ToolBar.this.tradeCast.ShowPMEX_MBPWindow(frmName, Title.PMEX_MarketDepthByPrice, LogsPMEX.SelectedSymbol);
                            } else if (frmName == FormName.PMEX_FastOrder) {
                                ToolBar.this.tradeCast.showPMEX_FastOrderFrame();
                            } else {
                                ToolBar.this.tradeCast.ShowDynamicForm(frmName, finalFormTitle);
                            }
                            if (id.equalsIgnoreCase(LanguageConstant.DetailedQuote)) {
                                ((ToolBar)ToolBar.this).mediator.detailedQuote.AddSymbol(LogsKSE.SelectedMarket, LogsKSE.SelectedSymbol);
                                ((ToolBar)ToolBar.this).mediator.detailedQuote.setTitle("");
                            }
                        }
                    });
                }
            });
        } else {
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String finalViewName = "";
                            if (frmName == FormName.MarketWatch) {
                                finalViewName = LanguageConstant.MarketWatch;
                            } else if (frmName == FormName.MBO) {
                                finalViewName = LanguageConstant.MarketDepthByOrder;
                            } else if (frmName == FormName.MBP) {
                                finalViewName = LanguageConstant.MarketDepthByPrice;
                            } else if (frmName == FormName.MessageWindow) {
                                finalViewName = LanguageConstant.MessageWindow;
                            } else if (frmName == FormName.TradeLog) {
                                finalViewName = LanguageConstant.TradeLog;
                            } else if (frmName == FormName.OutstandingLog) {
                                finalViewName = LanguageConstant.OutstandingLog;
                            } else if (frmName == FormName.ActivityLog) {
                                finalViewName = LanguageConstant.ActivityLog;
                            } else if (frmName == FormName.GraphsAndCharts) {
                                ToolBar.this.tradeCast.ShowGraphWindow(frmName, LanguageConstant.GraphsAndCharts, "", "");
                            } else if (frmName == FormName.PMEX_MarketWatch) {
                                finalViewName = "Commodity Watches";
                            } else if (frmName == FormName.PMEX_Matrix) {
                                finalViewName = Title.PMEX_Matirx;
                            } else if (frmName == FormName.PMEX_Ladder_Dock) {
                                finalViewName = Title.PMEX_Ladder_Dock;
                            } else if (frmName == FormName.PMEX_TradeOrder) {
                                finalViewName = Title.PMEX_TradedOrder;
                            } else if (frmName == FormName.PMEX_WorkingOrder) {
                                finalViewName = Title.PMEX_WorkingOrder;
                            } else if (frmName == FormName.PMEX_OrderActivity) {
                                finalViewName = Title.PMEX_OrderActivity;
                            }
                            ToolBar.this.tradeCast.showStaticWindow(finalViewName, true);
                            if (frmName == FormName.MBO) {
                                ((ToolBar)ToolBar.this).mediator.mbo.AddSymbol(LogsKSE.SelectedSymbol, LogsKSE.SelectedMarket);
                            }
                            if (frmName == FormName.MBP) {
                                ((ToolBar)ToolBar.this).mediator.mbp.AddSymbol(LogsKSE.SelectedSymbol, LogsKSE.SelectedMarket);
                            }
                            if (frmName == FormName.PMEX_Ladder_Dock) {
                                ToolBar.this.tradeCast.showStaticWindow(Title.PMEX_Ladder_Dock, true);
                                ToolBar.this.tradeCast.Panel_PMEX_Leader.addContract(LogsPMEX.SelectedSymbol);
                            }
                        }
                    });
                }
            });
        }
        return btn;
    }

    public void setUnattended() {
        if (LogCommon.isUnattended) {
            this.userName.setIcon(new ImageIcon(this.getClass().getResource("/Images/user2.png")));
        } else {
            this.userName.setIcon(new ImageIcon(this.getClass().getResource("/Images/userUnattened.png")));
        }
    }

    private void removeAllButtons() {
        try {
            Component[] com = this.getComponents();
            for (int i = 0; i < com.length; ++i) {
                Component component = com[i];
                if (this.unremoveButton.contains(component)) continue;
                this.remove(component);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

