/*
 * Decompiled with CFR 0.152.
 */
package windows;

import CustomComponent.NxGTableCellRender;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import Utilities.MyDradAndDrop;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.Title;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import kse.util.UtilKSE;
import languages.LanguageConstant;

public class TopMoverTable_backup
extends JPanel {
    private final Cursor handCursor = new Cursor(12);
    final Cursor defaultCursor = new Cursor(0);
    Mediator mediator = Mediator.getInstance();
    TradeCast tradeCast = TradeCast.getInstance();
    DefaultTableModel model = null;
    private int prevRow;
    private int prevCol;
    private NxGTableCellRender render;
    private FormName name = null;
    private JScrollPane jScrollPane1;
    public JTable table;

    public TopMoverTable_backup(FormName name) {
        this.initComponents();
        this.name = name;
        this.table.setSelectionMode(2);
        this.table.setToolTipText("Drag and Drop Scrip to add in My Watches");
        this.setTable();
        MyDradAndDrop myDradAndDrop = new MyDradAndDrop(this.table, name);
        JTableHeader header = this.table.getTableHeader();
        ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(0);
    }

    public void setTableColumnWidth() {
        if (this.name == FormName.TopMovers) {
            this.setColumnWidth();
        } else if (this.name == FormName.PMEX_TopMovers) {
            this.PMEX_setColumnWidth();
        }
    }

    private void setColumnWidth() {
        this.table.getColumnModel().getColumn(0).setPreferredWidth(60);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(215);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(60);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(55);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(65);
        this.table.getColumnModel().getColumn(5).setPreferredWidth(80);
        this.table.getColumnModel().getColumn(6).setPreferredWidth(66);
    }

    private void PMEX_setColumnWidth() {
        this.table.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(215);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(60);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(55);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(65);
        this.table.getColumnModel().getColumn(5).setPreferredWidth(80);
        this.table.getColumnModel().getColumn(6).setPreferredWidth(66);
        this.table.removeColumn(this.table.getColumnModel().getColumn(1));
        this.table.getColumnModel().getColumn(0).setHeaderValue("Contract");
    }

    public void setModel(DefaultTableModel model) {
        this.table.setModel(model);
    }

    public void setTable() {
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                TableColumnModel colModel;
                int vColIndex;
                int mColIndex;
                if (TopMoverTable_backup.this.name == FormName.TopMovers) {
                    TableColumnModel colModel2 = TopMoverTable_backup.this.table.getColumnModel();
                    int vColIndex2 = colModel2.getColumnIndexAtX(e.getX());
                    int mColIndex2 = TopMoverTable_backup.this.table.convertColumnIndexToModel(vColIndex2);
                    if ("Company".equalsIgnoreCase(TopMoverTable_backup.this.table.getColumnName(mColIndex2))) {
                        TopMoverTable_backup.this.table.setCursor(TopMoverTable_backup.this.handCursor);
                    } else {
                        TopMoverTable_backup.this.table.setCursor(TopMoverTable_backup.this.defaultCursor);
                    }
                } else if (TopMoverTable_backup.this.name == FormName.PMEX_TopMovers && (mColIndex = TopMoverTable_backup.this.table.convertColumnIndexToModel(vColIndex = (colModel = TopMoverTable_backup.this.table.getColumnModel()).getColumnIndexAtX(e.getX()))) < 6) {
                    if ("Scrip".equalsIgnoreCase(TopMoverTable_backup.this.table.getColumnName(mColIndex))) {
                        TopMoverTable_backup.this.table.setCursor(TopMoverTable_backup.this.handCursor);
                    } else {
                        TopMoverTable_backup.this.table.setCursor(TopMoverTable_backup.this.defaultCursor);
                    }
                }
            }
        });
    }

    public void setRender(NxGTableCellRender render) {
        this.table.setDefaultRenderer(Object.class, render);
        this.render = render;
    }

    public void fillTableWithPercentCalculate(String result) {
        this.model = (DefaultTableModel)this.table.getModel();
        this.removeTable();
        if (result.indexOf("=") >= 0) {
            String[] str1 = result.split("=");
            String[] Row2 = str1[1].split("\\|", -1);
            for (int rows = 0; rows < Row2.length - 1; ++rows) {
                String[] columns = Row2[rows].split("\\;", -1);
                Vector<Object> v = new Vector<Object>();
                for (int col = 0; col < columns.length; ++col) {
                    if (col == 0) {
                        String symbol = columns[0];
                        if (symbol.indexOf("-") >= 0) {
                            symbol = symbol.split("\\-", -1)[0];
                        }
                        v.addElement(columns[0]);
                        v.addElement(this.mediator.getSymbolTitle(symbol));
                        continue;
                    }
                    if (col == 1) {
                        v.addElement(columns[1]);
                        continue;
                    }
                    if (col == 2) {
                        v.addElement(columns[2]);
                        continue;
                    }
                    if (col == 3) {
                        double pr = Double.parseDouble(columns[1].trim());
                        double ch = Double.parseDouble(columns[2].trim());
                        v.addElement(ch / (pr - ch) * 100.0);
                        continue;
                    }
                    if (col == 4) {
                        v.addElement(columns[3]);
                        continue;
                    }
                    if (col == 5) {
                        v.addElement(columns[4]);
                        continue;
                    }
                    v.addElement(columns[col]);
                }
                this.model.addRow(v);
                if (rows > 10) continue;
            }
        }
        this.table.setModel(this.model);
    }

    public void fillTableWithPercentFromDB(String result) {
        this.model = (DefaultTableModel)this.table.getModel();
        this.removeTable();
        if (result.indexOf("=") >= 0) {
            String[] str1 = result.split("=");
            String[] Row2 = str1[1].split("\\|", -1);
            for (int rows = 0; rows < Row2.length - 1; ++rows) {
                String[] columns = Row2[rows].split("\\;", -1);
                Vector<String> v = new Vector<String>();
                for (int col = 0; col < columns.length; ++col) {
                    if (col == 0) {
                        String symbol = columns[0];
                        if (symbol.indexOf("-") >= 0) {
                            symbol = symbol.split("\\-", -1)[0];
                        }
                        v.addElement(columns[0]);
                        v.addElement(this.mediator.getSymbolTitle(symbol));
                        continue;
                    }
                    if (col == 1) {
                        v.addElement(columns[1]);
                        continue;
                    }
                    if (col == 2) {
                        v.addElement(columns[2]);
                        continue;
                    }
                    if (col == 3) {
                        v.addElement(columns[3]);
                        continue;
                    }
                    if (col == 4) {
                        v.addElement(columns[4]);
                        continue;
                    }
                    if (col == 5) {
                        v.addElement(columns[5]);
                        continue;
                    }
                    v.addElement(columns[col]);
                }
                this.model.addRow(v);
            }
        }
        this.table.setModel(this.model);
    }

    public void PMEX_fillTableWithPercentFromDB(String result) {
        this.model = (DefaultTableModel)this.table.getModel();
        this.removeTable();
        if (result.indexOf("=") >= 0) {
            String[] str1 = result.split("=");
            String[] Row2 = str1[1].split("\\|", -1);
            for (int rows = 0; rows < Row2.length; ++rows) {
                String[] columns = Row2[rows].split("\\;", -1);
                Vector<String> v = new Vector<String>();
                for (int col = 0; col < columns.length; ++col) {
                    if (col == 0) {
                        String symbol = columns[0];
                        if (symbol.indexOf("-") >= 0) {
                            symbol = symbol.split("\\-", -1)[0];
                        }
                        v.addElement(columns[0]);
                        v.addElement("");
                        continue;
                    }
                    if (col == 1) {
                        v.addElement(columns[1]);
                        continue;
                    }
                    if (col == 2) {
                        v.addElement(columns[2]);
                        continue;
                    }
                    if (col == 3) {
                        v.addElement(columns[3]);
                        continue;
                    }
                    if (col == 4) {
                        v.addElement(columns[4]);
                        continue;
                    }
                    if (col == 5) {
                        v.addElement(columns[5]);
                        continue;
                    }
                    v.addElement(columns[col]);
                }
                this.model.addRow(v);
            }
        }
        this.table.setModel(this.model);
    }

    public void removeTable() {
        if (this.model != null) {
            int numrows = this.model.getRowCount();
            for (int i = 0; i < numrows; ++i) {
                this.model.removeRow(0);
            }
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.jScrollPane1.setName("jScrollPane1");
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}){
            Class[] types;
            {
                this.types = new Class[]{String.class, String.class, Double.class, Double.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.table.setCursor(new Cursor(0));
        this.table.setName("table");
        this.table.setSelectionForeground(new Color(0, 0, 0));
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TopMoverTable_backup.this.tableMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                TopMoverTable_backup.this.tableMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                TopMoverTable_backup.this.tableMouseExited(evt);
            }
        });
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                TopMoverTable_backup.this.tableMouseMoved(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.table);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 300, Short.MAX_VALUE));
    }

    private void tableMouseClicked(MouseEvent evt) {
        TableColumnModel colModel;
        int vColIndex;
        int mColIndex;
        if (this.name == FormName.TopMovers) {
            TableColumnModel colModel2 = this.table.getColumnModel();
            int vColIndex2 = colModel2.getColumnIndexAtX(evt.getX());
            int mColIndex2 = this.table.convertColumnIndexToModel(vColIndex2);
            if ("Company".equalsIgnoreCase(this.table.getColumnName(mColIndex2).toString()) && !SwingUtilities.isRightMouseButton(evt)) {
                String sysmbol = this.table.getValueAt(this.table.getSelectedRow(), 0).toString();
                if (AppConfig.isHistoricalDataWatch) {
                    this.mediator.openScripDetails(sysmbol);
                } else {
                    TradeCast.getInstance().ShowDynamicForm(FormName.DetailedQuote, LanguageConstant.DetailedQuote);
                    this.mediator.detailedQuote.AddSymbol(UtilKSE.GetMarketFromsymbol((String)sysmbol), sysmbol);
                    this.mediator.detailedQuote.setTitle("");
                }
            }
        } else if (this.name == FormName.PMEX_TopMovers && (mColIndex = this.table.convertColumnIndexToModel(vColIndex = (colModel = this.table.getColumnModel()).getColumnIndexAtX(evt.getX()))) < 6 && "Scrip".equalsIgnoreCase(this.table.getColumnName(mColIndex).toString())) {
            String Contract = this.table.getValueAt(this.table.getSelectedRow(), 0).toString();
            TradeCast.getInstance().ShowLadderWindow(FormName.PMEX_Ladder, Title.PMEX_Ladder, Contract);
        }
    }

    private void tableMouseExited(MouseEvent evt) {
        this.table.setToolTipText("");
        this.render.setRowNo(-1);
        this.table.setCursor(this.defaultCursor);
    }

    private void tableMouseEntered(MouseEvent evt) {
        this.table.setToolTipText("Drag and Drop Scrip to add in My Watches");
    }

    private void tableMouseMoved(MouseEvent evt) {
        int row = this.table.rowAtPoint(evt.getPoint());
        int col = this.table.columnAtPoint(evt.getPoint());
        if (row == this.prevRow && col == this.prevCol) {
            return;
        }
        ToolTipManager.sharedInstance().mousePressed(evt);
        ToolTipManager.sharedInstance().mouseEntered(evt);
        this.prevRow = row;
        this.prevCol = col;
        if (row != this.render.getRowNo()) {
            this.render.setRowNo(row);
            this.repaint();
        }
    }
}

