/*
 * Decompiled with CFR 0.152.
 */
package windows.bipl;

import Beans.FundTransferBIPLBean;
import CATALYST.Socket.EncryptDecrypt;
import CustomComponent.DocumentType;
import CustomComponent.NxGPassword;
import CustomComponent.NxGTextField;
import MyDocking.Mediator;
import RendersNModels.FundTransferRender;
import Utilities.LogsTC;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.gui.component.NxGTable;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import languages.LanguageCentre;

public class FundTransferBIPL
extends JPanel {
    private LanguageCentre languageCentre = new LanguageCentre();
    DefaultTableModel model = new DefaultTableModel();
    private ArrayList<FundTransferBIPLBean> rows = new ArrayList();
    private SimpleDateFormat dt = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss");
    private JButton btnGet;
    private JButton btnTransfer;
    public JComboBox cbAccountNo;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JLabel lblMessage;
    private JLabel lblOrderHeader;
    private JLabel lblPinCode;
    private JScrollPane scrollPane;
    private NxGTable table;
    private JTextField txtAccount;
    private JTextField txtAvailableFund;
    private JTextField txtCNIC;
    private NxGTextField txtFundTransfer;
    private NxGPassword txtPinCode;
    private JTextField txtRemaining;
    private JTextField txtTitle;

    public FundTransferBIPL() {
        this.initComponents();
        Mediator.getInstance().setFundTransferBIPL(this);
        this.lblOrderHeader.setText("<html> <b> Fund Transfer and Account Information </b> <html>");
        this.setAccounts();
        this.setForDocument();
        this.initTable();
    }

    private void setAccounts() {
        this.cbAccountNo.setModel(new DefaultComboBoxModel<Object>(LogsTC.accountAll.keySet().toArray()));
        AutoCompleteSupport support = AutoCompleteSupport.install((JComboBox)this.cbAccountNo, (EventList)GlazedLists.eventListOf((Object[])LogsTC.accountAll.keySet().toArray()));
    }

    private void setForDocument() {
        this.txtPinCode.setDocument(DocumentType.NUMERIC, 4);
        this.txtFundTransfer.setDocument(DocumentType.NUMERIC, 10);
    }

    private void initComponents() {
        this.lblMessage = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.txtAvailableFund = new JTextField();
        this.jLabel6 = new JLabel();
        this.txtRemaining = new JTextField();
        this.btnTransfer = new JButton();
        this.lblPinCode = new JLabel();
        this.txtPinCode = new NxGPassword();
        this.txtFundTransfer = new NxGTextField();
        this.jLabel5 = new JLabel();
        this.txtAccount = new JTextField();
        this.jLabel7 = new JLabel();
        this.txtCNIC = new JTextField();
        this.txtTitle = new JTextField();
        this.jLabel8 = new JLabel();
        this.jPanel2 = new JPanel();
        this.scrollPane = new JScrollPane();
        this.table = new NxGTable();
        this.lblOrderHeader = new JLabel();
        this.jLabel1 = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.jSeparator3 = new JSeparator();
        this.jLabel3 = new JLabel();
        this.cbAccountNo = new JComboBox();
        this.btnGet = new JButton();
        this.setLayout(null);
        this.lblMessage.setText(" ");
        this.add(this.lblMessage);
        this.lblMessage.setBounds(20, 350, 510, 20);
        this.add(this.jSeparator1);
        this.jSeparator1.setBounds(0, 345, 730, 3);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(" Transfer Fund "));
        this.jPanel1.setLayout(null);
        this.jLabel2.setText("Available Fund");
        this.jPanel1.add(this.jLabel2);
        this.jLabel2.setBounds(20, 110, 80, 22);
        this.jLabel4.setText("Transfer Amount");
        this.jPanel1.add(this.jLabel4);
        this.jLabel4.setBounds(20, 140, 90, 22);
        this.txtAvailableFund.setEditable(false);
        this.txtAvailableFund.setHorizontalAlignment(4);
        this.jPanel1.add(this.txtAvailableFund);
        this.txtAvailableFund.setBounds(110, 110, 120, 22);
        this.jLabel6.setText("Remaining");
        this.jPanel1.add(this.jLabel6);
        this.jLabel6.setBounds(20, 170, 80, 22);
        this.txtRemaining.setEditable(false);
        this.txtRemaining.setHorizontalAlignment(4);
        this.jPanel1.add(this.txtRemaining);
        this.txtRemaining.setBounds(110, 170, 120, 22);
        this.btnTransfer.setIcon(new ImageIcon(this.getClass().getResource("/Images/MenuFundTransfer.png")));
        this.btnTransfer.setText("Transfer");
        this.btnTransfer.setName("FundTransfer -> btnTransfer");
        this.btnTransfer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FundTransferBIPL.this.btnTransferActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.btnTransfer);
        this.btnTransfer.setBounds(110, 230, 120, 25);
        this.lblPinCode.setHorizontalAlignment(2);
        this.lblPinCode.setText("PIN Code");
        this.jPanel1.add(this.lblPinCode);
        this.lblPinCode.setBounds(20, 200, 80, 22);
        this.jPanel1.add(this.txtPinCode);
        this.txtPinCode.setBounds(110, 200, 120, 22);
        this.txtFundTransfer.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                FundTransferBIPL.this.txtFundTransferKeyReleased(evt);
            }
        });
        this.jPanel1.add(this.txtFundTransfer);
        this.txtFundTransfer.setBounds(110, 140, 120, 22);
        this.jLabel5.setText("From Account");
        this.jPanel1.add(this.jLabel5);
        this.jLabel5.setBounds(20, 50, 80, 22);
        this.txtAccount.setEditable(false);
        this.jPanel1.add(this.txtAccount);
        this.txtAccount.setBounds(110, 50, 120, 22);
        this.jLabel7.setText("CNIC");
        this.jPanel1.add(this.jLabel7);
        this.jLabel7.setBounds(20, 80, 80, 22);
        this.txtCNIC.setEditable(false);
        this.jPanel1.add(this.txtCNIC);
        this.txtCNIC.setBounds(110, 80, 120, 22);
        this.txtTitle.setEditable(false);
        this.jPanel1.add(this.txtTitle);
        this.txtTitle.setBounds(110, 20, 120, 22);
        this.jLabel8.setText("Title");
        this.jPanel1.add(this.jLabel8);
        this.jLabel8.setBounds(20, 20, 80, 22);
        this.add(this.jPanel1);
        this.jPanel1.setBounds(470, 70, 250, 270);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(" Account Information "));
        this.table.setModel((TableModel)new DefaultTableModel(new Object[0][], new String[]{"Title", "Account No", "CNIC", "Status", "Balance"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false, false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                FundTransferBIPL.this.tableMousePressed(evt);
            }
        });
        this.scrollPane.setViewportView((Component)this.table);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.scrollPane, -1, 428, Short.MAX_VALUE).addGap(5, 5, 5)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 203, Short.MAX_VALUE));
        this.add(this.jPanel2);
        this.jPanel2.setBounds(10, 110, 450, 230);
        this.lblOrderHeader.setIcon(new ImageIcon(this.getClass().getResource("/Images/FundTransfer.png")));
        this.lblOrderHeader.setText("-------");
        this.add(this.lblOrderHeader);
        this.lblOrderHeader.setBounds(28, 0, 360, 60);
        this.jLabel1.setBackground(new Color(255, 255, 255));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/Images/HeaderBG.png")));
        this.jLabel1.setOpaque(true);
        this.add(this.jLabel1);
        this.jLabel1.setBounds(0, 0, 730, 60);
        this.add(this.jSeparator2);
        this.jSeparator2.setBounds(0, 60, 730, 3);
        this.jSeparator3.setOrientation(1);
        this.add(this.jSeparator3);
        this.jSeparator3.setBounds(465, 90, 3, 230);
        this.jLabel3.setText("Account No");
        this.add(this.jLabel3);
        this.jLabel3.setBounds(20, 80, 70, 23);
        this.cbAccountNo.setEditable(true);
        this.cbAccountNo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FundTransferBIPL.this.cbAccountNoItemStateChanged(evt);
            }
        });
        this.add(this.cbAccountNo);
        this.cbAccountNo.setBounds(90, 80, 240, 23);
        this.btnGet.setIcon(new ImageIcon(this.getClass().getResource("/Images/get.png")));
        this.btnGet.setText("Get");
        this.btnGet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FundTransferBIPL.this.btnGetActionPerformed(evt);
            }
        });
        this.add(this.btnGet);
        this.btnGet.setBounds(350, 80, 100, 23);
    }

    private void cbAccountNoItemStateChanged(ItemEvent evt) {
    }

    private void tableMousePressed(MouseEvent evt) {
        if (this.table.getSelectedRow() >= 0) {
            FundTransferBIPLBean b = this.rows.get(this.table.getSelectedRow());
            this.txtTitle.setText(b.getAccountTitle());
            this.txtAccount.setText(b.getAccount());
            this.txtCNIC.setText(b.getCNIC());
            this.txtAvailableFund.setText(Util.format0digit((String)b.getBalance()));
        }
    }

    private void txtFundTransferKeyReleased(KeyEvent evt) {
        String af = this.txtAvailableFund.getText().replaceAll(",", "");
        long availableFund = Long.parseLong(af);
        String ft = this.txtFundTransfer.getText().replaceAll(",", "");
        long fundTransfer = Long.parseLong(ft);
        long rem = availableFund - fundTransfer;
        this.txtRemaining.setText(Util.format0digit((String)(rem + "")));
    }

    private void btnTransferActionPerformed(ActionEvent evt) {
        if (this.isValidInput()) {
            String af = this.txtAvailableFund.getText().replaceAll(",", "");
            long availableFund = Long.parseLong(af);
            String ft = this.txtFundTransfer.getText().replaceAll(",", "");
            long fundTransfer = Long.parseLong(ft);
            if (fundTransfer > availableFund) {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)("You cannot Transfer fund more then available fund(" + this.txtAvailableFund.getText() + ")"));
                this.txtFundTransfer.requestFocus();
            } else {
                this.submitRequest();
            }
        }
    }

    private void btnGetActionPerformed(ActionEvent evt) {
        if (this.cbAccountNo.getSelectedItem() == null) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Please select Account No");
            this.cbAccountNo.requestFocus();
        } else if (this.cbAccountNo.getSelectedItem().toString().trim().length() <= 0) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Please select Account No");
            this.cbAccountNo.requestFocus();
        } else {
            this.getCustomerAllAccount();
        }
    }

    private void getCustomerAllAccount() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                FundTransferBIPL.this.txtAvailableFund.setText("");
                Util.setMessage((JLabel)FundTransferBIPL.this.lblMessage, (MessageType)MessageType.Loading, (String)"Loading information");
                try {
                    String result = WebService.getInstance().getPort().getInfo(EncryptDecrypt.getInstance().EncryptText(LogCommon.UserID), "GetCustomerAllAccounts=", FundTransferBIPL.this.cbAccountNo.getSelectedItem().toString());
                    Mediator.getInstance().println("GetCustomerAllAccounts = " + result);
                    if (result.indexOf("|") >= 0) {
                        String[] data;
                        for (String rowData : data = result.split("\\|", -1)) {
                            if (!rowData.contains(";")) continue;
                            String[] row = rowData.split("\\;", -1);
                            FundTransferBIPLBean b = new FundTransferBIPLBean();
                            b.setAccountTitle(row[0]);
                            b.setAccount(row[1]);
                            b.setCNIC(row[2]);
                            b.setStatus(row[3]);
                            b.setBalance(row[4]);
                            FundTransferBIPL.this.rows.add(b);
                        }
                    } else {
                        Util.setMessage((JLabel)FundTransferBIPL.this.lblMessage, (MessageType)MessageType.Information, (String)"No record found");
                    }
                }
                catch (Exception ex) {
                    Util.setMessage((JLabel)FundTransferBIPL.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in loading");
                    ex.printStackTrace();
                    Mediator.getInstance().WriteExceptionInClientMachine(ex);
                }
                Util.setMessage((JLabel)FundTransferBIPL.this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
                FundTransferBIPL.this.addRows();
            }
        }).start();
    }

    private void initTable() {
        ((JLabel)((Object)this.table.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(0);
        this.model = (DefaultTableModel)this.table.getModel();
        this.table.setModel((TableModel)this.model);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new FundTransferRender());
        this.table.setRowHeight(18);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setColumnControlVisible(false);
    }

    private void addRows() {
        for (int i = 0; i < this.rows.size(); ++i) {
            FundTransferBIPLBean bean = this.rows.get(i);
            this.model.addRow(new Object[]{bean.getAccountTitle(), bean.getAccount(), bean.getCNIC(), bean.getStatus(), bean.getBalance()});
        }
        this.tableDataChange();
    }

    private void tableDataChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.model.fireTableDataChanged();
            this.table.addNotify();
            this.table.repaint();
            this.table.packAll();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FundTransferBIPL.this.model.fireTableDataChanged();
                    FundTransferBIPL.this.table.addNotify();
                    FundTransferBIPL.this.table.repaint();
                    FundTransferBIPL.this.table.packAll();
                }
            });
        }
    }

    private boolean isValidInput() {
        boolean isValid = false;
        if (this.txtAvailableFund.getText().trim().length() < 1) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Fund not Available");
            this.txtAvailableFund.requestFocus();
        } else if (this.cbAccountNo.getSelectedItem() == null) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please select Account No");
            this.cbAccountNo.requestFocus();
        } else if (this.cbAccountNo.getSelectedItem().toString().trim().length() < 1) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please select Account No");
            this.cbAccountNo.requestFocus();
        } else if (this.txtFundTransfer.getText().trim().length() < 1) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please enter fund transfer amount");
            this.txtFundTransfer.requestFocus();
        } else if (this.txtPinCode.getText().trim().length() < 1) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please enter PIN");
            this.txtPinCode.requestFocus();
        } else {
            isValid = true;
        }
        return isValid;
    }

    private void reset() {
        this.emptyTable();
        this.txtTitle.setText("");
        this.txtAccount.setText("");
        this.txtCNIC.setText("");
        this.txtAvailableFund.setText("");
        this.cbAccountNo.setSelectedItem("");
        this.txtFundTransfer.setText("");
        this.txtRemaining.setText("");
        this.txtPinCode.setText("");
    }

    private void emptyTable() {
        for (int i = 0; i < this.rows.size(); ++i) {
            this.model.removeRow(0);
        }
        this.rows.clear();
        this.tableDataChange();
    }

    private void submitRequest() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Util.setMessage((JLabel)FundTransferBIPL.this.lblMessage, (MessageType)MessageType.Loading, (String)"Please wait while we are processing your request...");
                FundTransferBIPL.this.btnTransfer.setEnabled(false);
                String transferAccount = FundTransferBIPL.this.txtAccount.getText();
                String userId = EncryptDecrypt.getInstance().EncryptText(LogCommon.UserID);
                String account = EncryptDecrypt.getInstance().EncryptText(FundTransferBIPL.this.cbAccountNo.getSelectedItem() + "|" + transferAccount);
                String PIN = EncryptDecrypt.getInstance().EncryptText(FundTransferBIPL.this.txtPinCode.getText());
                String fund = FundTransferBIPL.this.txtFundTransfer.getText();
                try {
                    String result = WebService.getInstance().getPort().getAccountStatement(userId, account, PIN, fund, "FundTransferBIPL");
                    Mediator.getInstance().println("FundTransferBIPL = " + result);
                    FundTransferBIPL.this.btnTransfer.setEnabled(true);
                    if (result.contains("false|")) {
                        String reString = result.split("\\|", -1)[1];
                        Util.setMessage((JLabel)FundTransferBIPL.this.lblMessage, (MessageType)MessageType.Error, (String)reString);
                    } else if (result.contains("InvalidFund")) {
                        Util.setMessage((JLabel)FundTransferBIPL.this.lblMessage, (MessageType)MessageType.Error, (String)"Invalid Fund amount");
                    } else if (result.contains("AccountNotAssign")) {
                        Util.setMessage((JLabel)FundTransferBIPL.this.lblMessage, (MessageType)MessageType.Error, (String)"Account not assigned");
                    } else if (result.contains("InvalidPIN")) {
                        Util.setMessage((JLabel)FundTransferBIPL.this.lblMessage, (MessageType)MessageType.Error, (String)"Invalid PIN code");
                    } else if (result.equalsIgnoreCase("true")) {
                        FundTransferBIPL.this.reset();
                        Util.setMessage((JLabel)FundTransferBIPL.this.lblMessage, (MessageType)MessageType.Sussess, (String)"Your request Fund have been transferred");
                    }
                }
                catch (Exception ex) {
                    Util.setMessage((JLabel)FundTransferBIPL.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in submitting request");
                    Mediator.getInstance().WriteExceptionInClientMachine(ex);
                }
            }
        }).start();
    }
}

