/*
 * Decompiled with CFR 0.152.
 */
package windows.js;

import MyDocking.Mediator;
import RendersNModels.ComboBoxToolTipRender;
import Utilities.LogsTC;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.gui.util.AppConfig;
import common.gui.util.ColorUtility;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import languages.LanguageCentre;
import languages.LanguageConstant;
import windows.js.JSExposure;
import windows.js.JSSummary;
import windows.js.JSValuePanel;
import windows.js.JSValues;

public class JSAccount
extends JPanel {
    private final JSExposure exposureJS;
    JLabel lblMessage = null;
    private final SpinnerNumberModel model = new SpinnerNumberModel(10, 10, 999999, 10);
    static int interval = 10;
    private Timer timerExposureJS = null;
    boolean isInCall = false;
    private LanguageCentre languageCentre = new LanguageCentre();
    private JButton btnApply;
    private JButton btnRefresh;
    private JComboBox cbAccount;
    private JCheckBox isStop;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JSpinner spInterval;

    public JSAccount(JSExposure exposureJS, JLabel lbl) {
        this.initComponents();
        this.setAccounts();
        this.isStop.setVisible(false);
        this.jLabel3.setVisible(false);
        this.spInterval.setVisible(false);
        this.jLabel2.setVisible(false);
        this.btnApply.setVisible(false);
        Dimension d = new Dimension(2000, 45);
        this.setPreferredSize(d);
        this.setSize(d);
        this.setMaximumSize(d);
        this.exposureJS = exposureJS;
        this.lblMessage = lbl;
        this.spInterval.setModel(this.model);
        this.spInterval.setValue(interval);
        if (LogCommon.preferredAccount.trim().length() > 0) {
            this.cbAccount.setSelectedItem(LogCommon.preferredAccount);
        } else {
            try {
                this.cbAccount.setSelectedIndex(0);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.loadData();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.cbAccount = new JComboBox();
        this.btnRefresh = new JButton();
        this.jLabel2 = new JLabel();
        this.spInterval = new JSpinner();
        this.jLabel3 = new JLabel();
        this.btnApply = new JButton();
        this.isStop = new JCheckBox();
        this.jLabel1.setText("Account ");
        this.cbAccount.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbAccount.setOpaque(false);
        this.cbAccount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSAccount.this.cbAccountActionPerformed(evt);
            }
        });
        this.btnRefresh.setIcon(new ImageIcon(this.getClass().getResource("/Images/refresh.png")));
        this.btnRefresh.setText("Refresh");
        this.btnRefresh.setName("JSAccount -> btnRefresh");
        this.btnRefresh.setOpaque(false);
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSAccount.this.btnRefreshActionPerformed(evt);
            }
        });
        this.jLabel2.setHorizontalAlignment(2);
        this.jLabel2.setText("seconds");
        this.jLabel2.setHorizontalTextPosition(4);
        this.spInterval.setPreferredSize(new Dimension(29, 23));
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("Refresh Exposure after");
        this.jLabel3.setHorizontalTextPosition(4);
        this.btnApply.setText("Apply");
        this.btnApply.setName("JSAccount -> btnApply");
        this.btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSAccount.this.btnApplyActionPerformed(evt);
            }
        });
        this.isStop.setText("Stop auto refresh");
        this.isStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSAccount.this.isStopActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabel1, -2, 51, -2).addGap(4, 4, 4).addComponent(this.cbAccount, -2, 127, -2).addGap(11, 11, 11).addComponent(this.btnRefresh).addGap(6, 6, 6).addComponent(this.isStop, -2, 110, -2).addGap(0, 0, 0).addComponent(this.jLabel3, -2, 120, -2).addGap(5, 5, 5).addComponent(this.spInterval, -2, 55, -2).addGap(5, 5, 5).addComponent(this.jLabel2, -2, 45, -2).addGap(0, 0, 0).addComponent(this.btnApply, -2, 73, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.jLabel1, -2, 23, -2)).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.cbAccount, -2, 23, -2)).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.btnRefresh)).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.isStop)).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabel3, -2, 23, -2)).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.spInterval, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabel2, -2, 23, -2)).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.btnApply)));
    }

    private void btnRefreshActionPerformed(ActionEvent evt) {
        this.loadData();
    }

    private void cbAccountActionPerformed(ActionEvent evt) {
        if (evt.getModifiers() == 16 || evt.getActionCommand().equalsIgnoreCase("comboBoxEdited")) {
            this.loadData();
        }
    }

    private void btnApplyActionPerformed(ActionEvent evt) {
        try {
            interval = Integer.parseInt(this.spInterval.getValue().toString().trim());
            JOptionPane.showMessageDialog(null, "Auto refresh time interval has been applyed", "Exposure", 1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void isStopActionPerformed(ActionEvent evt) {
    }

    private void setAccounts() {
        this.cbAccount.setModel(new DefaultComboBoxModel<Object>(LogsTC.accountAll.keySet().toArray()));
        AutoCompleteSupport support = AutoCompleteSupport.install((JComboBox)this.cbAccount, (EventList)GlazedLists.eventListOf((Object[])LogsTC.accountAll.keySet().toArray()));
        this.cbAccount.setRenderer(new ComboBoxToolTipRender(LogsTC.accountAll, ""));
    }

    private void getExposure() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                String result = "";
                if (!JSAccount.this.isInCall) {
                    JSAccount.this.isInCall = true;
                    try {
                        if (LogCommon.isExposureOpen) {
                            JSAccount.this.setMessage(JSAccount.this.lblMessage, MessageType.Loading, JSAccount.this.languageCentre.getValue(LanguageConstant.Loading));
                        }
                        result = WebService.getInstance().getPort().getExposureDynamic(LogCommon.UserID, JSAccount.this.cbAccount.getSelectedItem().toString(), AppConfig.ExposureWindowType);
                        if (LogCommon.isExposureOpen) {
                            JSAccount.this.setMessage(JSAccount.this.lblMessage, MessageType.EMPTY, "");
                            JSAccount.this.exposureJS.setData(result);
                        }
                    }
                    catch (Exception ex) {
                        if (LogCommon.isExposureOpen) {
                            JSAccount.this.setMessage(JSAccount.this.lblMessage, MessageType.Error, "Error in loading Exposure Watch");
                            this.setEmpty();
                        }
                        Mediator.getInstance().PrintLog(ex, result);
                    }
                    JSAccount.this.isInCall = false;
                }
            }

            private void setEmpty() {
                ((JSAccount)JSAccount.this).exposureJS.porfolio.reset();
                ((JSAccount)JSAccount.this).exposureJS.openPosition.reset();
                try {
                    for (int i = 0; i < ((JSAccount)JSAccount.this).exposureJS.pnlHolder.getComponentCount(); ++i) {
                        if (!(((JSAccount)JSAccount.this).exposureJS.pnlHolder.getComponent(i) instanceof JSSummary)) continue;
                        JSSummary js = (JSSummary)((JSAccount)JSAccount.this).exposureJS.pnlHolder.getComponent(i);
                        for (int j = 0; j < js.getComponentCount(); ++j) {
                            if (!(js.getComponent(j) instanceof JScrollPane)) continue;
                            JScrollPane sp = (JScrollPane)js.getComponent(j);
                            JPanel pnl = (JPanel)sp.getViewport().getComponent(0);
                            for (int k = 0; k < pnl.getComponentCount(); ++k) {
                                if (!(pnl.getComponent(k) instanceof JSValuePanel)) continue;
                                JSValuePanel jsv = (JSValuePanel)pnl.getComponent(k);
                                for (int l = 0; l < jsv.getComponentCount(); ++l) {
                                    if (!(jsv.getComponent(l) instanceof JSValues)) continue;
                                    JSValues val = (JSValues)jsv.getComponent(l);
                                    val.setValueEmpty();
                                }
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }, "JS Account SetAccount").start();
    }

    void getFocus() {
        this.cbAccount.requestFocus();
    }

    private void loadData() {
        if (this.cbAccount.getSelectedItem() == null) {
            this.setMessage(this.lblMessage, MessageType.Information, "Please select account");
            this.cbAccount.requestFocus();
        } else if (this.cbAccount.getSelectedItem().toString().trim() == null) {
            this.setMessage(this.lblMessage, MessageType.Information, "Please select account");
            this.cbAccount.requestFocus();
        } else {
            this.getExposure();
        }
    }

    private void moveIt() {
        new Thread((Runnable)new ExposureJSThread(), "ExposureJSThread").start();
    }

    private void sendSubscribeExposureJS() {
        try {
            System.err.println("sendSubscribeExposureJS");
            this.loadData();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setMessage(JLabel lblMessage, MessageType type, String text) {
        lblMessage.setIcon(null);
        lblMessage.setText("");
        lblMessage.setForeground(Color.BLACK);
        if (text.lastIndexOf(".") != text.length() - 1) {
            text = text + ".";
        }
        if (type == MessageType.Information) {
            lblMessage.setIcon(JSAccount.icon("/common/gui/images/info.png"));
            lblMessage.setText(text);
            lblMessage.setForeground(ColorUtility.informationFG);
        } else if (type == MessageType.Sussess) {
            lblMessage.setIcon(JSAccount.icon("/common/gui/images/success.png"));
            lblMessage.setText(text);
            lblMessage.setForeground(ColorUtility.successFG);
        } else if (type == MessageType.Error) {
            lblMessage.setIcon(JSAccount.icon("/common/gui/images/error.png"));
            lblMessage.setText(text);
            lblMessage.setForeground(ColorUtility.errorFG);
        } else if (type == MessageType.EMPTY) {
            lblMessage.setIcon(null);
            lblMessage.setText("");
            lblMessage.setForeground(Color.BLACK);
        } else if (type == MessageType.Loading) {
            lblMessage.setIcon(JSAccount.icon("/common/gui/images/loader.gif"));
            lblMessage.setText(text);
            lblMessage.setForeground(Color.BLACK);
        } else if (type == MessageType.Normal) {
            lblMessage.setIcon(null);
            lblMessage.setText(text);
            lblMessage.setForeground(Color.BLACK);
        }
    }

    private static Icon icon(String path) {
        URL resource = Util.class.getResource(path);
        if (resource == null) {
            return new ImageIcon();
        }
        return new ImageIcon(resource);
    }

    private class ExposureJSTask
    extends ExposureJSTimerTask {
        private ExposureJSTask() {
        }

        @Override
        public void doRun() {
            JSAccount.this.moveIt();
        }
    }

    private class ExposureJSThread
    implements Runnable {
        private ExposureJSThread() {
        }

        @Override
        public void run() {
            JSAccount.this.sendSubscribeExposureJS();
        }
    }

    private abstract class ExposureJSTimerTask
    extends TimerTask {
        private ExposureJSTimerTask() {
        }

        public abstract void doRun();

        @Override
        public void run() {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(this);
            } else {
                this.doRun();
            }
        }
    }
}

