/*
 * Decompiled with CFR 0.152.
 */
package windows.js;

import CATALYST.Socket.EncryptDecrypt;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import RendersNModels.ComboBoxToolTipRender;
import Utilities.LoadLogs;
import Utilities.LogsTC;
import Utilities.ThreadWithName;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.bean.AccountBean;
import common.gui.component.JTextFieldFilter;
import common.gui.util.FormName;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.Title;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.text.Document;
import languages.LanguageConstant;
import pmex.gui.util.LogsPMEX;

public class JSFundTransfer
extends JPanel {
    double accountExposureEquity = 0.0;
    double accountExposureCommodity = 0.0;
    private final String linkText = Title.FundTransferStatement;
    private boolean isEquityTransfer = true;
    Timer timer = new Timer(10, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JSFundTransfer.this.cbEquityAccount.requestFocus();
            JSFundTransfer.this.timer.stop();
        }
    });
    private JButton btnFundTransfer;
    public JComboBox cbCommodityAccount;
    public JComboBox cbEquityAccount;
    private JLabel jLabel1;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel2;
    private JLabel jLabel20;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel24;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JLabel lblCommodityTOEquity;
    private JLabel lblEquityTOCommodity;
    private JLabel lblFundTransferStatement;
    private JLabel lblMessage;
    private JTextField txtAvbAmountCommodity;
    private JTextField txtAvbAmountEquity;
    private JTextField txtBalanceAmountCommodity;
    private JTextField txtBalanceAmountEquity;
    private JPasswordField txtPinCode;
    private JTextField txtTransferAmountCommodity;
    private JTextField txtTransferAmountEquity;

    public JSFundTransfer() {
        this.initComponents();
        Mediator.getInstance().setJSFundTransfer(this);
        this.setEquityAccounts();
        this.setCommodityAccounts();
        this.setEquitytoCommodity();
        this.txtTransferAmountEquity.setDocument((Document)new JTextFieldFilter("0123456789."));
        this.txtTransferAmountCommodity.setDocument((Document)new JTextFieldFilter("0123456789."));
        this.lblFundTransferStatement.setText("<html>" + this.linkText + "</html>");
        this.lblFundTransferStatement.setCursor(Cursor.getPredefinedCursor(12));
        this.txtPinCode.setDocument((Document)new JTextFieldFilter("0123456789", 4));
        this.timer.start();
        this.txtPinCode.setText(LogCommon.pinCode);
    }

    private void setEquityAccounts() {
        this.cbEquityAccount.setModel(new DefaultComboBoxModel<Object>(LogsTC.accountAll.keySet().toArray()));
        AutoCompleteSupport support = AutoCompleteSupport.install((JComboBox)this.cbEquityAccount, (EventList)GlazedLists.eventListOf((Object[])LogsTC.accountAll.keySet().toArray()));
        if (LogCommon.preferredAccount.trim().length() > 0) {
            this.cbEquityAccount.setSelectedItem(LogCommon.preferredAccount);
        } else {
            this.cbEquityAccount.setSelectedItem("");
        }
        support.setStrict(true);
        this.cbEquityAccount.setRenderer(new ComboBoxToolTipRender(LogsTC.accountAll, ""));
        this.cbEquityAccount.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    JSFundTransfer.this.cbEquityAccount.setToolTipText(LogsTC.accountAll.get(JSFundTransfer.this.cbEquityAccount.getSelectedItem().toString().trim()).toString());
                }
                catch (Exception ex) {
                    JSFundTransfer.this.cbEquityAccount.setToolTipText(null);
                }
            }
        });
        this.setAmountRequestEquity();
    }

    private void setCommodityAccounts() {
        Iterator en = LogsPMEX.ALL_ACCOUNTS.keySet().iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (en.hasNext()) {
            String key = en.next().toString();
            AccountBean ac = (AccountBean)LogsPMEX.ALL_ACCOUNTS.get(key);
            list.add(ac.getAccountNo());
        }
        this.cbCommodityAccount.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        AutoCompleteSupport support = AutoCompleteSupport.install((JComboBox)this.cbCommodityAccount, (EventList)GlazedLists.eventListOf((Object[])list.toArray()));
        support.setStrict(false);
        this.cbCommodityAccount.setRenderer(new ComboBoxToolTipRender(LogsPMEX.ALL_ACCOUNTS, ""));
        this.cbCommodityAccount.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    JSFundTransfer.this.cbCommodityAccount.setToolTipText(((AccountBean)LogsPMEX.ALL_ACCOUNTS.get(JSFundTransfer.this.cbCommodityAccount.getSelectedItem().toString().trim())).toString());
                }
                catch (Exception ex) {
                    JSFundTransfer.this.cbCommodityAccount.setToolTipText(null);
                }
            }
        });
        try {
            this.cbCommodityAccount.setSelectedItem("");
        }
        catch (Exception exception) {
            // empty catch block
        }
        support.setStrict(true);
        this.setAmountRequestCommodity();
    }

    public boolean setAmountRequestEquity() {
        if (this.cbEquityAccount.getSelectedItem() == null) {
            this.setEquityEmpty();
            return false;
        }
        if (this.cbEquityAccount.getSelectedItem().toString().trim().length() > 0) {
            String st = this.cbEquityAccount.getSelectedItem().toString();
            if (LogsTC.accountAll.containsKey(st)) {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Loading, (String)"Loading Avaiable Amount");
                LoadLogs availableAmount = new LoadLogs("AvailableAmountByAccount=", true);
                new ThreadWithName(availableAmount, "AvailableAmountByAccount").start();
                return true;
            }
            this.setEquityEmpty();
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Invalid Equity Account");
            this.cbEquityAccount.requestFocus();
            return false;
        }
        this.setEquityEmpty();
        return false;
    }

    public boolean setAmountRequestCommodity() {
        if (this.cbCommodityAccount.getSelectedItem() == null) {
            this.setCommodityEmpty();
            return false;
        }
        if (this.cbCommodityAccount.getSelectedItem().toString().trim().length() > 0) {
            String st = this.cbCommodityAccount.getSelectedItem().toString().trim();
            if (LogsPMEX.ALL_ACCOUNTS.containsKey(st)) {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Loading, (String)"Loading Avaiable Amount");
                LoadLogs availableAmount = new LoadLogs("AvailableAmountByAccountPMEX=", true);
                new ThreadWithName(availableAmount, "AvailableAmountByAccountPMEX").start();
                return true;
            }
            this.setCommodityEmpty();
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Invalid Commodity Account");
            this.cbCommodityAccount.requestFocus();
            return false;
        }
        this.setCommodityEmpty();
        return false;
    }

    private void setEquityEmpty() {
        this.txtAvbAmountEquity.setText("");
        this.txtBalanceAmountEquity.setText("");
        this.txtTransferAmountEquity.setText("");
        this.accountExposureEquity = 0.0;
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
    }

    private void setCommodityEmpty() {
        this.txtAvbAmountCommodity.setText("");
        this.txtBalanceAmountCommodity.setText("");
        this.txtTransferAmountCommodity.setText("");
        this.accountExposureCommodity = 0.0;
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
    }

    private void setRemainingAmountEquity() {
        block4: {
            try {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)" ");
                double amount = Double.parseDouble(this.txtTransferAmountEquity.getText().trim());
                this.txtBalanceAmountEquity.setText(Util.format2digit((String)(this.accountExposureEquity - amount + "")));
                if (amount > this.accountExposureEquity) {
                    Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Insufficient available amount");
                }
                if (!this.txtTransferAmountCommodity.isEditable() && this.cbCommodityAccount.getSelectedItem() != null && this.cbCommodityAccount.getSelectedItem().toString().trim().length() > 0) {
                    this.txtBalanceAmountCommodity.setText(Util.format2digit((String)(this.accountExposureCommodity + amount + "")));
                }
            }
            catch (Exception ex) {
                this.txtBalanceAmountEquity.setText(Util.format2digit((String)(this.accountExposureEquity + "")));
                if (this.txtTransferAmountCommodity.isEditable() || this.cbCommodityAccount.getSelectedItem() == null || this.cbCommodityAccount.getSelectedItem().toString().trim().length() <= 0) break block4;
                this.txtBalanceAmountCommodity.setText(Util.format2digit((String)(this.accountExposureCommodity + "")));
            }
        }
    }

    private void setRemainingAmountCommodity() {
        block4: {
            try {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)" ");
                double amount = Double.parseDouble(this.txtTransferAmountCommodity.getText().trim());
                this.txtBalanceAmountCommodity.setText(Util.format2digit((String)(this.accountExposureCommodity - amount + "")));
                if (amount > this.accountExposureCommodity) {
                    Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Insufficient available amount");
                }
                if (!this.txtTransferAmountEquity.isEditable() && this.cbEquityAccount.getSelectedItem() != null && this.cbEquityAccount.getSelectedItem().toString().trim().length() > 0) {
                    this.txtBalanceAmountEquity.setText(Util.format2digit((String)(this.accountExposureEquity + amount + "")));
                }
            }
            catch (Exception ex) {
                this.txtBalanceAmountCommodity.setText(Util.format2digit((String)(this.accountExposureCommodity + "")));
                if (this.txtTransferAmountEquity.isEditable() || this.cbEquityAccount.getSelectedItem() == null || this.cbEquityAccount.getSelectedItem().toString().trim().length() <= 0) break block4;
                this.txtBalanceAmountEquity.setText(Util.format2digit((String)(this.accountExposureEquity + "")));
            }
        }
    }

    public void setAccountAmountEquity(String result) {
        if (result.equalsIgnoreCase("Exception")) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Error in loading Amount");
            return;
        }
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
        if (result.indexOf("|") >= 0) {
            String[] values = result.split("\\|", -1);
            String state = values[0];
            String amount = values[1];
            if (state.equalsIgnoreCase("true")) {
                try {
                    this.accountExposureEquity = Double.parseDouble(amount);
                    this.txtAvbAmountEquity.setText(Util.format2digit((String)amount));
                }
                catch (Exception ex) {
                    this.accountExposureEquity = 0.0;
                    ex.printStackTrace();
                    this.txtAvbAmountEquity.setText("0.00");
                }
            } else {
                this.txtAvbAmountEquity.setText("0.00");
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)state);
                this.accountExposureEquity = 0.0;
            }
            this.setRemainingAmountEquity();
            this.setRemainingAmountonAccountChangeEquity();
        } else {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Error in loading Account Avaiable Amount");
            this.txtAvbAmountEquity.setText("0.00");
        }
    }

    public void setAccountAmountCommodity(String result) {
        if (result.equalsIgnoreCase("Exception")) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Error in loading Amount");
            return;
        }
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
        if (result.indexOf("|") >= 0) {
            String[] values = result.split("\\|", -1);
            String state = values[0];
            String amount = values[1];
            if (state.equalsIgnoreCase("true")) {
                try {
                    this.accountExposureCommodity = Double.parseDouble(amount);
                    this.txtAvbAmountCommodity.setText(Util.format2digit((String)amount));
                }
                catch (Exception ex) {
                    this.accountExposureCommodity = 0.0;
                    this.txtAvbAmountCommodity.setText("0.00");
                    ex.printStackTrace();
                }
            } else {
                this.txtAvbAmountCommodity.setText("0.00");
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)state);
                this.accountExposureCommodity = 0.0;
            }
            this.setRemainingAmountCommodity();
            this.setRemainingAmountonAccountChangeCommodity();
        } else {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Error in loading Account Avaiable Amount");
            this.txtAvbAmountCommodity.setText("0.00");
        }
    }

    private void setRemainingAmountonAccountChangeCommodity() {
        if (this.txtTransferAmountEquity.isEditable() && this.txtTransferAmountEquity.getText().trim().length() > 0) {
            double equityAmount = Double.parseDouble(this.txtTransferAmountEquity.getText());
            this.txtBalanceAmountCommodity.setText(Util.format2digit((String)(this.accountExposureCommodity + equityAmount + "")) + "");
        }
    }

    private void setRemainingAmountonAccountChangeEquity() {
        if (this.txtTransferAmountCommodity.isEditable() && this.txtTransferAmountCommodity.getText().trim().length() > 0) {
            double commodityAmount = Double.parseDouble(this.txtTransferAmountCommodity.getText());
            this.txtBalanceAmountEquity.setText(Util.format2digit((String)(this.accountExposureEquity + commodityAmount + "")) + "");
        }
    }

    public void OnEnter(KeyEvent evt) {
        Object source = evt.getSource();
        if (evt.getKeyCode() == 10 && source == this.txtPinCode) {
            this.setEquitytoCommodityRequest();
        }
    }

    private void initComponents() {
        this.cbEquityAccount = new JComboBox();
        this.jLabel1 = new JLabel();
        this.cbCommodityAccount = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jLabel3 = new JLabel();
        this.txtAvbAmountEquity = new JTextField();
        this.txtTransferAmountEquity = new JTextField();
        this.txtBalanceAmountEquity = new JTextField();
        this.lblMessage = new JLabel();
        this.jLabel13 = new JLabel();
        this.jLabel18 = new JLabel();
        this.jLabel19 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabel17 = new JLabel();
        this.txtAvbAmountCommodity = new JTextField();
        this.txtTransferAmountCommodity = new JTextField();
        this.txtBalanceAmountCommodity = new JTextField();
        this.jLabel22 = new JLabel();
        this.jLabel23 = new JLabel();
        this.btnFundTransfer = new JButton();
        this.jSeparator2 = new JSeparator();
        this.lblCommodityTOEquity = new JLabel();
        this.jLabel5 = new JLabel();
        this.lblEquityTOCommodity = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel24 = new JLabel();
        this.jLabel20 = new JLabel();
        this.txtPinCode = new JPasswordField();
        this.jLabel11 = new JLabel();
        this.lblFundTransferStatement = new JLabel();
        this.jLabel6 = new JLabel();
        this.jSeparator3 = new JSeparator();
        this.setLayout(null);
        this.cbEquityAccount.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbEquityAccount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSFundTransfer.this.cbEquityAccountActionPerformed(evt);
            }
        });
        this.add(this.cbEquityAccount);
        this.cbEquityAccount.setBounds(110, 80, 140, 20);
        this.jLabel1.setText("Equity Account");
        this.add(this.jLabel1);
        this.jLabel1.setBounds(20, 80, 80, 20);
        this.cbCommodityAccount.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbCommodityAccount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSFundTransfer.this.cbCommodityAccountActionPerformed(evt);
            }
        });
        this.add(this.cbCommodityAccount);
        this.cbCommodityAccount.setBounds(385, 80, 140, 20);
        this.jLabel2.setText("Commodity Account");
        this.add(this.jLabel2);
        this.jLabel2.setBounds(280, 80, 100, 20);
        this.jLabel12.setText("PKR");
        this.add(this.jLabel12);
        this.jLabel12.setBounds(130, 170, 20, 20);
        this.jLabel3.setText("Available Amount");
        this.add(this.jLabel3);
        this.jLabel3.setBounds(20, 110, 100, 20);
        this.txtAvbAmountEquity.setEditable(false);
        this.txtAvbAmountEquity.setHorizontalAlignment(4);
        this.txtAvbAmountEquity.setFocusable(false);
        this.add(this.txtAvbAmountEquity);
        this.txtAvbAmountEquity.setBounds(150, 110, 100, 20);
        this.txtTransferAmountEquity.setHorizontalAlignment(4);
        this.txtTransferAmountEquity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSFundTransfer.this.txtTransferAmountEquityActionPerformed(evt);
            }
        });
        this.txtTransferAmountEquity.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                JSFundTransfer.this.txtTransferAmountEquityFocusLost(evt);
            }
        });
        this.txtTransferAmountEquity.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                JSFundTransfer.this.txtTransferAmountEquityKeyReleased(evt);
            }
        });
        this.add(this.txtTransferAmountEquity);
        this.txtTransferAmountEquity.setBounds(150, 140, 100, 20);
        this.txtBalanceAmountEquity.setEditable(false);
        this.txtBalanceAmountEquity.setHorizontalAlignment(4);
        this.txtBalanceAmountEquity.setFocusable(false);
        this.add(this.txtBalanceAmountEquity);
        this.txtBalanceAmountEquity.setBounds(150, 170, 100, 20);
        this.lblMessage.setText(" ");
        this.add(this.lblMessage);
        this.lblMessage.setBounds(10, 240, 380, 20);
        this.jLabel13.setText("Transfer Amount");
        this.add(this.jLabel13);
        this.jLabel13.setBounds(20, 140, 100, 20);
        this.jLabel18.setText("PKR");
        this.add(this.jLabel18);
        this.jLabel18.setBounds(130, 140, 20, 20);
        this.jLabel19.setText("PKR");
        this.add(this.jLabel19);
        this.jLabel19.setBounds(130, 110, 20, 20);
        this.jSeparator1.setOrientation(1);
        this.add(this.jSeparator1);
        this.jSeparator1.setBounds(266, 80, 3, 115);
        this.jLabel17.setText("PKR");
        this.add(this.jLabel17);
        this.jLabel17.setBounds(405, 170, 20, 20);
        this.txtAvbAmountCommodity.setEditable(false);
        this.txtAvbAmountCommodity.setHorizontalAlignment(4);
        this.txtAvbAmountCommodity.setFocusable(false);
        this.add(this.txtAvbAmountCommodity);
        this.txtAvbAmountCommodity.setBounds(425, 110, 100, 20);
        this.txtTransferAmountCommodity.setHorizontalAlignment(4);
        this.txtTransferAmountCommodity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSFundTransfer.this.txtTransferAmountCommodityActionPerformed(evt);
            }
        });
        this.txtTransferAmountCommodity.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                JSFundTransfer.this.txtTransferAmountCommodityKeyReleased(evt);
            }
        });
        this.add(this.txtTransferAmountCommodity);
        this.txtTransferAmountCommodity.setBounds(425, 140, 100, 20);
        this.txtBalanceAmountCommodity.setEditable(false);
        this.txtBalanceAmountCommodity.setHorizontalAlignment(4);
        this.txtBalanceAmountCommodity.setFocusable(false);
        this.add(this.txtBalanceAmountCommodity);
        this.txtBalanceAmountCommodity.setBounds(425, 170, 100, 20);
        this.jLabel22.setText("PKR");
        this.add(this.jLabel22);
        this.jLabel22.setBounds(405, 140, 20, 20);
        this.jLabel23.setText("PKR");
        this.add(this.jLabel23);
        this.jLabel23.setBounds(405, 110, 20, 20);
        this.btnFundTransfer.setText("Transfer fund");
        this.btnFundTransfer.setName("JSFundTransfer -> btnFundTransfer");
        this.btnFundTransfer.setNextFocusableComponent(this.lblEquityTOCommodity);
        this.btnFundTransfer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSFundTransfer.this.btnFundTransferActionPerformed(evt);
            }
        });
        this.add(this.btnFundTransfer);
        this.btnFundTransfer.setBounds(415, 240, 110, 23);
        this.add(this.jSeparator2);
        this.jSeparator2.setBounds(0, 230, 550, 2);
        this.lblCommodityTOEquity.setHorizontalAlignment(2);
        this.lblCommodityTOEquity.setIcon(new ImageIcon(this.getClass().getResource("/Images/PMEXTOKSEDisable.png")));
        this.lblCommodityTOEquity.setNextFocusableComponent(this.cbEquityAccount);
        this.lblCommodityTOEquity.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                JSFundTransfer.this.lblCommodityTOEquityMousePressed(evt);
            }
        });
        this.add(this.lblCommodityTOEquity);
        this.lblCommodityTOEquity.setBounds(280, 0, 270, 70);
        this.jLabel5.setText("Available Amount");
        this.add(this.jLabel5);
        this.jLabel5.setBounds(280, 110, 100, 20);
        this.lblEquityTOCommodity.setHorizontalAlignment(4);
        this.lblEquityTOCommodity.setIcon(new ImageIcon(this.getClass().getResource("/Images/KSETOPMEX.png")));
        this.lblEquityTOCommodity.setNextFocusableComponent(this.lblCommodityTOEquity);
        this.lblEquityTOCommodity.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                JSFundTransfer.this.lblEquityTOCommodityMousePressed(evt);
            }
        });
        this.add(this.lblEquityTOCommodity);
        this.lblEquityTOCommodity.setBounds(0, 0, 260, 70);
        this.jLabel14.setText("Transfer Amount");
        this.add(this.jLabel14);
        this.jLabel14.setBounds(280, 140, 100, 20);
        this.jLabel24.setText("Balance Amount");
        this.add(this.jLabel24);
        this.jLabel24.setBounds(280, 170, 100, 20);
        this.jLabel20.setText("Balance Amount");
        this.add(this.jLabel20);
        this.jLabel20.setBounds(20, 170, 100, 20);
        this.txtPinCode.setNextFocusableComponent(this.btnFundTransfer);
        this.txtPinCode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSFundTransfer.this.txtPinCodeActionPerformed(evt);
            }
        });
        this.txtPinCode.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                JSFundTransfer.this.txtPinCodeKeyPressed(evt);
            }
        });
        this.add(this.txtPinCode);
        this.txtPinCode.setBounds(485, 200, 40, 20);
        this.jLabel11.setHorizontalAlignment(0);
        this.jLabel11.setText("PIN");
        this.add(this.jLabel11);
        this.jLabel11.setBounds(455, 200, 30, 20);
        this.lblFundTransferStatement.setFont(new Font("Tahoma", 1, 11));
        this.lblFundTransferStatement.setIcon(new ImageIcon(this.getClass().getResource("/Images/FundTransferStatement.png")));
        this.lblFundTransferStatement.setText("Fund Transfer Statement");
        this.lblFundTransferStatement.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                JSFundTransfer.this.lblFundTransferStatementMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                JSFundTransfer.this.lblFundTransferStatementMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                JSFundTransfer.this.lblFundTransferStatementMousePressed(evt);
            }
        });
        this.add(this.lblFundTransferStatement);
        this.lblFundTransferStatement.setBounds(270, 200, 170, 20);
        this.jLabel6.setIcon(new ImageIcon(this.getClass().getResource("/Images/HeaderBG1.png")));
        this.add(this.jLabel6);
        this.jLabel6.setBounds(0, 0, 550, 70);
        this.add(this.jSeparator3);
        this.jSeparator3.setBounds(0, 70, 550, 2);
    }

    private void txtTransferAmountEquityFocusLost(FocusEvent evt) {
        this.setRemainingAmountEquity();
    }

    private void txtTransferAmountEquityKeyReleased(KeyEvent evt) {
        this.setRemainingAmountEquity();
    }

    private void cbEquityAccountActionPerformed(ActionEvent evt) {
        if ((evt.getModifiers() == 16 || evt.getActionCommand().equalsIgnoreCase("comboBoxEdited")) && this.setAmountRequestEquity()) {
            if (this.txtTransferAmountEquity.isEditable()) {
                this.txtTransferAmountEquity.requestFocus();
            } else {
                this.txtPinCode.requestFocus();
            }
        }
    }

    private void txtTransferAmountCommodityKeyReleased(KeyEvent evt) {
        this.setRemainingAmountCommodity();
    }

    private void cbCommodityAccountActionPerformed(ActionEvent evt) {
        if ((evt.getModifiers() == 16 || evt.getActionCommand().equalsIgnoreCase("comboBoxEdited")) && this.setAmountRequestCommodity()) {
            if (this.txtTransferAmountCommodity.isEditable()) {
                this.txtTransferAmountCommodity.requestFocus();
            } else {
                this.txtPinCode.requestFocus();
            }
        }
    }

    private void txtPinCodeActionPerformed(ActionEvent evt) {
        this.setEquitytoCommodityRequest();
    }

    private void btnFundTransferActionPerformed(ActionEvent evt) {
        this.setEquitytoCommodityRequest();
    }

    private void lblFundTransferStatementMousePressed(MouseEvent evt) {
        this.lblFundTransferStatement.setText("<html>" + this.linkText + "</html>");
        TradeCast.getInstance().ShowDynamicForm(FormName.JSFundTransferStatement, Title.FundTransferStatement);
    }

    private void lblEquityTOCommodityMousePressed(MouseEvent evt) {
        this.isEquityTransfer = true;
        this.setEquitytoCommodity();
        this.lblEquityTOCommodity.setIcon(new ImageIcon(this.getClass().getResource("/Images/KSETOPMEX.png")));
        this.lblCommodityTOEquity.setIcon(new ImageIcon(this.getClass().getResource("/Images/PMEXTOKSEDisable.png")));
    }

    private void lblCommodityTOEquityMousePressed(MouseEvent evt) {
        this.isEquityTransfer = false;
        this.setCommoditytoEquity();
        this.lblCommodityTOEquity.setIcon(new ImageIcon(this.getClass().getResource("/Images/PMEXTOKSE.png")));
        this.lblEquityTOCommodity.setIcon(new ImageIcon(this.getClass().getResource("/Images/KSETOPMEXDisable.png")));
    }

    private void lblFundTransferStatementMouseEntered(MouseEvent evt) {
        this.lblFundTransferStatement.setText("<html><u>" + this.linkText + "</u></html>");
    }

    private void lblFundTransferStatementMouseExited(MouseEvent evt) {
        this.lblFundTransferStatement.setText("<html>" + this.linkText + "</html>");
    }

    private void txtPinCodeKeyPressed(KeyEvent evt) {
        this.OnEnter(evt);
    }

    private void txtTransferAmountEquityActionPerformed(ActionEvent evt) {
        this.cbCommodityAccount.requestFocus();
    }

    private void txtTransferAmountCommodityActionPerformed(ActionEvent evt) {
        this.cbEquityAccount.requestFocus();
    }

    private void setEquitytoCommodity() {
        this.txtTransferAmountEquity.setEditable(true);
        this.txtTransferAmountCommodity.setEditable(false);
        this.txtTransferAmountCommodity.setText("");
        this.txtBalanceAmountEquity.setText(this.txtAvbAmountEquity.getText());
        this.txtBalanceAmountCommodity.setText(this.txtAvbAmountCommodity.getText());
        this.txtTransferAmountEquity.requestFocus();
    }

    private void setCommoditytoEquity() {
        this.txtTransferAmountEquity.setEditable(false);
        this.txtTransferAmountCommodity.setEditable(true);
        this.txtTransferAmountEquity.setText("");
        this.txtBalanceAmountEquity.setText(this.txtAvbAmountEquity.getText());
        this.txtBalanceAmountCommodity.setText(this.txtAvbAmountCommodity.getText());
        this.txtTransferAmountCommodity.requestFocus();
    }

    public void setEquitytoCommodityRequest() {
        if (this.isEquityTransfer) {
            this.EquityTOCommodity();
        }
        if (!this.isEquityTransfer) {
            this.CommodityTOEquity();
        }
    }

    private void setEmpty() {
        this.txtTransferAmountEquity.setText("");
        this.txtTransferAmountCommodity.setText("");
        this.txtBalanceAmountEquity.setText("");
        this.txtBalanceAmountCommodity.setText("");
        try {
            this.cbEquityAccount.setSelectedIndex(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            this.cbCommodityAccount.setSelectedIndex(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.txtAvbAmountEquity.setText("");
        this.txtAvbAmountCommodity.setText("");
    }

    private void EquityTOCommodity() {
        if (this.isValidInput()) {
            this.submitRequest("KSE to PMEX");
        }
    }

    private void CommodityTOEquity() {
        if (this.isValidInput()) {
            this.submitRequest("PMEX to KSE");
        }
    }

    private boolean isValidInput() {
        if (this.cbEquityAccount.getSelectedItem() == null) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please select Equity account");
            this.cbEquityAccount.requestFocus();
            return false;
        }
        if (this.cbEquityAccount.getSelectedItem().toString().length() <= 0) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please select Equity account");
            this.cbEquityAccount.requestFocus();
            return false;
        }
        if (this.cbCommodityAccount.getSelectedItem() == null) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please select Commmodity account");
            this.cbCommodityAccount.requestFocus();
            return false;
        }
        if (this.cbCommodityAccount.getSelectedItem().toString().length() <= 0) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please select Commmodity account");
            this.cbCommodityAccount.requestFocus();
            return false;
        }
        if (this.isEquityTransfer) {
            if (this.txtTransferAmountEquity.getText().trim().length() <= 0) {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"You cannot transfer zero Rupee");
                this.txtTransferAmountEquity.requestFocus();
                return false;
            }
            if (Double.parseDouble(this.txtTransferAmountEquity.getText()) <= 0.0) {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"You cannot transfer zero Rupee");
                this.txtTransferAmountEquity.requestFocus();
                return false;
            }
            if (Double.parseDouble(this.txtTransferAmountEquity.getText()) > this.accountExposureEquity) {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Insufficient Equity available amount");
                this.txtTransferAmountEquity.requestFocus();
                return false;
            }
        } else {
            if (this.txtTransferAmountCommodity.getText().trim().length() <= 0) {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"You cannot transfer zero Rupee");
                this.txtTransferAmountCommodity.requestFocus();
                return false;
            }
            if (Double.parseDouble(this.txtTransferAmountCommodity.getText()) <= 0.0) {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"You cannot transfer zero Rupee");
                this.txtTransferAmountCommodity.requestFocus();
                return false;
            }
            if (Double.parseDouble(this.txtTransferAmountCommodity.getText()) > this.accountExposureCommodity) {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Insufficient Commmodity available amount");
                this.txtTransferAmountCommodity.requestFocus();
                return false;
            }
        }
        if (this.txtPinCode.getText().length() <= 0) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please enter PIN");
            this.txtPinCode.requestFocus();
            return false;
        }
        if (this.txtPinCode.getText().length() < 4) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"PIN length should be four digits");
            this.txtPinCode.requestFocus();
            return false;
        }
        String equityAcc = this.cbEquityAccount.getSelectedItem().toString();
        String commodityAcc = this.cbCommodityAccount.getSelectedItem().toString();
        if (!LogsTC.accountAll.containsKey(equityAcc)) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Invalid Equity account");
            this.cbEquityAccount.requestFocus();
            return false;
        }
        if (!LogsPMEX.ALL_ACCOUNTS.containsKey(commodityAcc)) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Invalid Commmodity account");
            this.cbCommodityAccount.requestFocus();
            return false;
        }
        return true;
    }

    private void submitRequest(final String type) {
        new Thread("JSFundTransfer " + type){

            @Override
            public void run() {
                try {
                    Util.setMessage((JLabel)JSFundTransfer.this.lblMessage, (MessageType)MessageType.Loading, (String)"Please wait while submitting...");
                    JSFundTransfer.this.btnFundTransfer.setEnabled(false);
                    String pinCode = EncryptDecrypt.getInstance().EncryptText(String.valueOf(JSFundTransfer.this.txtPinCode.getPassword()));
                    String amount = "0";
                    amount = type.equalsIgnoreCase("Equity to Commodity") || type.equalsIgnoreCase("KSE to PMEX") ? JSFundTransfer.this.txtTransferAmountEquity.getText().trim() : JSFundTransfer.this.txtTransferAmountCommodity.getText().trim();
                    String result = WebService.getInstance().getPort().setWithdrawlRequest(LogCommon.UserID, pinCode, amount, "", JSFundTransfer.this.cbEquityAccount.getSelectedItem().toString(), type, JSFundTransfer.this.cbCommodityAccount.getSelectedItem().toString(), "FundTransfer");
                    Util.setMessage((JLabel)JSFundTransfer.this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
                    if (result.equalsIgnoreCase("Success")) {
                        JOptionPane.showMessageDialog(TradeCast.getInstance().frame, "Your request has been submitted.               ", LanguageConstant.JSFundTransferRequest, 1);
                        JSFundTransfer.this.setEmpty();
                        JSFundTransfer.this.setAmountRequestEquity();
                        JSFundTransfer.this.setAmountRequestCommodity();
                        JSFundTransfer.this.setRemainingAmountEquity();
                        JSFundTransfer.this.setRemainingAmountCommodity();
                    } else if (result.equalsIgnoreCase("Invalid Pincode")) {
                        Util.setMessage((JLabel)JSFundTransfer.this.lblMessage, (MessageType)MessageType.Error, (String)"Invalid PIN");
                        JSFundTransfer.this.txtPinCode.requestFocus();
                    } else if (result.equalsIgnoreCase("Error")) {
                        Util.setMessage((JLabel)JSFundTransfer.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in submitting");
                    } else {
                        Util.setMessage((JLabel)JSFundTransfer.this.lblMessage, (MessageType)MessageType.Error, (String)result);
                    }
                    JSFundTransfer.this.btnFundTransfer.setEnabled(true);
                }
                catch (Exception ex) {
                    Util.setMessage((JLabel)JSFundTransfer.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in submitting request");
                    JSFundTransfer.this.btnFundTransfer.setEnabled(true);
                    Mediator.getInstance().PrintLog(ex, "");
                    ex.printStackTrace();
                }
            }
        }.start();
    }
}

