/*
 * Decompiled with CFR 0.152.
 */
package windows.js;

import Beans.JSFundTransferStatementBean;
import CATALYST.Socket.EncryptDecrypt;
import Control.JasperFileChooser;
import Control.ReportControl;
import Control.ReportControlEvent;
import Control.ReportControlListener;
import CustomComponent.MyTime;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import RendersNModels.FundTransferStatementCellRender;
import RendersNModels.FundTransferStatementModel;
import Utilities.LogsTC;
import common.bean.AccountBean;
import common.gui.component.JTextFieldFilter;
import common.gui.component.NxGTable;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import languages.LanguageCentre;
import languages.LanguageConstant;
import org.jdesktop.swingx.JXDatePicker;
import reports.Jasper_Report;
import reports.Report_WithdrawlStatement;

public class JSFundTransferStatement
extends JPanel
implements FocusListener,
ReportControlListener {
    Mediator mediator = Mediator.getInstance();
    HashMap<String, String> map = new HashMap();
    Vector<JSFundTransferStatementBean> rows = new Vector();
    Vector column = new Vector();
    FundTransferStatementModel model = null;
    private int rowindex = -1;
    private FundTransferStatementCellRender render = new FundTransferStatementCellRender();
    private final String linkText = LanguageConstant.JSFundTransferRequest;
    private LanguageCentre languageCentre = new LanguageCentre();
    Timer timer = new Timer(10, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JSFundTransferStatement.this.txtStartDate.requestFocus();
            JSFundTransferStatement.this.timer.stop();
        }
    });
    private JButton btnGet;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JLabel lblFundTransferRequest;
    private JLabel lblMessage;
    private JMenuItem menuCancel;
    private JPopupMenu poopupMenu;
    private ReportControl reportControl1;
    private NxGTable table;
    private JXDatePicker txtEndDate;
    private JPasswordField txtPinCode;
    private JXDatePicker txtStartDate;
    public String JRXMLFileName = "Withdrawlstatement.jrxml";

    public JSFundTransferStatement() {
        this.mediator.setFundTransferStatement(this);
        this.initComponents();
        this.reportControl1.setVisible(false);
        this.column.add("Requested Date");
        this.column.add("Equity Account");
        this.column.add("Commodity Account");
        this.column.add("Type");
        this.column.add("Status");
        this.column.add("Requested Amount");
        this.column.add("Approved Amount");
        this.model = new FundTransferStatementModel((Vector)this.rows, this.column);
        this.table.setModel((TableModel)this.model);
        this.table.setRowHeight(AppConfig.rowHeight);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)this.render);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setSelectionMode(0);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(170);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(170);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(170);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(170);
        this.table.getColumnModel().getColumn(5).setPreferredWidth(170);
        this.table.getColumnModel().getColumn(6).setPreferredWidth(200);
        JTableHeader header = this.table.getTableHeader();
        ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(0);
        this.table.setSortable(false);
        String[] names = new String[LogsTC.accountAll.size()];
        int i = 0;
        for (String key : LogsTC.accountAll.keySet()) {
            AccountBean ac = LogsTC.accountAll.get(key);
            names[i++] = ac.getName();
        }
        this.txtPinCode.addFocusListener(this);
        this.txtPinCode.setDocument((Document)new JTextFieldFilter("0123456789", 4));
        this.txtStartDate.setFormats(new DateFormat[]{LogsTC.dateFormatAcc});
        this.txtEndDate.setFormats(new DateFormat[]{LogsTC.dateFormatAcc});
        this.txtStartDate.setDate(new Date(System.currentTimeMillis()));
        this.txtEndDate.setDate(new Date(System.currentTimeMillis()));
        this.lblFundTransferRequest.setText("<html>" + this.linkText + "</html>");
        this.lblFundTransferRequest.setCursor(Cursor.getPredefinedCursor(12));
        this.reportControl1.addListener(this);
        this.map.put("N", "In Process");
        this.map.put("A", "Approved");
        this.map.put("P", "Pending");
        this.map.put("R", "Rejected");
        this.map.put("C", "Cancel");
        this.table.setComponentPopupMenu(this.poopupMenu);
        this.txtPinCode.setDocument((Document)new JTextFieldFilter("0123456789", 4));
        for (int j = 0; j < this.table.getColumnCount(); ++j) {
            this.table.getColumnExt(j).setCellRenderer((TableCellRenderer)this.render);
        }
        this.setSorter();
        this.timer.start();
        this.txtPinCode.setText(LogCommon.pinCode);
    }

    private void initComponents() {
        this.poopupMenu = new JPopupMenu();
        this.menuCancel = new JMenuItem();
        this.lblMessage = new JLabel();
        this.jLabel2 = new JLabel();
        this.txtPinCode = new JPasswordField();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.btnGet = new JButton();
        this.lblFundTransferRequest = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.reportControl1 = new ReportControl();
        this.txtEndDate = new JXDatePicker();
        this.txtStartDate = new JXDatePicker();
        this.jScrollPane1 = new JScrollPane();
        this.table = new NxGTable();
        this.menuCancel.setIcon(new ImageIcon(this.getClass().getResource("/Images/close16.png")));
        this.menuCancel.setText("Cancel                                ");
        this.menuCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSFundTransferStatement.this.menuCancelActionPerformed(evt);
            }
        });
        this.poopupMenu.add(this.menuCancel);
        this.lblMessage.setVerticalAlignment(1);
        this.lblMessage.setFocusable(false);
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText("PIN");
        this.txtPinCode.setPreferredSize(new Dimension(5, 18));
        this.txtPinCode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSFundTransferStatement.this.txtPinCodeActionPerformed(evt);
            }
        });
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText("Start Date");
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setText("End Date");
        this.btnGet.setIcon(new ImageIcon(this.getClass().getResource("/Images/get.png")));
        this.btnGet.setText("Get");
        this.btnGet.setName("JSFundTransferStatement -> btnGet");
        this.btnGet.setPreferredSize(new Dimension(49, 20));
        this.btnGet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSFundTransferStatement.this.btnGetActionPerformed(evt);
            }
        });
        this.lblFundTransferRequest.setFont(new Font("Tahoma", 1, 11));
        this.lblFundTransferRequest.setHorizontalAlignment(0);
        this.lblFundTransferRequest.setIcon(new ImageIcon(this.getClass().getResource("/Images/MenuFundTransfer.png")));
        this.lblFundTransferRequest.setText("Fund Transfer Request");
        this.lblFundTransferRequest.setPreferredSize(new Dimension(57, 18));
        this.lblFundTransferRequest.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                JSFundTransferStatement.this.lblFundTransferRequestMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                JSFundTransferStatement.this.lblFundTransferRequestMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                JSFundTransferStatement.this.lblFundTransferRequestMousePressed(evt);
            }
        });
        this.txtEndDate.setPreferredSize(new Dimension(110, 18));
        this.txtEndDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSFundTransferStatement.this.txtEndDateActionPerformed(evt);
            }
        });
        this.txtStartDate.setPreferredSize(new Dimension(110, 18));
        this.txtStartDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSFundTransferStatement.this.txtStartDateActionPerformed(evt);
            }
        });
        this.table.setModel((TableModel)new DefaultTableModel(new Object[0][], new String[]{"1", "1"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Long.class};
                this.canEdit = new boolean[]{true, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane1.setViewportView((Component)this.table);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addGap(10, 10, 10).addComponent((Component)this.txtStartDate, -2, -1, -2).addGap(10, 10, 10).addComponent(this.jLabel4).addGap(6, 6, 6).addComponent((Component)this.txtEndDate, -2, -1, -2).addGap(10, 10, 10).addComponent(this.jLabel2, -2, 21, -2).addGap(4, 4, 4).addComponent(this.txtPinCode, -2, 36, -2).addGap(9, 9, 9).addComponent(this.btnGet, -2, 81, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblFundTransferRequest, -2, 160, -2).addGap(50, 50, 50).addComponent(this.reportControl1, -2, -1, -2)).addComponent(this.jScrollPane1).addComponent(this.lblMessage, -2, 560, -2)).addGap(10, 10, 10)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, -2, 23, -2).addComponent((Component)this.txtStartDate, -2, 23, -2).addComponent(this.jLabel4, -2, 23, -2).addComponent((Component)this.txtEndDate, -2, 23, -2).addComponent(this.jLabel2, -2, 23, -2).addComponent(this.txtPinCode, -2, 23, -2).addComponent(this.btnGet, -2, 23, -2).addComponent(this.lblFundTransferRequest, -2, 23, -2).addComponent(this.reportControl1, -2, -1, -2)).addGap(7, 7, 7).addComponent(this.jScrollPane1, -1, 270, Short.MAX_VALUE).addGap(5, 5, 5).addComponent(this.jSeparator1, -2, 3, -2).addGap(2, 2, 2).addComponent(this.lblMessage, -2, 20, -2)));
    }

    private void btnGetActionPerformed(ActionEvent evt) {
        this.getWithdrawalStatement();
    }

    private synchronized void fillTable(String result) {
        if (result == null) {
            return;
        }
        if (result.indexOf("|") >= 0) {
            String[] row = result.split("\\|", -1);
            for (int i = 0; i < row.length - 1; ++i) {
                JSFundTransferStatementBean b = JSFundTransferStatementBean.parse(row[i]);
                this.rows.addElement(b);
            }
        }
        this.model.fireTableDataChanged();
        this.table.addNotify();
        this.table.packAll();
        this.table.repaint();
        this.repaint();
        if (this.rows.size() <= 1) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Normal, (String)(Util.format0digit((String)(this.rows.size() + "")) + " record found."));
        } else {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Normal, (String)(Util.format0digit((String)(this.rows.size() + "")) + " records found."));
        }
    }

    private void txtPinCodeActionPerformed(ActionEvent evt) {
        if (this.txtPinCode.getText().length() <= 0) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please enter PIN");
            this.txtPinCode.requestFocus();
        } else if (this.txtPinCode.getText().length() < 4) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"PIN length should be four digits");
            this.txtPinCode.requestFocus();
        } else {
            this.getWithdrawalStatement();
        }
    }

    private void menuCancelActionPerformed(ActionEvent evt) {
        int row = this.table.getSelectedRow();
        JSFundTransferStatementBean b = this.rows.get(row);
        Integer ID = b.getId();
        String status = b.getStatus();
        if (!status.equalsIgnoreCase("In Process")) {
            JOptionPane.showMessageDialog(TradeCast.getInstance().frame, "This Fund Transfer request cannot be cancelled!");
            return;
        }
        int choice = JOptionPane.showConfirmDialog(TradeCast.getInstance().frame, "Do you want to cancel this Fund Transfer request?", "Confirmation", 2, 0);
        if (choice == 0) {
            if (status.equalsIgnoreCase("In Process")) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                final String serialNo = ID + "";
                String reqDate = this.table.getModel().getValueAt(row, 2).toString().trim();
                Date dd = null;
                try {
                    dd = df.parse(reqDate);
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                    dd = new Date(System.currentTimeMillis());
                }
                final String requestedDate = df.format(dd);
                new Thread("JSFundTransferStatement menuCancel"){

                    @Override
                    public void run() {
                        String result = "";
                        try {
                            Util.setMessage((JLabel)JSFundTransferStatement.this.lblMessage, (MessageType)MessageType.Loading, (String)"Please wait");
                            result = WebService.getInstance().getPort().updateWithdrawalRequest(LogCommon.UserID, "", serialNo, requestedDate, "C", "FundTransfer");
                            if (result.equalsIgnoreCase("Success")) {
                                Util.setMessage((JLabel)JSFundTransferStatement.this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
                                JOptionPane.showMessageDialog(TradeCast.getInstance().frame, "Fund Transfer cancellation request has been sent.", "Request submitted", 1);
                                JSFundTransferStatement.this.getWithdrawalStatement();
                            } else {
                                Util.setMessage((JLabel)JSFundTransferStatement.this.lblMessage, (MessageType)MessageType.Error, (String)result);
                            }
                        }
                        catch (Exception ex) {
                            Util.setMessage((JLabel)JSFundTransferStatement.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in submitting cancellation request");
                            Mediator.getInstance().PrintLog(ex, result);
                            ex.printStackTrace();
                        }
                    }
                }.start();
            } else {
                JOptionPane.showMessageDialog(TradeCast.getInstance().frame, "Request can not be cancel!");
            }
        }
    }

    private void txtStartDateActionPerformed(ActionEvent evt) {
        if (this.txtStartDate.getDate() == null) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please select start date");
            this.txtStartDate.requestFocus();
        } else {
            this.txtEndDate.requestFocus();
        }
    }

    private void txtEndDateActionPerformed(ActionEvent evt) {
        if (this.txtEndDate.getDate() == null) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please select end date");
            this.txtEndDate.requestFocus();
        } else {
            this.txtPinCode.requestFocus();
        }
    }

    private void lblFundTransferRequestMouseEntered(MouseEvent evt) {
        this.lblFundTransferRequest.setText("<html><u>" + this.linkText + "</u></html>");
    }

    private void lblFundTransferRequestMouseExited(MouseEvent evt) {
        this.lblFundTransferRequest.setText("<html>" + this.linkText + "</html>");
    }

    private void lblFundTransferRequestMousePressed(MouseEvent evt) {
        this.lblFundTransferRequest.setText("<html>" + this.linkText + "</html>");
        TradeCast.getInstance().ShowDynamicForm(FormName.JSFundTransferRequest, LanguageConstant.JSFundTransferRequest);
    }

    private void setSorter() {
        JTableHeader header = this.table.getTableHeader();
        header.addMouseListener(new ColumnListner(this.table));
        header.setReorderingAllowed(false);
    }

    @Override
    public void focusGained(FocusEvent e) {
        Object source = e.getSource();
        if (source == this.txtPinCode) {
            this.txtPinCode.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void ReportControl_Print(ReportControlEvent e) {
        Report_WithdrawlStatement Report = new Report_WithdrawlStatement(this.JRXMLFileName, this.table.getModel());
        this.SetParamenters((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        Report.PrintReport();
    }

    @Override
    public void ReportControl_Save(ReportControlEvent e) {
        String FileName;
        boolean result;
        Report_WithdrawlStatement Report = new Report_WithdrawlStatement(this.JRXMLFileName, this.table.getModel());
        this.SetParamenters((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File("Cash Withdrawal Statement-" + MyTime.getInstance().getDate()));
        fc.addAllJasperChoosableFileFilter();
        fc.setAcceptAllFileFilterUsed(false);
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null && !(result = Report.Export(FileName = fc.getSelectedFile().getAbsolutePath() + "." + fc.getExtenstion()))) {
            JOptionPane.showMessageDialog(null, "Error in saving file.");
        }
    }

    @Override
    public void ReportControl_Pdf(ReportControlEvent e) {
        int Option;
        String FileName;
        boolean result;
        Report_WithdrawlStatement Report = new Report_WithdrawlStatement(this.JRXMLFileName, this.table.getModel());
        this.SetParamenters((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File("Cash Withdrawl Statement-" + MyTime.getInstance().getDate()));
        fc.addPdfFileFilter();
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null && (result = Report.ExportToPdf(FileName = fc.getSelectedFile().getAbsolutePath().replaceAll("\"", "") + "." + fc.getExtenstion())) && (Option = JOptionPane.showConfirmDialog(null, "Withdraw Statement report created. Do you want to open it?", "PDF", 0)) == 0) {
            try {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + FileName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void ReportControl_View(ReportControlEvent e) {
        Report_WithdrawlStatement Report = new Report_WithdrawlStatement(this.JRXMLFileName, this.table.getModel());
        this.SetParamenters((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        Report.generateReport();
    }

    @Override
    public void ReportControl_CustomExport(ReportControlEvent e) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void SetParamenters(Jasper_Report Report) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("Title", AppConfig.companyName);
        param.put("PrintDate", MyTime.getInstance().getTimeAndDateForReport());
        param.put("FromDate", LogsTC.dateFormatAcc.format(this.txtStartDate.getDate()));
        param.put("ToDate", LogsTC.dateFormatAcc.format(this.txtEndDate.getDate()));
        Report.SetParameter(param);
    }

    private void getWithdrawalStatement() {
        if (this.txtStartDate.getDate() == null) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please select start date");
            this.txtStartDate.requestFocus();
        } else if (this.txtEndDate.getDate() == null) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please select end date");
            this.txtEndDate.requestFocus();
        } else if (this.txtEndDate.getDate().compareTo(this.txtStartDate.getDate()) == -1) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Start date should grater then OR equal from end date");
            this.txtStartDate.requestFocus();
        } else if (this.txtPinCode.getText().length() <= 0) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please enter PIN");
            this.txtPinCode.requestFocus();
        } else if (this.txtPinCode.getText().length() < 4) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"PIN length should be four digit");
            this.txtPinCode.requestFocus();
        } else {
            this.rows.clear();
            this.model.fireTableDataChanged();
            this.table.addNotify();
            this.table.repaint();
            new Thread(){

                @Override
                public void run() {
                    String result = "";
                    try {
                        Util.setMessage((JLabel)JSFundTransferStatement.this.lblMessage, (MessageType)MessageType.Loading, (String)JSFundTransferStatement.this.languageCentre.getValue(LanguageConstant.Loading));
                        String pinCode = EncryptDecrypt.getInstance().EncryptText(String.valueOf(JSFundTransferStatement.this.txtPinCode.getPassword()));
                        String startDate_ = LogsTC.dateFormatAcc.format(JSFundTransferStatement.this.txtStartDate.getDate());
                        String endDate_ = LogsTC.dateFormatAcc.format(JSFundTransferStatement.this.txtEndDate.getDate());
                        result = WebService.getInstance().getPort().getWithdrawalStatement(LogCommon.UserID, pinCode, "", startDate_, endDate_, "FundTransfer");
                        if (result.equalsIgnoreCase("Error")) {
                            Util.setMessage((JLabel)JSFundTransferStatement.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in loading Fund Transfer Statement");
                        } else if (result.equalsIgnoreCase("Invalid Pincode")) {
                            Util.setMessage((JLabel)JSFundTransferStatement.this.lblMessage, (MessageType)MessageType.Information, (String)"Invalid PIN");
                            JSFundTransferStatement.this.txtPinCode.requestFocus();
                        } else if (result.equalsIgnoreCase("No Record Found")) {
                            Util.setMessage((JLabel)JSFundTransferStatement.this.lblMessage, (MessageType)MessageType.Information, (String)"No record found");
                        } else {
                            JSFundTransferStatement.this.fillTable(result);
                        }
                    }
                    catch (Exception ex) {
                        Util.setMessage((JLabel)JSFundTransferStatement.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in loading Fund Transfer Statement");
                        JSFundTransferStatement.this.mediator.println(ex.toString());
                        JSFundTransferStatement.this.mediator.PrintLog(ex, result);
                    }
                }
            }.start();
        }
    }

    private class ColumnListner
    extends MouseAdapter {
        private final NxGTable table;
        protected int sortCol = 0;
        protected boolean isSortAsc = true;
        private TableColumnModel colModel;

        public ColumnListner(NxGTable table) {
            this.table = table;
            this.colModel = table.getColumnModel();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int columnModelIndex = this.colModel.getColumnIndexAtX(e.getX());
            int modelIndex = this.colModel.getColumn(columnModelIndex).getModelIndex();
            if (modelIndex < 0) {
                return;
            }
            if (this.sortCol == modelIndex) {
                this.isSortAsc = !this.isSortAsc;
            } else {
                this.sortCol = modelIndex;
            }
            this.table.getTableHeader().repaint();
            Collections.sort(JSFundTransferStatement.this.rows, new FundTransferComparator(this.sortCol, this.isSortAsc));
            this.table.tableChanged(new TableModelEvent(JSFundTransferStatement.this.model));
            this.table.packAll();
            this.table.repaint();
        }
    }

    private class FundTransferComparator
    implements Comparator<JSFundTransferStatementBean> {
        int colIndex = 0;
        boolean isAsc = true;

        public FundTransferComparator(int colIndex, boolean isAsc) {
            this.colIndex = colIndex;
            this.isAsc = isAsc;
        }

        @Override
        public int compare(JSFundTransferStatementBean o1, JSFundTransferStatementBean o2) {
            int result = 0;
            switch (this.colIndex) {
                case 0: {
                    result = o1.getRequestedDate().compareTo(o2.getRequestedDate());
                    break;
                }
                case 1: {
                    result = o1.getEquityAccount().compareTo(o2.getEquityAccount());
                    break;
                }
                case 2: {
                    result = o1.getCommodityAccount().compareTo(o2.getCommodityAccount());
                    break;
                }
                case 3: {
                    result = o1.getType().compareTo(o2.getType());
                    break;
                }
                case 4: {
                    result = o1.getStatus().compareTo(o2.getStatus());
                    break;
                }
                case 5: {
                    result = o1.getRequestedAmount() < o2.getRequestedAmount() ? -1 : (o1.getRequestedAmount() > o2.getRequestedAmount() ? 1 : 0);
                    break;
                }
                case 6: {
                    int n = o1.getApprovedAmount() < o2.getApprovedAmount() ? -1 : (result = o1.getApprovedAmount() > o2.getApprovedAmount() ? 1 : 0);
                }
            }
            if (!this.isAsc) {
                result = -result;
            }
            return result;
        }
    }
}

