/*
 * Decompiled with CFR 0.152.
 */
package windows.js;

import CustomComponent.NxGLabelGradeint;
import CustomComponent.NxGTableCellRender;
import RendersNModels.OpenPositionModel;
import common.gui.util.AppConfig;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;

public class JSOpenPositionDetail
extends JPanel {
    Position openPosition = new Position();
    public DefaultTableModel model = null;
    Vector openColumns = new Vector();
    public Vector openRow = new Vector();
    ImageIcon loaderIcon = new ImageIcon(this.getClass().getResource(AppConfig.loaderIconPath));
    public boolean IsModelExist = false;
    ArrayList DataType = new ArrayList();
    public double[] Total;
    private PositionTableCellRenderer render = new PositionTableCellRenderer();
    private JLabel lblMessage = null;
    private JScrollPane jScrollPane2;
    private JTable table;

    public JSOpenPositionDetail(JLabel lbl) {
        this.initComponents();
        this.lblMessage = lbl;
    }

    public synchronized void setPortfolio(String msg) {
        this.openPosition.fillPosition(msg);
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.table = new JTable();
        this.setBorder(BorderFactory.createTitledBorder(null, " Today Position ", 0, 0, new Font("Tahoma", 1, 10)));
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.table.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane2.setViewportView(this.table);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.jScrollPane2, -1, 80, Short.MAX_VALUE).addGap(2, 2, 2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.jScrollPane2, -1, 87, Short.MAX_VALUE)));
    }

    public void reset() {
        this.openPosition.removeOpenTable();
    }

    public JTable getTable() {
        return this.table;
    }

    private class Position {
        public synchronized void fillPosition(String msg) {
            JSOpenPositionDetail.this.lblMessage.setText("");
            JSOpenPositionDetail.this.lblMessage.setIcon(null);
            this.removeOpenTable();
            if (msg.indexOf("|") < 0) {
                JSOpenPositionDetail.this.lblMessage.setForeground(MyColors.successMessageFG);
                JSOpenPositionDetail.this.lblMessage.setText("No record found");
                JSOpenPositionDetail.this.lblMessage.setIcon(null);
                return;
            }
            boolean Added = false;
            String[] str = msg.trim().split("\\|", -1);
            JSOpenPositionDetail.this.openColumns.clear();
            String[] Header = str[0].split("\\;", -1);
            for (int i = 0; i < Header.length; ++i) {
                JSOpenPositionDetail.this.openColumns.add(Header[i]);
            }
            JSOpenPositionDetail.this.DataType.clear();
            if (str.length < 2) {
                JSOpenPositionDetail.this.lblMessage.setForeground(MyColors.successMessageFG);
                JSOpenPositionDetail.this.lblMessage.setText("No record found");
                JSOpenPositionDetail.this.lblMessage.setIcon(null);
                return;
            }
            for (int rowS = 1; rowS < str.length; ++rowS) {
                Vector<String> row = new Vector<String>();
                if (str[rowS].length() <= 0) continue;
                String[] str2 = str[rowS].split("\\;", -1);
                if (str2.length <= 0) {
                    JSOpenPositionDetail.this.lblMessage.setForeground(MyColors.successMessageFG);
                    JSOpenPositionDetail.this.lblMessage.setText("No record found");
                    JSOpenPositionDetail.this.lblMessage.setIcon(null);
                    return;
                }
                for (int col = 0; col < str2.length; ++col) {
                    String s = str2[col].replaceAll("\\,", "");
                    row.addElement(String.valueOf(s));
                    if (rowS != 1) continue;
                    this.SetDataType(s);
                }
                Added = true;
                JSOpenPositionDetail.this.openRow.addElement(row);
            }
            if (Added && JSOpenPositionDetail.this.IsModelExist) {
                JSOpenPositionDetail.this.table.addNotify();
            }
            if (!JSOpenPositionDetail.this.IsModelExist) {
                JSOpenPositionDetail.this.IsModelExist = true;
                JSOpenPositionDetail.this.model = new OpenPositionModel(JSOpenPositionDetail.this.openRow, JSOpenPositionDetail.this.openColumns);
                JSOpenPositionDetail.this.table.setModel(JSOpenPositionDetail.this.model);
                JSOpenPositionDetail.this.table.setRowHeight(AppConfig.rowHeight);
                JSOpenPositionDetail.this.table.setSelectionMode(0);
                for (int k = 0; k < JSOpenPositionDetail.this.openColumns.size(); ++k) {
                    JSOpenPositionDetail.this.table.getColumn(JSOpenPositionDetail.this.openColumns.elementAt(k)).setCellRenderer(JSOpenPositionDetail.this.render);
                }
                JSOpenPositionDetail.this.table.setAutoCreateRowSorter(false);
                JTableHeader header = JSOpenPositionDetail.this.table.getTableHeader();
                ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(0);
            }
            if (JSOpenPositionDetail.this.table.getRowCount() > 1) {
                JSOpenPositionDetail.this.lblMessage.setText(Util.format0digit((String)(JSOpenPositionDetail.this.table.getRowCount() + "".trim().replaceAll("\\,", ""))) + " records found.");
            } else {
                JSOpenPositionDetail.this.lblMessage.setText(Util.format0digit((String)(JSOpenPositionDetail.this.table.getRowCount() + "".trim().replaceAll("\\,", ""))) + " record found.");
            }
            JSOpenPositionDetail.this.lblMessage.setIcon(null);
            this.tableDataChange();
            JSOpenPositionDetail.this.repaint();
        }

        private void tableDataChange() {
            if (SwingUtilities.isEventDispatchThread()) {
                if (JSOpenPositionDetail.this.model != null) {
                    JSOpenPositionDetail.this.model.fireTableDataChanged();
                }
                JSOpenPositionDetail.this.table.addNotify();
                JSOpenPositionDetail.this.table.repaint();
                JSOpenPositionDetail.this.repaint();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (JSOpenPositionDetail.this.model != null) {
                            JSOpenPositionDetail.this.model.fireTableDataChanged();
                        }
                        JSOpenPositionDetail.this.table.addNotify();
                        JSOpenPositionDetail.this.table.repaint();
                        JSOpenPositionDetail.this.repaint();
                    }
                });
            }
        }

        public void removeOpenTable() {
            JSOpenPositionDetail.this.openRow.clear();
            this.tableDataChange();
        }

        public void SetDataType(String Val) {
            try {
                if (Val.indexOf(".") > -1) {
                    Double.parseDouble(Val.replaceAll("\\,", ""));
                    JSOpenPositionDetail.this.DataType.add("Double");
                } else {
                    Integer.parseInt(Val.replaceAll("\\,", ""));
                    JSOpenPositionDetail.this.DataType.add("Integer");
                }
            }
            catch (Exception e) {
                JSOpenPositionDetail.this.DataType.add("String");
            }
        }

        public void MakeTotal() {
            try {
                int i;
                JSOpenPositionDetail.this.Total = new double[JSOpenPositionDetail.this.DataType.size()];
                for (i = 0; i < JSOpenPositionDetail.this.DataType.size(); ++i) {
                    JSOpenPositionDetail.this.Total[i] = 0.0;
                }
                for (i = 0; i < JSOpenPositionDetail.this.openRow.size(); ++i) {
                    Vector Col = (Vector)JSOpenPositionDetail.this.openRow.get(i);
                    for (int j = 0; j < JSOpenPositionDetail.this.DataType.size(); ++j) {
                        JSOpenPositionDetail.this.Total[j] = JSOpenPositionDetail.this.Total[j] + this.CheckISDouble(Col.get(j).toString());
                    }
                }
                Vector<String> NewRow = new Vector<String>();
                NewRow.addElement("Total");
                DecimalFormat twoPlacesWithComma = new DecimalFormat("###.##");
                twoPlacesWithComma.setMinimumFractionDigits(2);
                twoPlacesWithComma.setMaximumFractionDigits(2);
                for (int i2 = 1; i2 < JSOpenPositionDetail.this.Total.length; ++i2) {
                    NewRow.addElement(twoPlacesWithComma.format(JSOpenPositionDetail.this.Total[i2]));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public double CheckISDouble(String str) {
            double RetVal = 0.0;
            try {
                RetVal = Double.parseDouble(str.replaceAll("\\,", ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return RetVal;
        }
    }

    private class PositionTableCellRenderer
    extends NxGTableCellRender {
        private PositionTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
            NxGLabelGradeint cell = new NxGLabelGradeint();
            cell.setForeground(MyColors.cellRenderFG);
            cell.setVerticalAlignment(0);
            if (obj == null) {
                obj = "";
            }
            boolean isTotalRow = false;
            if (row == JSOpenPositionDetail.this.model.getRowCount() - 1 && JSOpenPositionDetail.this.model.getValueAt(row, 0).toString().equalsIgnoreCase("Total")) {
                isTotalRow = true;
            }
            if (JSOpenPositionDetail.this.DataType.size() >= column) {
                if (JSOpenPositionDetail.this.DataType.get(column).toString().equalsIgnoreCase("Double")) {
                    cell.setHorizontalAlignment(4);
                    cell.setText(" " + Util.format2digit((String)obj.toString().trim().replaceAll("\\,", "")) + " ");
                } else if (JSOpenPositionDetail.this.DataType.get(column).toString().equalsIgnoreCase("Integer")) {
                    cell.setHorizontalAlignment(4);
                    cell.setText(" " + Util.format0digit((String)obj.toString().trim().replaceAll("\\,", "")) + " ");
                } else if (JSOpenPositionDetail.this.DataType.get(column).toString().equalsIgnoreCase("String")) {
                    cell.setHorizontalAlignment(2);
                    cell.setText(" " + obj.toString() + " ");
                }
            }
            if (row % 2 == 0) {
                cell.setGradient(this.getOddColorStart(), this.getOddColorEnd());
            } else {
                cell.setGradient(this.getEvenColorStart(), this.getEvenColorEnd());
            }
            if (isSelected) {
                cell.setGradient(this.getSelectColorStart(), this.getSelectColorEnd());
                cell.setForeground(Color.WHITE);
            }
            if ((this.getRowNo() != -1 || this.getRowNo() <= row) && this.getRowNo() == row) {
                cell.setGradient(this.getRoleOverColorStart(), this.getRoleOverColorEnd());
                cell.setForeground(Color.WHITE);
            }
            if (isTotalRow) {
                cell.setFont(new Font(cell.getFont().getFontName(), 1, cell.getFont().getSize()));
            }
            return cell;
        }
    }
}

