/*
 * Decompiled with CFR 0.152.
 */
package windows.periodic;

import Control.JasperFileChooser;
import Control.ReportControl;
import Control.ReportControlEvent;
import Control.ReportControlListener;
import CustomComponent.MyTime;
import MyDocking.Mediator;
import Utilities.LogsTC;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.gui.component.NxGTable;
import common.gui.util.AppConfig;
import common.gui.util.CompressManager;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import kse.gui.bean.PeriodicTradeDetailBean;
import kse.gui.model.PeriodicTradeDetailModel;
import kse.gui.render.PeriodicDetailRender;
import languages.LanguageCentre;
import languages.LanguageConstant;
import org.jdesktop.swingx.JXDatePicker;
import reports.Jasper_Report;
import reports.Report_PeriodicDetail;

public class PreviousPeriodicTradeDetail
extends JPanel
implements ReportControlListener {
    private AutoCompleteSupport autoCom;
    Vector<String> column = new Vector();
    Vector<PeriodicTradeDetailBean> rowsAll = new Vector();
    Vector<PeriodicTradeDetailBean> rows = new Vector();
    PeriodicTradeDetailModel model = null;
    PeriodicDetailRender render = null;
    private AutoCompleteSupport autoCompleteScrip;
    private AutoCompleteSupport autoCompleteClearingType;
    private JTextComponent editorScrip;
    private JTextComponent editorClearing;
    private Set<String> allClearingType = new TreeSet<String>();
    private LanguageCentre languageCentre = new LanguageCentre();
    private JButton btnGet;
    public JComboBox cbAccountNo;
    public JComboBox cbClearingType;
    public JComboBox cbScrip;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JLabel lblAccount;
    private JLabel lblAccount1;
    private JLabel lblClearingType;
    private JLabel lblFromTradeDate;
    private JLabel lblMsg;
    private JLabel lblToTradeDate;
    private ReportControl reportControl1;
    private NxGTable table;
    private JXDatePicker txtFromDate;
    private JXDatePicker txtToTradeDate;
    public String JRXMLFileName = "PeriodicTradeDetail.jrxml";

    public PreviousPeriodicTradeDetail() {
        this.initComponents();
        int year = 2015;
        int month = 6;
        int day = 30;
        String date = year + "/" + month + "/" + day;
        Date utilDate = null;
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd");
            utilDate = formatter.parse(date);
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        this.txtFromDate.setFormats(new DateFormat[]{LogsTC.dateFormatAcc});
        this.txtToTradeDate.setFormats(new DateFormat[]{LogsTC.dateFormatAcc});
        this.txtFromDate.getMonthView().setUpperBound(utilDate);
        this.txtFromDate.setDate(utilDate);
        this.txtToTradeDate.getMonthView().setUpperBound(utilDate);
        this.txtToTradeDate.setDate(utilDate);
        this.setAccount();
        this.setAllScrip();
        this.initTable();
        this.setClearingType();
        this.editorScrip = (JTextComponent)this.cbScrip.getEditor().getEditorComponent();
        this.editorScrip.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PreviousPeriodicTradeDetail.this.filterData();
                PreviousPeriodicTradeDetail.this.addTotalRows();
            }
        });
        this.editorClearing = (JTextComponent)this.cbClearingType.getEditor().getEditorComponent();
        this.editorClearing.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                PreviousPeriodicTradeDetail.this.filterData();
                PreviousPeriodicTradeDetail.this.addTotalRows();
            }
        });
        this.cbAccountNo.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                PreviousPeriodicTradeDetail.this.editorScrip.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.reportControl1.addListener(this);
    }

    private void setClearingType() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (PreviousPeriodicTradeDetail.this.autoCompleteClearingType != null && PreviousPeriodicTradeDetail.this.autoCompleteClearingType.isInstalled()) {
                        PreviousPeriodicTradeDetail.this.autoCompleteClearingType.uninstall();
                    }
                    if (PreviousPeriodicTradeDetail.this.allClearingType.size() <= 0) {
                        PreviousPeriodicTradeDetail.this.allClearingType.add("ALL");
                    }
                    PreviousPeriodicTradeDetail.this.cbClearingType.setModel(new DefaultComboBoxModel<Object>(PreviousPeriodicTradeDetail.this.allClearingType.toArray()));
                    PreviousPeriodicTradeDetail.this.autoCompleteClearingType = AutoCompleteSupport.install((JComboBox)PreviousPeriodicTradeDetail.this.cbClearingType, (EventList)GlazedLists.eventListOf((Object[])PreviousPeriodicTradeDetail.this.allClearingType.toArray()));
                    PreviousPeriodicTradeDetail.this.cbClearingType.setSelectedItem("ALL");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    private void setAccount() {
        ArrayList<String> allAccount = new ArrayList<String>();
        for (String s : LogsTC.accountAll.keySet()) {
            allAccount.add(s);
        }
        Collections.sort(allAccount);
        this.cbAccountNo.setModel(new DefaultComboBoxModel<Object>(allAccount.toArray()));
        this.autoCom = AutoCompleteSupport.install((JComboBox)this.cbAccountNo, (EventList)GlazedLists.eventListOf((Object[])allAccount.toArray()));
        if (LogCommon.preferredAccount.trim().length() > 0) {
            this.cbAccountNo.setSelectedItem(LogCommon.preferredAccount);
        } else {
            this.cbAccountNo.setSelectedItem("");
        }
    }

    private boolean checkValidate() {
        if (this.cbAccountNo.getSelectedItem() == null) {
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Information, (String)"Please select account");
            this.cbAccountNo.requestFocus();
            return false;
        }
        if (this.cbAccountNo.getSelectedItem().toString().length() <= 0) {
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Information, (String)"Please select account");
            this.cbAccountNo.requestFocus();
            return false;
        }
        if (this.txtFromDate.getDate() == null) {
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Information, (String)"Please select from date");
            this.txtFromDate.requestFocus();
            return false;
        }
        if (this.txtToTradeDate == null) {
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Information, (String)"Please select to date");
            this.txtToTradeDate.requestFocus();
            return false;
        }
        if (this.txtToTradeDate.getDate().compareTo(this.txtFromDate.getDate()) < 0) {
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Information, (String)"From date should be greater then or equal to To date.");
            this.txtFromDate.requestFocus();
            return false;
        }
        return true;
    }

    private void initTable() {
        this.column.add("Account");
        this.column.add("Trade Type");
        this.column.add("Scrip");
        this.column.add("Clearing Type");
        this.column.add("Sett Date");
        this.column.add("Trade Date");
        this.column.add("Buy Qty");
        this.column.add("Sell Qty");
        this.column.add("Rate");
        this.column.add("Buy Amt");
        this.column.add("Sell Amt");
        this.column.add("Brok Amt");
        this.column.add("CVT+WHT Amt");
        this.column.add("FED Amt");
        this.column.add("Net Amt");
        this.model = new PeriodicTradeDetailModel(this.rows, this.column);
        this.table.setModel((TableModel)this.model);
        this.table.setColumnControlVisible(false);
        this.table.setSelectionMode(0);
        this.table.setAutoResizeMode(0);
        this.table.setSortable(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getColumn(0).setPreferredWidth(150);
        this.setRender();
    }

    public void setAllScrip() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (PreviousPeriodicTradeDetail.this.autoCompleteScrip != null && PreviousPeriodicTradeDetail.this.autoCompleteScrip.isInstalled()) {
                        PreviousPeriodicTradeDetail.this.autoCompleteScrip.uninstall();
                    }
                    Vector allScrip = new Vector(LogCommon.SymbolAndSymbolName.keySet());
                    allScrip.addElement("ALL");
                    Collections.sort(allScrip);
                    PreviousPeriodicTradeDetail.this.cbScrip.setModel(new DefaultComboBoxModel(allScrip));
                    PreviousPeriodicTradeDetail.this.autoCompleteScrip = AutoCompleteSupport.install((JComboBox)PreviousPeriodicTradeDetail.this.cbScrip, (EventList)GlazedLists.eventListOf((Object[])allScrip.toArray()));
                    PreviousPeriodicTradeDetail.this.cbScrip.setSelectedItem("ALL");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    void setRender() {
        this.render = new PeriodicDetailRender();
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            this.table.getColumn(i).setCellRenderer((TableCellRenderer)this.render);
        }
    }

    private Vector<PeriodicTradeDetailBean> parseRows(String row) {
        Vector<PeriodicTradeDetailBean> rows = new Vector<PeriodicTradeDetailBean>();
        try {
            this.rowsAll.clear();
            if (row.indexOf("|") > 0) {
                int i;
                String[] pipeSeparate = row.split("\\|", -1);
                for (i = 0; i < pipeSeparate.length - 1; ++i) {
                    String[] semiColonSeparator = pipeSeparate[i].toString().split("\\;", -1);
                    PeriodicTradeDetailBean v = PeriodicTradeDetailBean.parse((String[])semiColonSeparator);
                    this.rowsAll.add(v);
                }
                for (i = 0; i < this.rowsAll.size(); ++i) {
                    PeriodicTradeDetailBean b = this.rowsAll.elementAt(i);
                    this.allClearingType.add(b.getClearingType());
                }
            } else {
                Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Information, (String)"No record found");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Mediator.getInstance().PrintLog(ex, row);
        }
        return rows;
    }

    private void filterData() {
        String scrip = this.editorScrip.getText();
        String clearingType = this.editorClearing.getText();
        this.rows.clear();
        for (int i = 0; i < this.rowsAll.size(); ++i) {
            PeriodicTradeDetailBean v = this.rowsAll.get(i);
            if (scrip.equalsIgnoreCase("") || scrip.equalsIgnoreCase("ALL")) {
                if (clearingType.trim().equalsIgnoreCase("") || clearingType.trim().equalsIgnoreCase("ALL")) {
                    this.rows.addElement(v);
                    continue;
                }
                if (v.getClearingType().indexOf(clearingType) != 0) continue;
                this.rows.addElement(v);
                continue;
            }
            if (v.getScrip().indexOf(scrip) != 0) continue;
            if (clearingType.trim().equalsIgnoreCase("") || clearingType.trim().equalsIgnoreCase("ALL")) {
                this.rows.addElement(v);
                continue;
            }
            if (v.getClearingType().indexOf(clearingType) != 0) continue;
            this.rows.addElement(v);
        }
        this.tableDataChange(false);
    }

    private void addTotalRows() {
        String oldScrip = "";
        Vector<PeriodicTradeDetailBean> row = new Vector<PeriodicTradeDetailBean>();
        long buyQty = 0L;
        long sellQty = 0L;
        long buyQtyGT = 0L;
        long sellQtyGT = 0L;
        double buyAmt = 0.0;
        double sellAmt = 0.0;
        double brokAmt = 0.0;
        double CVT_WHTAmt = 0.0;
        double FEDAmt = 0.0;
        double netAmt = 0.0;
        double buyAmtGT = 0.0;
        double sellAmtGT = 0.0;
        double brokAmtGT = 0.0;
        double CVT_WHTAmtGT = 0.0;
        double FEDAmtGT = 0.0;
        double netAmtGT = 0.0;
        for (int i = 0; i < this.rows.size(); ++i) {
            PeriodicTradeDetailBean beanTotal;
            PeriodicTradeDetailBean bean = this.rows.get(i);
            if (i == 0) {
                oldScrip = bean.getScrip();
            }
            if (oldScrip.equalsIgnoreCase(bean.getScrip())) {
                buyQty += bean.getBuyQty();
                sellQty += bean.getSellQty();
                buyAmt += bean.getBuyAmt();
                sellAmt += bean.getSellAmt();
                brokAmt += bean.getBrokAmt();
                CVT_WHTAmt += bean.getCVT_WHTAmt();
                FEDAmt += bean.getFEDAmt();
                netAmt += bean.getNetAmt();
                buyQtyGT += bean.getBuyQty();
                sellQtyGT += bean.getSellQty();
                buyAmtGT += bean.getBuyAmt();
                sellAmtGT += bean.getSellAmt();
                brokAmtGT += bean.getBrokAmt();
                CVT_WHTAmtGT += bean.getCVT_WHTAmt();
                FEDAmtGT += bean.getFEDAmt();
                netAmtGT += bean.getNetAmt();
                row.add(bean);
            } else {
                beanTotal = new PeriodicTradeDetailBean();
                beanTotal.setScrip("Total");
                beanTotal.setBuyQty(buyQty);
                beanTotal.setSellQty(sellQty);
                beanTotal.setBuyAmt(buyAmt);
                beanTotal.setSellAmt(sellAmt);
                beanTotal.setBrokAmt(brokAmt);
                beanTotal.setCVT_WHTAmt(CVT_WHTAmt);
                beanTotal.setFEDAmt(FEDAmt);
                beanTotal.setNetAmt(netAmt);
                row.add(beanTotal);
                row.add(bean);
                buyQty = bean.getBuyQty();
                sellQty = bean.getSellQty();
                buyAmt = bean.getBuyAmt();
                sellAmt = bean.getSellAmt();
                brokAmt = bean.getBrokAmt();
                CVT_WHTAmt = bean.getCVT_WHTAmt();
                FEDAmt = bean.getFEDAmt();
                netAmt = bean.getNetAmt();
                buyQtyGT += bean.getBuyQty();
                sellQtyGT += bean.getSellQty();
                buyAmtGT += bean.getBuyAmt();
                sellAmtGT += bean.getSellAmt();
                brokAmtGT += bean.getBrokAmt();
                CVT_WHTAmtGT += bean.getCVT_WHTAmt();
                FEDAmtGT += bean.getFEDAmt();
                netAmtGT += bean.getNetAmt();
                oldScrip = bean.getScrip();
            }
            if (i != this.rows.size() - 1) continue;
            beanTotal = new PeriodicTradeDetailBean();
            PeriodicTradeDetailBean beanGTotal = new PeriodicTradeDetailBean();
            beanTotal.setScrip("Total");
            beanTotal.setBuyQty(buyQty);
            beanTotal.setSellQty(sellQty);
            beanTotal.setBuyAmt(buyAmt);
            beanTotal.setSellAmt(sellAmt);
            beanTotal.setBrokAmt(brokAmt);
            beanTotal.setCVT_WHTAmt(CVT_WHTAmt);
            beanTotal.setFEDAmt(FEDAmt);
            beanTotal.setNetAmt(netAmt);
            beanGTotal.setScrip("Grand Total");
            beanGTotal.setBuyQty(buyQtyGT);
            beanGTotal.setSellQty(sellQtyGT);
            beanGTotal.setBuyAmt(buyAmtGT);
            beanGTotal.setSellAmt(sellAmtGT);
            beanGTotal.setBrokAmt(brokAmtGT);
            beanGTotal.setCVT_WHTAmt(CVT_WHTAmtGT);
            beanGTotal.setFEDAmt(FEDAmtGT);
            beanGTotal.setNetAmt(netAmtGT);
            row.add(beanTotal);
            row.add(beanGTotal);
        }
        this.rows.clear();
        this.rows.addAll(row);
        this.tableDataChange(true);
    }

    private Vector<String> getColumnParse(String colName) {
        try {
            String[] pipeSeparate = colName.split("\\$", -1);
            String[] semiColonSeparator = pipeSeparate[0].toString().split("\\;", -1);
            this.column.clear();
            for (int i = 0; i < semiColonSeparator.length - 1; ++i) {
                if (semiColonSeparator[i].trim().length() <= 0) continue;
                this.column.add(semiColonSeparator[i]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this.column;
    }

    private void tableDataChange(final boolean isPack) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.model.fireTableDataChanged();
            if (isPack) {
                this.table.packAll();
            }
            this.table.addNotify();
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PreviousPeriodicTradeDetail.this.model.fireTableDataChanged();
                    if (isPack) {
                        PreviousPeriodicTradeDetail.this.table.packAll();
                    }
                    PreviousPeriodicTradeDetail.this.table.addNotify();
                    PreviousPeriodicTradeDetail.this.table.repaint();
                }
            });
        }
    }

    private synchronized void setData(String result) {
        Mediator.getInstance().println("PreviousPeriodicTradeDetail = " + result);
        Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.EMPTY, (String)"");
        this.rows.clear();
        if (result.indexOf("$") > 0) {
            String[] colSep = result.split("\\$", -1);
            this.parseRows(colSep[1]);
            this.setClearingType();
            this.filterData();
            this.addTotalRows();
        } else {
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Information, (String)"No record found");
        }
        this.tableDataChange(true);
    }

    private void initComponents() {
        this.lblFromTradeDate = new JLabel();
        this.txtFromDate = new JXDatePicker();
        this.lblToTradeDate = new JLabel();
        this.txtToTradeDate = new JXDatePicker();
        this.lblAccount = new JLabel();
        this.cbAccountNo = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.table = new NxGTable();
        this.reportControl1 = new ReportControl();
        this.btnGet = new JButton();
        this.jSeparator1 = new JSeparator();
        this.lblMsg = new JLabel();
        this.cbScrip = new JComboBox();
        this.lblAccount1 = new JLabel();
        this.cbClearingType = new JComboBox();
        this.lblClearingType = new JLabel();
        this.lblFromTradeDate.setText("From Date");
        this.lblToTradeDate.setText("To Date");
        this.lblAccount.setHorizontalAlignment(2);
        this.lblAccount.setText("Scrip");
        this.cbAccountNo.setEditable(true);
        this.table.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.table.setAutoResizeMode(0);
        this.jScrollPane1.setViewportView((Component)this.table);
        this.btnGet.setIcon(new ImageIcon(this.getClass().getResource("/Images/get.png")));
        this.btnGet.setText("Get");
        this.btnGet.setMaximumSize(new Dimension(49, 22));
        this.btnGet.setMinimumSize(new Dimension(49, 22));
        this.btnGet.setName("PreviousPeriodicTradeDetail -> btnGet");
        this.btnGet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreviousPeriodicTradeDetail.this.btnGetActionPerformed(evt);
            }
        });
        this.cbScrip.setEditable(true);
        this.lblAccount1.setHorizontalAlignment(2);
        this.lblAccount1.setText("Account");
        this.cbClearingType.setEditable(true);
        this.cbClearingType.setMinimumSize(new Dimension(110, 18));
        this.lblClearingType.setHorizontalAlignment(2);
        this.lblClearingType.setText("Clearing Type");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.lblAccount, -2, 50, -2).addGap(0, 0, 0).addComponent(this.cbScrip, -2, 100, -2).addGap(8, 8, 8).addComponent(this.lblClearingType, -2, 68, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbClearingType, -2, 107, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.reportControl1, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jScrollPane1))).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.lblAccount1, -2, 50, -2).addGap(2, 2, 2).addComponent(this.cbAccountNo, -2, 100, -2).addGap(10, 10, 10).addComponent(this.lblFromTradeDate, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.txtFromDate, -2, 107, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblToTradeDate, -2, 50, -2).addGap(0, 0, 0).addComponent((Component)this.txtToTradeDate, -2, 100, -2).addGap(10, 10, 10).addComponent(this.btnGet, -2, 70, -2)).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.lblMsg, -2, 525, -2))).addGap(0, 109, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblAccount1, -2, 22, -2).addComponent(this.cbAccountNo, -2, 22, -2).addComponent(this.lblFromTradeDate, -2, 22, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblToTradeDate, -2, 22, -2).addComponent((Component)this.txtFromDate, -2, -1, -2)).addComponent((Component)this.txtToTradeDate, -2, -1, -2).addComponent(this.btnGet, -2, 22, -2)).addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblAccount, -2, 22, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbScrip, -2, 22, -2).addComponent(this.lblClearingType, -2, 22, -2).addComponent(this.cbClearingType, -2, 22, -2)).addComponent(this.reportControl1, -2, -1, -2)).addGap(10, 10, 10).addComponent(this.jScrollPane1, -1, 117, Short.MAX_VALUE).addGap(6, 6, 6).addComponent(this.jSeparator1, -2, -1, -2).addGap(6, 6, 6).addComponent(this.lblMsg, -2, 16, -2)));
    }

    private void btnGetActionPerformed(ActionEvent evt) {
        this.getData();
    }

    @Override
    public void ReportControl_Print(ReportControlEvent e) {
        Report_PeriodicDetail Report = new Report_PeriodicDetail(this.JRXMLFileName, this.table.getModel());
        this.SetParameter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        Report.PrintReport();
    }

    @Override
    public void ReportControl_Save(ReportControlEvent e) {
        String FileName;
        boolean result;
        Report_PeriodicDetail Report = new Report_PeriodicDetail(this.JRXMLFileName, this.table.getModel());
        this.SetParameter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File("Previous Periodic Trade Detail-" + MyTime.getInstance().getDate()));
        fc.addAllJasperChoosableFileFilter();
        fc.setAcceptAllFileFilterUsed(false);
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null && !(result = Report.Export(FileName = fc.getSelectedFile().getAbsolutePath() + "." + fc.getExtenstion()))) {
            JOptionPane.showMessageDialog(null, "Error in saving file.");
        }
    }

    @Override
    public void ReportControl_Pdf(ReportControlEvent e) {
        int Option;
        String FileName;
        boolean result;
        Report_PeriodicDetail Report = new Report_PeriodicDetail(this.JRXMLFileName, this.table.getModel());
        this.SetParameter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File("Previous Periodic Trade Detail-" + MyTime.getInstance().getDate()));
        fc.addPdfFileFilter();
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null && (result = Report.ExportToPdf(FileName = fc.getSelectedFile().getAbsolutePath().replaceAll("\"", "") + "." + fc.getExtenstion())) && (Option = JOptionPane.showConfirmDialog(null, "Previous Periodic Trade Detail report created. Do you want to open it?", "PDF", 0)) == 0) {
            try {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + FileName);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void ReportControl_View(ReportControlEvent e) {
        Report_PeriodicDetail Report = new Report_PeriodicDetail(this.JRXMLFileName, this.table.getModel());
        this.SetParameter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        Report.generateReport();
    }

    @Override
    public void ReportControl_CustomExport(ReportControlEvent e) {
    }

    private void SetParameter(Jasper_Report Report) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("Title", AppConfig.companyName);
        param.put("Time", MyTime.getInstance().getTime());
        param.put("PrintDate", MyTime.getInstance().getTimeAndDateForReport());
        param.put("FromDate", LogsTC.dateFormatAcc.format(this.txtFromDate.getDate()));
        param.put("ToDate", LogsTC.dateFormatAcc.format(this.txtToTradeDate.getDate()));
        param.put("AccountNo", this.cbAccountNo.getSelectedItem().toString());
        param.put("ClearingType", this.cbClearingType.getSelectedItem().toString());
        param.put("UserID", LogCommon.UserID);
        Report.SetParameter(param);
    }

    private void getData() {
        if (this.checkValidate()) {
            new Thread("PreviousPeriodicTradeDetail"){

                @Override
                public void run() {
                    try {
                        PreviousPeriodicTradeDetail.this.rowsAll.clear();
                        PreviousPeriodicTradeDetail.this.rows.clear();
                        PreviousPeriodicTradeDetail.this.tableDataChange(false);
                        Util.setMessage((JLabel)PreviousPeriodicTradeDetail.this.lblMsg, (MessageType)MessageType.Loading, (String)PreviousPeriodicTradeDetail.this.languageCentre.getValue(LanguageConstant.Loading));
                        byte[] data = WebService.getInstance().getPort().getOrderHistory(LogCommon.UserID, PreviousPeriodicTradeDetail.this.cbAccountNo.getSelectedItem().toString(), "", "", "", LogsTC.dateFormatAcc.format(PreviousPeriodicTradeDetail.this.txtFromDate.getDate()), LogsTC.dateFormatAcc.format(PreviousPeriodicTradeDetail.this.txtToTradeDate.getDate()), "PreviousPeriodicTradeDetail");
                        String result = CompressManager.unzipStringFromBytes((byte[])data);
                        PreviousPeriodicTradeDetail.this.setData(result);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        Util.setMessage((JLabel)PreviousPeriodicTradeDetail.this.lblMsg, (MessageType)MessageType.Error, (String)"Error in loading data");
                    }
                }
            }.start();
        }
    }
}

