/*
 * Decompiled with CFR 0.152.
 */
package windows.pmex;

import MyDocking.Mediator;
import MyDocking.TradeCast;
import Utilities.MyDradAndDrop;
import common.bean.ContractBrowseBean;
import common.gui.component.NxGPanel;
import common.gui.component.NxGTable;
import common.gui.render.SearchHighLighterRender;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.Title;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXSearchField;
import pmex.gui.model.ContractBrowseModel;
import pmex.gui.util.LogsPMEX;
import pmex.interfaces.ContractBarInterface;
import windows.pmex.PMEX_ContractBrowseDialog;

public class PMEX_ContractBrowse
extends NxGPanel
implements ActionListener {
    private Mediator mediator = Mediator.getInstance();
    private TradeCast tradeCast = TradeCast.getInstance();
    private ContractBrowseBean selectedValue = new ContractBrowseBean();
    private List<ContractBrowseBean> allRows = new ArrayList<ContractBrowseBean>();
    private Vector<ContractBrowseBean> rows = new Vector();
    private Vector<String> columns = new Vector();
    private ContractBrowseModel model = null;
    private SearchHighLighterRender render = null;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private int searchingColumn = -123;
    private PMEX_ContractBrowseDialog dialog = null;
    private ContractBarInterface contractBarInterface = null;
    private Color Background = new Color(255, 102, 102);
    private Icon Cancel_ICON = null;
    private Icon Search_ICON = null;
    final Cursor handCursor = new Cursor(12);
    final Cursor defaultCursor = new Cursor(0);
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JLabel lblMessage;
    private JLabel lblName;
    private JPopupMenu popupMenu;
    private NxGTable table;
    private JXSearchField txtSearchField;

    public PMEX_ContractBrowse(ContractBarInterface contractBarInterface, FormName formName) {
        this.initComponents();
        this.contractBarInterface = contractBarInterface;
        this.columns.add("Contract");
        this.columns.add("Type");
        this.columns.add("Exchange");
        this.columns.add("Maturity MY");
        this.columns.add("Maturity Date");
        this.columns.add("Date");
        this.model = new ContractBrowseModel(this.rows, this.columns);
        this.table.setModel((TableModel)this.model);
        this.render = new SearchHighLighterRender((JTable)this.table);
        ((JLabel)((Object)this.table.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(0);
        for (int k = 0; k < this.columns.size(); ++k) {
            this.table.getColumn((Object)this.columns.elementAt(k)).setCellRenderer((TableCellRenderer)this.render);
        }
        this.table.getColumn((Object)"Contract").setPreferredWidth(78);
        this.table.setAutoCreateRowSorter(true);
        this.table.setSelectionMode(2);
        this.table.setRowHeight(AppConfig.rowHeight);
        this.setupSearchField();
        ArrayList v = new ArrayList(LogsPMEX.PMEX_CONTRACT_ALL.keySet());
        Collections.sort(v);
        Iterator it = v.iterator();
        while (it.hasNext()) {
            this.allRows.add((ContractBrowseBean)LogsPMEX.PMEX_CONTRACT_ALL.get(it.next() + ""));
        }
        this.rowsFillter("");
        new MyDradAndDrop((JTable)this.table, formName);
        this.setTxtSearchFieldIcon();
        if (!LogCommon.isShowScripBrowseHelp) {
            if (formName == FormName.PMEX_MarketWatch) {
                this.tradeCast.setTrayMessage("Contract Browse: ", "Select multiple contract & drag / drop to add in Market Watch", TrayIcon.MessageType.INFO);
            } else if (formName == FormName.PMEX_Matrix) {
                this.tradeCast.setTrayMessage("Contract Browse: ", "Select multiple contract & drag / drop to add in Matrix", TrayIcon.MessageType.INFO);
            }
            LogCommon.isShowScripBrowseHelp = true;
        }
    }

    private void setupSearchField() {
        this.txtSearchField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PMEX_ContractBrowse.this.rowsFillter(PMEX_ContractBrowse.this.txtSearchField.getText().trim());
            }
        });
        this.txtSearchField.setFindPopupMenu(this.popupMenu);
        for (int i = 0; i < this.columns.size(); ++i) {
            JRadioButtonMenuItem rb = new JRadioButtonMenuItem(this.columns.get(i));
            rb.setActionCommand(i + "");
            rb.addActionListener(this);
            this.buttonGroup.add(rb);
            this.popupMenu.add(rb);
        }
        this.popupMenu.addSeparator();
        JRadioButtonMenuItem rb = new JRadioButtonMenuItem("Search");
        rb.setActionCommand("-123");
        rb.setSelected(true);
        rb.addActionListener(this);
        this.buttonGroup.add(rb);
        this.popupMenu.add(rb);
        this.lblName.setText("Search");
    }

    private void rowsFillter(String str) {
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
        this.render.setSearchText(str);
        this.render.setSearchingColumn(this.searchingColumn);
        this.rows.clear();
        this.txtSearchField.setBackground(Color.WHITE);
        Util.removeRowsTable((DefaultTableModel)this.model);
        if (str.length() == 0) {
            for (int i = 0; i < this.allRows.size(); ++i) {
                ContractBrowseBean bean = this.allRows.get(i);
                this.rows.add(bean);
                this.txtSearchField.setBackground(Color.WHITE);
            }
        } else {
            for (int i = 0; i < this.allRows.size(); ++i) {
                ContractBrowseBean bean = this.allRows.get(i);
                if (this.searchingColumn == -123) {
                    if (bean.toString().toUpperCase().indexOf(str.toUpperCase()) < 0) continue;
                    this.rows.add(bean);
                    continue;
                }
                if (this.searchingColumn == 0) {
                    if (bean.getContract().toUpperCase().indexOf(str.toUpperCase()) < 0) continue;
                    this.rows.add(bean);
                    continue;
                }
                if (this.searchingColumn == 1) {
                    if (bean.getType().toUpperCase().indexOf(str.toUpperCase()) < 0) continue;
                    this.rows.add(bean);
                    continue;
                }
                if (this.searchingColumn == 2) {
                    if (bean.getExchange().toUpperCase().indexOf(str.toUpperCase()) < 0) continue;
                    this.rows.add(bean);
                    continue;
                }
                if (this.searchingColumn == 3) {
                    if (bean.getMaturityMonthYear().toUpperCase().indexOf(str.toUpperCase()) < 0) continue;
                    this.rows.add(bean);
                    continue;
                }
                if (this.searchingColumn == 4) {
                    if (bean.getMaturityDate().toUpperCase().indexOf(str.toUpperCase()) < 0) continue;
                    this.rows.add(bean);
                    continue;
                }
                if (this.searchingColumn != 5 || bean.getFormattedDate().toUpperCase().indexOf(str.toUpperCase()) < 0) continue;
                this.rows.add(bean);
            }
        }
        this.model.fireTableDataChanged();
        this.table.addNotify();
        this.table.repaint();
        if (this.rows.size() <= 0) {
            this.txtSearchField.setBackground(this.Background);
        }
        if (this.rows.size() == 1) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)(Util.format0digit((String)(this.rows.size() + "")) + " record found out of " + Util.format0digit((String)(this.allRows.size() + ""))));
        } else if (this.rows.size() > 1) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)(Util.format0digit((String)(this.rows.size() + "")) + " records found out of " + Util.format0digit((String)(this.allRows.size() + ""))));
        }
    }

    public void setDialog(PMEX_ContractBrowseDialog dialog) {
        this.dialog = dialog;
    }

    public void setSearchText(String text) {
        this.rowsFillter("");
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.jSeparator1 = new JSeparator();
        this.lblMessage = new JLabel();
        this.lblName = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.table = new NxGTable();
        this.txtSearchField = new JXSearchField();
        this.lblMessage.setText("jLabel1");
        this.lblName.setFont(new Font("Tahoma", 1, 11));
        this.lblName.setText("Search");
        this.lblName.setHorizontalTextPosition(2);
        this.table.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PMEX_ContractBrowse.this.tableMouseClicked(evt);
            }
        });
        this.table.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                PMEX_ContractBrowse.this.tableMouseMoved(evt);
            }
        });
        this.jScrollPane2.setViewportView((Component)this.table);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE).addGap(10, 10, 10)).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.lblMessage, -1, 216, Short.MAX_VALUE).addGap(80, 80, 80)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblName, -2, 83, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.txtSearchField, -2, 165, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblName, -2, 20, -2).addComponent((Component)this.txtSearchField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 76, Short.MAX_VALUE).addGap(5, 5, 5).addComponent(this.jSeparator1, -2, -1, -2).addGap(2, 2, 2).addComponent(this.lblMessage, -2, 20, -2)));
        layout.linkSize(1, new Component[]{this.lblName, this.txtSearchField});
    }

    private void tableMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() >= 2) {
            if (this.contractBarInterface != null) {
                this.contractBarInterface.addContractToWatch(this.table.getValueAt(this.table.getSelectedRow(), 0) + "", false);
            }
            if (this.dialog != null) {
                PMEX_ContractBrowseDialog.setSelectedContract((ContractBrowseBean)LogsPMEX.PMEX_CONTRACT_ALL.get(this.table.getValueAt(this.table.getSelectedRow(), 0) + ""));
                if (this.contractBarInterface == null) {
                    this.dispose();
                }
            }
        } else {
            TableColumnModel colModel = this.table.getColumnModel();
            int vColIndex = colModel.getColumnIndexAtX(evt.getX());
            int mColIndex = this.table.convertColumnIndexToModel(vColIndex);
            if ("Contract".equalsIgnoreCase(this.table.getColumnName(mColIndex).toString())) {
                String Contract = this.table.getValueAt(this.table.getSelectedRow(), 0).toString();
                TradeCast.getInstance().ShowLadderWindow(FormName.PMEX_Ladder, Title.PMEX_Ladder, Contract);
            }
        }
    }

    private void tableMouseMoved(MouseEvent evt) {
        TableColumnModel colModel = this.table.getColumnModel();
        int vColIndex = colModel.getColumnIndexAtX(evt.getX());
        int mColIndex = this.table.convertColumnIndexToModel(vColIndex);
        if ("Contract".equalsIgnoreCase(this.table.getColumnName(mColIndex)) && this.table.getRowCount() > 0 && this.table.rowAtPoint(evt.getPoint()) > -1) {
            this.table.setCursor(this.handCursor);
        } else if (this.table.getRowCount() > 0) {
            this.table.setCursor(this.defaultCursor);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof JRadioButtonMenuItem) {
            JRadioButtonMenuItem rb = (JRadioButtonMenuItem)obj;
            try {
                this.searchingColumn = Integer.parseInt(rb.getActionCommand());
                if (this.searchingColumn == -123) {
                    this.lblName.setText("Search");
                } else {
                    this.lblName.setText(this.columns.get(this.searchingColumn));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.rowsFillter(this.txtSearchField.getText());
        }
    }

    private void setTxtSearchFieldIcon() {
        try {
            this.Cancel_ICON = new ImageIcon(this.getClass().getResource("/common/gui/images/cross.png"));
            this.txtSearchField.getCancelButton().setIcon(this.Cancel_ICON);
            this.txtSearchField.getCancelButton().setRolloverIcon(this.Cancel_ICON);
            this.txtSearchField.getCancelButton().setPressedIcon(this.Cancel_ICON);
            this.txtSearchField.updateUI();
            this.Search_ICON = new ImageIcon(this.getClass().getResource("/common/gui/images/search26x20.png"));
            this.txtSearchField.getFindButton().setIcon(this.Search_ICON);
            this.txtSearchField.getFindButton().setRolloverIcon(this.Search_ICON);
            this.txtSearchField.updateUI();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void dispose() {
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }
}

