/*
 * Decompiled with CFR 0.152.
 */
package windows.pmex;

import MyDocking.Mediator;
import RendersNModels.ComboBoxToolTipRender;
import Utilities.CompressManager;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.bean.AccountBean;
import common.gui.component.NxGTable;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.AbstractDocument;
import languages.LanguageCentre;
import languages.LanguageConstant;
import pmex.gui.bean.TraderPositionBeans;
import pmex.gui.model.TraderPositionModel;
import pmex.gui.render.TraderPositionRender;
import pmex.gui.util.LogsPMEX;
import windows.pmex.buyingpower.DocumentSizeAndUppercaseFilter;

public class PMEX_ExpiringPosition
extends JPanel {
    private Vector<String> column = new Vector();
    private Vector<TraderPositionBeans> rows = new Vector();
    private TraderPositionModel model = null;
    private TraderPositionRender render;
    private LanguageCentre languageCentre = new LanguageCentre();
    private JButton btnRefresh;
    private JComboBox cbAccountNo;
    private JScrollPane jScrollPane2;
    private JLabel lblMessage;
    private JLabel lblPrefix;
    private JLabel lbltraders;
    private NxGTable table;
    private JSeparator tableSeperator;

    public PMEX_ExpiringPosition() {
        try {
            this.initComponents();
            Mediator.getInstance().setPMEX_ExpiringPosition(this);
            this.column.add("Traders");
            this.column.add("Contract");
            this.column.add("Position");
            this.column.add("Realized P/L");
            this.column.add("Unrealized P/L");
            this.column.add("Intl-Unrealized P/L");
            this.column.add("Intl-Price");
            this.model = new TraderPositionModel(this.rows, this.column, (JTable)this.table);
            this.table.setModel((TableModel)this.model);
            this.table.setAutoCreateRowSorter(true);
            this.table.addNotify();
            this.table.repaint();
            this.cbAccountNo.setMaximumRowCount(7);
            this.setColumnWidth();
            this.setAccounts();
            this.setRender();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void setAccounts() {
        if (LogsPMEX.accountPrefix.length() > 0) {
            this.lblPrefix.setText(LogsPMEX.accountPrefix);
        } else {
            this.lblPrefix.setVisible(false);
            this.lblPrefix.setText(" ");
        }
        Iterator en = LogsPMEX.ALL_ACCOUNTS.keySet().iterator();
        ArrayList<String> list = new ArrayList<String>();
        list.add("ALL");
        while (en.hasNext()) {
            String key = en.next().toString();
            AccountBean ac = (AccountBean)LogsPMEX.ALL_ACCOUNTS.get(key);
            if (ac.getAccountNo().indexOf(LogsPMEX.accountPrefix) == 0) {
                list.add(ac.getAccountNo().replaceFirst(LogsPMEX.accountPrefix, ""));
                continue;
            }
            list.add(ac.getAccountNo());
        }
        this.cbAccountNo.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        AutoCompleteSupport support = AutoCompleteSupport.install((JComboBox)this.cbAccountNo, (EventList)GlazedLists.eventListOf((Object[])list.toArray()));
        support.setStrict(false);
        this.cbAccountNo.setRenderer(new ComboBoxToolTipRender(LogsPMEX.ALL_ACCOUNTS, LogsPMEX.accountPrefix));
        this.cbAccountNo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    PMEX_ExpiringPosition.this.cbAccountNo.setToolTipText(((AccountBean)LogsPMEX.ALL_ACCOUNTS.get(LogsPMEX.accountPrefix + PMEX_ExpiringPosition.this.cbAccountNo.getSelectedItem().toString().trim())).toString());
                }
                catch (Exception ex) {
                    PMEX_ExpiringPosition.this.cbAccountNo.setToolTipText(null);
                }
            }
        });
        try {
            if (this.cbAccountNo.getItemCount() > 0) {
                if (LogCommon.preferredAccountPMEX.trim().length() > 0) {
                    this.cbAccountNo.setSelectedItem(LogCommon.preferredAccountPMEX.replaceFirst(LogsPMEX.accountPrefix, ""));
                } else {
                    this.cbAccountNo.setSelectedItem("");
                }
            } else {
                this.cbAccountNo.setSelectedItem("");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        AbstractDocument d = (AbstractDocument)((JTextField)this.cbAccountNo.getEditor().getEditorComponent()).getDocument();
        d.setDocumentFilter(new DocumentSizeAndUppercaseFilter(4));
    }

    private void setRender() {
        this.render = new TraderPositionRender((JTable)this.table);
        for (int k = 0; k < this.column.size(); ++k) {
            this.table.getColumn((Object)this.column.elementAt(k)).setCellRenderer((TableCellRenderer)this.render);
        }
    }

    private void setColumnWidth() {
        this.table.getColumnModel().getColumn(0).setPreferredWidth(175);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(190);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(117);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(136);
        this.table.getColumnModel().getColumn(5).setPreferredWidth(177);
        this.table.getColumnModel().getColumn(6).setPreferredWidth(100);
    }

    private void initComponents() {
        this.lbltraders = new JLabel();
        this.lblPrefix = new JLabel();
        this.cbAccountNo = new JComboBox();
        this.btnRefresh = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.table = new NxGTable();
        this.lblMessage = new JLabel();
        this.tableSeperator = new JSeparator();
        this.lbltraders.setText(" Account");
        this.lbltraders.setMaximumSize(new Dimension(0, 0));
        this.lbltraders.setMinimumSize(new Dimension(0, 0));
        this.lbltraders.setPreferredSize(new Dimension(39, 6));
        this.lblPrefix.setHorizontalAlignment(4);
        this.lblPrefix.setText("88888");
        this.lblPrefix.setMaximumSize(new Dimension(0, 0));
        this.lblPrefix.setMinimumSize(new Dimension(0, 0));
        this.lblPrefix.setPreferredSize(new Dimension(39, 6));
        this.cbAccountNo.setPreferredSize(new Dimension(22, 20));
        this.cbAccountNo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PMEX_ExpiringPosition.this.cbAccountNoActionPerformed(evt);
            }
        });
        this.btnRefresh.setIcon(new ImageIcon(this.getClass().getResource("/Images/refresh.png")));
        this.btnRefresh.setText("Refresh");
        this.btnRefresh.setFocusable(false);
        this.btnRefresh.setHorizontalTextPosition(4);
        this.btnRefresh.setMaximumSize(new Dimension(75, 23));
        this.btnRefresh.setMinimumSize(new Dimension(75, 23));
        this.btnRefresh.setName("PMEX_ExpiringPosition -> btnRefresh");
        this.btnRefresh.setPreferredSize(new Dimension(75, 20));
        this.btnRefresh.setVerticalTextPosition(3);
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PMEX_ExpiringPosition.this.btnRefreshActionPerformed(evt);
            }
        });
        this.table.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane2.setViewportView((Component)this.table);
        this.lblMessage.setBackground(new Color(153, 153, 255));
        this.lblMessage.setVerticalAlignment(1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tableSeperator, GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblMessage, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.lbltraders, -2, 50, -2).addGap(10, 10, 10).addComponent(this.lblPrefix, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbAccountNo, -2, 113, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRefresh, -2, 98, -2).addGap(0, 60, Short.MAX_VALUE)).addComponent(this.jScrollPane2, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbltraders, -2, 20, -2).addComponent(this.lblPrefix, -2, 20, -2).addComponent(this.cbAccountNo, -2, -1, -2).addComponent(this.btnRefresh, -2, 21, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 228, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tableSeperator, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblMessage, -2, 20, -2)));
    }

    private void cbAccountNoActionPerformed(ActionEvent evt) {
        try {
            if (evt.getModifiers() == 16 || evt.getActionCommand().equalsIgnoreCase("comboBoxEdited")) {
                this.getTraderPositionWebService();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void btnRefreshActionPerformed(ActionEvent evt) {
        this.getTraderPositionWebService();
    }

    public synchronized void getTraderPositionWebService() {
        new Thread((Runnable)new ThreadTraderPosition(), "PMEX_BuyiungPower getTraderPositionWebService").start();
    }

    private void emptyTable() {
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
        this.rows.clear();
        this.model.fireTableDataChanged();
        this.table.addNotify();
        this.table.repaint();
    }

    private synchronized void ParseTraderPosition(String result) {
        boolean isFound = false;
        if (result.indexOf("|") >= 0) {
            String[] rowsAll = result.split("\\|", -1);
            for (int row = 0; row <= rowsAll.length - 1; ++row) {
                int index;
                TraderPositionBeans tpBean = TraderPositionBeans.parse((String)rowsAll[row]);
                if (this.getSelectedAccount().equalsIgnoreCase("") || this.getSelectedAccount().equalsIgnoreCase("All")) {
                    for (TraderPositionBeans np : this.rows) {
                        if (np.getTraders().equalsIgnoreCase(tpBean.getTraders()) && np.getContract().equalsIgnoreCase(tpBean.getContract())) {
                            isFound = true;
                            index = this.rows.indexOf(np);
                            this.rows.remove(np);
                            this.rows.add(index, tpBean);
                            break;
                        }
                        isFound = false;
                    }
                    if (isFound) continue;
                    this.rows.add(tpBean);
                    continue;
                }
                if (!tpBean.getTraders().equalsIgnoreCase(this.getSelectedAccount())) continue;
                for (TraderPositionBeans np : this.rows) {
                    if (np.getContract().equalsIgnoreCase(tpBean.getContract())) {
                        isFound = true;
                        index = this.rows.indexOf(np);
                        this.rows.remove(np);
                        this.rows.add(index, tpBean);
                        break;
                    }
                    isFound = false;
                }
                if (isFound) continue;
                this.rows.add(tpBean);
            }
        }
        if (this.rows.size() <= 0) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Normal, (String)"No record found.");
        } else if (this.rows.size() == 1) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)(Util.format0digit((String)(this.rows.size() + "")) + " record found."));
        } else {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)(Util.format0digit((String)(this.rows.size() + "")) + " records found."));
        }
        this.model.fireTableDataChanged();
        this.table.repaint();
    }

    public String getSelectedAccount() {
        if (this.cbAccountNo.getSelectedItem() == null) {
            return "";
        }
        if (this.cbAccountNo.getSelectedItem().toString().trim().equalsIgnoreCase("")) {
            return "";
        }
        if (this.cbAccountNo.getSelectedItem().toString().trim().equalsIgnoreCase("ALL")) {
            return "All";
        }
        return LogsPMEX.accountPrefix + this.cbAccountNo.getSelectedItem().toString().trim();
    }

    private class ThreadTraderPosition
    implements Runnable {
        private ThreadTraderPosition() {
        }

        @Override
        public void run() {
            try {
                if (PMEX_ExpiringPosition.this.getSelectedAccount().trim().length() > 0) {
                    PMEX_ExpiringPosition.this.emptyTable();
                    Util.setMessage((JLabel)PMEX_ExpiringPosition.this.lblMessage, (MessageType)MessageType.Loading, (String)PMEX_ExpiringPosition.this.languageCentre.getValue(LanguageConstant.Loading));
                    byte[] _byte = WebService.getInstance().getPort().getCompressedData(LogCommon.UserID, "PMEX_GetExpiringPositions", PMEX_ExpiringPosition.this.getSelectedAccount());
                    String data = CompressManager.unzipStringFromBytes(_byte);
                    Mediator.getInstance().println("PMEX_ExpiringPosition = " + data);
                    Util.setMessage((JLabel)PMEX_ExpiringPosition.this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
                    if (data.contains("No Record(s) found")) {
                        Util.setMessage((JLabel)PMEX_ExpiringPosition.this.lblMessage, (MessageType)MessageType.Information, (String)"No record found");
                    } else {
                        data = data.replaceAll("PMEX_GetExpiringPositions=", "");
                        PMEX_ExpiringPosition.this.ParseTraderPosition(data);
                    }
                } else {
                    PMEX_ExpiringPosition.this.emptyTable();
                    Util.setMessage((JLabel)PMEX_ExpiringPosition.this.lblMessage, (MessageType)MessageType.Information, (String)"Please select account");
                }
            }
            catch (Exception ex) {
                Util.setMessage((JLabel)PMEX_ExpiringPosition.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in loading Expiring Position");
                ex.printStackTrace();
            }
        }
    }
}

