/*
 * Decompiled with CFR 0.152.
 */
package windows.pmex;

import Beans.MBPFeed;
import CustomComponent.MyTime;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import Utilities.FormsProperties;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.bean.ContractBrowseBean;
import common.bean.MBO_MBP_Bean;
import common.gui.component.NxGDialogBox;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.Util;
import common.gui.windows.MBODetail;
import common.gui.windows.render.MBPRender;
import common.interfaces.AddContract;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import languages.LanguageCentre;
import languages.LanguageConstant;
import org.jdesktop.swingx.JXButton;
import org.jdesktop.swingx.JXCollapsiblePane;
import pmex.gui.bean.LeaderBean;
import pmex.gui.util.LogsPMEX;
import pmex.gui.util.UtilPMEX;
import windows.pmex.PMEX_ContractBrowseDialog;
import windows.pmex.PMEX_MBP_ContractBars;
import windows.pmex.order.PMEX_OrderOneClick;

public class PMEX_MBP
extends JPanel
implements ActionListener,
FocusListener,
AddContract {
    private Mediator mediator = Mediator.getInstance();
    private TradeCast tradeCast = TradeCast.getInstance();
    private NxGDialogBox dialogBox;
    private final String detail = "Details";
    private Vector rows = null;
    private Vector columns = null;
    private List<MBO_MBP_Bean> allRows = new ArrayList<MBO_MBP_Bean>(10);
    private PMEX_MBP_ContractBars barPanel = new PMEX_MBP_ContractBars();
    private String LastContract = "";
    private String lastTime = " ";
    private AutoCompleteSupport autoCom;
    private JPopupMenu popupMenu;
    private MBODetail MBPDetail = null;
    private MBPRender render = new MBPRender(null);
    private PMEX_OrderOneClick PMEX_Order_Template = null;
    private final String dummyFeed = ";;;,,$,,$,,$,,$,,$,,$,,$,,$,,$,,$;,,$,,$,,$,,$,,$,,$,,$,,$,,$,,$|";
    private String contract = "";
    public static String contractPrompt = "Please Select a Contract";
    private LanguageCentre languageCentre = new LanguageCentre();
    private JToggleButton btnSeeMore;
    private JComboBox cbContract;
    private JXCollapsiblePane collPaneMBPDetail;
    private JXCollapsiblePane collPaneOrder;
    private JToolBar jToolBar1;
    private JXButton jXButton1;
    private JLabel lblDetail;
    private JLabel lblLastUpdate;
    private JLabel lblMarket;
    private JLabel lblMessage;
    private JPanel pnlBar;
    private JScrollPane scrollPane;
    private JTable table;

    public PMEX_MBP(NxGDialogBox dialogBox, String contract) {
        this.contract = contract;
        this.dialogBox = dialogBox;
        this.mediator.setPMEX_MPB(this);
        this.PMEX_Order_Template = new PMEX_OrderOneClick(this);
        this.PMEX_Order_Template.setVisible(false);
        this.rows = new Vector();
        this.columns = new Vector();
        this.columns.addElement("Com.");
        this.columns.addElement("Volume");
        this.columns.addElement("Price");
        this.columns.addElement("Price ");
        this.columns.addElement("Volume ");
        this.columns.addElement("Com. ");
        this.table = new JTable(this.rows, this.columns);
        this.initComponents();
        this.pnlBar.add(this.barPanel);
        this.MBPDetail = new MBODetail(false, false, this.table);
        this.collPaneMBPDetail.add((Component)this.MBPDetail);
        FontMetrics metrics = this.getFontMetrics(LogCommon.MarketDepthFont);
        int fontHeight = metrics.getHeight();
        if (fontHeight <= 18) {
            this.table.setRowHeight(18);
        } else {
            this.table.setRowHeight(fontHeight);
        }
        this.table.setEnabled(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        JTableHeader header = this.table.getTableHeader();
        ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(0);
        for (int k = 0; k < this.columns.size(); ++k) {
            this.table.getColumn(this.columns.elementAt(k)).setCellRenderer((TableCellRenderer)this.render);
        }
        this.table.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                int scrWidth = 0;
                if (PMEX_MBP.this.scrollPane.getVerticalScrollBar().isShowing()) {
                    scrWidth = ((PMEX_MBP)PMEX_MBP.this).scrollPane.getVerticalScrollBar().getPreferredSize().width;
                }
                PMEX_MBP.this.MBPDetail.changeMargin(scrWidth);
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
        this.init();
        this.setupOrderPanel();
        this.setOrderOptions(LogCommon.PMEX_OrderOption);
        LogsPMEX.CONTRACT_HOLDER.add(this);
        this.tradeCast.PMEX_MBPWindowHolder.add(this);
        this.addContract();
        if (contract != null && contract.trim().length() > 1) {
            this.SendMBPMessage(contract, UtilPMEX.GetMarketFromContract((String)contract));
            this.cbContract.setSelectedItem(contract);
        }
        this.cbContract.setMaximumRowCount(16);
        this.setCollaspeDetail();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(200L);
                    PMEX_MBP.this.PMEX_Order_Template.setVisible(true);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    private void init() {
        this.cbContract.addActionListener(this);
        this.jXButton1.addActionListener((ActionListener)this);
        this.lblLastUpdate.setText("  ");
        this.lblLastUpdate.setFont(AppConfig.defaultPlanFont);
        this.lblLastUpdate.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                PMEX_MBP.this.lblLastUpdate.setText(PMEX_MBP.this.lastTime);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PMEX_MBP.this.lblLastUpdate.setText("  ");
            }
        });
        this.lblMessage.setText("");
        this.lblMessage.setFont(AppConfig.defaultPlanFont);
        this.lblDetail.setMaximumSize(new Dimension(55, 14));
        this.lblDetail.setMinimumSize(new Dimension(55, 14));
        this.lblDetail.setPreferredSize(new Dimension(55, 14));
        this.lblDetail.setCursor(Cursor.getPredefinedCursor(12));
        this.lblDetail.setText("<html>Details</html>");
        this.lblMarket.setFont(AppConfig.defaultPlanFont);
        this.cbContract.setFont(AppConfig.defaultPlanFont);
        if (Util.isMacOSX()) {
            this.btnSeeMore.setMaximumSize(new Dimension(90, 23));
            this.btnSeeMore.setMinimumSize(new Dimension(90, 23));
            this.btnSeeMore.setPreferredSize(new Dimension(90, 23));
            this.btnSeeMore.setSize(new Dimension(90, 23));
        }
    }

    private void SendMBPMessage(String contract, String Market) {
        if (!this.LastContract.equalsIgnoreCase(contract + ":" + Market)) {
            this.updateFeed(";;;,,$,,$,,$,,$,,$,,$,,$,,$,,$,,$;,,$,,$,,$,,$,,$,,$,,$,,$,,$,,$|");
            this.MBPDetail.setDetailEmpty();
            if (!contract.equalsIgnoreCase(contractPrompt) && contract.length() > 0 && LogsPMEX.PMEX_CONTRACT_ALL.size() > 0 && !LogsPMEX.PMEX_CONTRACT_ALL.containsKey(contract.trim())) {
                this.lblMessage.setText("Invalid Contract");
            } else {
                this.contract = contract;
                this.lblMessage.setText("");
                this.PMEX_Order_Template.setContract(contract);
                this.PMEX_Order_Template.setMarket(UtilPMEX.GetMarketFromContract((String)contract));
                this.PMEX_Order_Template.setLastTradePrice(LeaderBean.DEFAULT_VALUE);
            }
            this.LastContract = contract + ":" + Market;
            this.mediator.SubcribePMEXMBP("PMEX_MBP : SendMBPMessage = " + contract);
            this.lblMessage.setFont(AppConfig.defaultPlanFont);
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Loading, (String)this.languageCentre.getValue(LanguageConstant.Loading));
        }
    }

    public void MessageSent(boolean b) {
        if (b) {
            this.PMEX_Order_Template.sendOrderToServer();
        } else {
            this.PMEX_Order_Template.setFocusResquest();
        }
    }

    public String getContract() {
        return this.cbContract.getSelectedItem().toString();
    }

    public String getContractWithMarket() {
        if (this.LastContract.equalsIgnoreCase("") && !this.getContract().equalsIgnoreCase(contractPrompt)) {
            return this.getContract() + ":" + UtilPMEX.GetMarketFromContract((String)this.getContract());
        }
        return this.LastContract;
    }

    private void setupOrderPanel() {
        this.collPaneOrder.add((Component)((Object)this.PMEX_Order_Template));
        this.collPaneOrder.setCollapsed(false);
    }

    public void setOrderOptions(String PMEX_OrderOption) {
        if (this.PMEX_Order_Template != null) {
            this.PMEX_Order_Template.setOrderOptions(PMEX_OrderOption);
        }
    }

    private void setCollaspeDetail() {
        boolean state = this.collPaneMBPDetail.isCollapsed();
        this.collPaneMBPDetail.setCollapsed(!state);
        if (state) {
            this.lblDetail.setIcon(new ImageIcon(this.getClass().getResource("/Images/uparrowgray.png")));
        } else {
            this.lblDetail.setIcon(new ImageIcon(this.getClass().getResource("/Images/downarrowgray.png")));
        }
    }

    private void setCollaspeOrderWindow() {
        boolean state = this.collPaneOrder.isCollapsed();
        this.collPaneOrder.setCollapsed(!state);
        if (state) {
            this.PMEX_Order_Template.setFocusResquest();
            this.btnSeeMore.setIcon(new ImageIcon(this.getClass().getResource("/Images/uparrowgray.png")));
            this.btnSeeMore.setText("See Less");
        } else {
            this.btnSeeMore.setIcon(new ImageIcon(this.getClass().getResource("/Images/downarrowgray.png")));
            this.btnSeeMore.setText("See More");
        }
    }

    public void openWindow(FormName formName) {
        if (formName != FormName.GraphsAndCharts) {
            if (formName == FormName.Buy) {
                TradeCast.getInstance().ShowDynamicForm(FormName.Buy, LanguageConstant.Buy);
                if (this.mediator.buysell != null) {
                    // empty if block
                }
            } else if (formName == FormName.Sell) {
                TradeCast.getInstance().ShowDynamicForm(FormName.Sell, LanguageConstant.Sell);
                if (this.mediator.buysell != null) {
                    // empty if block
                }
            } else if (formName == FormName.ShortSell) {
                TradeCast.getInstance().ShowDynamicForm(FormName.ShortSell, LanguageConstant.ShortSell);
                if (this.mediator.shortsell != null) {
                    // empty if block
                }
            } else if (formName == FormName.Cancel) {
                TradeCast.getInstance().ShowDynamicForm(FormName.Cancel, LanguageConstant.Cancel);
                if (this.mediator.cancel != null) {
                    // empty if block
                }
            } else if (formName == FormName.MBO) {
                this.tradeCast.showStaticWindow(LanguageConstant.MarketDepthByOrder, false);
                if (this.mediator.mbo != null) {
                    // empty if block
                }
            } else if (formName == FormName.MBP) {
                this.tradeCast.showStaticWindow(LanguageConstant.MarketDepthByPrice, false);
                if (this.mediator.mbp != null) {
                    // empty if block
                }
            } else if (formName == FormName.DetailedQuote) {
                TradeCast.getInstance().ShowDynamicForm(FormName.DetailedQuote, LanguageConstant.DetailedQuote);
                if (this.mediator.detailedQuote != null) {
                    this.mediator.detailedQuote.setTitle("");
                }
            } else if (formName == FormName.Prefernces) {
                TradeCast.getInstance().ShowDynamicForm(FormName.Prefernces, LanguageConstant.Fonts);
                if (this.mediator.prefrences != null) {
                    this.mediator.prefrences.selectFontTab(this.languageCentre.getValue(LanguageConstant.Others));
                }
            }
        }
    }

    private void tableDataChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.table.addNotify();
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PMEX_MBP.this.table.addNotify();
                    PMEX_MBP.this.table.repaint();
                }
            });
        }
    }

    public void AddSymbol(String contract, String market) {
        if (this.cbContract.getSelectedItem().toString().compareTo(contract) != 0) {
            this.rows.clear();
            this.allRows.clear();
            this.tableDataChange();
            this.PMEX_Order_Template.setMBPBean(null);
            this.cbContract.setSelectedItem(contract);
            this.SendMBPMessage(contract, "FUT");
        }
        this.table.repaint();
    }

    public void updateFeed(final String Msg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PMEX_MBP.this.updateFeed2(Msg);
            }
        });
    }

    private void updateFeed2(String Msg) {
        block29: {
            this.mediator.println("PMP FeedRecived = " + Msg);
            double lastTradePrice = 0.0;
            if (Msg.trim().equalsIgnoreCase("")) {
                Msg = ";;;,,$,,$,,$,,$,,$,,$,,$,,$,,$,,$;,,$,,$,,$,,$,,$,,$,,$,,$,,$,,$|";
            }
            try {
                if (this.cbContract.getSelectedItem() == null) break block29;
                String selectedContract = this.cbContract.getSelectedItem().toString();
                if (!selectedContract.trim().equalsIgnoreCase("")) {
                    double buyVolTot = 0.0;
                    double sellVolTot = 0.0;
                    double buyPriceTot = 0.0;
                    double sellPriceTot = 0.0;
                    try {
                        String[] feeds = Msg.split("\\|", -1);
                        for (int iteration = 0; iteration < feeds.length; ++iteration) {
                            if (feeds[iteration].trim().length() <= 0 || feeds[iteration].indexOf(";") < 0) continue;
                            String[] feed = feeds[iteration].split("\\;", -1);
                            MBPFeed mbpfeed = new MBPFeed();
                            mbpfeed.feedString = feeds[iteration];
                            mbpfeed.symbol = feed[0];
                            mbpfeed.market = feed[1];
                            mbpfeed.buy = feed[3];
                            mbpfeed.sell = feed[4];
                            mbpfeed.lastPrice = feed[2];
                            if (!selectedContract.equalsIgnoreCase(mbpfeed.symbol)) continue;
                            if (mbpfeed.lastPrice.indexOf("$") > 0) {
                                String[] val = mbpfeed.lastPrice.split("\\$", -1);
                                try {
                                    lastTradePrice = Double.parseDouble(val[0]);
                                    this.PMEX_Order_Template.setLastTradePrice(lastTradePrice);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    this.PMEX_Order_Template.setLastTradePrice(LeaderBean.DEFAULT_VALUE);
                                }
                            }
                            String[] BuyValues = mbpfeed.buy.split("\\$", -1);
                            String[] SellValues = mbpfeed.sell.split("\\$", -1);
                            String[] BuyVal = new String[]{"", ""};
                            String[] SellVal = new String[]{"", ""};
                            this.rows.clear();
                            this.allRows.clear();
                            long cumulativeBuy = 0L;
                            long maxCumulativeVolBuy = 0L;
                            long cumulativeSell = 0L;
                            long maxCumulativeVolSell = 0L;
                            long maxCumulativeVol = 0L;
                            for (int i = 0; i < 10; ++i) {
                                MBO_MBP_Bean bean = new MBO_MBP_Bean();
                                SellVal[1] = "";
                                SellVal[0] = "";
                                BuyVal[1] = "";
                                BuyVal[0] = "";
                                Vector<String> rowSingle = new Vector<String>();
                                if (i < BuyValues.length - 1) {
                                    BuyVal = BuyValues[i].split("\\,", -1);
                                }
                                if (i < SellValues.length - 1) {
                                    SellVal = SellValues[i].split("\\,", -1);
                                }
                                try {
                                    try {
                                        long vol = Long.parseLong(BuyVal[0]);
                                        rowSingle.addElement(Util.format0digit((String)((cumulativeBuy += vol) + "")));
                                        rowSingle.addElement(Util.format0digit((String)(vol + "")));
                                        buyVolTot = (double)vol + buyVolTot;
                                        maxCumulativeVolBuy = cumulativeBuy;
                                        bean.setCumulativeBuy(cumulativeBuy);
                                        bean.setVolumeBuy(vol);
                                    }
                                    catch (Exception e) {
                                        rowSingle.addElement("");
                                        rowSingle.addElement(BuyVal[0]);
                                    }
                                    try {
                                        double price = Double.parseDouble(BuyVal[1]);
                                        rowSingle.addElement(price + "");
                                        bean.setPriceBuy(price);
                                    }
                                    catch (Exception e) {
                                        rowSingle.addElement(BuyVal[1]);
                                    }
                                    try {
                                        double price = Double.parseDouble(BuyVal[1]);
                                        long vol = Integer.parseInt(BuyVal[0]);
                                        double res = price * (double)vol;
                                        buyPriceTot += res;
                                    }
                                    catch (Exception price) {
                                        // empty catch block
                                    }
                                    try {
                                        double price = Double.parseDouble(SellVal[1]);
                                        int vol = Integer.parseInt(SellVal[0]);
                                        double res = price * (double)vol;
                                        sellPriceTot += res;
                                    }
                                    catch (Exception price) {
                                        // empty catch block
                                    }
                                    try {
                                        double price = Double.parseDouble(SellVal[1]);
                                        rowSingle.addElement(price + "");
                                        bean.setPriceSell(price);
                                    }
                                    catch (Exception e) {
                                        rowSingle.addElement(SellVal[1]);
                                    }
                                    try {
                                        int vol = Integer.parseInt(SellVal[0]);
                                        rowSingle.addElement(Util.format0digit((String)(vol + "")));
                                        rowSingle.addElement(Util.format0digit((String)((cumulativeSell += (long)vol) + "")));
                                        sellVolTot = (double)vol + sellVolTot;
                                        maxCumulativeVolSell = cumulativeSell;
                                        bean.setCumulativeSell(cumulativeSell);
                                        bean.setVolumeSell((long)vol);
                                    }
                                    catch (Exception e) {
                                        rowSingle.addElement(SellVal[0]);
                                        rowSingle.addElement("");
                                    }
                                    this.allRows.add(bean);
                                    this.rows.insertElementAt(rowSingle, i);
                                    if (maxCumulativeVolBuy > maxCumulativeVolSell) {
                                        maxCumulativeVol = maxCumulativeVolBuy;
                                        continue;
                                    }
                                    maxCumulativeVol = maxCumulativeVolSell;
                                    continue;
                                }
                                catch (Exception ex) {
                                    this.mediator.PrintLog(ex, Msg);
                                }
                            }
                            this.poltValues(this.allRows, maxCumulativeVol);
                            this.tableDataChange();
                            this.lastTime = MyTime.getInstance().getTime();
                            this.lblLastUpdate.setToolTipText("Last Update Time " + this.lastTime);
                            if (this.allRows.size() > 0) {
                                this.PMEX_Order_Template.setMBPBean(this.allRows.get(0));
                            }
                            this.MBPDetail.setValues(0.0, 0.0, buyVolTot, sellVolTot, buyPriceTot, sellPriceTot);
                            this.lblMessage.setFont(this.lblMessage.getFont().deriveFont(1));
                            String symbol = this.cbContract.getSelectedItem().toString();
                            String tit = this.lblMessage.getText();
                            String title = this.mediator.getContractTitle(symbol);
                            System.err.println(tit + " , " + title);
                            if (tit.equalsIgnoreCase(title + ".")) continue;
                            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Normal, (String)title);
                        }
                        break block29;
                    }
                    catch (Exception ex) {
                        this.mediator.PrintLog(ex, Msg);
                        break block29;
                    }
                }
                this.setTableEmpty();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void resetTableFont() {
        FontMetrics metrics = this.getFontMetrics(LogCommon.MarketDepthFont);
        int fontHeight = metrics.getHeight();
        if (fontHeight <= 18) {
            this.table.setRowHeight(18);
        } else {
            this.table.setRowHeight(fontHeight);
        }
        if (this.MBPDetail != null) {
            this.MBPDetail.Refresh();
        }
        this.table.repaint();
    }

    public Font GetMBPFont() {
        return this.table.getFont();
    }

    public void dispose() {
        if (this.dialogBox != null) {
            this.dialogBox.dispose();
        }
    }

    private void initComponents() {
        this.cbContract = new JComboBox();
        this.jXButton1 = new JXButton();
        this.lblMarket = new JLabel();
        this.lblDetail = new JLabel();
        this.pnlBar = new JPanel();
        this.scrollPane = new JScrollPane();
        this.table = new JTable(this.rows, this.columns);
        this.collPaneMBPDetail = new JXCollapsiblePane();
        this.jToolBar1 = new JToolBar();
        this.btnSeeMore = new JToggleButton();
        this.collPaneOrder = new JXCollapsiblePane();
        this.lblLastUpdate = new JLabel();
        this.lblMessage = new JLabel();
        this.cbContract.setEditable(true);
        this.jXButton1.setText("...");
        this.lblMarket.setText("Contract ");
        this.lblDetail.setIcon(new ImageIcon(this.getClass().getResource("/Images/downarrowgray.png")));
        this.lblDetail.setText("Details");
        this.lblDetail.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                PMEX_MBP.this.lblDetailMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PMEX_MBP.this.lblDetailMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                PMEX_MBP.this.lblDetailMousePressed(evt);
            }
        });
        this.pnlBar.setBackground(new Color(102, 102, 255));
        this.pnlBar.setOpaque(false);
        this.pnlBar.setLayout(new BoxLayout(this.pnlBar, 2));
        this.scrollPane.setViewportView(this.table);
        this.collPaneMBPDetail.setCollapsed(true);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.btnSeeMore.setIcon(new ImageIcon(this.getClass().getResource("/Images/downarrowgray.png")));
        this.btnSeeMore.setSelected(true);
        this.btnSeeMore.setText("See Less");
        this.btnSeeMore.setFocusable(false);
        this.btnSeeMore.setHorizontalTextPosition(2);
        this.btnSeeMore.setMaximumSize(new Dimension(80, 23));
        this.btnSeeMore.setMinimumSize(new Dimension(80, 23));
        this.btnSeeMore.setVerticalTextPosition(3);
        this.btnSeeMore.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PMEX_MBP.this.btnSeeMoreItemStateChanged(evt);
            }
        });
        this.jToolBar1.add(this.btnSeeMore);
        this.lblLastUpdate.setHorizontalAlignment(4);
        this.lblLastUpdate.setIcon(new ImageIcon(this.getClass().getResource("/Images/lastUpdateTime16.png")));
        this.lblLastUpdate.setText("PKT 88:88:88");
        this.lblLastUpdate.setToolTipText("Yet not updated");
        this.lblLastUpdate.setHorizontalTextPosition(2);
        this.lblMessage.setText("A");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.scrollPane, -2, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblMessage, -2, 262, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.lblLastUpdate, -2, 90, -2)).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.lblMarket).addGap(4, 4, 4).addComponent(this.cbContract, -2, 177, -2).addGap(6, 6, 6).addComponent((Component)this.jXButton1, -2, 18, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 68, Short.MAX_VALUE).addComponent(this.lblDetail, -2, 55, -2)).addGroup(layout.createSequentialGroup().addGap(59, 59, 59).addComponent(this.pnlBar, -1, -1, Short.MAX_VALUE).addGap(35, 35, 35)).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent((Component)this.collPaneMBPDetail, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jToolBar1, -2, 370, -2)).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent((Component)this.collPaneOrder, -1, -1, Short.MAX_VALUE).addGap(1, 1, 1))).addGap(10, 10, 10)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.lblMarket)).addGroup(layout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.cbContract, -2, -1, -2)).addComponent((Component)this.jXButton1, -2, -1, -2).addGroup(layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.lblDetail, -2, 19, -2))).addGap(8, 8, 8).addComponent(this.pnlBar, -2, -1, -2).addGap(8, 8, 8).addComponent(this.scrollPane, -1, 40, Short.MAX_VALUE).addGap(0, 0, 0).addComponent((Component)this.collPaneMBPDetail, -2, -1, -2).addGap(2, 2, 2).addComponent(this.jToolBar1, -2, -1, -2).addGap(0, 0, 0).addComponent((Component)this.collPaneOrder, -2, -1, -2).addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblMessage, -2, 20, -2).addComponent(this.lblLastUpdate, -2, 20, -2)).addGap(0, 0, 0)));
    }

    private void lblDetailMouseEntered(MouseEvent evt) {
        this.lblDetail.setText("<html><U>Details</U></html>");
    }

    private void lblDetailMouseExited(MouseEvent evt) {
        this.lblDetail.setText("<html>Details</html>");
    }

    private void lblDetailMousePressed(MouseEvent evt) {
        this.setCollaspeDetail();
    }

    private void btnSeeMoreItemStateChanged(ItemEvent evt) {
        this.setCollaspeOrderWindow();
    }

    @Override
    public void paint(Graphics g) {
        try {
            super.paint(g);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void update(Graphics g) {
        try {
            this.paint(g);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cbContract) {
            if (e.getModifiers() == 16 || e.getActionCommand().equalsIgnoreCase("comboBoxEdited")) {
                this.setTableEmpty();
                String sym = "";
                if (this.cbContract.getSelectedItem() != null) {
                    sym = this.cbContract.getSelectedItem().toString();
                } else {
                    this.SendMBPMessage("", "");
                    this.lblMessage.setFont(AppConfig.defaultPlanFont);
                    this.lblMessage.setText("Please enter Contract");
                }
                if (sym.length() < 1 || sym == contractPrompt) {
                    this.SendMBPMessage("", "");
                    this.lblMessage.setFont(AppConfig.defaultPlanFont);
                    this.lblMessage.setText("Please enter Contract");
                } else {
                    this.SendMBPMessage(sym, UtilPMEX.GetMarketFromContract((String)sym));
                }
            }
        } else if (e.getSource() == this.jXButton1) {
            if (this.tradeCast.htFormsProperties.containsKey(FormName.ContractBrowse)) {
                FormsProperties fp = this.tradeCast.htFormsProperties.get(FormName.ContractBrowse);
                ContractBrowseBean cb = PMEX_ContractBrowseDialog.getSelectedContract(this.tradeCast.frame, true, fp.getSize());
                if (cb != null) {
                    this.cbContract.setSelectedItem(cb.getContract());
                }
            } else {
                ContractBrowseBean cb = PMEX_ContractBrowseDialog.getSelectedContract(this.tradeCast.frame, true, new Dimension(600, 400));
                if (cb != null) {
                    this.cbContract.setSelectedItem(cb.getContract());
                }
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public void addContract() {
        if (this.autoCom != null && this.autoCom.isInstalled()) {
            this.autoCom.uninstall();
        }
        ArrayList v = new ArrayList(LogsPMEX.PMEX_CONTRACT_ALL.keySet());
        Collections.sort(v);
        v.add(0, contractPrompt);
        this.autoCom = AutoCompleteSupport.install((JComboBox)this.cbContract, (EventList)GlazedLists.eventListOf((Object[])v.toArray()));
        this.autoCom.setStrict(false);
        this.cbContract.setSelectedItem(contractPrompt);
    }

    private void poltValues(List<MBO_MBP_Bean> allRows, long maxCumulativeVol) {
        this.barPanel.setValues(allRows, maxCumulativeVol);
        this.barPanel.repaint();
    }

    private void setTableEmpty() {
        this.rows.clear();
        for (int i = 0; i < 10; ++i) {
            Vector<String> vvv = new Vector<String>();
            vvv.addElement("");
            vvv.addElement("");
            vvv.addElement("");
            vvv.addElement("");
            vvv.addElement("");
            vvv.addElement("");
            this.rows.insertElementAt(vvv, i);
        }
        this.poltValues(null, 0L);
        this.PMEX_Order_Template.setMBPBean(null);
        this.MBPDetail.setDetailEmpty();
        this.tableDataChange();
    }
}

