/*
 * Decompiled with CFR 0.152.
 */
package windows.pmex;

import MyDocking.Mediator;
import RendersNModels.ComboBoxToolTipRender;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.bean.AccountBean;
import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.AbstractDocument;
import languages.LanguageCentre;
import languages.LanguageConstant;
import pmex.gui.bean.VaultPositionBean;
import pmex.gui.model.VaultPositionModel;
import pmex.gui.render.VaultPositionRender;
import pmex.gui.util.LogsPMEX;
import windows.pmex.buyingpower.DocumentSizeAndUppercaseFilter;

public class PMEX_VaultPosition
extends JPanel
implements FocusListener {
    private Mediator mediator = Mediator.getInstance();
    private Vector<VaultPositionBean> rows = new Vector();
    private Vector columns = new Vector();
    private VaultPositionModel model = null;
    private VaultPositionRender render = new VaultPositionRender();
    private LanguageCentre languageCentre = new LanguageCentre();
    private JButton btnGet;
    public JComboBox cbAccountNo;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JLabel lblMessage;
    private JLabel lblPrefix;
    private JTable table;

    public PMEX_VaultPosition() {
        this.initComponents();
        this.columns.add("Trader Name");
        this.columns.add("Commodity");
        this.columns.add("Balance");
        this.columns.add("Locked Balance");
        this.model = new VaultPositionModel(this.rows, this.columns);
        this.setAccount();
        this.table.setModel((TableModel)this.model);
        for (int k = 0; k < this.columns.size(); ++k) {
            this.table.getColumn(this.columns.elementAt(k)).setCellRenderer((TableCellRenderer)this.render);
        }
        this.table.setAutoCreateRowSorter(true);
        JTableHeader header = this.table.getTableHeader();
        ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(0);
        this.cbAccountNo.addFocusListener(this);
        this.table.setRowHeight(AppConfig.rowHeight);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.cbAccountNo.requestFocus();
    }

    private void addData(String allData) {
        this.removeAccStatementTable();
        if (allData.equalsIgnoreCase("Exception")) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Error in loading Account Statement");
            return;
        }
        if (allData.indexOf("|") < 0) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Normal, (String)"No record found");
            return;
        }
        if (allData.indexOf("|") >= 0) {
            String[] rowData = allData.split("\\|", -1);
            for (int i = 0; i < rowData.length - 1; ++i) {
                VaultPositionBean bean = VaultPositionBean.parse((String)rowData[i]);
                this.rows.add(bean);
            }
            this.tableDataChange();
        }
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
    }

    private void tableDataChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.table.addNotify();
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PMEX_VaultPosition.this.table.addNotify();
                    PMEX_VaultPosition.this.table.repaint();
                }
            });
        }
    }

    private void setAccount() {
        if (LogsPMEX.accountPrefix.length() > 0) {
            this.lblPrefix.setText(LogsPMEX.accountPrefix);
        } else {
            this.lblPrefix.setText("Account");
        }
        Iterator en = LogsPMEX.ALL_ACCOUNTS.keySet().iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (en.hasNext()) {
            String key = en.next().toString();
            AccountBean ac = (AccountBean)LogsPMEX.ALL_ACCOUNTS.get(key);
            if (ac.getAccountNo().indexOf(LogsPMEX.accountPrefix) == 0) {
                list.add(ac.getAccountNo().replaceFirst(LogsPMEX.accountPrefix, ""));
                continue;
            }
            list.add(ac.getAccountNo());
        }
        this.cbAccountNo.setRenderer(new ComboBoxToolTipRender(LogsPMEX.ALL_ACCOUNTS, LogsPMEX.accountPrefix));
        this.cbAccountNo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    PMEX_VaultPosition.this.cbAccountNo.setToolTipText(((AccountBean)LogsPMEX.ALL_ACCOUNTS.get(LogsPMEX.accountPrefix + PMEX_VaultPosition.this.cbAccountNo.getSelectedItem().toString().trim())).toString());
                }
                catch (Exception ex) {
                    PMEX_VaultPosition.this.cbAccountNo.setToolTipText(null);
                }
            }
        });
        Collections.sort(list);
        this.cbAccountNo.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        AutoCompleteSupport autoComplete = AutoCompleteSupport.install((JComboBox)this.cbAccountNo, (EventList)GlazedLists.eventListOf((Object[])list.toArray()));
        autoComplete.setStrict(true);
        AbstractDocument d = (AbstractDocument)((JTextField)this.cbAccountNo.getEditor().getEditorComponent()).getDocument();
        d.setDocumentFilter(new DocumentSizeAndUppercaseFilter(4));
    }

    private void removeAccStatementTable() {
        this.rows.clear();
        this.tableDataChange();
    }

    private void initComponents() {
        this.lblPrefix = new JLabel();
        this.btnGet = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.lblMessage = new JLabel();
        this.cbAccountNo = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.lblPrefix.setHorizontalAlignment(2);
        this.lblPrefix.setText("Account");
        this.btnGet.setIcon(new ImageIcon(this.getClass().getResource("/Images/get.png")));
        this.btnGet.setText("Get");
        this.btnGet.setName("PMEX_VaultPosition -> btnGet");
        this.btnGet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PMEX_VaultPosition.this.btnGetActionPerformed(evt);
            }
        });
        this.jScrollPane1.setPreferredSize(new Dimension(452, 100));
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[]{"Voucher No.", "Date", "Description", "Credit", "Debit", "Balance"}));
        this.table.setFocusable(false);
        this.table.setMinimumSize(new Dimension(50, 0));
        this.table.setSelectionMode(0);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                PMEX_VaultPosition.this.tableMouseExited(evt);
            }
        });
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                PMEX_VaultPosition.this.tableMouseMoved(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.table);
        this.lblMessage.setText(" ");
        this.cbAccountNo.setEditable(true);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblPrefix, -2, 45, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbAccountNo, -2, 125, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnGet, -2, 91, -2)).addComponent(this.lblMessage, -2, 494, -2)).addGap(0, 18, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblPrefix, -2, 23, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbAccountNo, -2, -1, -2).addComponent(this.btnGet))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 108, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblMessage, -2, 19, -2)));
    }

    private void btnGetActionPerformed(ActionEvent evt) {
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
        this.removeAccStatementTable();
        if (this.cbAccountNo.getSelectedItem() == null) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Please select account.");
            this.cbAccountNo.requestFocus();
            return;
        }
        if (this.cbAccountNo.getSelectedItem().toString().length() <= 0) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Please select account.");
            this.cbAccountNo.requestFocus();
            return;
        }
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Loading, (String)this.languageCentre.getValue(LanguageConstant.Loading));
        new Thread(new Runnable(){

            @Override
            public void run() {
                PMEX_VaultPosition.this.loadData();
            }
        }).start();
    }

    private void tableMouseExited(MouseEvent evt) {
    }

    private void tableMouseMoved(MouseEvent evt) {
    }

    @Override
    public void focusGained(FocusEvent e) {
        Object source = e.getSource();
        if (source == this.cbAccountNo) {
            // empty if block
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    private void loadData() {
        String result = "";
        try {
            result = WebService.getInstance().getPort().getAccountStatement(LogCommon.UserID, this.cbAccountNo.getSelectedItem().toString(), "", "", "PMEXVaultPosition");
            this.addData(result);
        }
        catch (Exception ex) {
            this.mediator.PrintLog(ex, result);
            this.addData("Exception");
        }
    }
}

