/*
 * Decompiled with CFR 0.152.
 */
package windows.pmex.buyingpower;

import CustomComponent.CustomComboEditor;
import MyDocking.Mediator;
import RendersNModels.NetPositionModel;
import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import common.gui.util.Util;
import java.awt.Component;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import windows.pmex.buyingpower.PMEX_BuyingPower_Dock_Account_Panel;
import windows.pmex.buyingpower.PMEX_BuyingPower_Dock_Panel;

public class PMEX_BuyingPower_Dock
extends JPanel {
    private Vector rows = new Vector();
    private Vector<String> columns = new Vector();
    private NetPositionModel model = null;
    public static final String NetLiquidity = "Net Liquidity";
    public static final String MarginRequired = "Margin Required";
    public static final String BuyingPower = "Buying Power";
    public static final String RealizedPL = "Realized P/L";
    public static final String UnrealizedPL = "Unrealized P/L";
    public static final String BuyPowerPercentUsed = "% Buying Power Used";
    public static final String Threshold = "Threshold";
    private PMEX_BuyingPower_Dock_Panel pnlNetLiquidity = new PMEX_BuyingPower_Dock_Panel();
    private PMEX_BuyingPower_Dock_Panel pnlMarginRequired = new PMEX_BuyingPower_Dock_Panel();
    private PMEX_BuyingPower_Dock_Panel pnlBuyingPower = new PMEX_BuyingPower_Dock_Panel();
    private PMEX_BuyingPower_Dock_Panel pnlRealizedPL = new PMEX_BuyingPower_Dock_Panel();
    private PMEX_BuyingPower_Dock_Panel pnlUnrealizedPL = new PMEX_BuyingPower_Dock_Panel();
    private PMEX_BuyingPower_Dock_Panel pnlBuyPowerPercentUsed = new PMEX_BuyingPower_Dock_Panel();
    private PMEX_BuyingPower_Dock_Panel pnlThreshold = new PMEX_BuyingPower_Dock_Panel();
    private PMEX_BuyingPower_Dock_Account_Panel pnlAccount = new PMEX_BuyingPower_Dock_Account_Panel(this);
    private String previousResut = "";
    private JScrollPane jScrollPane1;
    private JTable table;

    public PMEX_BuyingPower_Dock() {
        Mediator.getInstance().setPMEX_buyingPower_Dock(this);
        this.initComponents();
        this.initTable();
        this.initPanel(NetLiquidity, this.pnlNetLiquidity);
        this.initPanel(MarginRequired, this.pnlMarginRequired);
        this.initPanel(BuyingPower, this.pnlBuyingPower);
        this.initPanel(RealizedPL, this.pnlRealizedPL);
        this.initPanel(UnrealizedPL, this.pnlUnrealizedPL);
        this.initPanel(BuyPowerPercentUsed, this.pnlBuyPowerPercentUsed);
        this.initPanel(Threshold, this.pnlThreshold);
    }

    private void initTable() {
        int i = 0;
        this.columns.add("" + i++);
        this.columns.add("" + i++);
        this.columns.add("" + i++);
        this.columns.add("" + i++);
        this.columns.add("" + i++);
        this.columns.add("" + i++);
        this.columns.add("" + i++);
        this.columns.add("" + i++);
        Vector<String> v = new Vector<String>();
        v.add("");
        v.add("");
        v.add("");
        v.add("");
        v.add("");
        v.add("");
        v.add("");
        v.add("");
        this.rows.add(v);
        this.model = new NetPositionModel(this.rows, this.columns);
        this.table.setRowHeight(102);
        this.table.setModel((TableModel)((Object)this.model));
        this.table.setTableHeader(null);
        this.setUpAccountColumn(this.table, this.table.getColumnModel().getColumn(0));
        this.setUpValueColumn(this.table, this.table.getColumnModel().getColumn(1), NetLiquidity, this.pnlNetLiquidity, false, false, true, false);
        this.setUpValueColumn(this.table, this.table.getColumnModel().getColumn(2), MarginRequired, this.pnlMarginRequired, false, false, true, false);
        this.setUpValueColumn(this.table, this.table.getColumnModel().getColumn(3), BuyingPower, this.pnlBuyingPower, true, false, true, false);
        this.setUpValueColumn(this.table, this.table.getColumnModel().getColumn(4), RealizedPL, this.pnlRealizedPL, false, true, true, false);
        this.setUpValueColumn(this.table, this.table.getColumnModel().getColumn(5), UnrealizedPL, this.pnlUnrealizedPL, false, true, true, false);
        this.setUpValueColumn(this.table, this.table.getColumnModel().getColumn(6), BuyPowerPercentUsed, this.pnlBuyPowerPercentUsed, true, false, false, true);
        this.setUpValueColumn(this.table, this.table.getColumnModel().getColumn(7), Threshold, this.pnlThreshold, false, false, false, false);
        this.table.getColumnModel().getColumn(0).setMaxWidth(100);
        this.table.getColumnModel().getColumn(0).setMinWidth(100);
        this.table.getColumnModel().getColumn(7).setMaxWidth(120);
        this.table.getColumnModel().getColumn(7).setMinWidth(120);
        this.model.fireTableDataChanged();
        this.table.addNotify();
        this.table.repaint();
    }

    private void initPanel(String title, PMEX_BuyingPower_Dock_Panel panel) {
        panel.setTitle(title);
        panel.setFont(AppConfig.defaultBoldFontExStats2);
        if (title.equalsIgnoreCase(NetLiquidity)) {
            panel.setIcon(new ImageIcon(this.getClass().getResource("/pmex/gui/images/netPosition24x24.png")));
        } else if (title.equalsIgnoreCase(MarginRequired)) {
            panel.setIcon(new ImageIcon(this.getClass().getResource("/pmex/gui/images/marginRequired24x24.png")));
        } else if (title.equalsIgnoreCase(BuyingPower)) {
            panel.setIcon(new ImageIcon(this.getClass().getResource("/pmex/gui/images/buyingPower24x24.png")));
        } else if (title.equalsIgnoreCase(RealizedPL)) {
            panel.setIcon(new ImageIcon(this.getClass().getResource("/pmex/gui/images/realisedPL24x24.png")));
        } else if (title.equalsIgnoreCase(UnrealizedPL)) {
            panel.setIcon(new ImageIcon(this.getClass().getResource("/pmex/gui/images/unrealisedPL24x24.png")));
        } else if (title.equalsIgnoreCase(BuyPowerPercentUsed)) {
            panel.setIcon(new ImageIcon(this.getClass().getResource("/pmex/gui/images/buyingPwerPercent24x24.png")));
        } else if (title.equalsIgnoreCase(Threshold)) {
            panel.setIcon(new ImageIcon(this.getClass().getResource("/pmex/gui/images/threshold24x24.png")));
        }
    }

    public void setUpValueColumn(final JTable table, TableColumn col, final String title, final PMEX_BuyingPower_Dock_Panel lbl, final boolean isPercent, final boolean isForeColor, final boolean isShowPKR, final boolean isDecimal) {
        col.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable tblDataTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (PMEX_BuyingPower_Dock.this.pnlAccount.getSelectedAccount().length() > 0) {
                    lbl.setValue(value + "", isForeColor, isShowPKR, isDecimal, isPercent);
                    if (isPercent) {
                        if (column == 3) {
                            try {
                                double d = Double.parseDouble(PMEX_BuyingPower_Dock.this.pnlBuyPowerPercentUsed.getValue() + "");
                                int per = (int)(100.0 - d);
                                lbl.setPercent(per, false);
                                PMEX_BuyingPower_Dock.this.model.fireTableDataChanged();
                                table.addNotify();
                                table.repaint();
                            }
                            catch (Exception ex) {
                                lbl.setPercent(0, isPercent);
                            }
                        } else if (column == 6) {
                            try {
                                lbl.setPercent((int)Double.parseDouble(value.toString()), isPercent);
                                PMEX_BuyingPower_Dock.this.model.fireTableDataChanged();
                                table.addNotify();
                                table.repaint();
                            }
                            catch (Exception ex) {
                                lbl.setPercent(0, isPercent);
                            }
                        } else {
                            try {
                                double d = Double.parseDouble(tblDataTable.getValueAt(0, 6) + "");
                                int per = (int)(100.0 - d);
                                lbl.setPercent(per, isPercent);
                            }
                            catch (Exception ex) {
                                lbl.setPercent(0, isPercent);
                            }
                        }
                    }
                    lbl.setToolTipText(title + " : " + Util.format2digit((String)(value + "")));
                }
                return lbl;
            }
        });
    }

    public void setUpAccountColumn(JTable table, TableColumn sportColumn) {
        sportColumn.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable tblDataTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return PMEX_BuyingPower_Dock.this.pnlAccount;
            }
        });
        sportColumn.setCellEditor(new CustomComboEditor(this.pnlAccount));
    }

    public String getSelectedAccount() {
        return this.pnlAccount.getSelectedAccount();
    }

    public void accountChanged(String account) {
        this.getDataFromServer(account);
    }

    private void getDataFromServer(String account) {
        this.emptyTable();
        this.previousResut = "";
        Mediator.getInstance().ResetTimerBuyingPower();
    }

    public void ParseBuyingPower(String result) {
        if (result.indexOf("$") >= 0 && !result.equalsIgnoreCase(this.previousResut)) {
            String[] allRows = result.split("\\$", -1);
            for (int i = 0; i < allRows.length; ++i) {
                String[] singleRow;
                String sngRow = allRows[i];
                if (sngRow.indexOf(";") <= 0 || !(singleRow = sngRow.split("\\;", -1))[1].equalsIgnoreCase(this.pnlAccount.getSelectedAccount())) continue;
                this.table.setValueAt(singleRow[4], 0, 1);
                this.table.setValueAt(singleRow[6], 0, 2);
                this.table.setValueAt(singleRow[5], 0, 3);
                this.table.setValueAt(singleRow[2], 0, 4);
                this.table.setValueAt(singleRow[3], 0, 5);
                this.table.setValueAt(singleRow[7], 0, 6);
                this.table.setValueAt(singleRow[8], 0, 7);
                this.table.addNotify();
                this.model.fireTableDataChanged();
                this.table.repaint();
                this.previousResut = result;
            }
        }
    }

    private void emptyTable() {
        this.table.setValueAt("", 0, 1);
        this.table.setValueAt("", 0, 2);
        this.table.setValueAt("", 0, 3);
        this.table.setValueAt("", 0, 4);
        this.table.setValueAt("", 0, 5);
        this.table.setValueAt("", 0, 6);
        this.table.setValueAt("", 0, 7);
        this.table.addNotify();
        this.model.fireTableDataChanged();
        this.table.repaint();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.jScrollPane1.setVerticalScrollBarPolicy(21);
        this.table.setModel(new DefaultTableModel(new Object[][]{{"1", "2", "3", "4", "5", "6"}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4", "5", "6"}));
        this.jScrollPane1.setViewportView(this.table);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 348, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 36, Short.MAX_VALUE));
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        Mediator.getInstance().ResetTimerBuyingPower();
        if (aFlag) {
            // empty if block
        }
    }

    public void setPreferredAccount() {
        if (LogCommon.preferredAccountPMEX.trim().length() > 0) {
            this.pnlAccount.setPreferredAccount();
            Mediator.getInstance().ResetTimerBuyingPower();
        }
    }
}

