/*
 * Decompiled with CFR 0.152.
 */
package windows.pmex.logs;

import Control.JasperFileChooser;
import Control.ReportControl;
import Control.ReportControlEvent;
import Control.ReportControlListener;
import CustomComponent.MyTime;
import MyDocking.Mediator;
import RendersNModels.ComboBoxToolTipRender;
import Utilities.LoadLogs;
import Utilities.ThreadWithName;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.bean.AccountBean;
import common.gui.component.NxGTable;
import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import common.gui.util.MyColors;
import common.gui.util.Util;
import common.interfaces.AddContract;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.AbstractDocument;
import javax.swing.text.JTextComponent;
import languages.LanguageCentre;
import languages.LanguageConstant;
import pmex.gui.bean.TradedOrderBean;
import pmex.gui.model.TradedOrderModel;
import pmex.gui.render.TradedOrderRender;
import pmex.gui.util.LogsPMEX;
import reports.Jasper_Report;
import reports.Report_PMEX_TradedOrder;
import windows.pmex.buyingpower.DocumentSizeAndUppercaseFilter;

public class PMEX_TradedOrder
extends JPanel
implements ActionListener,
ItemListener,
ReportControlListener,
AddContract {
    private Mediator mediator = Mediator.getInstance();
    private Vector<TradedOrderBean> rows = new Vector();
    private Vector<TradedOrderBean> rowsAll = new Vector();
    private Vector<String> columns = new Vector();
    private TradedOrderModel model = null;
    private TradedOrderRender render = null;
    private AutoCompleteSupport autoCom;
    private AutoCompleteSupport autoComplete;
    private JTextComponent editorContract;
    private JTextComponent editorTrader;
    private ImageIcon loaderIcon = new ImageIcon(this.getClass().getResource(AppConfig.loaderIconPath));
    private LanguageCentre languageCentre = new LanguageCentre();
    private JButton btnReload;
    private JButton btnRestore;
    private JComboBox cbAccountNo;
    private JCheckBox cbBuy;
    private JComboBox cbContract;
    private JCheckBox cbSell;
    private JComboBox cbTrader;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JLabel lblBuy;
    private JLabel lblMarket;
    private JLabel lblMessage;
    private JLabel lblPrefix;
    private JLabel lblSell;
    private JLabel lblTrader;
    private ReportControl reportControl1;
    private NxGTable table;
    private JTextField txtBuySum;
    private JTextField txtSellSum;
    public String JRXMLFileName = "PMEX_TradedOrder.jrxml";

    public PMEX_TradedOrder() {
        try {
            this.initComponents();
            this.mediator.setPMEX_TradedOrder(this);
            this.btnReload.addActionListener(this);
            this.btnRestore.addActionListener(this);
            this.cbContract.addActionListener(this);
            this.cbBuy.addItemListener(this);
            this.cbSell.addItemListener(this);
            this.setTreader();
            this.setAccount();
            this.addContract();
            this.cbContract.setMaximumRowCount(30);
            LogsPMEX.CONTRACT_HOLDER.add(this);
            this.reportControl1.setVisible(true);
            this.cbSell.setForeground(MyColors.SellBG);
            this.cbBuy.setForeground(MyColors.BuyBG);
            this.initTable();
            this.hideValues();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initTable() {
        this.columns.add("User");
        this.columns.add("Account");
        this.columns.add("Contract");
        this.columns.add("Order ID");
        this.columns.add("Ticket ID");
        this.columns.add("Client Order ID");
        this.columns.add("Price");
        this.columns.add("Average Price");
        this.columns.add("Fill Volume");
        this.columns.add("Total Fill");
        this.columns.add("Remaining Volume");
        this.columns.add("Transaction Type");
        this.columns.add("Distance");
        this.columns.add("Trailing Step");
        this.columns.add("Time");
        this.model = new TradedOrderModel(this.rows, this.columns);
        this.table.setModel((TableModel)this.model);
        this.render = new TradedOrderRender();
        for (int k = 0; k < this.model.getColumnCount(); ++k) {
            this.table.getColumn((Object)this.model.getColumnName(k)).setCellRenderer((TableCellRenderer)this.render);
        }
        FontMetrics metrics = this.getFontMetrics(LogCommon.LogFont);
        int fontHeight = metrics.getHeight();
        this.table.setRowHeight(fontHeight);
        this.table.setRowSorter(null);
        this.table.repaint();
        this.setSorter();
        this.reportControl1.addListener(this);
    }

    private void setSorter() {
        JTableHeader header = this.table.getTableHeader();
        header.addMouseListener(new ColumnListner(this.table));
        header.setReorderingAllowed(false);
    }

    private void setTreader() {
        Vector<String> allTrader = new Vector<String>();
        allTrader.addElement("ALL");
        allTrader.addElement(LogCommon.UserID);
        Collections.sort(allTrader);
        this.cbTrader.setModel(new DefaultComboBoxModel(allTrader));
        AutoCompleteSupport support = AutoCompleteSupport.install((JComboBox)this.cbTrader, (EventList)GlazedLists.eventListOf((Object[])allTrader.toArray()));
        this.cbTrader.setSelectedItem("ALL");
        this.editorTrader = (JTextComponent)this.cbTrader.getEditor().getEditorComponent();
        this.editorTrader.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                PMEX_TradedOrder.this.rowFilter();
            }
        });
    }

    private void setAccount() {
        if (LogsPMEX.accountPrefix.length() > 0) {
            this.lblPrefix.setText(LogsPMEX.accountPrefix);
        } else {
            this.lblPrefix.setText("Account");
        }
        Iterator en = LogsPMEX.ALL_ACCOUNTS.keySet().iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (en.hasNext()) {
            String key = en.next().toString();
            AccountBean ac = (AccountBean)LogsPMEX.ALL_ACCOUNTS.get(key);
            if (ac.getAccountNo().indexOf(LogsPMEX.accountPrefix) == 0) {
                list.add(ac.getAccountNo().replaceFirst(LogsPMEX.accountPrefix, ""));
                continue;
            }
            list.add(ac.getAccountNo());
        }
        Collections.sort(list);
        list.add(0, "ALL");
        this.cbAccountNo.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        this.autoComplete = AutoCompleteSupport.install((JComboBox)this.cbAccountNo, (EventList)GlazedLists.eventListOf((Object[])list.toArray()));
        this.cbAccountNo.setRenderer(new ComboBoxToolTipRender(LogsPMEX.ALL_ACCOUNTS, LogsPMEX.accountPrefix));
        this.cbAccountNo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    PMEX_TradedOrder.this.cbAccountNo.setToolTipText(((AccountBean)LogsPMEX.ALL_ACCOUNTS.get(LogsPMEX.accountPrefix + PMEX_TradedOrder.this.cbAccountNo.getSelectedItem().toString().trim())).toString());
                }
                catch (Exception ex) {
                    PMEX_TradedOrder.this.cbAccountNo.setToolTipText(null);
                }
            }
        });
        this.cbAccountNo.setSelectedItem("ALL");
        this.cbAccountNo.setEditable(true);
        this.cbAccountNo.addActionListener(this);
        this.cbAccountNo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
            }
        });
        AbstractDocument d = (AbstractDocument)((JTextField)this.cbAccountNo.getEditor().getEditorComponent()).getDocument();
        d.setDocumentFilter(new DocumentSizeAndUppercaseFilter(4));
    }

    private String getSelectedAccount() {
        if (this.cbAccountNo.getSelectedItem() == null) {
            return "";
        }
        if (this.cbAccountNo.getSelectedItem().toString().trim().equalsIgnoreCase("")) {
            return "";
        }
        if (this.cbAccountNo.getSelectedItem().toString().trim().equalsIgnoreCase("ALL")) {
            return "ALL";
        }
        return LogsPMEX.accountPrefix + this.cbAccountNo.getSelectedItem().toString().trim();
    }

    public void GetLog() {
        this.lblMessage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
        this.lblMessage.setIcon(this.loaderIcon);
        LoadLogs loadLogs = new LoadLogs("PMEX_GetTradedOrder=", true, false);
        new ThreadWithName(loadLogs, "PMEX_GetTradedOrder").start();
    }

    public void LogRecieved(String Str) {
        this.lblMessage.setIcon(null);
        if (Str.equalsIgnoreCase("No Record found") || Str.equalsIgnoreCase("")) {
            this.lblMessage.setText("No record found.");
        } else if (Str.equalsIgnoreCase("Exception")) {
            this.lblMessage.setText("Error in loading Traded Order Log.");
        } else {
            this.UpdateTable(Str);
        }
    }

    private synchronized void UpdateTable(String Logstr) {
        this.rowsAll.clear();
        this.emptyTable();
        this.lblMessage.setText(" ");
        this.lblMessage.setIcon(null);
        if (Logstr.indexOf(";") < 1) {
            this.lblMessage.setText("No record found.");
            return;
        }
        if (Logstr.indexOf("|") > 0) {
            String[] data = Logstr.split("\\|", -1);
            for (int i = 0; i < data.length; ++i) {
                String string = data[i];
                if (string.trim().equalsIgnoreCase("")) continue;
                TradedOrderBean b = TradedOrderBean.parse((String)string);
                this.rowsAll.add(b);
            }
            this.rowFilter();
        }
    }

    private void rowFilter() {
        this.emptyTable();
        String Trader = "";
        String Account = this.getSelectedAccount();
        String Contract = "";
        String Type2 = "";
        int BuyCount = 0;
        int SellCount = 0;
        double buySum = 0.0;
        double sellSum = 0.0;
        Trader = this.cbTrader.getSelectedItem() == null ? this.editorTrader.getText() : this.cbTrader.getSelectedItem().toString();
        Contract = this.cbContract.getSelectedItem() == null ? this.editorContract.getText() : this.cbContract.getSelectedItem().toString().trim();
        if (Contract.equalsIgnoreCase("ALL")) {
            Contract = "";
        }
        if (Account.equalsIgnoreCase("ALL")) {
            Account = "";
        }
        if (Trader.equalsIgnoreCase("ALL")) {
            Trader = "";
        }
        if (this.cbSell.isSelected()) {
            Type2 = "SELL";
        }
        if (this.cbBuy.isSelected()) {
            Type2 = "BUY";
        }
        if (this.cbBuy.isSelected() && this.cbSell.isSelected()) {
            Type2 = "";
        }
        for (TradedOrderBean b : this.rowsAll) {
            if (!b.getTrader().equalsIgnoreCase(Trader) && Trader.length() > 0 || !b.getContract().trim().equalsIgnoreCase(Contract) && Contract.length() > 0 || b.getAccount().trim().indexOf(Account) == -1 && Account.length() > 0 || !b.getTransactionType().equalsIgnoreCase(Type2) && Type2.length() > 0) continue;
            if (b.getTransactionType().equalsIgnoreCase("Buy")) {
                buySum += (double)b.getFillVolume() * b.getPrice();
                ++BuyCount;
            }
            if (b.getTransactionType().equalsIgnoreCase("Sell")) {
                sellSum += (double)b.getFillVolume() * b.getPrice();
                ++SellCount;
            }
            this.rows.add(b);
        }
        if (this.model.getRowCount() > 1) {
            this.lblMessage.setText(Util.format0digit((String)(this.model.getRowCount() + "".trim().replaceAll("\\,", ""))) + " records found.     Buy (" + Util.format0digit((String)(BuyCount + "")) + ")     Sell (" + Util.format0digit((String)(SellCount + "")) + ")");
        } else {
            this.lblMessage.setText(Util.format0digit((String)(this.model.getRowCount() + "".trim().replaceAll("\\,", ""))) + " record found.     Buy (" + Util.format0digit((String)(BuyCount + "")) + ")     Sell (" + Util.format0digit((String)(SellCount + "")) + ")");
        }
        this.txtBuySum.setText(Util.format2digit((String)(buySum + "")));
        this.txtSellSum.setText(Util.format2digit((String)(sellSum + "")));
        this.lblMessage.setIcon(null);
        this.tableDataChange();
    }

    public void orderPacketReceived(TradedOrderBean b) {
        this.rowsAll.add(b);
        this.rowFilter();
    }

    public void emptyTable() {
        this.lblMessage.setText("No record found.");
        this.lblMessage.setIcon(null);
        this.rows.clear();
        this.tableDataChange();
    }

    private void tableDataChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.model.fireTableDataChanged();
            this.table.packAll();
            this.table.addNotify();
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PMEX_TradedOrder.this.model.fireTableDataChanged();
                    PMEX_TradedOrder.this.table.packAll();
                    PMEX_TradedOrder.this.table.addNotify();
                    PMEX_TradedOrder.this.table.repaint();
                }
            });
        }
    }

    private void deleteSummaryRows() {
        Vector<TradedOrderBean> rowsTemp = new Vector<TradedOrderBean>(this.rows.size());
        for (TradedOrderBean b : this.rows) {
            if (b.getAccount().equalsIgnoreCase("Total (Contract)") || b.getAccount().equalsIgnoreCase("Total (Account)") || b.getAccount().equalsIgnoreCase("Total (Trader)")) continue;
            rowsTemp.add(b);
        }
        this.rows.clear();
        this.rows.addAll(rowsTemp);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.table = new NxGTable();
        this.cbContract = new JComboBox();
        this.lblPrefix = new JLabel();
        this.reportControl1 = new ReportControl();
        this.cbTrader = new JComboBox();
        this.cbAccountNo = new JComboBox();
        this.lblTrader = new JLabel();
        this.lblSell = new JLabel();
        this.lblBuy = new JLabel();
        this.txtBuySum = new JTextField();
        this.btnReload = new JButton();
        this.cbBuy = new JCheckBox();
        this.cbSell = new JCheckBox();
        this.txtSellSum = new JTextField();
        this.btnRestore = new JButton();
        this.lblMarket = new JLabel();
        this.lblMessage = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.table.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.table.setAutoResizeMode(0);
        this.jScrollPane1.setViewportView((Component)this.table);
        this.lblPrefix.setHorizontalAlignment(4);
        this.lblPrefix.setText("Account");
        this.lblTrader.setText("User");
        this.lblSell.setText("Sold");
        this.lblBuy.setText("Bought");
        this.txtBuySum.setEditable(false);
        this.txtBuySum.setHorizontalAlignment(4);
        this.txtBuySum.setText(" ");
        this.txtBuySum.setEnabled(false);
        this.btnReload.setIcon(new ImageIcon(this.getClass().getResource("/Images/refresh.png")));
        this.btnReload.setText("Refresh");
        this.btnReload.setToolTipText("Reload from server");
        this.btnReload.setName("PMEX_TradedOrder -> btnReload");
        this.cbBuy.setText("Buy");
        this.cbBuy.setMaximumSize(new Dimension(43, 20));
        this.cbBuy.setMinimumSize(new Dimension(43, 20));
        this.cbBuy.setPreferredSize(new Dimension(43, 20));
        this.cbSell.setText("Sell");
        this.txtSellSum.setEditable(false);
        this.txtSellSum.setHorizontalAlignment(4);
        this.txtSellSum.setText(" ");
        this.txtSellSum.setEnabled(false);
        this.btnRestore.setIcon(new ImageIcon(this.getClass().getResource("/Images/reset.png")));
        this.btnRestore.setText("Reset");
        this.btnRestore.setToolTipText("Reset filters");
        this.btnRestore.setName("PMEX_TradedOrder -> btnRestore");
        this.lblMarket.setText("Contract");
        this.lblMessage.setText("jLabel1");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblMarket).addGap(8, 8, 8).addComponent(this.cbContract, -2, 230, -2).addGap(5, 5, 5).addComponent(this.cbSell, -2, 43, -2).addGap(0, 0, 0).addComponent(this.lblSell, -2, 40, -2).addGap(7, 7, 7).addComponent(this.txtSellSum, -2, 90, -2).addGap(5, 5, 5).addComponent(this.btnReload, -2, 150, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 27, Short.MAX_VALUE).addComponent(this.reportControl1, -2, -1, -2)).addComponent(this.jScrollPane1)).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.lblTrader, -2, 42, -2).addGap(8, 8, 8).addComponent(this.cbTrader, -2, 80, -2).addGap(10, 10, 10).addComponent(this.lblPrefix, -2, 56, -2).addGap(4, 4, 4).addComponent(this.cbAccountNo, -2, 80, -2).addGap(5, 5, 5).addComponent(this.cbBuy, -2, -1, -2).addGap(3, 3, 3).addComponent(this.lblBuy, -2, 40, -2).addGap(4, 4, 4).addComponent(this.txtBuySum, -2, 90, -2).addGap(5, 5, 5).addComponent(this.btnRestore, -2, 150, -2)).addGroup(layout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.lblMessage, -2, 721, -2))).addGap(0, 0, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.lblTrader, -2, 20, -2)).addGroup(layout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.cbTrader, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.lblPrefix, -2, 20, -2)).addGroup(layout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.cbAccountNo, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.cbBuy, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.lblBuy, -2, 20, -2)).addGroup(layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.txtBuySum, -2, -1, -2)).addComponent(this.btnRestore, -2, 23, -2)).addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblMarket, -2, 20, -2).addComponent(this.btnReload, -2, 23, -2).addComponent(this.reportControl1, -2, -1, -2).addGroup(layout.createSequentialGroup().addGap(1, 1, 1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbContract, -2, -1, -2).addComponent(this.cbSell, -2, 20, -2).addComponent(this.lblSell, -2, 20, -2).addComponent(this.txtSellSum, -2, -1, -2)))).addGap(4, 4, 4).addComponent(this.jScrollPane1, -1, 201, Short.MAX_VALUE).addGap(6, 6, 6).addComponent(this.jSeparator1, -2, -1, -2).addGap(3, 3, 3).addComponent(this.lblMessage, -2, 20, -2)));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.btnReload) {
            this.GetLog();
        } else if (evt.getSource() == this.btnRestore) {
            this.deleteSummaryRows();
            this.tableDataChange();
        } else if (evt.getSource() == this.cbAccountNo) {
            this.rowFilter();
        } else if (evt.getSource() == this.cbTrader) {
            this.rowFilter();
        } else if (evt.getSource() == this.cbContract && (evt.getModifiers() == 16 || evt.getActionCommand().equalsIgnoreCase("comboBoxEdited"))) {
            this.rowFilter();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.cbBuy || source == this.cbSell) {
            this.rowFilter();
        }
    }

    public void addContract() {
        if (this.autoCom != null && this.autoCom.isInstalled()) {
            this.autoCom.uninstall();
        }
        ArrayList v = new ArrayList(LogsPMEX.PMEX_CONTRACT_ALL.keySet());
        Collections.sort(v);
        v.add(0, "ALL");
        this.autoCom = AutoCompleteSupport.install((JComboBox)this.cbContract, (EventList)GlazedLists.eventListOf((Object[])v.toArray()));
        this.autoCom.setStrict(false);
        this.cbContract.setSelectedItem("ALL");
        this.editorContract = (JTextComponent)this.cbContract.getEditor().getEditorComponent();
        this.editorContract.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PMEX_TradedOrder.this.rowFilter();
            }
        });
    }

    @Override
    public void ReportControl_Print(ReportControlEvent e) {
        Report_PMEX_TradedOrder Report = new Report_PMEX_TradedOrder(this.JRXMLFileName, this.getTableRows());
        this.SetParamter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        Report.PrintReport();
    }

    @Override
    public void ReportControl_Save(ReportControlEvent e) {
        String FileName;
        boolean result;
        Report_PMEX_TradedOrder Report = new Report_PMEX_TradedOrder(this.JRXMLFileName, this.getTableRows());
        this.SetParamter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File("Traded Orders-" + MyTime.getInstance().getDate()));
        fc.addAllJasperChoosableFileFilter();
        fc.setAcceptAllFileFilterUsed(false);
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null && !(result = Report.Export(FileName = fc.getSelectedFile().getAbsolutePath() + "." + fc.getExtenstion()))) {
            JOptionPane.showMessageDialog(null, "Error in saving file.");
        }
    }

    @Override
    public void ReportControl_Pdf(ReportControlEvent e) {
        Report_PMEX_TradedOrder Report = new Report_PMEX_TradedOrder(this.JRXMLFileName, this.getTableRows());
        this.SetParamter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File("Traded Orders-" + MyTime.getInstance().getDate()));
        fc.addPdfFileFilter();
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null) {
            String FileName = fc.getSelectedFile().getAbsolutePath().replaceAll("\"", "") + "." + fc.getExtenstion();
            boolean result = Report.ExportToPdf(FileName);
            if (result) {
                int Option = JOptionPane.showConfirmDialog(null, "Traded Orders report created. Do you want to open it?", "PDF", 0);
                if (Option == 0) {
                    try {
                        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + FileName);
                    }
                    catch (IOException iOException) {}
                }
            } else {
                JOptionPane.showMessageDialog(null, "Error in creating pdf file.");
            }
        }
    }

    @Override
    public void ReportControl_View(ReportControlEvent e) {
        Report_PMEX_TradedOrder Report = new Report_PMEX_TradedOrder(this.JRXMLFileName, this.getTableRows());
        this.SetParamter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        Report.generateReport();
    }

    @Override
    public void ReportControl_CustomExport(ReportControlEvent e) {
    }

    public void SetParamter(Jasper_Report Report) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("PrintDate", MyTime.getInstance().getTimeAndDateForReport());
        Report.SetParameter(param);
    }

    private String[][] getTableRows() {
        String[][] obj = new String[this.table.getModel().getRowCount()][this.table.getModel().getColumnCount()];
        try {
            for (int i = 0; i < this.table.getModel().getRowCount(); ++i) {
                for (int j = 0; j < this.table.getModel().getColumnCount(); ++j) {
                    Object value = this.table.getModel().getValueAt(i, j);
                    if (!(value instanceof TradedOrderBean)) continue;
                    if (!((TradedOrderBean)value).isSummaryrow) {
                        obj[i][0] = ((TradedOrderBean)value).getTrader();
                        obj[i][1] = ((TradedOrderBean)value).getAccount();
                        obj[i][2] = ((TradedOrderBean)value).getContract();
                        obj[i][3] = ((TradedOrderBean)value).getOrderID();
                        obj[i][4] = ((TradedOrderBean)value).getTicketID();
                        obj[i][5] = ((TradedOrderBean)value).getClientOrderID();
                        obj[i][6] = String.valueOf(((TradedOrderBean)value).getPrice());
                        obj[i][7] = String.valueOf(((TradedOrderBean)value).getAveragePrice());
                        obj[i][8] = String.valueOf(((TradedOrderBean)value).getFillVolume());
                        obj[i][9] = String.valueOf(((TradedOrderBean)value).getTotalFill());
                        obj[i][10] = String.valueOf(((TradedOrderBean)value).getRemainingVolume());
                        obj[i][11] = ((TradedOrderBean)value).getTransactionType();
                        obj[i][13] = String.valueOf(((TradedOrderBean)value).getDistance());
                        obj[i][14] = String.valueOf(((TradedOrderBean)value).getTrailingStep());
                        obj[i][12] = ((TradedOrderBean)value).getTransactionTime();
                        continue;
                    }
                    if (((TradedOrderBean)value).isSummaryrow) {
                        if (((TradedOrderBean)value).summaryid == 0) {
                            obj[i][0] = "";
                            obj[i][1] = "Total (Contract)";
                            obj[i][2] = "";
                            obj[i][3] = String.valueOf(((TradedOrderBean)value).getAverageSell());
                            obj[i][4] = String.valueOf(((TradedOrderBean)value).getTotalFillSell());
                            obj[i][5] = String.valueOf(((TradedOrderBean)value).getTotolAmountSell());
                            obj[i][6] = "";
                            obj[i][7] = String.valueOf(((TradedOrderBean)value).getAverageBuy());
                            obj[i][8] = String.valueOf(((TradedOrderBean)value).getTotalFillBuy());
                            obj[i][9] = String.valueOf(((TradedOrderBean)value).getTotolAmountBuy());
                            obj[i][10] = "";
                            obj[i][11] = "";
                            obj[i][13] = "";
                            obj[i][14] = "";
                            obj[i][12] = "";
                            continue;
                        }
                        if (((TradedOrderBean)value).summaryid == 1) {
                            obj[i][0] = "";
                            obj[i][1] = "Total (Account)";
                            obj[i][2] = "";
                            obj[i][3] = String.valueOf(((TradedOrderBean)value).getAverageSell());
                            obj[i][4] = String.valueOf(((TradedOrderBean)value).getTotalFillSell());
                            obj[i][5] = String.valueOf(((TradedOrderBean)value).getTotolAmountSell());
                            obj[i][6] = "";
                            obj[i][7] = String.valueOf(((TradedOrderBean)value).getAverageBuy());
                            obj[i][8] = String.valueOf(((TradedOrderBean)value).getTotalFillBuy());
                            obj[i][9] = String.valueOf(((TradedOrderBean)value).getTotolAmountBuy());
                            obj[i][10] = "";
                            obj[i][11] = "";
                            obj[i][13] = "";
                            obj[i][14] = "";
                            obj[i][12] = "";
                            continue;
                        }
                        if (((TradedOrderBean)value).summaryid != 2) continue;
                        obj[i][0] = "";
                        obj[i][1] = "Total (Trader)";
                        obj[i][2] = "";
                        obj[i][3] = String.valueOf(((TradedOrderBean)value).getAverageSell());
                        obj[i][4] = String.valueOf(((TradedOrderBean)value).getTotalFillSell());
                        obj[i][5] = String.valueOf(((TradedOrderBean)value).getTotolAmountSell());
                        obj[i][6] = "";
                        obj[i][7] = String.valueOf(((TradedOrderBean)value).getAverageBuy());
                        obj[i][8] = String.valueOf(((TradedOrderBean)value).getTotalFillBuy());
                        obj[i][9] = String.valueOf(((TradedOrderBean)value).getTotolAmountBuy());
                        obj[i][10] = "";
                        obj[i][11] = "";
                        obj[i][13] = "";
                        obj[i][14] = "";
                        obj[i][12] = "";
                        continue;
                    }
                    obj[i][j] = value.toString();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }

    private void hideValues() {
        this.lblBuy.setVisible(false);
        this.lblSell.setVisible(false);
        this.txtBuySum.setVisible(false);
        this.txtSellSum.setVisible(false);
    }

    private class ColumnListner
    extends MouseAdapter {
        private final NxGTable table;
        protected int sortCol = 0;
        protected boolean isSortAsc = true;
        private TableColumnModel colModel;

        public ColumnListner(NxGTable table) {
            this.table = table;
            this.colModel = table.getColumnModel();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int columnModelIndex = this.colModel.getColumnIndexAtX(e.getX());
            int modelIndex = this.colModel.getColumn(columnModelIndex).getModelIndex();
            if (modelIndex < 0) {
                return;
            }
            if (this.sortCol == modelIndex) {
                this.isSortAsc = !this.isSortAsc;
            } else {
                this.sortCol = modelIndex;
            }
            this.table.getTableHeader().repaint();
            Collections.sort(PMEX_TradedOrder.this.rows, new TraderOrderComparator(this.sortCol, this.isSortAsc));
            this.table.tableChanged(new TableModelEvent((TableModel)PMEX_TradedOrder.this.model));
            this.table.packAll();
            this.table.repaint();
        }

        private void addSummaryRowsForAccount() {
            Vector rowsTemp = new Vector(PMEX_TradedOrder.this.rows.size());
            rowsTemp.addAll(PMEX_TradedOrder.this.rows);
            PMEX_TradedOrder.this.rows.clear();
            String accoutPrv = ((TradedOrderBean)rowsTemp.get(0)).getAccount();
            String contractPrv = ((TradedOrderBean)rowsTemp.get(0)).getContract();
            long fillVolumeTotalBuyTrader = 0L;
            double totolAmountBuyTrader = 0.0;
            long fillVolumeTotalSellTrader = 0L;
            double totolAmountSellTrader = 0.0;
            long fillVolumeTotalBuyAccount = 0L;
            double totalAmountBuyAccount = 0.0;
            double averageBuyAccount = 0.0;
            long fillVolumeTotalSellAccount = 0L;
            double totalAmountSellAccount = 0.0;
            double averageSellAccount = 0.0;
            long fillVolumeTotalBuyContract = 0L;
            double totolAmountBuyContract = 0.0;
            double averageBuyContract = 0.0;
            long fillVolumeTotalSellContract = 0L;
            double totolAmountSellContract = 0.0;
            double averageSellContract = 0.0;
            for (int i = 0; i < rowsTemp.size(); ++i) {
                TradedOrderBean bAccountSumm;
                TradedOrderBean bContractSumm;
                if (accoutPrv.equalsIgnoreCase(((TradedOrderBean)rowsTemp.get(i)).getAccount())) {
                    if (((TradedOrderBean)rowsTemp.get(i)).getTransactionType().equalsIgnoreCase("Buy")) {
                        fillVolumeTotalBuyAccount += ((TradedOrderBean)rowsTemp.get(i)).getFillVolume();
                        totalAmountBuyAccount += (double)((TradedOrderBean)rowsTemp.get(i)).getFillVolume() * ((TradedOrderBean)rowsTemp.get(i)).getPrice();
                    } else if (((TradedOrderBean)rowsTemp.get(i)).getTransactionType().equalsIgnoreCase("Sell")) {
                        fillVolumeTotalSellAccount += ((TradedOrderBean)rowsTemp.get(i)).getFillVolume();
                        totalAmountSellAccount += (double)((TradedOrderBean)rowsTemp.get(i)).getFillVolume() * ((TradedOrderBean)rowsTemp.get(i)).getPrice();
                    }
                    if (contractPrv.equalsIgnoreCase(((TradedOrderBean)rowsTemp.get(i)).getContract())) {
                        if (((TradedOrderBean)rowsTemp.get(i)).getTransactionType().equalsIgnoreCase("Buy")) {
                            fillVolumeTotalBuyContract += ((TradedOrderBean)rowsTemp.get(i)).getFillVolume();
                            totolAmountBuyContract += (double)((TradedOrderBean)rowsTemp.get(i)).getFillVolume() * ((TradedOrderBean)rowsTemp.get(i)).getPrice();
                        } else if (((TradedOrderBean)rowsTemp.get(i)).getTransactionType().equalsIgnoreCase("Sell")) {
                            fillVolumeTotalSellContract += ((TradedOrderBean)rowsTemp.get(i)).getFillVolume();
                            totolAmountSellContract += (double)((TradedOrderBean)rowsTemp.get(i)).getFillVolume() * ((TradedOrderBean)rowsTemp.get(i)).getPrice();
                        }
                    } else {
                        averageBuyContract = totolAmountBuyContract / (double)fillVolumeTotalBuyContract;
                        averageSellContract = totolAmountSellContract / (double)fillVolumeTotalSellContract;
                        bContractSumm = new TradedOrderBean();
                        bContractSumm.setAccount("Total (Contract)");
                        bContractSumm.setAverageBuy(averageBuyContract);
                        bContractSumm.setTotalFillBuy(fillVolumeTotalBuyContract);
                        bContractSumm.setTotolAmountBuy(totolAmountBuyContract);
                        bContractSumm.setAverageSell(averageSellContract);
                        bContractSumm.setTotalFillSell(fillVolumeTotalSellContract);
                        bContractSumm.setTotolAmountSell(totolAmountSellContract);
                        PMEX_TradedOrder.this.rows.add(bContractSumm);
                        averageBuyContract = 0.0;
                        averageSellContract = 0.0;
                        fillVolumeTotalBuyContract = 0L;
                        totolAmountBuyContract = 0.0;
                        fillVolumeTotalSellContract = 0L;
                        totolAmountSellContract = 0.0;
                        if (i + 1 < rowsTemp.size()) {
                            contractPrv = ((TradedOrderBean)rowsTemp.get(i + 1)).getContract();
                            if (((TradedOrderBean)rowsTemp.get(i + 1)).getTransactionType().equalsIgnoreCase("Buy")) {
                                fillVolumeTotalBuyContract = ((TradedOrderBean)rowsTemp.get(i + 1)).getFillVolume();
                                totolAmountBuyContract = (double)((TradedOrderBean)rowsTemp.get(i + 1)).getFillVolume() * ((TradedOrderBean)rowsTemp.get(i + 1)).getPrice();
                            } else if (((TradedOrderBean)rowsTemp.get(i + 1)).getTransactionType().equalsIgnoreCase("Sell")) {
                                fillVolumeTotalSellContract = ((TradedOrderBean)rowsTemp.get(i + 1)).getFillVolume();
                                totolAmountSellContract = (double)((TradedOrderBean)rowsTemp.get(i + 1)).getFillVolume() * ((TradedOrderBean)rowsTemp.get(i + 1)).getPrice();
                            }
                        }
                    }
                    PMEX_TradedOrder.this.rows.add(rowsTemp.get(i));
                } else {
                    averageBuyContract = totolAmountBuyContract / (double)fillVolumeTotalBuyContract;
                    averageSellContract = totolAmountSellContract / (double)fillVolumeTotalSellContract;
                    bContractSumm = new TradedOrderBean();
                    bContractSumm.setAccount("Total (Contract)");
                    bContractSumm.setAverageBuy(averageBuyContract);
                    bContractSumm.setTotalFillBuy(fillVolumeTotalBuyContract);
                    bContractSumm.setTotolAmountBuy(totolAmountBuyContract);
                    bContractSumm.setAverageSell(averageSellContract);
                    bContractSumm.setTotalFillSell(fillVolumeTotalSellContract);
                    bContractSumm.setTotolAmountSell(totolAmountSellContract);
                    PMEX_TradedOrder.this.rows.add(bContractSumm);
                    fillVolumeTotalBuyContract = 0L;
                    totolAmountBuyContract = 0.0;
                    fillVolumeTotalSellContract = 0L;
                    totolAmountSellContract = 0.0;
                    averageBuyContract = 0.0;
                    averageSellContract = 0.0;
                    if (i + 1 < rowsTemp.size()) {
                        contractPrv = ((TradedOrderBean)rowsTemp.get(i)).getContract();
                        if (((TradedOrderBean)rowsTemp.get(i)).getTransactionType().equalsIgnoreCase("Buy")) {
                            fillVolumeTotalBuyContract = ((TradedOrderBean)rowsTemp.get(i)).getFillVolume();
                            totolAmountBuyContract = (double)((TradedOrderBean)rowsTemp.get(i)).getFillVolume() * ((TradedOrderBean)rowsTemp.get(i)).getPrice();
                        } else if (((TradedOrderBean)rowsTemp.get(i)).getTransactionType().equalsIgnoreCase("Sell")) {
                            fillVolumeTotalSellContract = ((TradedOrderBean)rowsTemp.get(i)).getFillVolume();
                            totolAmountSellContract = (double)((TradedOrderBean)rowsTemp.get(i)).getFillVolume() * ((TradedOrderBean)rowsTemp.get(i)).getPrice();
                        }
                    }
                    averageBuyAccount = totalAmountBuyAccount / (double)fillVolumeTotalBuyAccount;
                    averageSellAccount = totalAmountSellAccount / (double)fillVolumeTotalSellAccount;
                    fillVolumeTotalBuyTrader += fillVolumeTotalBuyAccount;
                    totolAmountBuyTrader += totalAmountBuyAccount;
                    totolAmountSellTrader += totalAmountSellAccount;
                    fillVolumeTotalSellTrader = (long)((double)fillVolumeTotalSellTrader + totalAmountSellAccount);
                    bAccountSumm = new TradedOrderBean();
                    bAccountSumm.setAccount("Total (Account)");
                    bAccountSumm.setAverageBuy(averageBuyAccount);
                    bAccountSumm.setTotalFillBuy(fillVolumeTotalBuyAccount);
                    bAccountSumm.setTotolAmountBuy(totalAmountBuyAccount);
                    bAccountSumm.setAverageSell(averageSellAccount);
                    bAccountSumm.setTotalFillSell(fillVolumeTotalSellAccount);
                    bAccountSumm.setTotolAmountSell(totalAmountSellAccount);
                    PMEX_TradedOrder.this.rows.add(bAccountSumm);
                    fillVolumeTotalBuyAccount = 0L;
                    totalAmountBuyAccount = 0.0;
                    averageBuyAccount = 0.0;
                    fillVolumeTotalSellAccount = 0L;
                    totalAmountSellAccount = 0.0;
                    averageSellAccount = 0.0;
                    if (i < rowsTemp.size()) {
                        accoutPrv = ((TradedOrderBean)rowsTemp.get(i)).getAccount();
                        if (((TradedOrderBean)rowsTemp.get(i)).getTransactionType().equalsIgnoreCase("Buy")) {
                            fillVolumeTotalBuyAccount = ((TradedOrderBean)rowsTemp.get(i)).getFillVolume();
                            totalAmountBuyAccount = (double)((TradedOrderBean)rowsTemp.get(i)).getFillVolume() * ((TradedOrderBean)rowsTemp.get(i)).getPrice();
                        } else if (((TradedOrderBean)rowsTemp.get(i)).getTransactionType().equalsIgnoreCase("Sell")) {
                            fillVolumeTotalSellAccount = ((TradedOrderBean)rowsTemp.get(i)).getFillVolume();
                            totalAmountSellAccount = (double)((TradedOrderBean)rowsTemp.get(i)).getFillVolume() * ((TradedOrderBean)rowsTemp.get(i)).getPrice();
                        }
                    }
                    PMEX_TradedOrder.this.rows.add(rowsTemp.get(i));
                }
                if (i != rowsTemp.size() - 1) continue;
                averageBuyContract = totolAmountBuyContract / (double)fillVolumeTotalBuyContract;
                averageSellContract = totolAmountSellContract / (double)fillVolumeTotalSellContract;
                bContractSumm = new TradedOrderBean();
                bContractSumm.setAccount("Total (Contract)");
                bContractSumm.setAverageBuy(averageBuyContract);
                bContractSumm.setTotalFillBuy(fillVolumeTotalBuyContract);
                bContractSumm.setTotolAmountBuy(totolAmountBuyContract);
                bContractSumm.setAverageSell(averageSellContract);
                bContractSumm.setTotalFillSell(fillVolumeTotalSellContract);
                bContractSumm.setTotolAmountSell(totolAmountSellContract);
                PMEX_TradedOrder.this.rows.add(bContractSumm);
                averageBuyAccount = totalAmountBuyAccount / (double)fillVolumeTotalBuyAccount;
                averageSellAccount = totalAmountSellAccount / (double)fillVolumeTotalSellAccount;
                fillVolumeTotalBuyTrader += fillVolumeTotalBuyAccount;
                totolAmountBuyTrader += totalAmountBuyAccount;
                totolAmountSellTrader += totalAmountSellAccount;
                fillVolumeTotalSellTrader += fillVolumeTotalSellAccount;
                bAccountSumm = new TradedOrderBean();
                bAccountSumm.setAccount("Total (Account)");
                bAccountSumm.setAverageBuy(averageBuyAccount);
                bAccountSumm.setTotalFillBuy(fillVolumeTotalBuyAccount);
                bAccountSumm.setTotolAmountBuy(totalAmountBuyAccount);
                bAccountSumm.setAverageSell(averageSellAccount);
                bAccountSumm.setTotalFillSell(fillVolumeTotalSellAccount);
                bAccountSumm.setTotolAmountSell(totalAmountSellAccount);
                PMEX_TradedOrder.this.rows.add(bAccountSumm);
                TradedOrderBean bTraderSumm = new TradedOrderBean();
                bTraderSumm.setAccount("Total (Trader)");
                bTraderSumm.setTotalFillBuy(fillVolumeTotalBuyTrader);
                bTraderSumm.setTotolAmountBuy(totolAmountBuyTrader);
                bTraderSumm.setTotalFillSell(fillVolumeTotalSellTrader);
                bTraderSumm.setTotolAmountSell(totolAmountSellTrader);
                PMEX_TradedOrder.this.rows.add(bTraderSumm);
            }
        }

        private void addSummaryRowsForContract() {
            Vector rowsTemp = new Vector(PMEX_TradedOrder.this.rows.size());
            rowsTemp.addAll(PMEX_TradedOrder.this.rows);
            PMEX_TradedOrder.this.rows.clear();
            String contractPrv = ((TradedOrderBean)rowsTemp.get(0)).getContract();
            long fillVolumeTotalBuyContract = 0L;
            double totolAmountBuyContract = 0.0;
            long fillVolumeTotalSellContract = 0L;
            double totolAmountSellContract = 0.0;
            double averageBuyContract = 0.0;
            double averageSellContract = 0.0;
            long fillVolumeTotalBuyContractAll = 0L;
            double totolAmountBuyContractAll = 0.0;
            long fillVolumeTotalSellContractAll = 0L;
            double totolAmountSellContractAll = 0.0;
            for (int i = 0; i < rowsTemp.size(); ++i) {
                TradedOrderBean bContractSumm;
                TradedOrderBean tradedOrderBean = (TradedOrderBean)rowsTemp.elementAt(i);
                if (contractPrv.equalsIgnoreCase(tradedOrderBean.getContract())) {
                    PMEX_TradedOrder.this.rows.add(tradedOrderBean);
                    if (tradedOrderBean.getTransactionType().equalsIgnoreCase("Buy")) {
                        fillVolumeTotalBuyContract += tradedOrderBean.getFillVolume();
                        totolAmountBuyContract += (double)tradedOrderBean.getFillVolume() * tradedOrderBean.getPrice();
                    } else if (((TradedOrderBean)rowsTemp.get(i)).getTransactionType().equalsIgnoreCase("Sell")) {
                        fillVolumeTotalSellContract += tradedOrderBean.getFillVolume();
                        totolAmountSellContract += (double)tradedOrderBean.getFillVolume() * tradedOrderBean.getPrice();
                    }
                } else {
                    averageBuyContract = totolAmountBuyContract / (double)fillVolumeTotalBuyContract;
                    averageSellContract = totolAmountSellContract / (double)fillVolumeTotalSellContract;
                    fillVolumeTotalBuyContractAll += fillVolumeTotalBuyContract;
                    fillVolumeTotalSellContractAll += fillVolumeTotalSellContract;
                    totolAmountBuyContractAll += totolAmountBuyContract;
                    totolAmountSellContractAll += totolAmountSellContract;
                    bContractSumm = new TradedOrderBean();
                    bContractSumm.setAccount("Total (Contract)");
                    bContractSumm.setAverageBuy(averageBuyContract);
                    bContractSumm.setTotalFillBuy(fillVolumeTotalBuyContract);
                    bContractSumm.setTotolAmountBuy(totolAmountBuyContract);
                    bContractSumm.setAverageSell(averageSellContract);
                    bContractSumm.setTotalFillSell(fillVolumeTotalSellContract);
                    bContractSumm.setTotolAmountSell(totolAmountSellContract);
                    PMEX_TradedOrder.this.rows.add(bContractSumm);
                    fillVolumeTotalBuyContract = 0L;
                    totolAmountBuyContract = 0.0;
                    fillVolumeTotalSellContract = 0L;
                    totolAmountSellContract = 0.0;
                    averageBuyContract = 0.0;
                    averageSellContract = 0.0;
                    PMEX_TradedOrder.this.rows.add(tradedOrderBean);
                    if (i < rowsTemp.size()) {
                        contractPrv = ((TradedOrderBean)rowsTemp.get(i)).getContract();
                        if (((TradedOrderBean)rowsTemp.get(i)).getTransactionType().equalsIgnoreCase("Buy")) {
                            fillVolumeTotalBuyContract = ((TradedOrderBean)rowsTemp.get(i)).getFillVolume();
                            totolAmountBuyContract = (double)((TradedOrderBean)rowsTemp.get(i)).getFillVolume() * ((TradedOrderBean)rowsTemp.get(i)).getPrice();
                        } else if (((TradedOrderBean)rowsTemp.get(i)).getTransactionType().equalsIgnoreCase("Sell")) {
                            fillVolumeTotalSellContract = ((TradedOrderBean)rowsTemp.get(i)).getFillVolume();
                            totolAmountSellContract = (double)((TradedOrderBean)rowsTemp.get(i)).getFillVolume() * ((TradedOrderBean)rowsTemp.get(i)).getPrice();
                        }
                    }
                }
                if (i != rowsTemp.size() - 1) continue;
                averageBuyContract = totolAmountBuyContract / (double)fillVolumeTotalBuyContract;
                averageSellContract = totolAmountSellContract / (double)fillVolumeTotalSellContract;
                fillVolumeTotalBuyContractAll += fillVolumeTotalBuyContract;
                fillVolumeTotalSellContractAll += fillVolumeTotalSellContract;
                totolAmountBuyContractAll += totolAmountBuyContract;
                totolAmountSellContractAll += totolAmountSellContract;
                bContractSumm = new TradedOrderBean();
                bContractSumm.setAccount("Total (Contract)");
                bContractSumm.setAverageBuy(averageBuyContract);
                bContractSumm.setTotalFillBuy(fillVolumeTotalBuyContract);
                bContractSumm.setTotolAmountBuy(totolAmountBuyContract);
                bContractSumm.setAverageSell(averageSellContract);
                bContractSumm.setTotalFillSell(fillVolumeTotalSellContract);
                bContractSumm.setTotolAmountSell(totolAmountSellContract);
                PMEX_TradedOrder.this.rows.add(bContractSumm);
                TradedOrderBean bContractAllSumm = new TradedOrderBean();
                bContractAllSumm.setAccount("Total (Trader)");
                bContractAllSumm.setTotalFillBuy(fillVolumeTotalBuyContractAll);
                bContractAllSumm.setTotolAmountBuy(totolAmountBuyContractAll);
                bContractAllSumm.setTotalFillSell(fillVolumeTotalSellContractAll);
                bContractAllSumm.setTotolAmountSell(totolAmountSellContractAll);
                PMEX_TradedOrder.this.rows.add(bContractAllSumm);
            }
        }
    }

    private class TraderOrderComparator
    implements Comparator<TradedOrderBean> {
        int colIndex = 0;
        boolean isAsc = true;

        public TraderOrderComparator(int colIndex, boolean isAsc) {
            this.colIndex = colIndex;
            this.isAsc = isAsc;
        }

        @Override
        public int compare(TradedOrderBean b1, TradedOrderBean b2) {
            int result = 0;
            switch (this.colIndex) {
                case 0: {
                    result = b1.getTrader().compareTo(b2.getTrader());
                    break;
                }
                case 1: {
                    result = b1.getAccount().compareTo(b2.getAccount());
                    break;
                }
                case 2: {
                    result = b1.getContract().compareTo(b2.getContract());
                    break;
                }
                case 3: {
                    result = b1.getOrderID().compareTo(b2.getOrderID());
                    break;
                }
                case 4: {
                    result = b1.getTicketID().compareTo(b2.getTicketID());
                    break;
                }
                case 5: {
                    result = b1.getClientOrderID().compareTo(b2.getClientOrderID());
                    break;
                }
                case 7: {
                    result = b1.getAveragePrice() < b2.getAveragePrice() ? -1 : (b1.getAveragePrice() > b2.getAveragePrice() ? 1 : 0);
                    break;
                }
                case 6: {
                    result = b1.getPrice() < b2.getPrice() ? -1 : (b1.getPrice() > b2.getPrice() ? 1 : 0);
                    break;
                }
                case 8: {
                    result = b1.getFillVolume() < b2.getFillVolume() ? -1 : (b1.getFillVolume() > b2.getFillVolume() ? 1 : 0);
                    break;
                }
                case 9: {
                    result = b1.getTotalFill() < b2.getTotalFill() ? -1 : (b1.getTotalFill() > b2.getTotalFill() ? 1 : 0);
                    break;
                }
                case 10: {
                    result = b1.getRemainingVolume() < b2.getRemainingVolume() ? -1 : (b1.getRemainingVolume() > b2.getRemainingVolume() ? 1 : 0);
                    break;
                }
                case 11: {
                    result = b1.getTransactionType().compareTo(b2.getTransactionType());
                    break;
                }
                case 12: {
                    result = b1.getTransactionTimeToDate().compareTo(b2.getTransactionTimeToDate());
                    break;
                }
                case 13: {
                    result = b1.getDistance() < b2.getDistance() ? -1 : (b1.getDistance() > b2.getDistance() ? 1 : 0);
                    break;
                }
                case 14: {
                    int n = b1.getTrailingStep() < b2.getTrailingStep() ? -1 : (result = b1.getTrailingStep() > b2.getTrailingStep() ? 1 : 0);
                }
            }
            if (!this.isAsc) {
                result = -result;
            }
            return result;
        }
    }
}

