/*
 * Decompiled with CFR 0.152.
 */
package windows.pmex.logs;

import Beans.OrderBean;
import Control.JasperFileChooser;
import Control.ReportControl;
import Control.ReportControlEvent;
import Control.ReportControlListener;
import CustomComponent.ForgetMouseListner;
import CustomComponent.MyOptionPane;
import CustomComponent.MyTime;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import Orders.ExecuteMarketDialog;
import RendersNModels.ComboBoxToolTipRender;
import Utilities.LoadLogs;
import Utilities.ThreadWithName;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.bean.AccountBean;
import common.gui.component.NxGTable;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.MyColors;
import common.gui.util.Title;
import common.gui.util.Util;
import common.interfaces.AddContract;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.AbstractDocument;
import javax.swing.text.JTextComponent;
import languages.LanguageCentre;
import languages.LanguageConstant;
import pmex.gui.bean.PMEXOrderBean;
import pmex.gui.bean.WorkingOrderBean;
import pmex.gui.model.WorkingOrderModel;
import pmex.gui.render.WorkingOrderRender;
import pmex.gui.util.LogsPMEX;
import pmex.gui.util.UtilPMEX;
import reports.Jasper_Report;
import reports.Report_PMEX_WorkingOrder;
import windows.pmex.buyingpower.DocumentSizeAndUppercaseFilter;

public class PMEX_WorkingOrder
extends JPanel
implements ActionListener,
ItemListener,
ReportControlListener,
AddContract {
    private Mediator mediator = Mediator.getInstance();
    private Vector<WorkingOrderBean> rows = new Vector();
    private Vector<WorkingOrderBean> rowsAll = new Vector();
    private Vector<String> columns = new Vector();
    private WorkingOrderModel model = null;
    private WorkingOrderRender render = null;
    private AutoCompleteSupport autoCom;
    private AutoCompleteSupport autoComplete;
    private JTextComponent editorContract;
    private JTextComponent editorTrader;
    private ImageIcon loaderIcon = new ImageIcon(this.getClass().getResource(AppConfig.loaderIconPath));
    private Point lastPoint;
    private final List<WorkingOrderBean> workingOrderForCancel = Collections.synchronizedList(new ArrayList());
    private final ArrayList<OrderBean> selectdOrderForCancel = new ArrayList();
    private LanguageCentre languageCentre = new LanguageCentre();
    private JButton btnCancel;
    private JButton btnExecuteOrderOnMarket;
    private JButton btnReload;
    private JButton btnReset;
    private JComboBox cbAccountNo;
    private JCheckBox cbBuy;
    private JComboBox cbContract;
    private JCheckBox cbSelectAll;
    private JCheckBox cbSell;
    private JComboBox cbTrader;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JLabel lblForgetPinCode;
    private JLabel lblMessage;
    private JLabel lblPinCode;
    private JLabel lblPrefix;
    private JMenuItem menuChangeOrder;
    private JPopupMenu popupMenu;
    private ReportControl reportControl1;
    private NxGTable table;
    private JPasswordField txtPinCode;
    public String JRXMLFileName = "PMEX_WorkingOrders.jrxml";

    public PMEX_WorkingOrder() {
        try {
            this.initComponents();
            this.setThis();
            this.lblForgetPinCode.setForeground(MyColors.ForgotPincodeFG);
            this.lblForgetPinCode.setText("<html>Forgot PIN?</html>");
            ForgetMouseListner forgetMouseListner = new ForgetMouseListner(this.lblForgetPinCode);
            this.lblForgetPinCode.addMouseListener(forgetMouseListner);
            this.setTreader();
            this.setAccount();
            this.addContract();
            this.cbContract.setMaximumRowCount(30);
            LogsPMEX.CONTRACT_HOLDER.add(this);
            this.reportControl1.setVisible(true);
            this.cbSell.setForeground(MyColors.SellBG);
            this.cbBuy.setForeground(MyColors.BuyBG);
            this.initTable();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initTable() {
        this.columns.add("User");
        this.columns.add("Account");
        this.columns.add("Contract");
        this.columns.add("Order ID");
        this.columns.add("Client Order ID");
        this.columns.add("Quantity");
        this.columns.add("Limit Price");
        this.columns.add("Trigger Price");
        this.columns.add("Order Type");
        this.columns.add("Transaction Type");
        this.columns.add("GTC");
        this.columns.add("Distance");
        this.columns.add("Trailing Step");
        this.model = new WorkingOrderModel(this.rows, this.columns);
        this.table.setModel((TableModel)this.model);
        this.render = new WorkingOrderRender(this.rows);
        for (int k = 0; k < this.model.getColumnCount(); ++k) {
            this.table.getColumn((Object)this.model.getColumnName(k)).setCellRenderer((TableCellRenderer)this.render);
        }
        FontMetrics metrics = this.getFontMetrics(LogCommon.LogFont);
        int fontHeight = metrics.getHeight();
        this.table.setRowHeight(fontHeight);
        this.table.setRowSorter(null);
        this.table.repaint();
        this.setSorter();
        this.reportControl1.addListener(this);
    }

    private void setThis() {
        this.mediator.setPMEX_WorkingOrder(this);
        this.btnExecuteOrderOnMarket.addActionListener(this);
        this.btnReload.addActionListener(this);
        this.btnReset.addActionListener(this);
        this.btnCancel.addActionListener(this);
        this.cbContract.addActionListener(this);
        this.cbBuy.addItemListener(this);
        this.cbSell.addItemListener(this);
        this.cbSelectAll.addItemListener(this);
        this.menuChangeOrder.addActionListener(this);
    }

    private void setTreader() {
        Vector<String> allTrader = new Vector<String>();
        allTrader.addElement("ALL");
        allTrader.addElement(LogCommon.UserID);
        Collections.sort(allTrader);
        this.cbTrader.setModel(new DefaultComboBoxModel(allTrader));
        AutoCompleteSupport support = AutoCompleteSupport.install((JComboBox)this.cbTrader, (EventList)GlazedLists.eventListOf((Object[])allTrader.toArray()));
        this.cbTrader.setSelectedItem("ALL");
        this.editorTrader = (JTextComponent)this.cbTrader.getEditor().getEditorComponent();
        this.editorTrader.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                PMEX_WorkingOrder.this.rowFilter();
            }
        });
    }

    private void setAccount() {
        if (LogsPMEX.accountPrefix.length() > 0) {
            this.lblPrefix.setText(LogsPMEX.accountPrefix);
        } else {
            this.lblPrefix.setText("Account");
        }
        Iterator en = LogsPMEX.ALL_ACCOUNTS.keySet().iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (en.hasNext()) {
            String key = en.next().toString();
            AccountBean ac = (AccountBean)LogsPMEX.ALL_ACCOUNTS.get(key);
            if (ac.getAccountNo().indexOf(LogsPMEX.accountPrefix) == 0) {
                list.add(ac.getAccountNo().replaceFirst(LogsPMEX.accountPrefix, ""));
                continue;
            }
            list.add(ac.getAccountNo());
        }
        Collections.sort(list);
        list.add(0, "ALL");
        this.cbAccountNo.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        this.autoComplete = AutoCompleteSupport.install((JComboBox)this.cbAccountNo, (EventList)GlazedLists.eventListOf((Object[])list.toArray()));
        this.cbAccountNo.setRenderer(new ComboBoxToolTipRender(LogsPMEX.ALL_ACCOUNTS, LogsPMEX.accountPrefix));
        this.cbAccountNo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    PMEX_WorkingOrder.this.cbAccountNo.setToolTipText(((AccountBean)LogsPMEX.ALL_ACCOUNTS.get(LogsPMEX.accountPrefix + PMEX_WorkingOrder.this.cbAccountNo.getSelectedItem().toString().trim())).toString());
                }
                catch (Exception ex) {
                    PMEX_WorkingOrder.this.cbAccountNo.setToolTipText(null);
                }
            }
        });
        this.cbAccountNo.setSelectedItem("ALL");
        this.cbAccountNo.setEditable(true);
        this.cbAccountNo.addActionListener(this);
        this.cbAccountNo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
            }
        });
        AbstractDocument d = (AbstractDocument)((JTextField)this.cbAccountNo.getEditor().getEditorComponent()).getDocument();
        d.setDocumentFilter(new DocumentSizeAndUppercaseFilter(4));
    }

    public void setPIN() {
        this.txtPinCode.setText(LogCommon.pinCode);
    }

    private String getSelectedAccount() {
        if (this.cbAccountNo.getSelectedItem() == null) {
            return "";
        }
        if (this.cbAccountNo.getSelectedItem().toString().trim().equalsIgnoreCase("")) {
            return "";
        }
        if (this.cbAccountNo.getSelectedItem().toString().trim().equalsIgnoreCase("ALL")) {
            return "ALL";
        }
        return LogsPMEX.accountPrefix + this.cbAccountNo.getSelectedItem().toString().trim();
    }

    private void GetLog() {
        this.lblMessage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
        this.lblMessage.setIcon(this.loaderIcon);
        LoadLogs loadLogs = new LoadLogs("PMEX_GetWorkingOrder=", true, false);
        new ThreadWithName(loadLogs, "PMEX_GetWorkingOrder").start();
    }

    public void LogRecieved(String Str) {
        this.lblMessage.setIcon(null);
        if (Str.equalsIgnoreCase("No Record found") || Str.equalsIgnoreCase("")) {
            this.lblMessage.setText("No record found.");
        } else if (Str.equalsIgnoreCase("Exception")) {
            this.lblMessage.setText("Error in loading Traded Order Log.");
        } else {
            this.UpdateTable(Str);
        }
    }

    private synchronized void UpdateTable(String Logstr) {
        this.rowsAll.clear();
        this.emptyTable();
        this.lblMessage.setText(" ");
        this.lblMessage.setIcon(null);
        if (Logstr.indexOf(";") < 1) {
            this.lblMessage.setText("No record found.");
            return;
        }
        if (Logstr.indexOf("|") > 0) {
            String[] data = Logstr.split("\\|", -1);
            for (int i = 0; i < data.length; ++i) {
                String string = data[i];
                if (string.trim().equalsIgnoreCase("")) continue;
                WorkingOrderBean b = WorkingOrderBean.parse((String)string);
                this.rowsAll.add(b);
            }
            this.rowFilter();
        }
    }

    private void rowFilter() {
        this.emptyTable();
        String Trader = "";
        String Account = this.getSelectedAccount();
        String Contract = "";
        String Type2 = "";
        int BuyCount = 0;
        int SellCount = 0;
        Trader = this.cbTrader.getSelectedItem() == null ? this.editorTrader.getText() : this.cbTrader.getSelectedItem().toString();
        Contract = this.cbContract.getSelectedItem() == null ? this.editorContract.getText() : this.cbContract.getSelectedItem().toString().trim();
        if (Contract.equalsIgnoreCase("ALL")) {
            Contract = "";
        }
        if (Account.equalsIgnoreCase("ALL")) {
            Account = "";
        }
        if (Trader.equalsIgnoreCase("ALL")) {
            Trader = "";
        }
        if (this.cbSell.isSelected()) {
            Type2 = "SELL";
        }
        if (this.cbBuy.isSelected()) {
            Type2 = "BUY";
        }
        if (this.cbBuy.isSelected() && this.cbSell.isSelected()) {
            Type2 = "";
        }
        for (WorkingOrderBean b : this.rowsAll) {
            if (!b.getTrader().equalsIgnoreCase(Trader) && Trader.length() > 0 || !b.getContract().trim().equalsIgnoreCase(Contract) && Contract.length() > 0 || b.getAccount().trim().indexOf(Account) == -1 && Account.length() > 0 || !b.getTransactionType().equalsIgnoreCase(Type2) && Type2.length() > 0) continue;
            if (b.getTransactionType().equalsIgnoreCase("Buy")) {
                ++BuyCount;
            }
            if (b.getTransactionType().equalsIgnoreCase("Sell")) {
                ++SellCount;
            }
            this.rows.add(b);
        }
        if (this.model.getRowCount() > 1) {
            this.lblMessage.setText(Util.format0digit((String)(this.model.getRowCount() + "".trim().replaceAll("\\,", ""))) + " records found.     Buy (" + Util.format0digit((String)(BuyCount + "")) + ")     Sell (" + Util.format0digit((String)(SellCount + "")) + ")");
        } else {
            this.lblMessage.setText(Util.format0digit((String)(this.model.getRowCount() + "".trim().replaceAll("\\,", ""))) + " record found.     Buy (" + Util.format0digit((String)(BuyCount + "")) + ")     Sell (" + Util.format0digit((String)(SellCount + "")) + ")");
        }
        this.lblMessage.setIcon(null);
        this.tableDataChange();
    }

    public void orderPacketReceived(WorkingOrderBean b) {
        this.rowsAll.add(b);
        this.rowFilter();
    }

    public void orderPacketUpdate(WorkingOrderBean b) {
        int index = -1;
        for (int i = 0; i < this.rowsAll.size(); ++i) {
            if (!this.rowsAll.get(i).getOrderID().equalsIgnoreCase(b.getOrderID())) continue;
            index = i;
            break;
        }
        if (index != -1) {
            this.rowsAll.remove(index);
            this.rowsAll.add(index, b);
            this.rowFilter();
        }
    }

    public WorkingOrderBean getExistingOrderBean(String OrderID) {
        int index = -1;
        for (int i = 0; i < this.rowsAll.size(); ++i) {
            if (!this.rowsAll.get(i).getOrderID().equalsIgnoreCase(OrderID)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return null;
        }
        return this.rowsAll.get(index);
    }

    public void removeOrderRow(String cancelOrTreadeOrderID) {
        boolean bb;
        WorkingOrderBean found = null;
        for (int i = 0; i < this.rowsAll.size(); ++i) {
            WorkingOrderBean workingOrderBean = this.rowsAll.get(i);
            if (!workingOrderBean.getOrderID().equalsIgnoreCase(cancelOrTreadeOrderID)) continue;
            found = workingOrderBean;
            break;
        }
        if (bb = this.rowsAll.remove(found)) {
            this.rowFilter();
        }
    }

    public void emptyTable() {
        this.lblMessage.setText("No record found.");
        this.lblMessage.setIcon(null);
        this.rows.clear();
        this.table.addNotify();
        this.table.repaint();
    }

    private void setSorter() {
        JTableHeader header = this.table.getTableHeader();
        header.addMouseListener(new ColumnListner(this.table));
        header.setReorderingAllowed(false);
    }

    private void setAllRowsSelectedUnselected() {
        for (int i = 0; i < this.rows.size(); ++i) {
            this.rows.elementAt(i).setSelected(this.cbSelectAll.isSelected());
        }
        this.tableDataChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendExecuteOrderonMarketPacket() {
        if (this.txtPinCode.getText().trim().length() <= 0) {
            MyOptionPane.showMessage(MessageType.Warring, "Please enter PIN.", "Error", true);
            this.txtPinCode.requestFocus();
        } else {
            int i = 0;
            for (WorkingOrderBean b : this.rows) {
                if (!b.isSelected()) continue;
                ++i;
                break;
            }
            if (i == 0) {
                MyOptionPane.showMessage(MessageType.Information, "Please select order(s) which you wish to execute on Market Rates.", true);
            } else {
                this.workingOrderForCancel.clear();
                this.selectdOrderForCancel.clear();
                for (WorkingOrderBean b : this.rows) {
                    if (!b.isSelected()) continue;
                    this.workingOrderForCancel.add(b);
                    b.setSelected(false);
                    OrderBean ob = this.getOrderBean(b);
                    this.selectdOrderForCancel.add(ob);
                }
                ExecuteMarketDialog executeMarket = new ExecuteMarketDialog(TradeCast.getInstance().frame, this.selectdOrderForCancel, true);
                int n = executeMarket.Option;
                if (n != 0) {
                    this.workingOrderForCancel.clear();
                    this.selectdOrderForCancel.clear();
                    return;
                }
                if (n == 0) {
                    List<WorkingOrderBean> list = this.workingOrderForCancel;
                    synchronized (list) {
                        for (WorkingOrderBean b : this.workingOrderForCancel) {
                            String orderString = this.getCancelOrderString(b);
                            this.mediator.SendMsgToTradeServer_PMEX_CancelOrder(orderString);
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                }
                this.tableDataChange();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMarketOrder(String cancelOrTreadeOrderID) {
        List<WorkingOrderBean> list = this.workingOrderForCancel;
        synchronized (list) {
            WorkingOrderBean found = null;
            for (int i = 0; i < this.workingOrderForCancel.size(); ++i) {
                WorkingOrderBean workingOrderBean = this.workingOrderForCancel.get(i);
                if (!workingOrderBean.getOrderID().equalsIgnoreCase(cancelOrTreadeOrderID)) continue;
                found = workingOrderBean;
                break;
            }
            if (found != null) {
                PMEXOrderBean bean = this.getPMEXOrderBean(found);
                String orderString = bean.getMarketOrderString();
                this.mediator.SendMsgToTradeServer_PMEX_NewOrder(orderString);
                this.workingOrderForCancel.remove(found);
            }
        }
    }

    private void sendCancelOrderPacket() {
        if (this.txtPinCode.getText().trim().length() <= 0) {
            MyOptionPane.showMessage(MessageType.Warring, "Please enter PIN.", "Error", true);
            this.txtPinCode.requestFocus();
        } else {
            int i = 0;
            for (WorkingOrderBean b : this.rows) {
                if (!b.isSelected()) continue;
                ++i;
            }
            if (i == 0) {
                MyOptionPane.showMessage(MessageType.Information, "Please select any order to cancel.", "Error", true);
            } else {
                int n = JOptionPane.showConfirmDialog(new JFrame(), "Do you want to cancel selected order(s)?", "Cancel Order", 0);
                if (n == 0) {
                    for (WorkingOrderBean b : this.rows) {
                        if (!b.isSelected()) continue;
                        String orderString = this.getCancelOrderString(b);
                        this.mediator.SendMsgToTradeServer_PMEX_CancelOrder(orderString);
                        b.setSelected(false);
                    }
                }
                this.tableDataChange();
            }
        }
    }

    private OrderBean getOrderBean(WorkingOrderBean b) {
        OrderBean ob = new OrderBean();
        ob.setAccount(b.getAccount());
        ob.setScrip(b.getContract());
        ob.setMarket(UtilPMEX.GetMarketFromContract((String)b.getContract()));
        ob.setOrderType(b.getOrderType());
        ob.setOrderTransactionType(b.getTransactionType());
        ob.setVolume(b.getQuantity());
        return ob;
    }

    private PMEXOrderBean getPMEXOrderBean(WorkingOrderBean b) {
        PMEXOrderBean bean = new PMEXOrderBean();
        bean.setContract(b.getContract());
        bean.setMarket(UtilPMEX.GetMarketFromContract((String)b.getContract()));
        bean.setIsGoodTillCancel(b.isGoodTillCancel());
        bean.setAccount(b.getAccount());
        bean.setVolume(b.getQuantity());
        bean.setLimitPrice(b.getLimitPrice());
        bean.setTriggerPrice(b.getTriggerPrice());
        bean.setPIN(this.txtPinCode.getText());
        bean.setUserName(LogCommon.UserID);
        bean.setUserCode(LogCommon.UserCode);
        bean.setIP(LogCommon.localip);
        bean.setOrderNumber(LogsPMEX.orderNumber++ + "");
        bean.setDateTime(Mediator.getDateTime());
        if (b.getTransactionType().equalsIgnoreCase("Buy")) {
            bean.setTransactionType("BUY");
        } else {
            bean.setTransactionType("SEL");
        }
        return bean;
    }

    public String getCancelOrderString(WorkingOrderBean b) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.txtPinCode.getText()).append("$");
        sb.append("CXL").append(";");
        sb.append(b.getOrderID()).append(";");
        sb.append(b.getClientOrderID()).append(";");
        sb.append(LogsPMEX.orderNumber++).append(";");
        sb.append(b.getAccount()).append(";");
        sb.append(LogCommon.UserID).append(";");
        sb.append(LogCommon.UserCode).append(";");
        sb.append(this.mediator.myTime.getTime()).append(";");
        sb.append(LogCommon.localip).append(";");
        return sb.toString();
    }

    public long getContractOrderQuantity(String contract, double price) {
        long qty = 0L;
        for (WorkingOrderBean workingOrderBean : this.rowsAll) {
            if (!workingOrderBean.getContract().equalsIgnoreCase(contract) || workingOrderBean.getLimitPrice() != price) continue;
            qty += workingOrderBean.getQuantity();
        }
        return qty;
    }

    private void deleteSummaryRows() {
        Vector<WorkingOrderBean> rowsTemp = new Vector<WorkingOrderBean>(this.rows.size());
        for (WorkingOrderBean b : this.rows) {
            if (b.getAccount().equalsIgnoreCase("Total (Contract)") || b.getAccount().equalsIgnoreCase("Total (Account)") || b.getAccount().equalsIgnoreCase("Total (Trader)")) continue;
            rowsTemp.add(b);
        }
        this.rows.clear();
        this.rows.addAll(rowsTemp);
    }

    private void tableDataChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.model.fireTableDataChanged();
            this.table.packAll();
            this.table.addNotify();
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PMEX_WorkingOrder.this.model.fireTableDataChanged();
                    PMEX_WorkingOrder.this.table.packAll();
                    PMEX_WorkingOrder.this.table.addNotify();
                    PMEX_WorkingOrder.this.table.repaint();
                }
            });
        }
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.menuChangeOrder = new JMenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.table = new NxGTable();
        this.jLabel2 = new JLabel();
        this.cbBuy = new JCheckBox();
        this.cbSell = new JCheckBox();
        this.cbSelectAll = new JCheckBox();
        this.btnExecuteOrderOnMarket = new JButton();
        this.btnReset = new JButton();
        this.btnCancel = new JButton();
        this.reportControl1 = new ReportControl();
        this.cbTrader = new JComboBox();
        this.cbAccountNo = new JComboBox();
        this.lblForgetPinCode = new JLabel();
        this.cbContract = new JComboBox();
        this.txtPinCode = new JPasswordField();
        this.btnReload = new JButton();
        this.lblPrefix = new JLabel();
        this.lblPinCode = new JLabel();
        this.jLabel3 = new JLabel();
        this.lblMessage = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.menuChangeOrder.setText("Change Order");
        this.popupMenu.add(this.menuChangeOrder);
        this.table.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.table.setAutoResizeMode(0);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                PMEX_WorkingOrder.this.tableMousePressed(evt);
            }
        });
        this.jScrollPane1.setViewportView((Component)this.table);
        this.jLabel2.setText("Contract");
        this.cbBuy.setText("Buy");
        this.cbSell.setText("Sell");
        this.cbSell.setMaximumSize(new Dimension(41, 20));
        this.cbSell.setMinimumSize(new Dimension(41, 20));
        this.cbSell.setPreferredSize(new Dimension(41, 20));
        this.cbSelectAll.setText("Sellect All");
        this.cbSelectAll.setPreferredSize(new Dimension(70, 23));
        this.btnExecuteOrderOnMarket.setIcon(new ImageIcon(this.getClass().getResource("/Images/tick.png")));
        this.btnExecuteOrderOnMarket.setText("Execute selected order(s) on market rates");
        this.btnExecuteOrderOnMarket.setToolTipText("Execute selected order(s) on market rates");
        this.btnExecuteOrderOnMarket.setName("PMEX_WorkingOrder -> btnExecuteOrderOnMarket");
        this.btnReset.setIcon(new ImageIcon(this.getClass().getResource("/Images/reset.png")));
        this.btnReset.setText("Reset");
        this.btnReset.setToolTipText("Reset filters");
        this.btnReset.setName("PMEX_WorkingOrder -> btnReset");
        this.btnCancel.setIcon(new ImageIcon(this.getClass().getResource("/Images/close.png")));
        this.btnCancel.setText("Cancel selected order(s) from market");
        this.btnCancel.setToolTipText("Cancel selected order(s) from market");
        this.btnCancel.setName("PMEX_WorkingOrder -> btnCancel");
        this.cbTrader.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbAccountNo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.lblForgetPinCode.setText("Forgot PIN?");
        this.cbContract.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.txtPinCode.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                PMEX_WorkingOrder.this.txtPinCodeFocusGained(evt);
            }
        });
        this.btnReload.setIcon(new ImageIcon(this.getClass().getResource("/Images/refresh.png")));
        this.btnReload.setText("Refresh");
        this.btnReload.setToolTipText("Reload from server");
        this.btnReload.setName("PMEX_WorkingOrder -> btnReload");
        this.lblPrefix.setHorizontalAlignment(4);
        this.lblPrefix.setText("Account");
        this.lblPinCode.setText("PIN");
        this.jLabel3.setText("User");
        this.lblMessage.setText("jLabel1");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, 40, -2).addGap(10, 10, 10).addComponent(this.cbTrader, -2, 80, -2).addGap(10, 10, 10).addComponent(this.lblPrefix, -2, 57, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbAccountNo, -2, 80, -2).addGap(10, 10, 10).addComponent(this.cbBuy, -2, 70, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnExecuteOrderOnMarket)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblPinCode, -2, 40, -2).addComponent(this.jLabel2, -2, 46, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.cbContract, -2, 230, -2).addGap(10, 10, 10).addComponent(this.cbSell, -2, 70, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnCancel, -2, 256, -2)).addGroup(layout.createSequentialGroup().addComponent(this.txtPinCode, -2, 80, -2).addGap(10, 10, 10).addComponent(this.lblForgetPinCode, -2, 68, -2).addGap(82, 82, 82).addComponent(this.cbSelectAll, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnReset, -2, 85, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnReload, -1, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.reportControl1, -2, -1, -2))).addContainerGap()).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.lblMessage, -1, -1, Short.MAX_VALUE).addGap(49, 49, 49)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, -2, 20, -2).addComponent(this.cbTrader, -2, 20, -2).addComponent(this.lblPrefix, -2, 20, -2).addComponent(this.cbAccountNo, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbBuy).addComponent(this.btnExecuteOrderOnMarket, -2, 23, -2))).addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbContract, -2, 20, -2).addComponent(this.jLabel2, -2, 20, -2)).addComponent(this.cbSell, -2, 20, -2).addComponent(this.btnCancel, -2, 23, -2)).addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblPinCode, -2, 20, -2).addComponent(this.txtPinCode, -2, 20, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbSelectAll, -2, -1, -2).addComponent(this.btnReset, -2, 23, -2)).addComponent(this.btnReload, -2, 23, -2).addComponent(this.reportControl1, -2, 20, -2).addComponent(this.lblForgetPinCode, -2, 20, -2)).addGap(3, 3, 3).addComponent(this.jScrollPane1, -1, 174, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addGap(3, 3, 3).addComponent(this.lblMessage, -2, 20, -2)));
    }

    private void txtPinCodeFocusGained(FocusEvent evt) {
        this.txtPinCode.selectAll();
    }

    private void tableMousePressed(MouseEvent evt) {
        try {
            if (this.rows.size() > 0) {
                if (SwingUtilities.isLeftMouseButton(evt)) {
                    if (evt.getClickCount() == 2) {
                        if (!this.rows.get(this.table.rowAtPoint(evt.getPoint())).isSelected()) {
                            this.rows.get(this.table.rowAtPoint(evt.getPoint())).setSelected(true);
                            this.tableDataChange();
                        }
                        this.sendCancelOrderPacket();
                    } else if (evt.getClickCount() == 1) {
                        this.rows.get(this.table.rowAtPoint(evt.getPoint())).setSelected(!this.rows.get(this.table.rowAtPoint(evt.getPoint())).isSelected());
                        this.tableDataChange();
                    }
                } else if (SwingUtilities.isRightMouseButton(evt)) {
                    this.lastPoint = evt.getPoint();
                    this.popupMenu.show((Component)this.table, evt.getX(), evt.getY());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        int row;
        if (evt.getSource() == this.btnExecuteOrderOnMarket) {
            this.sendExecuteOrderonMarketPacket();
        } else if (evt.getSource() == this.btnReload) {
            this.GetLog();
        } else if (evt.getSource() == this.btnReset) {
            this.deleteSummaryRows();
            this.tableDataChange();
        } else if (evt.getSource() == this.btnCancel) {
            this.sendCancelOrderPacket();
            this.cbSelectAll.setSelected(false);
        } else if (evt.getSource() == this.cbAccountNo) {
            this.rowFilter();
        } else if (evt.getSource() == this.cbTrader) {
            this.rowFilter();
        } else if (evt.getSource() == this.cbContract) {
            if (evt.getModifiers() == 16 || evt.getActionCommand().equalsIgnoreCase("comboBoxEdited")) {
                this.rowFilter();
            }
        } else if (evt.getSource() == this.menuChangeOrder && (row = this.table.rowAtPoint(this.lastPoint)) != -1) {
            WorkingOrderBean b = this.rows.get(row);
            if (b.getTransactionType().equalsIgnoreCase("Buy")) {
                String temp = LogsPMEX.SelectedSymbol;
                LogsPMEX.SelectedSymbol = b.getContract();
                TradeCast.getInstance().ShowDynamicForm(FormName.PMEX_Buy, Title.PMEX_Buy);
                LogsPMEX.SelectedSymbol = temp;
                if (this.mediator.pmex_orderBase != null) {
                    this.mediator.pmex_orderBase.setCancelReplace(b);
                }
            } else if (b.getTransactionType().equalsIgnoreCase("Sell")) {
                String temp = LogsPMEX.SelectedSymbol;
                LogsPMEX.SelectedSymbol = b.getContract();
                TradeCast.getInstance().ShowDynamicForm(FormName.PMEX_Sell, Title.PMEX_Sell);
                LogsPMEX.SelectedSymbol = temp;
                if (this.mediator.pmex_orderBase != null) {
                    this.mediator.pmex_orderBase.setCancelReplace(b);
                }
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.cbBuy || source == this.cbSell) {
            this.rowFilter();
        } else if (source == this.cbSelectAll) {
            this.setAllRowsSelectedUnselected();
        }
    }

    public void addContract() {
        if (this.autoCom != null && this.autoCom.isInstalled()) {
            this.autoCom.uninstall();
        }
        ArrayList v = new ArrayList(LogsPMEX.PMEX_CONTRACT_ALL.keySet());
        Collections.sort(v);
        v.add(0, "ALL");
        this.autoCom = AutoCompleteSupport.install((JComboBox)this.cbContract, (EventList)GlazedLists.eventListOf((Object[])v.toArray()));
        this.autoCom.setStrict(false);
        this.cbContract.setSelectedItem("ALL");
        this.editorContract = (JTextComponent)this.cbContract.getEditor().getEditorComponent();
        this.editorContract.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PMEX_WorkingOrder.this.rowFilter();
            }
        });
    }

    @Override
    public void ReportControl_Print(ReportControlEvent e) {
        Report_PMEX_WorkingOrder Report = new Report_PMEX_WorkingOrder(this.JRXMLFileName, this.getTableRows());
        this.SetParameters((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        Report.PrintReport();
    }

    @Override
    public void ReportControl_Save(ReportControlEvent e) {
        String FileName;
        boolean result;
        Report_PMEX_WorkingOrder Report = new Report_PMEX_WorkingOrder(this.JRXMLFileName, this.getTableRows());
        this.SetParameters((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File("Working Orders-" + MyTime.getInstance().getDate()));
        fc.addAllJasperChoosableFileFilter();
        fc.setAcceptAllFileFilterUsed(false);
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null && !(result = Report.Export(FileName = fc.getSelectedFile().getAbsolutePath() + "." + fc.getExtenstion()))) {
            JOptionPane.showMessageDialog(null, "Error in saving file.");
        }
    }

    @Override
    public void ReportControl_Pdf(ReportControlEvent e) {
        int Option;
        String FileName;
        boolean result;
        Report_PMEX_WorkingOrder Report = new Report_PMEX_WorkingOrder(this.JRXMLFileName, this.getTableRows());
        this.SetParameters((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File("Working Orders-" + MyTime.getInstance().getDate()));
        fc.addPdfFileFilter();
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null && (result = Report.ExportToPdf(FileName = fc.getSelectedFile().getAbsolutePath().replaceAll("\"", "") + "." + fc.getExtenstion())) && (Option = JOptionPane.showConfirmDialog(null, "Working Orders report created. Do you want to open it?", "PDF", 0)) == 0) {
            try {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + FileName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void ReportControl_View(ReportControlEvent e) {
        Report_PMEX_WorkingOrder Report = new Report_PMEX_WorkingOrder(this.JRXMLFileName, this.getTableRows());
        this.SetParameters((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        Report.generateReport();
    }

    @Override
    public void ReportControl_CustomExport(ReportControlEvent e) {
    }

    private String[][] getTableRows() {
        String[][] obj = new String[this.table.getModel().getRowCount()][this.table.getModel().getColumnCount()];
        for (int i = 0; i < this.table.getModel().getRowCount(); ++i) {
            for (int j = 0; j < this.table.getModel().getColumnCount(); ++j) {
                Object value = this.table.getModel().getValueAt(i, j);
                if (value instanceof WorkingOrderBean) {
                    if (!((WorkingOrderBean)value).isSummaryrow) {
                        obj[i][0] = ((WorkingOrderBean)value).getTrader();
                        obj[i][1] = ((WorkingOrderBean)value).getAccount();
                        obj[i][2] = ((WorkingOrderBean)value).getContract();
                        obj[i][3] = ((WorkingOrderBean)value).getOrderID();
                        obj[i][4] = ((WorkingOrderBean)value).getClientOrderID();
                        obj[i][5] = String.valueOf(((WorkingOrderBean)value).getQuantity());
                        obj[i][6] = String.valueOf(((WorkingOrderBean)value).getLimitPrice());
                        obj[i][7] = String.valueOf(((WorkingOrderBean)value).getTriggerPrice());
                        obj[i][8] = String.valueOf(((WorkingOrderBean)value).getOrderType());
                        obj[i][9] = String.valueOf(((WorkingOrderBean)value).getTransactionType());
                        obj[i][10] = String.valueOf(((WorkingOrderBean)value).getIsGoodTillCancel());
                        obj[i][11] = String.valueOf(((WorkingOrderBean)value).getDistance());
                        obj[i][12] = String.valueOf(((WorkingOrderBean)value).getTrailingStep());
                        continue;
                    }
                    if (!((WorkingOrderBean)value).isSummaryrow) continue;
                    if (((WorkingOrderBean)value).summaryid == 0) {
                        obj[i][0] = "";
                        obj[i][1] = "Total (Contract)";
                        obj[i][2] = String.valueOf(((WorkingOrderBean)value).getAverageSell());
                        obj[i][3] = String.valueOf(((WorkingOrderBean)value).getTotalFillSell());
                        obj[i][4] = String.valueOf(((WorkingOrderBean)value).getTotolAmountSell());
                        obj[i][5] = "";
                        obj[i][6] = String.valueOf(((WorkingOrderBean)value).getAverageBuy());
                        obj[i][7] = String.valueOf(((WorkingOrderBean)value).getTotalFillBuy());
                        obj[i][8] = String.valueOf(((WorkingOrderBean)value).getTotolAmountBuy());
                        obj[i][9] = "";
                        obj[i][10] = "";
                        obj[i][11] = "";
                        obj[i][12] = "";
                        continue;
                    }
                    if (((WorkingOrderBean)value).summaryid == 1) {
                        obj[i][0] = "";
                        obj[i][1] = "Total (Account)";
                        obj[i][2] = String.valueOf(((WorkingOrderBean)value).getAverageSell());
                        obj[i][3] = String.valueOf(((WorkingOrderBean)value).getTotalFillSell());
                        obj[i][4] = String.valueOf(((WorkingOrderBean)value).getTotolAmountSell());
                        obj[i][5] = "";
                        obj[i][6] = String.valueOf(((WorkingOrderBean)value).getAverageBuy());
                        obj[i][7] = String.valueOf(((WorkingOrderBean)value).getTotalFillBuy());
                        obj[i][8] = String.valueOf(((WorkingOrderBean)value).getTotolAmountBuy());
                        obj[i][9] = "";
                        obj[i][10] = "";
                        obj[i][11] = "";
                        obj[i][12] = "";
                        continue;
                    }
                    if (((WorkingOrderBean)value).summaryid != 2) continue;
                    obj[i][0] = "";
                    obj[i][1] = "Total (Trader)";
                    obj[i][2] = String.valueOf(((WorkingOrderBean)value).getAverageSell());
                    obj[i][3] = String.valueOf(((WorkingOrderBean)value).getTotalFillSell());
                    obj[i][4] = String.valueOf(((WorkingOrderBean)value).getTotolAmountSell());
                    obj[i][5] = "";
                    obj[i][6] = String.valueOf(((WorkingOrderBean)value).getAverageBuy());
                    obj[i][7] = String.valueOf(((WorkingOrderBean)value).getTotalFillBuy());
                    obj[i][8] = String.valueOf(((WorkingOrderBean)value).getTotolAmountBuy());
                    obj[i][9] = "";
                    obj[i][10] = "";
                    obj[i][11] = "";
                    obj[i][12] = "";
                    continue;
                }
                obj[i][j] = value.toString();
            }
        }
        return obj;
    }

    private void SetParameters(Jasper_Report Report) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("PrintDate", MyTime.getInstance().getTimeAndDateForReport());
        Report.SetParameter(param);
    }

    private class ColumnListner
    extends MouseAdapter {
        private final NxGTable table;
        protected int sortCol = 0;
        protected boolean isSortAsc = true;
        private TableColumnModel colModel;

        public ColumnListner(NxGTable table) {
            this.table = table;
            this.colModel = table.getColumnModel();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int columnModelIndex = this.colModel.getColumnIndexAtX(e.getX());
            int modelIndex = this.colModel.getColumn(columnModelIndex).getModelIndex();
            if (modelIndex < 0) {
                return;
            }
            if (this.sortCol == modelIndex) {
                this.isSortAsc = !this.isSortAsc;
            } else {
                this.sortCol = modelIndex;
            }
            this.table.getTableHeader().repaint();
            Collections.sort(PMEX_WorkingOrder.this.rows, new WorkingOrderComparator(this.sortCol, this.isSortAsc));
            this.table.tableChanged(new TableModelEvent((TableModel)PMEX_WorkingOrder.this.model));
            this.table.packAll();
            this.table.repaint();
        }

        private void addSummaryRowsForAccount() {
            Vector rowsTemp = new Vector(PMEX_WorkingOrder.this.rows.size());
            rowsTemp.addAll(PMEX_WorkingOrder.this.rows);
            PMEX_WorkingOrder.this.rows.clear();
            String accoutPrv = ((WorkingOrderBean)rowsTemp.get(0)).getAccount();
            String contractPrv = ((WorkingOrderBean)rowsTemp.get(0)).getContract();
            long totalFillBuyTrader = 0L;
            double totolAmountBuyTrader = 0.0;
            long totalFillSellTrader = 0L;
            double totolAmountSellTrader = 0.0;
            long totalFillBuyAccount = 0L;
            double totolAmountBuyAccount = 0.0;
            double averageBuyAccount = 0.0;
            long totalFillSellAccount = 0L;
            double totolAmountSellAccount = 0.0;
            double averageSellAccount = 0.0;
            long totalFillBuyContract = 0L;
            double totolAmountBuyContract = 0.0;
            double averageBuyContract = 0.0;
            long totalFillSellContract = 0L;
            double totolAmountSellContract = 0.0;
            double averageSellContract = 0.0;
            for (int i = 0; i < rowsTemp.size(); ++i) {
                WorkingOrderBean bAccountSumm;
                WorkingOrderBean bContractSumm;
                if (accoutPrv.equalsIgnoreCase(((WorkingOrderBean)rowsTemp.get(i)).getAccount())) {
                    if (((WorkingOrderBean)rowsTemp.get(i)).getTransactionType().equalsIgnoreCase("Buy")) {
                        totalFillBuyAccount += ((WorkingOrderBean)rowsTemp.get(i)).getQuantity();
                        totolAmountBuyAccount += (double)((WorkingOrderBean)rowsTemp.get(i)).getQuantity() * ((WorkingOrderBean)rowsTemp.get(i)).getLimitPrice();
                    } else if (((WorkingOrderBean)rowsTemp.get(i)).getTransactionType().equalsIgnoreCase("Sell")) {
                        totalFillSellAccount += ((WorkingOrderBean)rowsTemp.get(i)).getQuantity();
                        totolAmountSellAccount += (double)((WorkingOrderBean)rowsTemp.get(i)).getQuantity() * ((WorkingOrderBean)rowsTemp.get(i)).getLimitPrice();
                    }
                    if (contractPrv.equalsIgnoreCase(((WorkingOrderBean)rowsTemp.get(i)).getContract())) {
                        if (((WorkingOrderBean)rowsTemp.get(i)).getTransactionType().equalsIgnoreCase("Buy")) {
                            totalFillBuyContract += ((WorkingOrderBean)rowsTemp.get(i)).getQuantity();
                            totolAmountBuyContract += (double)((WorkingOrderBean)rowsTemp.get(i)).getQuantity() * ((WorkingOrderBean)rowsTemp.get(i)).getLimitPrice();
                        } else if (((WorkingOrderBean)rowsTemp.get(i)).getTransactionType().equalsIgnoreCase("Sell")) {
                            totalFillSellContract += ((WorkingOrderBean)rowsTemp.get(i)).getQuantity();
                            totolAmountSellContract += (double)((WorkingOrderBean)rowsTemp.get(i)).getQuantity() * ((WorkingOrderBean)rowsTemp.get(i)).getLimitPrice();
                        }
                    } else {
                        averageBuyContract = totolAmountBuyContract / (double)totalFillBuyContract;
                        averageSellContract = totolAmountSellContract / (double)totalFillSellContract;
                        bContractSumm = new WorkingOrderBean();
                        bContractSumm.setAccount("Total (Contract)");
                        bContractSumm.setAverageBuy(averageBuyContract);
                        bContractSumm.setTotalFillBuy(totalFillBuyContract);
                        bContractSumm.setTotolAmountBuy(totolAmountBuyContract);
                        bContractSumm.setAverageSell(averageSellContract);
                        bContractSumm.setTotalFillSell(totalFillSellContract);
                        bContractSumm.setTotolAmountSell(totolAmountSellContract);
                        PMEX_WorkingOrder.this.rows.add(bContractSumm);
                        averageBuyContract = 0.0;
                        averageSellContract = 0.0;
                        totalFillBuyContract = 0L;
                        totolAmountBuyContract = 0.0;
                        totalFillSellContract = 0L;
                        totolAmountSellContract = 0.0;
                        if (i + 1 < rowsTemp.size()) {
                            contractPrv = ((WorkingOrderBean)rowsTemp.get(i + 1)).getContract();
                            if (((WorkingOrderBean)rowsTemp.get(i + 1)).getTransactionType().equalsIgnoreCase("Buy")) {
                                totalFillBuyContract = ((WorkingOrderBean)rowsTemp.get(i + 1)).getQuantity();
                                totolAmountBuyContract = (double)((WorkingOrderBean)rowsTemp.get(i + 1)).getQuantity() * ((WorkingOrderBean)rowsTemp.get(i + 1)).getLimitPrice();
                            } else if (((WorkingOrderBean)rowsTemp.get(i + 1)).getTransactionType().equalsIgnoreCase("Sell")) {
                                totalFillSellContract = ((WorkingOrderBean)rowsTemp.get(i + 1)).getQuantity();
                                totolAmountSellContract = (double)((WorkingOrderBean)rowsTemp.get(i + 1)).getQuantity() * ((WorkingOrderBean)rowsTemp.get(i + 1)).getLimitPrice();
                            }
                        }
                    }
                    PMEX_WorkingOrder.this.rows.add(rowsTemp.get(i));
                } else {
                    averageBuyContract = totolAmountBuyContract / (double)totalFillBuyContract;
                    averageSellContract = totolAmountSellContract / (double)totalFillSellContract;
                    bContractSumm = new WorkingOrderBean();
                    bContractSumm.setAccount("Total (Contract)");
                    bContractSumm.setAverageBuy(averageBuyContract);
                    bContractSumm.setTotalFillBuy(totalFillBuyContract);
                    bContractSumm.setTotolAmountBuy(totolAmountBuyContract);
                    bContractSumm.setAverageSell(averageSellContract);
                    bContractSumm.setTotalFillSell(totalFillSellContract);
                    bContractSumm.setTotolAmountSell(totolAmountSellContract);
                    PMEX_WorkingOrder.this.rows.add(bContractSumm);
                    totalFillBuyContract = 0L;
                    totolAmountBuyContract = 0.0;
                    totalFillSellContract = 0L;
                    totolAmountSellContract = 0.0;
                    averageBuyContract = 0.0;
                    averageSellContract = 0.0;
                    if (i + 1 < rowsTemp.size()) {
                        contractPrv = ((WorkingOrderBean)rowsTemp.get(i)).getContract();
                        if (((WorkingOrderBean)rowsTemp.get(i)).getTransactionType().equalsIgnoreCase("Buy")) {
                            totalFillBuyContract = ((WorkingOrderBean)rowsTemp.get(i)).getQuantity();
                            totolAmountBuyContract = (double)((WorkingOrderBean)rowsTemp.get(i)).getQuantity() * ((WorkingOrderBean)rowsTemp.get(i)).getLimitPrice();
                        } else if (((WorkingOrderBean)rowsTemp.get(i)).getTransactionType().equalsIgnoreCase("Sell")) {
                            totalFillSellContract = ((WorkingOrderBean)rowsTemp.get(i)).getQuantity();
                            totolAmountSellContract = (double)((WorkingOrderBean)rowsTemp.get(i)).getQuantity() * ((WorkingOrderBean)rowsTemp.get(i)).getLimitPrice();
                        }
                    }
                    averageBuyAccount = totolAmountBuyAccount / (double)totalFillBuyAccount;
                    averageSellAccount = totolAmountSellAccount / (double)totalFillSellAccount;
                    totalFillBuyTrader += totalFillBuyAccount;
                    totolAmountBuyTrader += totolAmountBuyAccount;
                    totolAmountSellTrader += totolAmountSellAccount;
                    totalFillSellTrader = (long)((double)totalFillSellTrader + totolAmountSellAccount);
                    bAccountSumm = new WorkingOrderBean();
                    bAccountSumm.setAccount("Total (Account)");
                    bAccountSumm.setAverageBuy(averageBuyAccount);
                    bAccountSumm.setTotalFillBuy(totalFillBuyAccount);
                    bAccountSumm.setTotolAmountBuy(totolAmountBuyAccount);
                    bAccountSumm.setAverageSell(averageSellAccount);
                    bAccountSumm.setTotalFillSell(totalFillSellAccount);
                    bAccountSumm.setTotolAmountSell(totolAmountSellAccount);
                    PMEX_WorkingOrder.this.rows.add(bAccountSumm);
                    totalFillBuyAccount = 0L;
                    totolAmountBuyAccount = 0.0;
                    averageBuyAccount = 0.0;
                    totalFillSellAccount = 0L;
                    totolAmountSellAccount = 0.0;
                    averageSellAccount = 0.0;
                    if (i < rowsTemp.size()) {
                        accoutPrv = ((WorkingOrderBean)rowsTemp.get(i)).getAccount();
                        if (((WorkingOrderBean)rowsTemp.get(i)).getTransactionType().equalsIgnoreCase("Buy")) {
                            totalFillBuyAccount = ((WorkingOrderBean)rowsTemp.get(i)).getQuantity();
                            totolAmountBuyAccount = (double)((WorkingOrderBean)rowsTemp.get(i)).getQuantity() * ((WorkingOrderBean)rowsTemp.get(i)).getLimitPrice();
                        } else if (((WorkingOrderBean)rowsTemp.get(i)).getTransactionType().equalsIgnoreCase("Sell")) {
                            totalFillSellAccount = ((WorkingOrderBean)rowsTemp.get(i)).getQuantity();
                            totolAmountSellAccount = (double)((WorkingOrderBean)rowsTemp.get(i)).getQuantity() * ((WorkingOrderBean)rowsTemp.get(i)).getLimitPrice();
                        }
                    }
                    PMEX_WorkingOrder.this.rows.add(rowsTemp.get(i));
                }
                if (i != rowsTemp.size() - 1) continue;
                averageBuyContract = totolAmountBuyContract / (double)totalFillBuyContract;
                averageSellContract = totolAmountSellContract / (double)totalFillSellContract;
                bContractSumm = new WorkingOrderBean();
                bContractSumm.setAccount("Total (Contract)");
                bContractSumm.setAverageBuy(averageBuyContract);
                bContractSumm.setTotalFillBuy(totalFillBuyContract);
                bContractSumm.setTotolAmountBuy(totolAmountBuyContract);
                bContractSumm.setAverageSell(averageSellContract);
                bContractSumm.setTotalFillSell(totalFillSellContract);
                bContractSumm.setTotolAmountSell(totolAmountSellContract);
                PMEX_WorkingOrder.this.rows.add(bContractSumm);
                averageBuyAccount = totolAmountBuyAccount / (double)totalFillBuyAccount;
                averageSellAccount = totolAmountSellAccount / (double)totalFillSellAccount;
                totalFillBuyTrader += totalFillBuyAccount;
                totolAmountBuyTrader += totolAmountBuyAccount;
                totolAmountSellTrader += totolAmountSellAccount;
                totalFillSellTrader = (long)((double)totalFillSellTrader + totolAmountSellAccount);
                bAccountSumm = new WorkingOrderBean();
                bAccountSumm.setAccount("Total (Account)");
                bAccountSumm.setAverageBuy(averageBuyAccount);
                bAccountSumm.setTotalFillBuy(totalFillBuyAccount);
                bAccountSumm.setTotolAmountBuy(totolAmountBuyAccount);
                bAccountSumm.setAverageSell(averageSellAccount);
                bAccountSumm.setTotalFillSell(totalFillSellAccount);
                bAccountSumm.setTotolAmountSell(totolAmountSellAccount);
                PMEX_WorkingOrder.this.rows.add(bAccountSumm);
                WorkingOrderBean bTraderSumm = new WorkingOrderBean();
                bTraderSumm.setAccount("Total (Trader)");
                bTraderSumm.setTotalFillBuy(totalFillBuyTrader);
                bTraderSumm.setTotolAmountBuy(totolAmountBuyTrader);
                bTraderSumm.setTotalFillSell(totalFillSellTrader);
                bTraderSumm.setTotolAmountSell(totolAmountSellTrader);
                PMEX_WorkingOrder.this.rows.add(bTraderSumm);
            }
        }

        private void addSummaryRowsForContract() {
            Vector rowsTemp = new Vector(PMEX_WorkingOrder.this.rows.size());
            rowsTemp.addAll(PMEX_WorkingOrder.this.rows);
            PMEX_WorkingOrder.this.rows.clear();
            String contractPrv = ((WorkingOrderBean)rowsTemp.get(0)).getContract();
            long totalFillBuyContract = 0L;
            double totolAmountBuyContract = 0.0;
            long totalFillSellContract = 0L;
            double totolAmountSellContract = 0.0;
            double averageBuyContract = 0.0;
            double averageSellContract = 0.0;
            long totalFillBuyContractAll = 0L;
            double totolAmountBuyContractAll = 0.0;
            long totalFillSellContractAll = 0L;
            double totolAmountSellContractAll = 0.0;
            for (int i = 0; i < rowsTemp.size(); ++i) {
                WorkingOrderBean bContractSumm;
                WorkingOrderBean tradedOrderBean = (WorkingOrderBean)rowsTemp.elementAt(i);
                if (contractPrv.equalsIgnoreCase(tradedOrderBean.getContract())) {
                    PMEX_WorkingOrder.this.rows.add(tradedOrderBean);
                    if (tradedOrderBean.getTransactionType().equalsIgnoreCase("Buy")) {
                        totalFillBuyContract += tradedOrderBean.getQuantity();
                        totolAmountBuyContract += (double)tradedOrderBean.getQuantity() * tradedOrderBean.getLimitPrice();
                    } else if (((WorkingOrderBean)rowsTemp.get(i)).getTransactionType().equalsIgnoreCase("Sell")) {
                        totalFillSellContract += tradedOrderBean.getQuantity();
                        totolAmountSellContract += (double)tradedOrderBean.getQuantity() * tradedOrderBean.getLimitPrice();
                    }
                } else {
                    averageBuyContract = totolAmountBuyContract / (double)totalFillBuyContract;
                    averageSellContract = totolAmountSellContract / (double)totalFillSellContract;
                    totalFillBuyContractAll += totalFillBuyContract;
                    totalFillSellContractAll += totalFillSellContract;
                    totolAmountBuyContractAll += totolAmountBuyContract;
                    totolAmountSellContractAll += totolAmountSellContract;
                    bContractSumm = new WorkingOrderBean();
                    bContractSumm.setAccount("Total (Contract)");
                    bContractSumm.setAverageBuy(averageBuyContract);
                    bContractSumm.setTotalFillBuy(totalFillBuyContract);
                    bContractSumm.setTotolAmountBuy(totolAmountBuyContract);
                    bContractSumm.setAverageSell(averageSellContract);
                    bContractSumm.setTotalFillSell(totalFillSellContract);
                    bContractSumm.setTotolAmountSell(totolAmountSellContract);
                    PMEX_WorkingOrder.this.rows.add(bContractSumm);
                    totalFillBuyContract = 0L;
                    totolAmountBuyContract = 0.0;
                    totalFillSellContract = 0L;
                    totolAmountSellContract = 0.0;
                    averageBuyContract = 0.0;
                    averageSellContract = 0.0;
                    PMEX_WorkingOrder.this.rows.add(tradedOrderBean);
                    if (i < rowsTemp.size()) {
                        contractPrv = ((WorkingOrderBean)rowsTemp.get(i)).getContract();
                        if (((WorkingOrderBean)rowsTemp.get(i)).getTransactionType().equalsIgnoreCase("Buy")) {
                            totalFillBuyContract = ((WorkingOrderBean)rowsTemp.get(i)).getQuantity();
                            totolAmountBuyContract = (double)((WorkingOrderBean)rowsTemp.get(i)).getQuantity() * ((WorkingOrderBean)rowsTemp.get(i)).getLimitPrice();
                        } else if (((WorkingOrderBean)rowsTemp.get(i)).getTransactionType().equalsIgnoreCase("Sell")) {
                            totalFillSellContract = ((WorkingOrderBean)rowsTemp.get(i)).getQuantity();
                            totolAmountSellContract = (double)((WorkingOrderBean)rowsTemp.get(i)).getQuantity() * ((WorkingOrderBean)rowsTemp.get(i)).getLimitPrice();
                        }
                    }
                }
                if (i != rowsTemp.size() - 1) continue;
                averageBuyContract = totolAmountBuyContract / (double)totalFillBuyContract;
                averageSellContract = totolAmountSellContract / (double)totalFillSellContract;
                totalFillBuyContractAll += totalFillBuyContract;
                totalFillSellContractAll += totalFillSellContract;
                totolAmountBuyContractAll += totolAmountBuyContract;
                totolAmountSellContractAll += totolAmountSellContract;
                bContractSumm = new WorkingOrderBean();
                bContractSumm.setAccount("Total (Contract)");
                bContractSumm.setAverageBuy(averageBuyContract);
                bContractSumm.setTotalFillBuy(totalFillBuyContract);
                bContractSumm.setTotolAmountBuy(totolAmountBuyContract);
                bContractSumm.setAverageSell(averageSellContract);
                bContractSumm.setTotalFillSell(totalFillSellContract);
                bContractSumm.setTotolAmountSell(totolAmountSellContract);
                PMEX_WorkingOrder.this.rows.add(bContractSumm);
                WorkingOrderBean bContractAllSumm = new WorkingOrderBean();
                bContractAllSumm.setAccount("Total (Trader)");
                bContractAllSumm.setTotalFillBuy(totalFillBuyContractAll);
                bContractAllSumm.setTotolAmountBuy(totolAmountBuyContractAll);
                bContractAllSumm.setTotalFillSell(totalFillSellContractAll);
                bContractAllSumm.setTotolAmountSell(totolAmountSellContractAll);
                PMEX_WorkingOrder.this.rows.add(bContractAllSumm);
            }
        }
    }

    private class WorkingOrderComparator
    implements Comparator<WorkingOrderBean> {
        int columnIndex = 0;
        boolean isAsc;

        public WorkingOrderComparator(int columnIndex, boolean isAsc) {
            this.columnIndex = columnIndex;
            this.isAsc = isAsc;
        }

        @Override
        public int compare(WorkingOrderBean t, WorkingOrderBean t1) {
            int result = 0;
            switch (this.columnIndex) {
                case 0: {
                    result = t.getTrader().compareTo(t1.getTrader());
                    break;
                }
                case 1: {
                    result = t.getAccount().compareTo(t1.getAccount());
                    break;
                }
                case 2: {
                    result = t.getContract().compareTo(t1.getContract());
                    break;
                }
                case 3: {
                    result = t.getOrderID().compareTo(t1.getOrderID());
                    break;
                }
                case 4: {
                    result = t.getClientOrderID().compareTo(t1.getClientOrderID());
                    break;
                }
                case 5: {
                    result = t.getQuantity() < t1.getQuantity() ? -1 : (t.getQuantity() > t1.getQuantity() ? 1 : 0);
                    break;
                }
                case 6: {
                    result = t.getLimitPrice() < t1.getLimitPrice() ? -1 : (t.getLimitPrice() > t1.getLimitPrice() ? 1 : 0);
                    break;
                }
                case 7: {
                    result = t.getTriggerPrice() < t1.getTriggerPrice() ? -1 : (t.getTriggerPrice() > t1.getTriggerPrice() ? 1 : 0);
                    break;
                }
                case 8: {
                    result = t.getOrderType().compareTo(t1.getOrderID());
                    break;
                }
                case 9: {
                    result = t.getTransactionType().compareTo(t1.getTransactionType());
                    break;
                }
                case 10: {
                    result = t.isGoodTillCancel() == Boolean.TRUE.booleanValue() ? 0 : 1;
                    break;
                }
                case 11: {
                    result = t.getDistance() < t1.getDistance() ? -1 : (t.getDistance() > t1.getDistance() ? 1 : 0);
                    break;
                }
                case 12: {
                    int n = t.getTrailingStep() < t1.getTrailingStep() ? -1 : (result = t.getTrailingStep() > t1.getTrailingStep() ? 1 : 0);
                }
            }
            if (!this.isAsc) {
                result = -result;
            }
            return result;
        }
    }
}

