/*
 * Decompiled with CFR 0.152.
 */
package windows.pmex.order;

import CATALYST.Control.MarketFeed;
import CustomComponent.NxGComboBox;
import CustomComponent.NxGPassword;
import CustomComponent.NxGSpinner;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import RendersNModels.ComboBoxToolTipRender;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.bean.AccountBean;
import common.gui.component.NxGDialogBox;
import common.gui.util.AppConfig;
import common.gui.util.ImageUtil;
import common.gui.util.LogCommon;
import common.gui.util.Title;
import common.gui.util.Util;
import common.interfaces.AddContract;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.text.AbstractDocument;
import pmex.gui.bean.PMEXMarketFeedBean;
import pmex.gui.bean.PMEXOrderBean;
import pmex.gui.util.LogsPMEX;
import pmex.gui.util.UtilPMEX;
import windows.pmex.buyingpower.DocumentSizeAndUppercaseFilter;
import windows.pmex.order.PMEX_FastOrder;
import windows.pmex.order.PMEX_OrderConfirmation;

public class PMEX_FastOrderPanel
extends JPanel
implements AddContract,
ActionListener {
    Mediator mediator = Mediator.getInstance();
    private AutoCompleteSupport autoCompleteContract;
    private AutoCompleteSupport autoComOrderType;
    private AutoCompleteSupport autoComOrder;
    private final SpinnerNumberModel PriceModel = new SpinnerNumberModel(0.0, 0.0, 1000000.0, 0.01);
    private final SpinnerNumberModel LimitModel = new SpinnerNumberModel(0.0, 0.0, 1000000.0, 0.01);
    private final SpinnerNumberModel QuantityModel = new SpinnerNumberModel(0, 0, 1000000, 10);
    public static String contractPrompt = "Please Select a Contract";
    private int ID = 0;
    private final PMEX_FastOrder fastOrder;
    private final NxGPassword txtPinCode;
    private JButton btnRemove;
    private JButton btnReset;
    private JButton btnSubmit;
    private JComboBox cbAccountNo;
    private JComboBox cbContract;
    private JComboBox cbOrder;
    private JComboBox cbOrderType;
    private JCheckBox isGTC;
    private JToolBar jToolBar1;
    private JLabel lblPrefix;
    private JSpinner spLimitPrice;
    private JSpinner spQuantity;
    private JSpinner spTriggerPrice;

    public PMEX_FastOrderPanel(PMEX_FastOrder fastOrder, NxGPassword txtPinCode, int id) {
        this.initComponents();
        this.fastOrder = fastOrder;
        this.txtPinCode = txtPinCode;
        this.ID = id;
        this.setThis();
        this.spTriggerPrice.setEnabled(false);
        this.addContract();
        this.setOrder();
        this.setOrderTypes();
        this.setAccounts();
        this.setModels();
        this.setOrderOptions(LogCommon.PMEX_OrderOption);
        this.setListener();
    }

    private void setThis() {
        LogsPMEX.CONTRACT_HOLDER.add(this);
        this.cbContract.addActionListener(this);
        this.cbOrder.addActionListener(this);
        this.cbOrderType.addActionListener(this);
        this.cbAccountNo.addActionListener(this);
    }

    private void removeThis() {
        this.cbContract.removeActionListener(this);
        this.cbOrder.removeActionListener(this);
        this.cbOrderType.removeActionListener(this);
        this.cbAccountNo.removeActionListener(this);
    }

    public void setFocus() {
        this.cbContract.requestFocus();
    }

    private void setListener() {
        ((JSpinner.DefaultEditor)this.spLimitPrice.getEditor()).getTextField().setFocusTraversalKeys(0, Collections.EMPTY_SET);
        ((JSpinner.DefaultEditor)this.spQuantity.getEditor()).getTextField().setFocusTraversalKeys(0, Collections.EMPTY_SET);
        ((JSpinner.DefaultEditor)this.spTriggerPrice.getEditor()).getTextField().setFocusTraversalKeys(0, Collections.EMPTY_SET);
        ((JSpinner.DefaultEditor)this.spQuantity.getEditor()).getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                super.keyPressed(evt);
                if (evt.getKeyCode() == 10 || evt.getKeyCode() == 9) {
                    String val = ((JSpinner.DefaultEditor)PMEX_FastOrderPanel.this.spQuantity.getEditor()).getTextField().getText();
                    if (val.trim().length() <= 0 || val.equalsIgnoreCase("0") || val.equalsIgnoreCase("0.0")) {
                        ((NxGSpinner)PMEX_FastOrderPanel.this.spQuantity).setError(true);
                        ((JSpinner.DefaultEditor)PMEX_FastOrderPanel.this.spQuantity.getEditor()).getTextField().requestFocus();
                    } else {
                        ((NxGSpinner)PMEX_FastOrderPanel.this.spQuantity).setError(false);
                        if (PMEX_FastOrderPanel.this.spLimitPrice.isEnabled()) {
                            ((JSpinner.DefaultEditor)PMEX_FastOrderPanel.this.spLimitPrice.getEditor()).getTextField().requestFocus();
                        } else {
                            PMEX_FastOrderPanel.this.btnSubmit.requestFocus();
                        }
                    }
                }
            }
        });
        ((JSpinner.DefaultEditor)this.spLimitPrice.getEditor()).getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                super.keyPressed(evt);
                if (evt.getKeyCode() == 10 || evt.getKeyCode() == 9) {
                    String val = ((JSpinner.DefaultEditor)PMEX_FastOrderPanel.this.spLimitPrice.getEditor()).getTextField().getText();
                    if (val.trim().length() <= 0 || val.equalsIgnoreCase("0") || val.equalsIgnoreCase("0.0")) {
                        ((NxGSpinner)PMEX_FastOrderPanel.this.spLimitPrice).setError(true);
                        ((JSpinner.DefaultEditor)PMEX_FastOrderPanel.this.spLimitPrice.getEditor()).getTextField().requestFocus();
                        PMEX_FastOrderPanel.this.setPriceFromFeedAndSubcribe(false);
                    } else {
                        ((NxGSpinner)PMEX_FastOrderPanel.this.spLimitPrice).setError(false);
                        if (PMEX_FastOrderPanel.this.spTriggerPrice.isEnabled()) {
                            ((JSpinner.DefaultEditor)PMEX_FastOrderPanel.this.spTriggerPrice.getEditor()).getTextField().requestFocus();
                        } else {
                            PMEX_FastOrderPanel.this.btnSubmit.requestFocus();
                        }
                    }
                }
            }
        });
        ((JSpinner.DefaultEditor)this.spTriggerPrice.getEditor()).getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                super.keyPressed(evt);
                if (evt.getKeyCode() == 10 || evt.getKeyCode() == 9) {
                    String val = ((JSpinner.DefaultEditor)PMEX_FastOrderPanel.this.spTriggerPrice.getEditor()).getTextField().getText();
                    if (val.trim().length() <= 0 || val.equalsIgnoreCase("0") || val.equalsIgnoreCase("0.0")) {
                        ((NxGSpinner)PMEX_FastOrderPanel.this.spTriggerPrice).setError(true);
                        ((JSpinner.DefaultEditor)PMEX_FastOrderPanel.this.spTriggerPrice.getEditor()).getTextField().requestFocus();
                    } else {
                        ((NxGSpinner)PMEX_FastOrderPanel.this.spTriggerPrice).setError(false);
                        PMEX_FastOrderPanel.this.btnSubmit.requestFocus();
                    }
                }
            }
        });
        ((JSpinner.DefaultEditor)this.spQuantity.getEditor()).getTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                PMEX_FastOrderPanel.this.spinnerSetTextSelected(e);
            }
        });
        ((JSpinner.DefaultEditor)this.spLimitPrice.getEditor()).getTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                PMEX_FastOrderPanel.this.spinnerSetTextSelected(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                String val = ((JSpinner.DefaultEditor)PMEX_FastOrderPanel.this.spLimitPrice.getEditor()).getTextField().getText();
                if (val.trim().length() <= 0 || val.equalsIgnoreCase("0") || val.equalsIgnoreCase("0.0")) {
                    PMEX_FastOrderPanel.this.setPriceFromFeedAndSubcribe(false);
                }
            }
        });
        ((JSpinner.DefaultEditor)this.spTriggerPrice.getEditor()).getTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                PMEX_FastOrderPanel.this.spinnerSetTextSelected(e);
            }
        });
        this.isGTC.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                super.keyPressed(e);
                if (e.getKeyCode() == 10) {
                    ((JSpinner.DefaultEditor)PMEX_FastOrderPanel.this.spQuantity.getEditor()).getTextField().requestFocus();
                }
            }
        });
    }

    private void spinnerSetTextSelected(FocusEvent e) {
        JFormattedTextField textField = (JFormattedTextField)e.getComponent();
        textField.setText(textField.getText());
        textField.selectAll();
    }

    public void resetValues() {
        this.resetError();
        this.removeThis();
        this.setOrderOptions(LogCommon.PMEX_OrderOption);
        ((NxGComboBox)this.cbContract).setSelectedItem(contractPrompt);
        ((NxGComboBox)this.cbOrder).setSelectedItem("Buy");
        ((NxGComboBox)this.cbOrderType).setSelectedItem("Limit");
        ((NxGComboBox)this.cbAccountNo).setSelectedItem("");
        try {
            if (this.cbAccountNo.getItemCount() > 0) {
                ((NxGComboBox)this.cbAccountNo).setSelectedIndex(0);
            } else {
                ((NxGComboBox)this.cbAccountNo).setSelectedItem("");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ((NxGSpinner)this.spLimitPrice).setEnabled(true);
        ((NxGSpinner)this.spLimitPrice).setError(false);
        ((NxGSpinner)this.spTriggerPrice).setValue(0);
        ((NxGSpinner)this.spTriggerPrice).setEnabled(false);
        ((NxGSpinner)this.spQuantity).setError(false);
        this.isGTC.setSelected(false);
        this.setThis();
    }

    private void resetError() {
        ((NxGComboBox)this.cbContract).setError(false);
        ((NxGComboBox)this.cbOrder).setError(false);
        ((NxGComboBox)this.cbOrderType).setError(false);
        ((NxGComboBox)this.cbAccountNo).setError(false);
        ((NxGSpinner)this.spLimitPrice).setError(false);
        ((NxGSpinner)this.spTriggerPrice).setError(false);
        ((NxGSpinner)this.spQuantity).setError(false);
        this.txtPinCode.setError(false);
    }

    private void setOrder() {
        if (this.autoComOrder != null && this.autoComOrder.isInstalled()) {
            this.autoComOrder.uninstall();
        }
        this.cbOrder.setModel(new DefaultComboBoxModel<String>(LogsPMEX.OrderType));
        this.autoComOrder = AutoCompleteSupport.install((JComboBox)this.cbOrder, (EventList)GlazedLists.eventListOf((Object[])LogsPMEX.OrderType));
        this.autoComOrder.setStrict(true);
        this.cbOrder.setSelectedItem("Buy");
    }

    private void setOrderTypes() {
        if (this.autoComOrderType != null && this.autoComOrderType.isInstalled()) {
            this.autoComOrderType.uninstall();
        }
        this.cbOrderType.setModel(new DefaultComboBoxModel<String>(LogsPMEX.OrderTypesSellFast));
        this.autoComOrderType = AutoCompleteSupport.install((JComboBox)this.cbOrderType, (EventList)GlazedLists.eventListOf((Object[])LogsPMEX.OrderTypesSellFast));
        this.cbOrderType.setSelectedItem("Limit");
    }

    private void setAccounts() {
        if (LogsPMEX.accountPrefix.length() > 0) {
            this.lblPrefix.setText(LogsPMEX.accountPrefix);
        } else {
            this.lblPrefix.setText("");
            this.lblPrefix.setVisible(false);
        }
        Iterator en = LogsPMEX.ALL_ACCOUNTS.keySet().iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (en.hasNext()) {
            String key = en.next().toString();
            AccountBean ac = (AccountBean)LogsPMEX.ALL_ACCOUNTS.get(key);
            if (ac.getAccountNo().indexOf(LogsPMEX.accountPrefix) == 0) {
                list.add(ac.getAccountNo().replaceFirst(LogsPMEX.accountPrefix, ""));
                continue;
            }
            list.add(ac.getAccountNo());
        }
        this.cbAccountNo.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        AutoCompleteSupport support = AutoCompleteSupport.install((JComboBox)this.cbAccountNo, (EventList)GlazedLists.eventListOf((Object[])list.toArray()));
        support.setStrict(false);
        this.cbAccountNo.setRenderer(new ComboBoxToolTipRender(LogsPMEX.ALL_ACCOUNTS, LogsPMEX.accountPrefix));
        this.cbAccountNo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    PMEX_FastOrderPanel.this.cbAccountNo.setToolTipText(((AccountBean)LogsPMEX.ALL_ACCOUNTS.get(LogsPMEX.accountPrefix + PMEX_FastOrderPanel.this.cbAccountNo.getSelectedItem().toString().trim())).toString());
                }
                catch (Exception ex) {
                    PMEX_FastOrderPanel.this.cbAccountNo.setToolTipText(null);
                }
            }
        });
        try {
            if (this.cbAccountNo.getItemCount() > 0) {
                if (LogCommon.preferredAccountPMEX.trim().length() > 0) {
                    this.cbAccountNo.setSelectedItem(LogCommon.preferredAccountPMEX.replaceFirst(LogsPMEX.accountPrefix, ""));
                } else {
                    this.cbAccountNo.setSelectedItem("");
                }
            } else {
                this.cbAccountNo.setSelectedItem("");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        AbstractDocument d = (AbstractDocument)((JTextField)this.cbAccountNo.getEditor().getEditorComponent()).getDocument();
        d.setDocumentFilter(new DocumentSizeAndUppercaseFilter(4));
    }

    private void setModels() {
        this.spLimitPrice.setModel(this.PriceModel);
        this.spTriggerPrice.setModel(this.LimitModel);
        this.spQuantity.setModel(this.QuantityModel);
    }

    public void setOrderOptions(String result) {
        try {
            Number step;
            Number max;
            Number min;
            Number value;
            Number step2;
            Number max2;
            Number min2;
            Number value2;
            String[] val;
            if (result.indexOf(";") > 0) {
                LogCommon.PMEX_OrderOption = result;
            }
            if (LogCommon.PMEX_OrderOption.indexOf(";") > 0) {
                val = LogCommon.PMEX_OrderOption.split("\\;", -1);
                value2 = new Integer(Integer.parseInt(val[0]));
                min2 = new Integer(1);
                max2 = new Integer(999999);
                step2 = new Integer(Integer.parseInt(val[1]));
                this.QuantityModel.setMinimum((Comparable<?>)((Object)min2));
                this.QuantityModel.setMaximum((Comparable<?>)((Object)max2));
                this.QuantityModel.setStepSize(step2);
                this.QuantityModel.setValue(value2);
            } else {
                value = new Integer(100);
                min = new Integer(1);
                max = new Integer(999999);
                step = new Integer(1);
                this.QuantityModel.setMinimum((Comparable<?>)((Object)min));
                this.QuantityModel.setMaximum((Comparable<?>)((Object)max));
                this.QuantityModel.setStepSize(step);
                this.QuantityModel.setValue(value);
            }
            if (LogCommon.PMEX_OrderOption.indexOf(";") > 0) {
                val = LogCommon.PMEX_OrderOption.split("\\;", -1);
                value2 = new Double(0.0);
                min2 = new Double(0.0);
                max2 = new Double(999999.99);
                step2 = new Double(Double.parseDouble(val[2]));
                this.PriceModel.setMinimum((Comparable<?>)((Object)min2));
                this.PriceModel.setMaximum((Comparable<?>)((Object)max2));
                this.PriceModel.setStepSize(step2);
                this.PriceModel.setValue(value2);
                this.LimitModel.setMinimum((Comparable<?>)((Object)min2));
                this.LimitModel.setMaximum((Comparable<?>)((Object)max2));
                this.LimitModel.setStepSize(step2);
                this.LimitModel.setValue(value2);
            } else {
                value = new Double(0.0);
                min = new Double(0.0);
                max = new Double(999999.99);
                step = new Double(0.01);
                this.PriceModel.setMinimum((Comparable<?>)((Object)min));
                this.PriceModel.setMaximum((Comparable<?>)((Object)max));
                this.PriceModel.setStepSize(step);
                this.PriceModel.setValue(value);
                this.LimitModel.setMinimum((Comparable<?>)((Object)min));
                this.LimitModel.setMaximum((Comparable<?>)((Object)max));
                this.LimitModel.setStepSize(step);
            }
        }
        catch (Exception ex) {
            Mediator.getInstance().PrintLog(ex, result);
        }
    }

    private void setPriceFromFeedAndSubcribe(boolean isSendFeedRequest) {
        String cont = this.cbContract.getSelectedItem().toString();
        String market = UtilPMEX.GetMarketFromContract((String)cont);
        String type = this.cbOrder.getSelectedItem().toString();
        MarketFeed marketFeed = this.mediator.PMEX_GetSingleFeed(cont, market);
        if (marketFeed != null) {
            if (type.equalsIgnoreCase("BUY")) {
                this.setPriceOfFeed(Double.parseDouble(marketFeed.sell));
            } else {
                this.setPriceOfFeed(Double.parseDouble(marketFeed.buy));
            }
        } else {
            PMEXMarketFeedBean pmexMarketFeedBean = this.mediator.PMEX_GetSingleFeed_Matrix(cont, market);
            if (pmexMarketFeedBean != null) {
                if (type.equalsIgnoreCase("BUY")) {
                    this.setPriceOfFeed(pmexMarketFeedBean.getSell());
                } else {
                    this.setPriceOfFeed(pmexMarketFeedBean.getBuy());
                }
            } else if (isSendFeedRequest) {
                this.mediator.sendFeedContract("", "PMEX_FastOrder : setPriceFromFeedAndSubcribe = " + isSendFeedRequest);
            }
        }
    }

    private void setPriceOfFeed(double price) {
        if ((this.spLimitPrice.getValue().toString().trim().length() <= 0 || this.spLimitPrice.getValue().toString().equalsIgnoreCase("0") || this.spLimitPrice.getValue().toString().equalsIgnoreCase("0.0")) && this.spLimitPrice.isEnabled()) {
            this.spLimitPrice.setValue(price);
        }
    }

    private void orderTypeChange() {
        String orderType = this.cbOrderType.getSelectedItem().toString();
        if (orderType.equalsIgnoreCase("Limit")) {
            this.spLimitPrice.setEnabled(true);
            this.spTriggerPrice.setEnabled(false);
            this.spTriggerPrice.setValue(0);
            this.setPriceFromFeedAndSubcribe(false);
        } else if (orderType.equalsIgnoreCase("Market")) {
            this.spLimitPrice.setEnabled(false);
            this.spTriggerPrice.setEnabled(false);
            this.spLimitPrice.setValue(0);
            this.spTriggerPrice.setValue(0);
        } else if (orderType.equalsIgnoreCase("Stop Loss Limit")) {
            this.spLimitPrice.setEnabled(true);
            this.spTriggerPrice.setEnabled(true);
            this.spTriggerPrice.setValue(0);
            this.setPriceFromFeedAndSubcribe(false);
        } else if (orderType.equalsIgnoreCase("Stop Loss Market")) {
            this.spLimitPrice.setValue(0);
            this.spLimitPrice.setEnabled(false);
            ((NxGSpinner)this.spLimitPrice).setError(false);
            this.spTriggerPrice.setEnabled(true);
            this.spTriggerPrice.setValue(0);
            this.setPriceFromFeedAndSubcribe(false);
        }
    }

    private void sendOrder() {
        if (this.isBasicValide()) {
            this.sendOrderToServer();
        }
    }

    private void openOrderConfirmation() {
        PMEXOrderBean bean = this.getBean();
        PMEX_OrderConfirmation OC = new PMEX_OrderConfirmation(bean, this.cbOrderType.getSelectedItem().toString(), this);
        NxGDialogBox jd = new NxGDialogBox((Frame)TradeCast.getInstance().frame, true);
        try {
            if (AppConfig.houseIcon == null) {
                AppConfig.houseIcon = ImageUtil.downloadImage((String)(AppConfig.TradeCastURL + "/HouseImages/small.png"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        jd.setIconImage(AppConfig.houseIcon);
        jd.getContentPane().add(OC);
        if (bean.getTransactionType().equalsIgnoreCase("Sel")) {
            jd.setTitle("Sell Order Confirmation");
        } else if (bean.getTransactionType().equalsIgnoreCase("Buy")) {
            jd.setTitle("Buy Order Confirmation");
        } else {
            jd.setTitle(bean.getTransactionType() + " Order Confirmation");
        }
        if (Util.isWindow7()) {
            jd.setSize(330, 225);
        } else {
            jd.setSize(330, 220);
        }
        jd.setLocationRelativeTo(null);
        jd.setVisible(true);
    }

    private void sendOrderToServer() {
        String transactionType = this.getType();
        if (transactionType.equalsIgnoreCase(Title.PMEX_Sell.trim())) {
            if (this.cbOrderType.getSelectedItem().toString().equalsIgnoreCase("Limit")) {
                this.sendSellOrder();
            } else if (this.cbOrderType.getSelectedItem().toString().equalsIgnoreCase("Market")) {
                this.sendSellMarketOrder();
            } else if (this.cbOrderType.getSelectedItem().toString().equalsIgnoreCase("Stop Loss Limit")) {
                this.sendSellStopLossLimitOrder();
            } else if (this.cbOrderType.getSelectedItem().toString().equalsIgnoreCase("Stop Loss Market")) {
                this.sendSellStopLossMarketOrder();
            }
        } else if (transactionType.equalsIgnoreCase(Title.PMEX_Buy.trim())) {
            if (this.cbOrderType.getSelectedItem().toString().equalsIgnoreCase("Limit")) {
                this.sendBuyOrder();
            } else if (this.cbOrderType.getSelectedItem().toString().equalsIgnoreCase("Market")) {
                this.sendBuyMarketOrder();
            } else if (this.cbOrderType.getSelectedItem().toString().equalsIgnoreCase("Stop Loss Limit")) {
                this.sendBuyStopLossLimitOrder();
            } else if (this.cbOrderType.getSelectedItem().toString().equalsIgnoreCase("Stop Loss Market")) {
                this.sendBuyStopLossMarketOrder();
            }
        }
    }

    private void sendSellOrder() {
        PMEXOrderBean bean = this.getBean();
        bean.setTransactionType("SEL");
        String orderString = bean.getLimitOrderString();
        this.mediator.SendMsgToTradeServer_PMEX_NewOrder(orderString);
    }

    private void sendSellMarketOrder() {
        PMEXOrderBean bean = this.getBean();
        bean.setTransactionType("SEL");
        String orderString = bean.getMarketOrderString();
        this.mediator.SendMsgToTradeServer_PMEX_NewOrder(orderString);
    }

    private void sendSellStopLossLimitOrder() {
        PMEXOrderBean bean = this.getBean();
        bean.setTransactionType("SEL");
        String orderString = bean.getStopLossLimitOrderString();
        this.mediator.SendMsgToTradeServer_PMEX_NewOrder(orderString);
    }

    private void sendSellStopLossMarketOrder() {
        PMEXOrderBean bean = this.getBean();
        bean.setTransactionType("SEL");
        String orderString = bean.getStopLossMarketOrderString();
        this.mediator.SendMsgToTradeServer_PMEX_NewOrder(orderString);
    }

    private void sendBuyOrder() {
        PMEXOrderBean bean = this.getBean();
        bean.setTransactionType("BUY");
        String orderString = bean.getLimitOrderString();
        this.mediator.SendMsgToTradeServer_PMEX_NewOrder(orderString);
    }

    private void sendBuyMarketOrder() {
        PMEXOrderBean bean = this.getBean();
        bean.setTransactionType("BUY");
        String orderString = bean.getMarketOrderString();
        this.mediator.SendMsgToTradeServer_PMEX_NewOrder(orderString);
    }

    private void sendBuyStopLossLimitOrder() {
        PMEXOrderBean bean = this.getBean();
        bean.setTransactionType("BUY");
        String orderString = bean.getStopLossLimitOrderString();
        this.mediator.SendMsgToTradeServer_PMEX_NewOrder(orderString);
    }

    private void sendBuyStopLossMarketOrder() {
        PMEXOrderBean bean = this.getBean();
        bean.setTransactionType("BUY");
        String orderString = bean.getStopLossMarketOrderString();
        this.mediator.SendMsgToTradeServer_PMEX_NewOrder(orderString);
    }

    private PMEXOrderBean getBean() {
        PMEXOrderBean bean = new PMEXOrderBean();
        bean.setContract(this.getContract());
        bean.setMarket(this.getMarket());
        bean.setIsGoodTillCancel(this.isGTC.isSelected());
        bean.setAccount(this.getSelectedAccount());
        bean.setVolume(Long.parseLong(this.spQuantity.getValue().toString()));
        bean.setLimitPrice(this.getLimitPrice());
        bean.setTriggerPrice(this.getTriggerPrice());
        bean.setPIN(this.txtPinCode.getText());
        bean.setUserName(LogCommon.UserID);
        bean.setUserCode(LogCommon.UserCode);
        bean.setIP(LogCommon.localip);
        bean.setOrderNumber(LogsPMEX.orderNumber++ + "");
        bean.setDateTime(Mediator.getDateTime());
        bean.setTransactionType(this.getType2());
        return bean;
    }

    private String getContract() {
        return this.cbContract.getSelectedItem().toString();
    }

    private String getMarket() {
        return UtilPMEX.GetMarketFromContract((String)this.getContract());
    }

    private double getLimitPrice() {
        return Double.parseDouble(this.spLimitPrice.getValue() + "");
    }

    private double getTriggerPrice() {
        return Double.parseDouble(this.spTriggerPrice.getValue() + "");
    }

    private String getType() {
        return this.cbOrder.getSelectedItem().toString();
    }

    public String getContractWithMarket() {
        if (!this.getContract().equalsIgnoreCase(contractPrompt)) {
            return this.getContract() + ":" + UtilPMEX.GetMarketFromContract((String)this.getContract());
        }
        return "";
    }

    private String getSelectedAccount() {
        if (this.cbAccountNo.getSelectedItem() == null) {
            return "";
        }
        if (this.cbAccountNo.getSelectedItem().toString().trim().equalsIgnoreCase("")) {
            return "";
        }
        return LogsPMEX.accountPrefix + this.cbAccountNo.getSelectedItem().toString().trim();
    }

    private void initComponents() {
        this.cbContract = new NxGComboBox();
        this.cbOrder = new NxGComboBox();
        this.cbOrderType = new NxGComboBox();
        this.isGTC = new JCheckBox();
        this.cbAccountNo = new NxGComboBox();
        this.spQuantity = new NxGSpinner();
        this.spLimitPrice = new NxGSpinner();
        this.spTriggerPrice = new NxGSpinner();
        this.jToolBar1 = new JToolBar();
        this.btnSubmit = new JButton();
        this.btnReset = new JButton();
        this.btnRemove = new JButton();
        this.lblPrefix = new JLabel();
        this.cbContract.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbContract.setOpaque(false);
        this.cbOrder.setModel(new DefaultComboBoxModel<String>(new String[]{"Buy", "Sell"}));
        this.cbOrder.setOpaque(false);
        this.cbOrderType.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbOrderType.setOpaque(false);
        this.cbOrderType.setPreferredSize(new Dimension(55, 20));
        this.isGTC.setBackground(UIManager.getDefaults().getColor("CheckBoxMenuItem.selectionBackground"));
        this.isGTC.setHorizontalAlignment(0);
        this.isGTC.setOpaque(false);
        this.isGTC.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                PMEX_FastOrderPanel.this.isGTCFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                PMEX_FastOrderPanel.this.isGTCFocusLost(evt);
            }
        });
        this.cbAccountNo.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbAccountNo.setOpaque(false);
        this.cbAccountNo.setPreferredSize(new Dimension(55, 20));
        this.spQuantity.setOpaque(false);
        this.spLimitPrice.setOpaque(false);
        this.spTriggerPrice.setOpaque(false);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.btnSubmit.setIcon(new ImageIcon(this.getClass().getResource("/Images/tick.png")));
        this.btnSubmit.setToolTipText("Send Order");
        this.btnSubmit.setHorizontalTextPosition(0);
        this.btnSubmit.setName("PMEX_FastOrderPanel -> btnSubmit");
        this.btnSubmit.setOpaque(false);
        this.btnSubmit.setPreferredSize(new Dimension(43, 23));
        this.btnSubmit.setVerticalTextPosition(3);
        this.btnSubmit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PMEX_FastOrderPanel.this.btnSubmitActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnSubmit);
        this.btnReset.setIcon(new ImageIcon(this.getClass().getResource("/Images/refresh.png")));
        this.btnReset.setToolTipText("Reset Values");
        this.btnReset.setHorizontalTextPosition(0);
        this.btnReset.setName("PMEX_FastOrderPanel -> Reset");
        this.btnReset.setOpaque(false);
        this.btnReset.setVerticalTextPosition(3);
        this.btnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PMEX_FastOrderPanel.this.btnResetActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnReset);
        this.btnRemove.setIcon(new ImageIcon(this.getClass().getResource("/Images/close12x12.png")));
        this.btnRemove.setToolTipText("Remove");
        this.btnRemove.setHorizontalTextPosition(0);
        this.btnRemove.setName("PMEX_FastOrderPanel -> btnRemove");
        this.btnRemove.setOpaque(false);
        this.btnRemove.setVerticalTextPosition(3);
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PMEX_FastOrderPanel.this.btnRemoveActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.btnRemove);
        this.lblPrefix.setHorizontalAlignment(4);
        this.lblPrefix.setText("Account");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.cbContract, -2, 147, -2).addGap(6, 6, 6).addComponent(this.cbOrder, -2, 50, -2).addGap(6, 6, 6).addComponent(this.cbOrderType, -2, 110, -2).addGap(10, 10, 10).addComponent(this.lblPrefix, -2, 48, -2).addGap(0, 0, 0).addComponent(this.cbAccountNo, 0, -1, Short.MAX_VALUE).addGap(6, 6, 6).addComponent(this.isGTC, -2, 30, -2).addGap(6, 6, 6).addComponent(this.spQuantity, -2, 65, -2).addGap(6, 6, 6).addComponent(this.spLimitPrice, -2, 65, -2).addGap(6, 6, 6).addComponent(this.spTriggerPrice, -2, 65, -2).addGap(6, 6, 6).addComponent(this.jToolBar1, -2, 66, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.cbContract, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.cbOrder, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.cbOrderType, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.lblPrefix, -2, 20, -2)).addGroup(layout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.cbAccountNo, -2, -1, -2)).addComponent(this.isGTC).addGroup(layout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.spQuantity, -2, 20, -2)).addGroup(layout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.spLimitPrice, -2, 20, -2)).addGroup(layout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.spTriggerPrice, -2, 20, -2)).addGroup(layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.jToolBar1, -2, 20, -2)));
    }

    private void btnRemoveActionPerformed(ActionEvent evt) {
        this.fastOrder.removeOrdePanel(this.getID());
    }

    private void btnSubmitActionPerformed(ActionEvent evt) {
        this.sendOrder();
    }

    private void btnResetActionPerformed(ActionEvent evt) {
        this.resetValues();
    }

    private void isGTCFocusGained(FocusEvent evt) {
        this.isGTC.setOpaque(true);
    }

    private void isGTCFocusLost(FocusEvent evt) {
        this.isGTC.setOpaque(false);
    }

    public void addContract() {
        if (this.autoCompleteContract != null && this.autoCompleteContract.isInstalled()) {
            this.autoCompleteContract.uninstall();
        }
        ArrayList v = new ArrayList(LogsPMEX.PMEX_CONTRACT_ALL.keySet());
        Collections.sort(v);
        v.add(0, contractPrompt);
        this.autoCompleteContract = AutoCompleteSupport.install((JComboBox)this.cbContract, (EventList)GlazedLists.eventListOf((Object[])v.toArray()));
        this.autoCompleteContract.setStrict(false);
        this.cbContract.setSelectedItem(contractPrompt);
    }

    public int getID() {
        return this.ID;
    }

    private boolean isBasicValide() {
        this.resetError();
        String cont = ((NxGComboBox)this.cbContract).getSelectedItem().toString();
        String order = ((NxGComboBox)this.cbOrder).getSelectedItem().toString();
        String orderType = ((NxGComboBox)this.cbOrderType).getSelectedItem().toString();
        String accountNo = this.getSelectedAccount();
        if (cont.equalsIgnoreCase("") || cont.equalsIgnoreCase(contractPrompt)) {
            ((NxGComboBox)this.cbContract).setError(true);
            ((NxGComboBox)this.cbContract).requestFocus();
            return false;
        }
        if (order.equalsIgnoreCase("")) {
            ((NxGComboBox)this.cbOrder).setError(true);
            ((NxGComboBox)this.cbOrder).requestFocus();
            return false;
        }
        if (orderType.equalsIgnoreCase("")) {
            ((NxGComboBox)this.cbOrderType).setError(true);
            ((NxGComboBox)this.cbOrderType).requestFocus();
            return false;
        }
        if (accountNo.equalsIgnoreCase("")) {
            ((NxGComboBox)this.cbAccountNo).setError(true);
            ((NxGComboBox)this.cbAccountNo).requestFocus();
            return false;
        }
        if (!LogsPMEX.ALL_ACCOUNTS.containsKey(this.getSelectedAccount())) {
            ((NxGComboBox)this.cbAccountNo).setError(true);
            ((NxGComboBox)this.cbAccountNo).requestFocus();
            return false;
        }
        if (this.spQuantity.getValue().toString().trim().length() <= 0 || this.spQuantity.getValue().toString().equalsIgnoreCase("0") || this.spQuantity.getValue().toString().equalsIgnoreCase("0.0")) {
            ((NxGSpinner)this.spQuantity).setError(true);
            ((JSpinner.DefaultEditor)this.spQuantity.getEditor()).getTextField().requestFocus();
            return false;
        }
        if ((this.spLimitPrice.getValue().toString().trim().length() <= 0 || this.spLimitPrice.getValue().toString().equalsIgnoreCase("0") || this.spLimitPrice.getValue().toString().equalsIgnoreCase("0.0")) && this.spLimitPrice.isEnabled()) {
            ((NxGSpinner)this.spLimitPrice).setError(true);
            ((JSpinner.DefaultEditor)this.spLimitPrice.getEditor()).getTextField().requestFocus();
            return false;
        }
        if ((this.spTriggerPrice.getValue().toString().trim().length() <= 0 || this.spTriggerPrice.getValue().toString().equalsIgnoreCase("0") || this.spTriggerPrice.getValue().toString().equalsIgnoreCase("0.0")) && this.spTriggerPrice.isEnabled()) {
            ((NxGSpinner)this.spTriggerPrice).setError(true);
            ((JSpinner.DefaultEditor)this.spTriggerPrice.getEditor()).getTextField().requestFocus();
            return false;
        }
        if (this.txtPinCode.getText().trim().length() <= 0) {
            this.txtPinCode.setError(true);
            this.txtPinCode.requestFocus();
            return false;
        }
        this.btnSubmit.requestFocus();
        return true;
    }

    private String getType2() {
        if (this.getType().equalsIgnoreCase("Buy")) {
            return "BUY";
        }
        return "SEL";
    }

    public void MessageSent(boolean b) {
        if (b) {
            this.sendOrderToServer();
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.cbContract) {
            if (evt.getModifiers() == 16 || evt.getActionCommand().equalsIgnoreCase("comboBoxEdited")) {
                this.spLimitPrice.setValue(0);
                if (this.cbContract.getSelectedItem().toString().trim().length() <= 0 || this.cbContract.getSelectedItem().toString().equalsIgnoreCase(contractPrompt)) {
                    ((NxGComboBox)this.cbContract).setError(true);
                    this.cbContract.requestFocus();
                } else {
                    ((NxGComboBox)this.cbContract).setError(false);
                    this.cbOrder.requestFocus();
                    this.setPriceFromFeedAndSubcribe(true);
                }
            }
        } else if (source == this.cbOrder) {
            if (evt.getModifiers() == 16 || evt.getActionCommand().equalsIgnoreCase("comboBoxEdited")) {
                if (this.cbOrder.getSelectedItem().toString().trim().length() <= 0) {
                    ((NxGComboBox)this.cbOrder).setError(true);
                    this.cbOrder.requestFocus();
                } else {
                    ((NxGComboBox)this.cbOrder).setError(false);
                    this.cbOrderType.requestFocus();
                }
            }
        } else if (source == this.cbOrderType) {
            if (evt.getModifiers() == 16 || evt.getActionCommand().equalsIgnoreCase("comboBoxEdited")) {
                if (this.cbOrderType.getSelectedItem().toString().trim().length() <= 0) {
                    ((NxGComboBox)this.cbOrderType).setError(true);
                    this.cbOrderType.requestFocus();
                } else {
                    this.orderTypeChange();
                    ((NxGComboBox)this.cbOrderType).setError(false);
                    this.cbAccountNo.requestFocus();
                }
            }
        } else if (source == this.cbAccountNo && (evt.getModifiers() == 16 || evt.getActionCommand().equalsIgnoreCase("comboBoxEdited"))) {
            if (this.cbAccountNo.getSelectedItem().toString().trim().length() <= 0) {
                ((NxGComboBox)this.cbAccountNo).setError(true);
                this.cbAccountNo.requestFocus();
            } else {
                ((NxGComboBox)this.cbAccountNo).setError(false);
                this.isGTC.requestFocus();
            }
        }
    }
}

