/*
 * Decompiled with CFR 0.152.
 */
package windows.pmex.order;

import CATALYST.Control.MarketFeed;
import CATALYST.Control.MarketWatch;
import CustomComponent.DocumentType;
import CustomComponent.ForgetMouseListner;
import CustomComponent.NxGComboBox;
import CustomComponent.NxGPassword;
import CustomComponent.NxGSpinner;
import CustomComponent.NxGTextField;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import Orders.OrderOption;
import RendersNModels.ComboBoxToolTipRender;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.bean.AccountBean;
import common.gui.component.NxGDialogBox;
import common.gui.util.AppConfig;
import common.gui.util.ImageUtil;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.MyColors;
import common.gui.util.Title;
import common.gui.util.Util;
import common.interfaces.AddContract;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.text.AbstractDocument;
import pmex.gui.bean.PMEXMarketFeedBean;
import pmex.gui.bean.PMEXOrderBean;
import pmex.gui.bean.WorkingOrderBean;
import pmex.gui.util.LogsPMEX;
import pmex.gui.util.UtilPMEX;
import windows.pmex.buyingpower.DocumentSizeAndUppercaseFilter;
import windows.pmex.order.PMEX_OrderConfirmation;

public class PMEX_OrderBase
extends JPanel
implements ActionListener,
AddContract {
    private Mediator mediator = Mediator.getInstance();
    private AutoCompleteSupport autoCom;
    private AutoCompleteSupport autoComOrderType;
    private final SpinnerNumberModel QuantityModel = new SpinnerNumberModel(0, 0, 1000000, 10);
    private final SpinnerNumberModel LimitPriceModel = new SpinnerNumberModel(0.0, 0.0, 1000000.0, 0.01);
    private final SpinnerNumberModel TriggerPriceModel = new SpinnerNumberModel(0.0, 0.0, 1000000.0, 0.01);
    private WorkingOrderBean workingOrderBean = null;
    private String type;
    boolean isFirstTimeBuy = true;
    boolean isFirstTimeBuyVol = true;
    boolean isFirstTimeSell = true;
    boolean isFirstTimeSellVol = true;
    final int schDelay = 2000;
    private Timer Timer_Buy = new Timer(2000, null);
    private Timer Timer_BuyVol = new Timer(2000, null);
    private Timer Timer_Sell = new Timer(2000, null);
    private Timer Timer_SellVol = new Timer(2000, null);
    private Color disableColor = Color.LIGHT_GRAY.brighter();
    private JButton btnOrder;
    private NxGComboBox cbAccountNo;
    private NxGComboBox cbContract;
    private NxGComboBox cbOrderType;
    private JCheckBox isGTC;
    private JCheckBox isSavePIN;
    private JLabel jLabel7;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel lblAccount;
    private JLabel lblContract;
    private JLabel lblForgetPinCode;
    private JLabel lblGTC;
    private JLabel lblLimitPrice;
    private JLabel lblMessage;
    private JLabel lblOrderType;
    private JLabel lblPrefix;
    private JLabel lblQuantity;
    private JLabel lblSettings;
    private JLabel lblTriggerPrice;
    private JLabel lblfBuy;
    private JLabel lblfBuyVolume;
    private JLabel lblfChange;
    private JLabel lblfHigh;
    private JLabel lblfLastTrade;
    private JLabel lblfLow;
    private JLabel lblfSell;
    private JLabel lblfSellVolume;
    private JLabel lblfTotalVolume;
    private NxGSpinner spLimitPrice;
    private NxGSpinner spQuantity;
    private NxGSpinner spTriggerPrice;
    private NxGPassword txtPinCode;
    private NxGTextField txtfBuy;
    private NxGTextField txtfBuyVolume;
    private NxGTextField txtfChange;
    private NxGTextField txtfHigh;
    private NxGTextField txtfLastTrade;
    private NxGTextField txtfLow;
    private NxGTextField txtfSell;
    private NxGTextField txtfSellVolume;
    private NxGTextField txtfTotalVolume;

    public PMEX_OrderBase(String type) {
        this.initComponents();
        this.spTriggerPrice.setEnabled(false);
        ForgetMouseListner forgetMouseListner = new ForgetMouseListner(this.lblForgetPinCode);
        this.lblForgetPinCode.addMouseListener(forgetMouseListner);
        this.lblForgetPinCode.setText("<html>Forgot PIN?</html>");
        this.lblForgetPinCode.setForeground(MyColors.ForgotPincodeFG);
        if (type.equalsIgnoreCase(Title.PMEX_Sell)) {
            this.setBackground(MyColors.SellBG);
            this.btnOrder.setText(Title.PMEX_Sell);
            this.setOrderTypes(Title.PMEX_Sell);
            this.type = "SEL";
        } else if (type.equalsIgnoreCase(Title.PMEX_Buy)) {
            this.setBackground(MyColors.BuyBG);
            this.btnOrder.setText(Title.PMEX_Buy);
            this.setOrderTypes(Title.PMEX_Buy);
            this.type = "BUY";
        }
        this.setThis();
        this.setModels();
        this.setForDocument();
        this.setListener();
        this.setAccounts();
        this.addContract();
        this.setOrderOptions(LogCommon.PMEX_OrderOption);
        this.setTrillingStopValues(false);
        this.resetFeedValues();
        this.SetTimer(this.txtfBuyVolume, this.Timer_BuyVol);
        this.SetTimer(this.txtfBuy, this.Timer_Buy);
        this.SetTimer(this.txtfSellVolume, this.Timer_SellVol);
        this.SetTimer(this.txtfSell, this.Timer_Sell);
        this.setDefaultColors();
        this.cbContract.setSelectedItem(LogsPMEX.SelectedSymbol);
        this.cbContract.requestFocus();
        if (LogCommon.pinCode.length() > 0) {
            this.txtPinCode.setText(LogCommon.pinCode);
            this.isSavePIN.setSelected(true);
        }
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
        this.FeedRecieved(false);
    }

    private void setThis() {
        this.mediator.setPMEXBuySell(this);
        LogsPMEX.CONTRACT_HOLDER.add(this);
    }

    private void setModels() {
        this.spQuantity.setModel(this.QuantityModel);
        this.spLimitPrice.setModel(this.LimitPriceModel);
        this.spTriggerPrice.setModel(this.TriggerPriceModel);
    }

    private void setForDocument() {
        this.txtPinCode.setDocument(DocumentType.NUMERIC, 4);
    }

    private void setListener() {
        this.btnOrder.addActionListener(this);
        this.cbContract.addActionListener(this);
        this.cbOrderType.addActionListener(this);
        this.isGTC.addActionListener(this);
        this.cbAccountNo.addActionListener(this);
        this.txtPinCode.addActionListener(this);
        ((JSpinner.DefaultEditor)this.spLimitPrice.getEditor()).getTextField().setFocusTraversalKeys(0, Collections.EMPTY_SET);
        ((JSpinner.DefaultEditor)this.spQuantity.getEditor()).getTextField().setFocusTraversalKeys(0, Collections.EMPTY_SET);
        ((JSpinner.DefaultEditor)this.spTriggerPrice.getEditor()).getTextField().setFocusTraversalKeys(0, Collections.EMPTY_SET);
        ((JSpinner.DefaultEditor)this.spQuantity.getEditor()).getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                super.keyPressed(evt);
                if (evt.getKeyCode() == 10 || evt.getKeyCode() == 9) {
                    String val = ((JSpinner.DefaultEditor)PMEX_OrderBase.this.spQuantity.getEditor()).getTextField().getText();
                    if (val.trim().length() <= 0 || val.equalsIgnoreCase("0") || val.equalsIgnoreCase("0.0")) {
                        PMEX_OrderBase.this.spQuantity.setError(true);
                        ((JSpinner.DefaultEditor)PMEX_OrderBase.this.spQuantity.getEditor()).getTextField().requestFocus();
                        Util.setMessage((JLabel)PMEX_OrderBase.this.lblMessage, (MessageType)MessageType.Information, (String)"Quantity Required.");
                    } else {
                        PMEX_OrderBase.this.spQuantity.setError(false);
                        if (PMEX_OrderBase.this.spLimitPrice.isEnabled()) {
                            ((JSpinner.DefaultEditor)PMEX_OrderBase.this.spLimitPrice.getEditor()).getTextField().requestFocus();
                        } else {
                            PMEX_OrderBase.this.txtPinCode.requestFocus();
                        }
                        Util.setMessage((JLabel)PMEX_OrderBase.this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
                    }
                }
            }
        });
        ((JSpinner.DefaultEditor)this.spLimitPrice.getEditor()).getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                super.keyPressed(evt);
                if (evt.getKeyCode() == 10 || evt.getKeyCode() == 9) {
                    String val = ((JSpinner.DefaultEditor)PMEX_OrderBase.this.spLimitPrice.getEditor()).getTextField().getText();
                    if (val.trim().length() <= 0 || val.equalsIgnoreCase("0") || val.equalsIgnoreCase("0.0")) {
                        PMEX_OrderBase.this.spLimitPrice.setError(true);
                        ((JSpinner.DefaultEditor)PMEX_OrderBase.this.spLimitPrice.getEditor()).getTextField().requestFocus();
                        Util.setMessage((JLabel)PMEX_OrderBase.this.lblMessage, (MessageType)MessageType.Information, (String)"Price Required.");
                        PMEX_OrderBase.this.setPriceFromFeedAndSubcribe(false);
                    } else {
                        PMEX_OrderBase.this.spLimitPrice.setError(false);
                        if (PMEX_OrderBase.this.spTriggerPrice.isEnabled()) {
                            ((JSpinner.DefaultEditor)PMEX_OrderBase.this.spTriggerPrice.getEditor()).getTextField().requestFocus();
                        } else {
                            PMEX_OrderBase.this.txtPinCode.requestFocus();
                        }
                        Util.setMessage((JLabel)PMEX_OrderBase.this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
                    }
                }
            }
        });
        ((JSpinner.DefaultEditor)this.spTriggerPrice.getEditor()).getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                super.keyPressed(evt);
                if (evt.getKeyCode() == 10 || evt.getKeyCode() == 9) {
                    String val = ((JSpinner.DefaultEditor)PMEX_OrderBase.this.spTriggerPrice.getEditor()).getTextField().getText();
                    if (val.trim().length() <= 0 || val.equalsIgnoreCase("0") || val.equalsIgnoreCase("0.0")) {
                        PMEX_OrderBase.this.spTriggerPrice.setError(true);
                        ((JSpinner.DefaultEditor)PMEX_OrderBase.this.spTriggerPrice.getEditor()).getTextField().requestFocus();
                        Util.setMessage((JLabel)PMEX_OrderBase.this.lblMessage, (MessageType)MessageType.Information, (String)"Limit Price Required.");
                    } else {
                        PMEX_OrderBase.this.spTriggerPrice.setError(false);
                        PMEX_OrderBase.this.txtPinCode.requestFocus();
                        Util.setMessage((JLabel)PMEX_OrderBase.this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
                    }
                }
            }
        });
        ((JSpinner.DefaultEditor)this.spQuantity.getEditor()).getTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                PMEX_OrderBase.this.spinnerSetTextSelected(e);
            }
        });
        ((JSpinner.DefaultEditor)this.spLimitPrice.getEditor()).getTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                PMEX_OrderBase.this.spinnerSetTextSelected(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                String val = ((JSpinner.DefaultEditor)PMEX_OrderBase.this.spLimitPrice.getEditor()).getTextField().getText();
                if (val.trim().length() <= 0 || val.equalsIgnoreCase("0") || val.equalsIgnoreCase("0.0")) {
                    PMEX_OrderBase.this.setPriceFromFeedAndSubcribe(false);
                }
            }
        });
        ((JSpinner.DefaultEditor)this.spTriggerPrice.getEditor()).getTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                PMEX_OrderBase.this.spinnerSetTextSelected(e);
            }
        });
        this.isGTC.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                super.keyPressed(e);
                if (e.getKeyCode() == 10) {
                    PMEX_OrderBase.this.cbAccountNo.requestFocus();
                }
            }
        });
    }

    private void spinnerSetTextSelected(FocusEvent e) {
        JFormattedTextField textField = (JFormattedTextField)e.getComponent();
        textField.setText(textField.getText());
        textField.selectAll();
    }

    private void setOrderTypes(String windowType) {
        if (this.autoComOrderType != null && this.autoComOrderType.isInstalled()) {
            this.autoComOrderType.uninstall();
        }
        if (windowType.equalsIgnoreCase(Title.PMEX_Sell)) {
            this.cbOrderType.setModel(new DefaultComboBoxModel<String>(LogsPMEX.OrderTypesSell));
            this.autoComOrderType = AutoCompleteSupport.install((JComboBox)this.cbOrderType, (EventList)GlazedLists.eventListOf((Object[])LogsPMEX.OrderTypesSell));
        } else if (windowType.equalsIgnoreCase(Title.PMEX_Buy)) {
            this.cbOrderType.setModel(new DefaultComboBoxModel<String>(LogsPMEX.OrderTypesBuy));
            this.autoComOrderType = AutoCompleteSupport.install((JComboBox)this.cbOrderType, (EventList)GlazedLists.eventListOf((Object[])LogsPMEX.OrderTypesBuy));
        }
        this.cbOrderType.setSelectedItem("Limit");
    }

    private void setAccounts() {
        if (LogsPMEX.accountPrefix.length() > 0) {
            this.lblPrefix.setText(LogsPMEX.accountPrefix);
        } else {
            this.cbAccountNo.setBounds(90, 95, 130, 23);
            this.lblPrefix.setVisible(false);
            this.lblPrefix.setText(" ");
        }
        Iterator en = LogsPMEX.ALL_ACCOUNTS.keySet().iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (en.hasNext()) {
            String key = en.next().toString();
            AccountBean ac = (AccountBean)LogsPMEX.ALL_ACCOUNTS.get(key);
            if (ac.getAccountNo().indexOf(LogsPMEX.accountPrefix) == 0) {
                list.add(ac.getAccountNo().replaceFirst(LogsPMEX.accountPrefix, ""));
                continue;
            }
            list.add(ac.getAccountNo());
        }
        this.cbAccountNo.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        AutoCompleteSupport support = AutoCompleteSupport.install((JComboBox)this.cbAccountNo, (EventList)GlazedLists.eventListOf((Object[])list.toArray()));
        support.setStrict(false);
        this.cbAccountNo.setRenderer(new ComboBoxToolTipRender(LogsPMEX.ALL_ACCOUNTS, LogsPMEX.accountPrefix));
        this.cbAccountNo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    PMEX_OrderBase.this.cbAccountNo.setToolTipText(((AccountBean)LogsPMEX.ALL_ACCOUNTS.get(LogsPMEX.accountPrefix + PMEX_OrderBase.this.cbAccountNo.getSelectedItem().toString().trim())).toString());
                }
                catch (Exception ex) {
                    PMEX_OrderBase.this.cbAccountNo.setToolTipText(null);
                }
            }
        });
        try {
            if (this.cbAccountNo.getItemCount() > 0) {
                if (LogCommon.preferredAccountPMEX.trim().length() > 0) {
                    this.cbAccountNo.setSelectedItem(LogCommon.preferredAccountPMEX.replaceFirst(LogsPMEX.accountPrefix, ""));
                } else {
                    this.cbAccountNo.setSelectedItem("");
                }
            } else {
                this.cbAccountNo.setSelectedItem("");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        AbstractDocument d = (AbstractDocument)((JTextField)this.cbAccountNo.getEditor().getEditorComponent()).getDocument();
        d.setDocumentFilter(new DocumentSizeAndUppercaseFilter(4));
    }

    private boolean isBasicValide() {
        boolean status = false;
        this.resetError();
        if (this.cbContract.getSelectedItem().toString().trim().length() <= 0) {
            this.cbContract.setError(true);
            this.cbContract.requestFocus();
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Contract Required.");
        } else if (this.cbOrderType.getSelectedItem().toString().trim().length() <= 0) {
            this.cbOrderType.setError(true);
            this.cbOrderType.requestFocus();
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Order Type Required.");
        } else if (this.cbAccountNo.getSelectedItem().toString().trim().length() <= 0) {
            this.cbAccountNo.setError(true);
            this.cbAccountNo.requestFocus();
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Account Required.");
        } else if (!LogsPMEX.ALL_ACCOUNTS.containsKey(this.getSelectedAccount())) {
            this.cbAccountNo.setError(true);
            this.cbAccountNo.requestFocus();
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)("Account \"" + this.getSelectedAccount() + "\" is not assign to " + LogCommon.UserID));
        } else if (this.spQuantity.getValue().toString().trim().length() <= 0 || this.spQuantity.getValue().toString().equalsIgnoreCase("0") || this.spQuantity.getValue().toString().equalsIgnoreCase("0.0")) {
            this.spQuantity.setError(true);
            ((JSpinner.DefaultEditor)this.spQuantity.getEditor()).getTextField().requestFocus();
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Quantity Required.");
        } else if ((this.spLimitPrice.getValue().toString().trim().length() <= 0 || this.spLimitPrice.getValue().toString().equalsIgnoreCase("0") || this.spLimitPrice.getValue().toString().equalsIgnoreCase("0.0")) && this.spLimitPrice.isEnabled()) {
            this.spLimitPrice.setError(true);
            ((JSpinner.DefaultEditor)this.spLimitPrice.getEditor()).getTextField().requestFocus();
            if (this.cbOrderType.getSelectedItem().toString().equalsIgnoreCase("Trailling Stop Market")) {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Distance Required.");
            } else {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Price Required.");
            }
        } else if ((this.spTriggerPrice.getValue().toString().trim().length() <= 0 || this.spTriggerPrice.getValue().toString().equalsIgnoreCase("0") || this.spTriggerPrice.getValue().toString().equalsIgnoreCase("0.0")) && this.spTriggerPrice.isEnabled()) {
            this.spTriggerPrice.setError(true);
            ((JSpinner.DefaultEditor)this.spTriggerPrice.getEditor()).getTextField().requestFocus();
            if (this.cbOrderType.getSelectedItem().toString().equalsIgnoreCase("Trailling Stop Market")) {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Trilling Step Required.");
            } else {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Limit Price Required.");
            }
        } else if (this.txtPinCode.getText().trim().length() <= 0) {
            this.txtPinCode.setError(true);
            this.txtPinCode.requestFocus();
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"PIN Required.");
        } else {
            status = true;
            this.resetError();
        }
        return status;
    }

    private PMEXOrderBean getBean() {
        PMEXOrderBean bean = new PMEXOrderBean();
        bean.setContract(this.getContract());
        bean.setMarket(this.getMarket());
        bean.setIsGoodTillCancel(this.isGTC.isSelected());
        bean.setAccount(this.getSelectedAccount());
        bean.setVolume(Long.parseLong(this.spQuantity.getValue().toString()));
        bean.setLimitPrice(this.getLimitPrice());
        bean.setTriggerPrice(this.getTriggerPrice());
        bean.setPIN(this.txtPinCode.getText());
        bean.setUserName(LogCommon.UserID);
        bean.setUserCode(LogCommon.UserCode);
        bean.setIP(LogCommon.localip);
        bean.setDistance(this.getDistance());
        bean.setTrailingStep(this.getTrillingStep());
        bean.setOrderNumber(LogsPMEX.orderNumber++ + "");
        bean.setDateTime(Mediator.getDateTime());
        bean.setTransactionType(this.type);
        return bean;
    }

    private void sendSellOrder() {
        PMEXOrderBean bean = this.getBean();
        bean.setTransactionType("SEL");
        String orderString = bean.getLimitOrderString();
        this.mediator.SendMsgToTradeServer_PMEX_NewOrder(orderString);
        this.resetValues();
    }

    private void sendSellMarketOrder() {
        PMEXOrderBean bean = this.getBean();
        bean.setTransactionType("SEL");
        String orderString = bean.getMarketOrderString();
        this.mediator.SendMsgToTradeServer_PMEX_NewOrder(orderString);
        this.resetValues();
    }

    private void sendSellStopLossLimitOrder() {
        PMEXOrderBean bean = this.getBean();
        bean.setTransactionType("SEL");
        String orderString = bean.getStopLossLimitOrderString();
        this.mediator.SendMsgToTradeServer_PMEX_NewOrder(orderString);
        this.resetValues();
    }

    private void sendSellStopLossMarketOrder() {
        PMEXOrderBean bean = this.getBean();
        bean.setTransactionType("SEL");
        String orderString = bean.getStopLossMarketOrderString();
        this.mediator.SendMsgToTradeServer_PMEX_NewOrder(orderString);
        this.resetValues();
    }

    private void sendSellTrillingStopOrder() {
        PMEXOrderBean bean = this.getBean();
        bean.setTransactionType("SEL");
        String orderString = bean.getTrillingStopOrder();
        this.mediator.SendMsgToTradeServer_PMEX_NewOrder(orderString);
        this.resetValues();
    }

    private void sendBuyTrillingStopOrder() {
        PMEXOrderBean bean = this.getBean();
        bean.setTransactionType("BUY");
        String orderString = bean.getTrillingStopOrder();
        this.mediator.SendMsgToTradeServer_PMEX_NewOrder(orderString);
        this.resetValues();
    }

    private void sendBuyOrder() {
        PMEXOrderBean bean = this.getBean();
        bean.setTransactionType("BUY");
        String orderString = bean.getLimitOrderString();
        this.mediator.SendMsgToTradeServer_PMEX_NewOrder(orderString);
        this.resetValues();
    }

    private void sendBuyMarketOrder() {
        PMEXOrderBean bean = this.getBean();
        bean.setTransactionType("BUY");
        String orderString = bean.getMarketOrderString();
        this.mediator.SendMsgToTradeServer_PMEX_NewOrder(orderString);
        this.resetValues();
    }

    private void sendBuyStopLossLimitOrder() {
        PMEXOrderBean bean = this.getBean();
        bean.setTransactionType("BUY");
        String orderString = bean.getStopLossLimitOrderString();
        this.mediator.SendMsgToTradeServer_PMEX_NewOrder(orderString);
        this.resetValues();
    }

    private void sendBuyStopLossMarketOrder() {
        PMEXOrderBean bean = this.getBean();
        bean.setTransactionType("BUY");
        String orderString = bean.getStopLossMarketOrderString();
        this.mediator.SendMsgToTradeServer_PMEX_NewOrder(orderString);
        this.resetValues();
    }

    private void sendSellCancelReplace() {
        PMEXOrderBean bean = this.getBean();
        bean.setTransactionType("SEL");
        if (LogsPMEX.OrderTypes.containsKey(this.workingOrderBean.getOrderType())) {
            String orderString = bean.getCancelRepalceOrderString(this.workingOrderBean, (String)LogsPMEX.OrderTypes.get(this.workingOrderBean.getOrderType()));
            this.mediator.SendMsgToTradeServer_PMEX_CancelRepalceOrder(orderString);
        } else {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)("Invalid Order Type " + this.workingOrderBean.getOrderType()));
        }
        this.resetValues();
    }

    private void sendBuyCancelReplace() {
        PMEXOrderBean bean = this.getBean();
        bean.setTransactionType("BUY");
        if (LogsPMEX.OrderTypes.containsKey(this.workingOrderBean.getOrderType())) {
            String orderString = bean.getCancelRepalceOrderString(this.workingOrderBean, (String)LogsPMEX.OrderTypes.get(this.workingOrderBean.getOrderType()));
            this.mediator.SendMsgToTradeServer_PMEX_CancelRepalceOrder(orderString);
        } else {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)("Invalid Order Type " + this.workingOrderBean.getOrderType()));
        }
        this.resetValues();
    }

    private void sendOrder() {
        if (this.isBasicValide()) {
            if (LogCommon.isConfirmation) {
                this.openOrderConfirmation();
            } else {
                this.sendOrderToServer();
            }
        }
    }

    private void sendOrderToServer() {
        String transactionType = this.btnOrder.getText().trim();
        if (this.workingOrderBean == null) {
            if (transactionType.equalsIgnoreCase(Title.PMEX_Sell.trim())) {
                if (this.cbOrderType.getSelectedItem().toString().equalsIgnoreCase("Limit")) {
                    this.sendSellOrder();
                } else if (this.cbOrderType.getSelectedItem().toString().equalsIgnoreCase("Market")) {
                    this.sendSellMarketOrder();
                } else if (this.cbOrderType.getSelectedItem().toString().equalsIgnoreCase("Stop Loss Limit")) {
                    this.sendSellStopLossLimitOrder();
                } else if (this.cbOrderType.getSelectedItem().toString().equalsIgnoreCase("Stop Loss Market")) {
                    this.sendSellStopLossMarketOrder();
                } else if (this.cbOrderType.getSelectedItem().toString().equalsIgnoreCase("Trailling Stop Market")) {
                    this.sendSellTrillingStopOrder();
                }
            } else if (transactionType.equalsIgnoreCase(Title.PMEX_Buy.trim())) {
                if (this.cbOrderType.getSelectedItem().toString().equalsIgnoreCase("Limit")) {
                    this.sendBuyOrder();
                } else if (this.cbOrderType.getSelectedItem().toString().equalsIgnoreCase("Market")) {
                    this.sendBuyMarketOrder();
                } else if (this.cbOrderType.getSelectedItem().toString().equalsIgnoreCase("Stop Loss Limit")) {
                    this.sendBuyStopLossLimitOrder();
                } else if (this.cbOrderType.getSelectedItem().toString().equalsIgnoreCase("Stop Loss Market")) {
                    this.sendBuyStopLossMarketOrder();
                } else if (this.cbOrderType.getSelectedItem().toString().equalsIgnoreCase("Trailling Stop Market")) {
                    this.sendBuyTrillingStopOrder();
                }
            }
        } else if (this.workingOrderBean != null) {
            if (transactionType.equalsIgnoreCase(Title.PMEX_Sell.trim())) {
                this.sendSellCancelReplace();
            } else if (transactionType.equalsIgnoreCase(Title.PMEX_Buy.trim())) {
                this.sendBuyCancelReplace();
            }
        }
    }

    private void resetValues() {
        this.cbOrderType.setSelectedItem("Limit");
        this.isGTC.setSelected(false);
        this.spQuantity.setValue(0);
        this.spTriggerPrice.setEnabled(false);
        this.spLimitPrice.setEnabled(true);
        this.spLimitPrice.setValue(0);
        this.spTriggerPrice.setValue(0);
        if (!this.isSavePIN.isSelected()) {
            this.txtPinCode.setText("");
        }
        this.cbContract.requestFocus();
        this.workingOrderBean = null;
        this.setOrderOptions(LogCommon.PMEX_OrderOption);
        this.setEnable(true);
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
        this.resetError();
    }

    private void resetError() {
        this.cbContract.setError(false);
        this.cbOrderType.setError(false);
        this.cbAccountNo.setError(false);
        this.spQuantity.setError(false);
        this.spLimitPrice.setError(false);
        this.spTriggerPrice.setError(false);
        this.txtPinCode.setError(false);
    }

    private void setEnable(boolean isEnable) {
        this.cbAccountNo.setEnabled(isEnable);
        this.cbContract.setEnabled(isEnable);
        this.cbOrderType.setEnabled(isEnable);
        this.isGTC.setEnabled(true);
        this.cbContract.requestFocus();
    }

    private String getSelectedAccount() {
        if (this.cbAccountNo.getSelectedItem() == null) {
            return "";
        }
        if (this.cbAccountNo.getSelectedItem().toString().trim().equalsIgnoreCase("")) {
            return "";
        }
        return LogsPMEX.accountPrefix + this.cbAccountNo.getSelectedItem().toString().trim();
    }

    public String getContractWithMarket() {
        return this.getContract() + ":" + UtilPMEX.GetMarketFromContract((String)this.getContract());
    }

    private String getContract() {
        return this.cbContract.getSelectedItem().toString();
    }

    private String getMarket() {
        return UtilPMEX.GetMarketFromContract((String)this.getContract());
    }

    private double getLimitPrice() {
        try {
            return Double.parseDouble(this.spLimitPrice.getValue() + "");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1.0;
        }
    }

    private double getTriggerPrice() {
        try {
            return Double.parseDouble(this.spTriggerPrice.getValue() + "");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1.0;
        }
    }

    private double getDistance() {
        try {
            return Double.parseDouble(this.spLimitPrice.getValue() + "");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1.0;
        }
    }

    private double getTrillingStep() {
        try {
            return Double.parseDouble(this.spTriggerPrice.getValue() + "");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1.0;
        }
    }

    private void orderTypeChange() {
        String orderType = this.cbOrderType.getSelectedItem().toString();
        if (orderType.equalsIgnoreCase("Limit")) {
            this.spLimitPrice.setEnabled(true);
            this.spTriggerPrice.setEnabled(false);
            this.spTriggerPrice.setValue(0);
            this.isGTC.setEnabled(true);
            this.setPriceFromFeedAndSubcribe(false);
            this.setTrillingStopValues(false);
        } else if (orderType.equalsIgnoreCase("Market")) {
            this.spLimitPrice.setEnabled(false);
            this.spTriggerPrice.setEnabled(false);
            this.spLimitPrice.setValue(0);
            this.spTriggerPrice.setValue(0);
            this.isGTC.setEnabled(false);
            this.isGTC.setSelected(false);
            this.setTrillingStopValues(false);
        } else if (orderType.equalsIgnoreCase("Stop Loss Limit")) {
            this.spLimitPrice.setEnabled(true);
            this.spTriggerPrice.setEnabled(true);
            this.spTriggerPrice.setValue(0);
            this.isGTC.setEnabled(true);
            this.setPriceFromFeedAndSubcribe(false);
            this.setTrillingStopValues(false);
        } else if (orderType.equalsIgnoreCase("Stop Loss Market")) {
            this.spLimitPrice.setError(false);
            this.spLimitPrice.setValue(0);
            this.spLimitPrice.setEnabled(false);
            this.spTriggerPrice.setEnabled(true);
            this.spTriggerPrice.setValue(0);
            this.isGTC.setEnabled(true);
            this.setPriceFromFeedAndSubcribe(false);
            this.setTrillingStopValues(false);
        } else if (orderType.equalsIgnoreCase("Trailling Stop Market")) {
            this.spLimitPrice.setError(false);
            this.spLimitPrice.setValue(0);
            this.spLimitPrice.setEnabled(false);
            this.spTriggerPrice.setEnabled(true);
            this.spTriggerPrice.setValue(0);
            this.isGTC.setEnabled(true);
            this.setPriceFromFeedAndSubcribe(false);
            this.setTrillingStopValues(true);
        }
    }

    public void setPrefredPrice(double val) {
        this.spLimitPrice.setValue(val);
    }

    public void initBuySell(String type, String UserID, String SelectedSymbol) {
        if (type.equalsIgnoreCase(Title.PMEX_Sell)) {
            this.setBackground(MyColors.SellBG);
            this.btnOrder.setText(Title.PMEX_Sell);
            this.setOrderTypes(Title.PMEX_Sell);
            this.type = "SEL";
        } else if (type.equalsIgnoreCase(Title.PMEX_Buy)) {
            this.setBackground(MyColors.BuyBG);
            this.btnOrder.setText(Title.PMEX_Buy);
            this.setOrderTypes(Title.PMEX_Buy);
            this.type = "BUY";
        }
    }

    public void getFocus() {
        this.isBasicValide();
    }

    public void setCancelReplace(WorkingOrderBean b) {
        this.workingOrderBean = b;
        if (b.getAccount().indexOf(LogsPMEX.accountPrefix) == 0) {
            this.cbAccountNo.setSelectedItem(b.getAccount().replaceFirst(LogsPMEX.accountPrefix, ""));
        } else {
            this.cbAccountNo.setSelectedItem(b.getAccount());
        }
        this.cbContract.setSelectedItem(b.getContract());
        this.cbOrderType.setSelectedItem(b.getOrderType());
        this.spQuantity.setValue(b.getQuantity());
        this.isGTC.setSelected(b.isGoodTillCancel());
        this.setEnable(false);
        this.isGTC.setEnabled(false);
        if (b.getOrderType().equalsIgnoreCase("Trailling Stop Market")) {
            this.setTrillingStopValues(true);
            this.spLimitPrice.setValue(b.getDistance());
            this.spTriggerPrice.setValue(b.getTrailingStep());
        } else {
            this.spLimitPrice.setValue(b.getLimitPrice());
            this.spTriggerPrice.setValue(b.getTriggerPrice());
        }
    }

    private void openOrderConfirmation() {
        PMEXOrderBean bean = this.getBean();
        PMEX_OrderConfirmation OC = new PMEX_OrderConfirmation(bean, this.cbOrderType.getSelectedItem().toString(), this);
        NxGDialogBox jd = new NxGDialogBox((Frame)TradeCast.getInstance().frame, true);
        try {
            if (AppConfig.houseIcon == null) {
                AppConfig.houseIcon = ImageUtil.downloadImage((String)(AppConfig.TradeCastURL + "/HouseImages/small.png"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        jd.setIconImage(AppConfig.houseIcon);
        jd.getContentPane().add(OC);
        if (bean.getTransactionType().equalsIgnoreCase("Sel")) {
            jd.setTitle("Sell Order Confirmation");
        } else if (bean.getTransactionType().equalsIgnoreCase("Buy")) {
            jd.setTitle("Buy Order Confirmation");
        } else {
            jd.setTitle(bean.getTransactionType() + " Order Confirmation");
        }
        if (Util.isWindow7()) {
            jd.setSize(330, 225);
        } else {
            jd.setSize(330, 220);
        }
        jd.setLocationRelativeTo(null);
        jd.setVisible(true);
    }

    public void MessageSent(boolean b) {
        if (b) {
            this.sendOrderToServer();
        }
    }

    private void setPriceFromFeedAndSubcribe(boolean isSendFeedRequest) {
        String market;
        String cont = this.getContract();
        MarketFeed marketFeed = this.mediator.PMEX_GetSingleFeed(cont, market = UtilPMEX.GetMarketFromContract((String)cont));
        if (marketFeed != null) {
            if (this.type.equalsIgnoreCase("BUY")) {
                this.setPriceOfFeed(Double.parseDouble(marketFeed.sell));
            } else {
                this.setPriceOfFeed(Double.parseDouble(marketFeed.buy));
            }
        } else {
            PMEXMarketFeedBean pmexMarketFeedBean = this.mediator.PMEX_GetSingleFeed_Matrix(cont, market);
            if (pmexMarketFeedBean != null) {
                if (this.type.equalsIgnoreCase("BUY")) {
                    this.setPriceOfFeed(pmexMarketFeedBean.getSell());
                } else {
                    this.setPriceOfFeed(pmexMarketFeedBean.getBuy());
                }
            } else if (isSendFeedRequest) {
                this.mediator.sendFeedContract("", "PMEX_Order Window : setPriceFromFeedAndSubcribe = " + isSendFeedRequest);
            }
        }
    }

    private void setPriceOfFeed(double price) {
        if ((this.spLimitPrice.getValue().toString().trim().length() <= 0 || this.spLimitPrice.getValue().toString().equalsIgnoreCase("0") || this.spLimitPrice.getValue().toString().equalsIgnoreCase("0.0")) && this.spLimitPrice.isEnabled()) {
            this.spLimitPrice.setValue(price);
        }
    }

    public void setOrderOptions(String result) {
        try {
            Number step;
            Number max;
            Number min;
            Number value;
            Number step2;
            Number max2;
            Number min2;
            Number value2;
            String[] val;
            if (result.indexOf(";") > 0) {
                LogCommon.PMEX_OrderOption = result;
            }
            if (LogCommon.PMEX_OrderOption.indexOf(";") > 0) {
                val = LogCommon.PMEX_OrderOption.split("\\;", -1);
                value2 = new Integer(Integer.parseInt(val[0]));
                min2 = new Integer(1);
                max2 = new Integer(999999);
                step2 = new Integer(Integer.parseInt(val[1]));
                this.QuantityModel.setMinimum((Comparable<?>)((Object)min2));
                this.QuantityModel.setMaximum((Comparable<?>)((Object)max2));
                this.QuantityModel.setStepSize(step2);
                this.QuantityModel.setValue(value2);
            } else {
                value = new Integer(100);
                min = new Integer(1);
                max = new Integer(999999);
                step = new Integer(1);
                this.QuantityModel.setMinimum((Comparable<?>)((Object)min));
                this.QuantityModel.setMaximum((Comparable<?>)((Object)max));
                this.QuantityModel.setStepSize(step);
                this.QuantityModel.setValue(value);
            }
            if (LogCommon.PMEX_OrderOption.indexOf(";") > 0) {
                val = LogCommon.PMEX_OrderOption.split("\\;", -1);
                value2 = new Double(0.0);
                min2 = new Double(0.0);
                max2 = new Double(999999.99);
                step2 = new Double(Double.parseDouble(val[2]));
                this.LimitPriceModel.setMinimum((Comparable<?>)((Object)min2));
                this.LimitPriceModel.setMaximum((Comparable<?>)((Object)max2));
                this.LimitPriceModel.setStepSize(step2);
                this.LimitPriceModel.setValue(value2);
                this.TriggerPriceModel.setMinimum((Comparable<?>)((Object)min2));
                this.TriggerPriceModel.setMaximum((Comparable<?>)((Object)max2));
                this.TriggerPriceModel.setStepSize(step2);
                this.TriggerPriceModel.setValue(value2);
            } else {
                value = new Double(0.0);
                min = new Double(0.0);
                max = new Double(999999.99);
                step = new Double(0.01);
                this.LimitPriceModel.setMinimum((Comparable<?>)((Object)min));
                this.LimitPriceModel.setMaximum((Comparable<?>)((Object)max));
                this.LimitPriceModel.setStepSize(step);
                this.LimitPriceModel.setValue(value);
                this.TriggerPriceModel.setMinimum((Comparable<?>)((Object)min));
                this.TriggerPriceModel.setMaximum((Comparable<?>)((Object)max));
                this.TriggerPriceModel.setStepSize(step);
            }
        }
        catch (Exception ex) {
            Mediator.getInstance().PrintLog(ex, result);
        }
    }

    private void initComponents() {
        this.lblMessage = new JLabel();
        this.lblContract = new JLabel();
        this.lblGTC = new JLabel();
        this.lblAccount = new JLabel();
        this.lblQuantity = new JLabel();
        this.lblLimitPrice = new JLabel();
        this.jLabel7 = new JLabel();
        this.lblTriggerPrice = new JLabel();
        this.cbContract = new NxGComboBox();
        this.cbOrderType = new NxGComboBox();
        this.cbAccountNo = new NxGComboBox();
        this.spTriggerPrice = new NxGSpinner();
        this.spQuantity = new NxGSpinner();
        this.spLimitPrice = new NxGSpinner();
        this.txtPinCode = new NxGPassword();
        this.btnOrder = new JButton();
        this.jSeparator1 = new JSeparator();
        this.isSavePIN = new JCheckBox();
        this.lblOrderType = new JLabel();
        this.isGTC = new JCheckBox();
        this.lblSettings = new JLabel();
        this.lblPrefix = new JLabel();
        this.lblForgetPinCode = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.lblfBuyVolume = new JLabel();
        this.txtfBuyVolume = new NxGTextField();
        this.lblfBuy = new JLabel();
        this.txtfBuy = new NxGTextField();
        this.txtfSell = new NxGTextField();
        this.lblfSell = new JLabel();
        this.txtfSellVolume = new NxGTextField();
        this.lblfSellVolume = new JLabel();
        this.txtfChange = new NxGTextField();
        this.lblfChange = new JLabel();
        this.txtfLastTrade = new NxGTextField();
        this.lblfLastTrade = new JLabel();
        this.txtfTotalVolume = new NxGTextField();
        this.lblfTotalVolume = new JLabel();
        this.txtfLow = new NxGTextField();
        this.lblfLow = new JLabel();
        this.txtfHigh = new NxGTextField();
        this.lblfHigh = new JLabel();
        this.setBackground(new Color(51, 255, 51));
        this.setLayout(null);
        this.lblMessage.setText("Contract :");
        this.add(this.lblMessage);
        this.lblMessage.setBounds(10, 305, 380, 20);
        this.lblContract.setHorizontalAlignment(4);
        this.lblContract.setText("Contract :");
        this.add(this.lblContract);
        this.lblContract.setBounds(10, 10, 70, 23);
        this.lblGTC.setHorizontalAlignment(4);
        this.lblGTC.setText("GTC :");
        this.add(this.lblGTC);
        this.lblGTC.setBounds(20, 70, 60, 23);
        this.lblAccount.setHorizontalAlignment(4);
        this.lblAccount.setText("Account :");
        this.add(this.lblAccount);
        this.lblAccount.setBounds(10, 100, 70, 23);
        this.lblQuantity.setHorizontalAlignment(4);
        this.lblQuantity.setText("Quantity :");
        this.add(this.lblQuantity);
        this.lblQuantity.setBounds(10, 130, 70, 23);
        this.lblLimitPrice.setHorizontalAlignment(4);
        this.lblLimitPrice.setText("Limit Price :");
        this.add(this.lblLimitPrice);
        this.lblLimitPrice.setBounds(10, 160, 70, 23);
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText("PIN :");
        this.add(this.jLabel7);
        this.jLabel7.setBounds(10, 220, 70, 23);
        this.lblTriggerPrice.setHorizontalAlignment(4);
        this.lblTriggerPrice.setText("Trigger Price :");
        this.add(this.lblTriggerPrice);
        this.lblTriggerPrice.setBounds(10, 190, 70, 23);
        this.cbContract.setOpaque(false);
        this.cbContract.setPreferredSize(new Dimension(56, 20));
        this.add(this.cbContract);
        this.cbContract.setBounds(90, 10, 130, 23);
        this.cbOrderType.setOpaque(false);
        this.cbOrderType.setPreferredSize(new Dimension(56, 20));
        this.add(this.cbOrderType);
        this.cbOrderType.setBounds(90, 40, 130, 23);
        this.cbAccountNo.setOpaque(false);
        this.cbAccountNo.setPreferredSize(new Dimension(56, 20));
        this.add(this.cbAccountNo);
        this.cbAccountNo.setBounds(140, 100, 80, 23);
        this.spTriggerPrice.setMinimumSize(new Dimension(10, 16));
        this.spTriggerPrice.setPreferredSize(new Dimension(15, 16));
        this.add(this.spTriggerPrice);
        this.spTriggerPrice.setBounds(90, 190, 130, 23);
        this.spQuantity.setMinimumSize(new Dimension(10, 16));
        this.spQuantity.setPreferredSize(new Dimension(15, 16));
        this.add(this.spQuantity);
        this.spQuantity.setBounds(90, 130, 130, 23);
        this.spLimitPrice.setMinimumSize(new Dimension(10, 16));
        this.spLimitPrice.setPreferredSize(new Dimension(15, 16));
        this.add(this.spLimitPrice);
        this.spLimitPrice.setBounds(90, 160, 130, 23);
        this.add(this.txtPinCode);
        this.txtPinCode.setBounds(90, 220, 40, 23);
        this.btnOrder.setText("Buy");
        this.btnOrder.setName("PMEX_OrderBase -> btnOrder");
        this.btnOrder.setOpaque(false);
        this.add(this.btnOrder);
        this.btnOrder.setBounds(88, 250, 132, 23);
        this.add(this.jSeparator1);
        this.jSeparator1.setBounds(0, 295, 400, 2);
        this.isSavePIN.setText("Save PIN");
        this.isSavePIN.setOpaque(false);
        this.isSavePIN.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PMEX_OrderBase.this.isSavePINItemStateChanged(evt);
            }
        });
        this.add(this.isSavePIN);
        this.isSavePIN.setBounds(133, 220, 90, 23);
        this.lblOrderType.setHorizontalAlignment(4);
        this.lblOrderType.setText("Order Type :");
        this.add(this.lblOrderType);
        this.lblOrderType.setBounds(10, 40, 70, 23);
        this.isGTC.setBackground(UIManager.getDefaults().getColor("CheckBoxMenuItem.selectionBackground"));
        this.isGTC.setOpaque(false);
        this.isGTC.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                PMEX_OrderBase.this.isGTCFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                PMEX_OrderBase.this.isGTCFocusLost(evt);
            }
        });
        this.add(this.isGTC);
        this.isGTC.setBounds(90, 70, 21, 23);
        this.lblSettings.setFont(new Font("Tahoma", 1, 11));
        this.lblSettings.setHorizontalAlignment(4);
        this.lblSettings.setIcon(new ImageIcon(this.getClass().getResource("/Images/option.png")));
        this.lblSettings.setText("Settings");
        this.lblSettings.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                PMEX_OrderBase.this.lblSettingsMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PMEX_OrderBase.this.lblSettingsMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                PMEX_OrderBase.this.lblSettingsMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                PMEX_OrderBase.this.lblSettingsMouseReleased(evt);
            }
        });
        this.add(this.lblSettings);
        this.lblSettings.setBounds(310, 275, 75, 20);
        this.lblPrefix.setHorizontalAlignment(4);
        this.lblPrefix.setText("Account");
        this.add(this.lblPrefix);
        this.lblPrefix.setBounds(90, 100, 48, 23);
        this.lblForgetPinCode.setHorizontalAlignment(0);
        this.lblForgetPinCode.setText("Forgot PIN?");
        this.add(this.lblForgetPinCode);
        this.lblForgetPinCode.setBounds(143, 275, 75, 18);
        this.jSeparator2.setOrientation(1);
        this.add(this.jSeparator2);
        this.jSeparator2.setBounds(230, 10, 3, 275);
        this.lblfBuyVolume.setHorizontalAlignment(4);
        this.lblfBuyVolume.setText("Buy Volume :");
        this.add(this.lblfBuyVolume);
        this.lblfBuyVolume.setBounds(240, 10, 75, 23);
        this.txtfBuyVolume.setHorizontalAlignment(4);
        this.txtfBuyVolume.setText("-8,888.88");
        this.txtfBuyVolume.setEnabled(false);
        this.add(this.txtfBuyVolume);
        this.txtfBuyVolume.setBounds(320, 10, 65, 23);
        this.lblfBuy.setHorizontalAlignment(4);
        this.lblfBuy.setText("Buy :");
        this.add(this.lblfBuy);
        this.lblfBuy.setBounds(240, 40, 75, 23);
        this.txtfBuy.setHorizontalAlignment(4);
        this.txtfBuy.setText("-8,888.88");
        this.txtfBuy.setEnabled(false);
        this.add(this.txtfBuy);
        this.txtfBuy.setBounds(320, 40, 65, 23);
        this.txtfSell.setHorizontalAlignment(4);
        this.txtfSell.setText("-8,888.88");
        this.txtfSell.setEnabled(false);
        this.add(this.txtfSell);
        this.txtfSell.setBounds(320, 70, 65, 23);
        this.lblfSell.setHorizontalAlignment(4);
        this.lblfSell.setText("Sell :");
        this.add(this.lblfSell);
        this.lblfSell.setBounds(240, 70, 75, 23);
        this.txtfSellVolume.setHorizontalAlignment(4);
        this.txtfSellVolume.setText("-8,888.88");
        this.txtfSellVolume.setEnabled(false);
        this.add(this.txtfSellVolume);
        this.txtfSellVolume.setBounds(320, 100, 65, 23);
        this.lblfSellVolume.setHorizontalAlignment(4);
        this.lblfSellVolume.setText("Sell Volume :");
        this.add(this.lblfSellVolume);
        this.lblfSellVolume.setBounds(240, 100, 75, 23);
        this.txtfChange.setHorizontalAlignment(4);
        this.txtfChange.setText("-8,888.88");
        this.txtfChange.setEnabled(false);
        this.add(this.txtfChange);
        this.txtfChange.setBounds(320, 130, 65, 23);
        this.lblfChange.setHorizontalAlignment(4);
        this.lblfChange.setText("Change :");
        this.add(this.lblfChange);
        this.lblfChange.setBounds(240, 130, 75, 23);
        this.txtfLastTrade.setHorizontalAlignment(4);
        this.txtfLastTrade.setText("-8,888.88");
        this.txtfLastTrade.setEnabled(false);
        this.add(this.txtfLastTrade);
        this.txtfLastTrade.setBounds(320, 160, 65, 23);
        this.lblfLastTrade.setHorizontalAlignment(4);
        this.lblfLastTrade.setText("Last Trade :");
        this.add(this.lblfLastTrade);
        this.lblfLastTrade.setBounds(240, 160, 75, 23);
        this.txtfTotalVolume.setHorizontalAlignment(4);
        this.txtfTotalVolume.setText("-8,888.88");
        this.txtfTotalVolume.setEnabled(false);
        this.add(this.txtfTotalVolume);
        this.txtfTotalVolume.setBounds(320, 190, 65, 23);
        this.lblfTotalVolume.setHorizontalAlignment(4);
        this.lblfTotalVolume.setText("Total Volume :");
        this.add(this.lblfTotalVolume);
        this.lblfTotalVolume.setBounds(240, 190, 75, 23);
        this.txtfLow.setHorizontalAlignment(4);
        this.txtfLow.setText("-8,888.88");
        this.txtfLow.setEnabled(false);
        this.add(this.txtfLow);
        this.txtfLow.setBounds(320, 220, 65, 23);
        this.lblfLow.setHorizontalAlignment(4);
        this.lblfLow.setText("Low :");
        this.add(this.lblfLow);
        this.lblfLow.setBounds(240, 220, 75, 23);
        this.txtfHigh.setHorizontalAlignment(4);
        this.txtfHigh.setText("-8,888.88");
        this.txtfHigh.setEnabled(false);
        this.add(this.txtfHigh);
        this.txtfHigh.setBounds(320, 250, 65, 23);
        this.lblfHigh.setHorizontalAlignment(4);
        this.lblfHigh.setText("High :");
        this.add(this.lblfHigh);
        this.lblfHigh.setBounds(240, 250, 75, 23);
    }

    private void isSavePINItemStateChanged(ItemEvent evt) {
        LogCommon.pinCode = evt.getStateChange() == 2 ? "" : this.txtPinCode.getText();
        this.mediator.setUniversalPIN();
    }

    private void lblSettingsMouseEntered(MouseEvent evt) {
        this.lblSettings.setText("<html><u><b>Settings</b></u></html>");
    }

    private void lblSettingsMouseExited(MouseEvent evt) {
        this.lblSettings.setText("<html><b>Settings</b></html>");
    }

    private void lblSettingsMousePressed(MouseEvent evt) {
        OrderOption orderOption = new OrderOption((Frame)TradeCast.getInstance().frame, true, evt, this);
    }

    private void lblSettingsMouseReleased(MouseEvent evt) {
        this.lblSettings.setText("<html><u><b>Settings</b></u></html>");
    }

    private void isGTCFocusGained(FocusEvent evt) {
        this.isGTC.setOpaque(true);
    }

    private void isGTCFocusLost(FocusEvent evt) {
        this.isGTC.setOpaque(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.btnOrder) {
            this.sendOrder();
        } else if (source == this.cbContract) {
            if (e.getModifiers() == 16 || e.getActionCommand().equalsIgnoreCase("comboBoxEdited")) {
                this.spLimitPrice.setValue(0);
                if (this.cbContract.getSelectedItem().toString().trim().length() <= 0) {
                    this.cbContract.setError(true);
                    this.cbContract.requestFocus();
                    Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Contratct Required.");
                } else {
                    this.cbContract.setError(false);
                    this.cbOrderType.requestFocus();
                    Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
                    this.setPriceFromFeedAndSubcribe(true);
                }
                this.resetFeedValues();
                this.FeedRecieved(false);
            }
        } else if (source == this.cbOrderType) {
            if (e.getModifiers() == 16 || e.getActionCommand().equalsIgnoreCase("comboBoxEdited")) {
                if (this.cbOrderType.getSelectedItem().toString().trim().length() <= 0) {
                    this.cbOrderType.setError(true);
                    this.cbOrderType.requestFocus();
                    Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Order Type Required.");
                } else {
                    this.orderTypeChange();
                    this.cbOrderType.setError(false);
                    if (this.isGTC.isEnabled()) {
                        this.isGTC.requestFocus();
                    } else {
                        this.cbAccountNo.requestFocus();
                    }
                }
            }
        } else if (source == this.cbAccountNo) {
            if (e.getModifiers() == 16 || e.getActionCommand().equalsIgnoreCase("comboBoxEdited")) {
                if (this.cbAccountNo.getSelectedItem().toString().trim().length() <= 0) {
                    this.cbAccountNo.setError(true);
                    this.cbAccountNo.requestFocus();
                    Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Account Required.");
                } else {
                    this.cbAccountNo.setError(false);
                    ((JSpinner.DefaultEditor)this.spQuantity.getEditor()).getTextField().requestFocus();
                    Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
                }
            }
        } else if (source == this.txtPinCode) {
            if (this.txtPinCode.getText().trim().length() <= 0) {
                this.txtPinCode.setError(true);
                this.txtPinCode.requestFocus();
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"PIN Required.");
            } else {
                this.sendOrder();
            }
        }
    }

    public void addContract() {
        if (this.autoCom != null && this.autoCom.isInstalled()) {
            this.autoCom.uninstall();
        }
        ArrayList v = new ArrayList(LogsPMEX.PMEX_CONTRACT_ALL.keySet());
        v.add("");
        Collections.sort(v);
        this.autoCom = AutoCompleteSupport.install((JComboBox)this.cbContract, (EventList)GlazedLists.eventListOf((Object[])v.toArray()));
        this.autoCom.setStrict(false);
    }

    private void setTrillingStopValues(boolean isTrill) {
        if (isTrill) {
            this.lblLimitPrice.setText("Distance :");
            this.lblTriggerPrice.setText("Trailing Step :");
            this.spTriggerPrice.setEnabled(true);
            this.spLimitPrice.setEnabled(true);
        } else {
            this.lblLimitPrice.setText("Limit Price :");
            this.lblTriggerPrice.setText("Trigger Price :");
        }
    }

    private void SetTimer(final NxGTextField Obj, final Timer timer) {
        ActionListener Task2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Obj.setBlendColor(PMEX_OrderBase.this.disableColor);
                timer.stop();
            }
        };
        timer.addActionListener(Task2);
        timer.start();
    }

    private void setDefaultColors() {
        this.txtfBuyVolume.setDisabledTextColor(MarketWatch.Buy_BuyVol_Color);
        this.txtfBuy.setDisabledTextColor(MarketWatch.Buy_BuyVol_Color);
        this.txtfSell.setDisabledTextColor(MarketWatch.Sell_SellVol_Color);
        this.txtfSellVolume.setDisabledTextColor(MarketWatch.Sell_SellVol_Color);
        this.txtfLastTrade.setDisabledTextColor(Color.black);
        this.txtfTotalVolume.setDisabledTextColor(MyColors.LeaderFontGB);
        this.txtfChange.setDisabledTextColor(Color.black);
        this.txtfHigh.setDisabledTextColor(MyColors.HighMW);
        this.txtfLow.setDisabledTextColor(MyColors.LowMW);
    }

    private void resetFeedValues() {
        this.txtfBuyVolume.setText("0");
        this.txtfBuy.setText("0.00");
        this.txtfSellVolume.setText("0");
        this.txtfSell.setText("0.00");
        this.txtfChange.setText("0.00");
        this.txtfLastTrade.setText("0.00");
        this.txtfTotalVolume.setText("0");
        this.txtfLow.setText("0");
        this.txtfHigh.setText("0");
        this.isFirstTimeBuyVol = true;
        this.isFirstTimeBuy = true;
        this.isFirstTimeSellVol = true;
        this.isFirstTimeSell = true;
    }

    public void FeedRecieved(boolean UpdatePrice) {
        String Feed2 = "";
        MarketFeed mktFeed = this.mediator.PMEX_GetSingleFeed(this.getContract(), this.getMarket());
        if (mktFeed == null) {
            Feed2 = this.getContract() + ";" + this.getMarket() + ";00;0.00;0.00;0;OPN;+;0.00;0:0:0;0.00;;0;0;0;0;0;00|";
            this.updateWindow(Feed2, UpdatePrice);
            return;
        }
        Feed2 = mktFeed.feedString;
        int seTextIndex = Feed2.indexOf(59);
        if (seTextIndex < 1) {
            Feed2 = this.getContract() + ";" + this.getMarket() + ";00;0.00;0.00;0;OPN;+;0.00;0:0:0;0.00;;0;0;0;0;0;00|";
        }
        this.updateWindow(Feed2, UpdatePrice);
    }

    public void updateWindow(String str, Boolean UpdatePrice) {
        Double capsLower = 0.0;
        Double capsUpper = 0.0;
        if (str.indexOf(";") > -1) {
            try {
                String[] SYMDATA = str.split("\\;", -1);
                if (UpdatePrice.booleanValue()) {
                    // empty if block
                }
                this.SetValues(this.txtfBuy, Double.parseDouble(this.txtfBuy.getText().trim().replaceAll("\\,", "")), Double.parseDouble(SYMDATA[3].trim()), this.Timer_Buy, this.isFirstTimeBuy);
                this.isFirstTimeBuy = false;
                this.txtfBuy.setText(Util.format2digit((String)SYMDATA[3]));
                this.SetValues(this.txtfSell, Double.parseDouble(this.txtfSell.getText().trim().replaceAll("\\,", "")), Double.parseDouble(SYMDATA[4].trim()), this.Timer_Sell, this.isFirstTimeSell);
                this.isFirstTimeSell = false;
                this.txtfSell.setText(Util.format2digit((String)SYMDATA[4]));
                if (Util.isInteger((String)SYMDATA[5])) {
                    this.SetValues(this.txtfSellVolume, Double.parseDouble(this.txtfSellVolume.getText().trim().replaceAll("\\,", "")), Double.parseDouble(SYMDATA[5].trim()), this.Timer_SellVol, this.isFirstTimeSellVol);
                    this.isFirstTimeSellVol = false;
                    this.txtfSellVolume.setText(Util.FormatedText((Number)Integer.parseInt(SYMDATA[5].trim())));
                } else {
                    this.txtfSellVolume.setText("0");
                }
                if (Util.isInteger((String)SYMDATA[2])) {
                    this.SetValues(this.txtfBuyVolume, Double.parseDouble(this.txtfBuyVolume.getText().trim().replaceAll("\\,", "")), Double.parseDouble(SYMDATA[2].trim()), this.Timer_BuyVol, this.isFirstTimeBuyVol);
                    this.isFirstTimeBuyVol = false;
                    this.txtfBuyVolume.setText(Util.FormatedText((Number)Integer.parseInt(SYMDATA[2].trim())));
                } else {
                    this.txtfBuyVolume.setText("0");
                }
                this.txtfLastTrade.setText(Util.format2digit((String)SYMDATA[10]));
                if (SYMDATA[8].indexOf("-") >= 0) {
                    this.txtfChange.setDisabledTextColor(MyColors.errorMessageFG);
                } else {
                    this.txtfChange.setDisabledTextColor(new Color(0, 128, 0));
                }
                this.txtfChange.setText(Util.format2digit((String)SYMDATA[8]));
                this.txtfTotalVolume.setText(Util.format0digit((String)SYMDATA[16]));
                this.txtfLow.setText(Util.format2digit((String)SYMDATA[14]));
                this.txtfHigh.setText(Util.format2digit((String)SYMDATA[13]));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void SetValues(NxGTextField obj, Double oldVal, Double newVal, Timer timer, boolean isFirstTime) {
        if (isFirstTime) {
            obj.setBlendColor(this.disableColor);
            timer.restart();
            return;
        }
        if (newVal < oldVal) {
            obj.setBlendColor(MyColors.MarketWatchDecreaseColor);
            timer.restart();
        } else if (newVal > oldVal) {
            obj.setBlendColor(MyColors.MarketWatchIncreaseColor);
            timer.restart();
        }
    }
}

