/*
 * Decompiled with CFR 0.152.
 */
package windows.pmex.order;

import CustomComponent.MyOptionPane;
import MyDocking.Mediator;
import Orders.OrderConfirmation;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import pmex.gui.bean.PMEXOrderBean;
import windows.pmex.PMEX_Ladder;
import windows.pmex.PMEX_MBP;
import windows.pmex.order.PMEX_FastOrderPanel;
import windows.pmex.order.PMEX_OrderBase;

public class PMEX_OrderConfirmation
extends JPanel {
    private Mediator mediator = Mediator.getInstance();
    private String pincode = "";
    private PMEXOrderBean bean = null;
    private final String orderType;
    private final JPanel owner;
    private JButton btnDecline;
    private JButton btnExecute;
    public static JCheckBox cbShowPrompt;
    private JCheckBox isGTC;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JSeparator jSeparator1;
    private JLabel lblLimitPrice;
    private JLabel lblTriggerPrice;
    private JTextField txtAccount;
    private JTextField txtContract;
    private JTextField txtLimitPrice;
    private JTextField txtMarket;
    private JTextField txtOrderType;
    private JTextField txtTriggerPrice;
    private JTextField txtVolume;

    public PMEX_OrderConfirmation(PMEXOrderBean bean, String orderType, JPanel owner) {
        this.initComponents();
        this.bean = bean;
        this.orderType = orderType;
        this.owner = owner;
        this.setFields(bean);
    }

    public final void setFields(PMEXOrderBean bean) {
        this.txtMarket.setText(bean.getMarket());
        this.txtContract.setText(bean.getContract());
        this.txtLimitPrice.setText(Util.format2digit((String)(bean.getLimitPrice() + "")));
        this.txtVolume.setText(Util.format0digit((String)(bean.getVolume() + "")));
        this.txtAccount.setText(bean.getAccount());
        if (this.orderType.equalsIgnoreCase("Stop Loss Limit")) {
            this.txtTriggerPrice.setHorizontalAlignment(4);
            this.txtTriggerPrice.setText(Util.format2digit((String)(bean.getTriggerPrice() + "")));
        }
        if (this.orderType.equalsIgnoreCase("Stop Loss Market")) {
            this.txtTriggerPrice.setHorizontalAlignment(4);
            this.txtTriggerPrice.setText(Util.format2digit((String)(bean.getTriggerPrice() + "")));
        }
        if (this.orderType.equalsIgnoreCase("Market")) {
            this.txtLimitPrice.setText("Market Order");
            this.txtLimitPrice.setHorizontalAlignment(2);
        }
        if (this.orderType.equalsIgnoreCase("Trailling Stop Market")) {
            this.setTrillingStopValues(true);
            this.txtLimitPrice.setText(Util.format2digit((String)(bean.getDistance() + "")));
            this.txtTriggerPrice.setText(Util.format2digit((String)(bean.getTrailingStep() + "")));
        } else {
            this.setTrillingStopValues(false);
        }
        if (bean.getTransactionType().equalsIgnoreCase("Sel") || bean.getTransactionType().equalsIgnoreCase("Sell")) {
            this.txtOrderType.setText("Sell");
        } else if (bean.getTransactionType().equalsIgnoreCase("BUY")) {
            this.txtOrderType.setText("Buy");
        }
        this.pincode = bean.getPIN();
        if (bean.getTransactionType().equalsIgnoreCase("BUY")) {
            this.setBackground(MyColors.BuyBG);
            cbShowPrompt.setBackground(MyColors.BuyBG);
        } else if (bean.getTransactionType().equalsIgnoreCase("SELL") || bean.getTransactionType().equalsIgnoreCase("SEL") || bean.getTransactionType().equalsIgnoreCase("Short Sell")) {
            this.setBackground(MyColors.SellBG);
            cbShowPrompt.setBackground(MyColors.SellBG);
        } else if (bean.getMarket().equalsIgnoreCase("LB")) {
            this.setBackground(MyColors.BuyBG);
            cbShowPrompt.setBackground(MyColors.BuyBG);
        }
        this.btnExecute.requestFocus();
        cbShowPrompt.setSelected(LogCommon.isConfirmation);
        this.isGTC.setSelected(bean.IsGoodTillCancel());
        this.getFocus();
    }

    public void getFocus() {
        new Thread("PMEX_OrderCinfirmation"){

            @Override
            public void run() {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(OrderConfirmation.class.getName()).log(Level.SEVERE, null, ex);
                }
                PMEX_OrderConfirmation.this.btnExecute.requestFocus();
            }
        }.start();
    }

    private void setTrillingStopValues(boolean isTrill) {
        if (isTrill) {
            this.lblLimitPrice.setText("Distance");
            this.lblTriggerPrice.setText("Trailing Step");
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.lblLimitPrice = new JLabel();
        this.txtContract = new JTextField();
        this.txtMarket = new JTextField();
        this.txtLimitPrice = new JTextField();
        this.txtAccount = new JTextField();
        this.txtVolume = new JTextField();
        this.txtOrderType = new JTextField();
        this.btnExecute = new JButton();
        this.btnDecline = new JButton();
        cbShowPrompt = new JCheckBox();
        this.txtTriggerPrice = new JTextField();
        this.jLabel8 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabel7 = new JLabel();
        this.lblTriggerPrice = new JLabel();
        this.isGTC = new JCheckBox();
        this.setLayout(null);
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setText("Market");
        this.add(this.jLabel1);
        this.jLabel1.setBounds(5, 10, 50, 20);
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("Contract");
        this.add(this.jLabel2);
        this.jLabel2.setBounds(5, 40, 50, 20);
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("Order Type");
        this.add(this.jLabel3);
        this.jLabel3.setBounds(140, 10, 70, 20);
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText("Volume");
        this.add(this.jLabel4);
        this.jLabel4.setBounds(140, 40, 70, 20);
        this.lblLimitPrice.setHorizontalAlignment(4);
        this.lblLimitPrice.setText("Price");
        this.add(this.lblLimitPrice);
        this.lblLimitPrice.setBounds(5, 70, 50, 20);
        this.txtContract.setEditable(false);
        this.txtContract.setFocusable(false);
        this.add(this.txtContract);
        this.txtContract.setBounds(60, 40, 80, 20);
        this.txtMarket.setEditable(false);
        this.txtMarket.setFocusable(false);
        this.add(this.txtMarket);
        this.txtMarket.setBounds(60, 10, 80, 20);
        this.txtLimitPrice.setEditable(false);
        this.txtLimitPrice.setHorizontalAlignment(4);
        this.txtLimitPrice.setFocusable(false);
        this.add(this.txtLimitPrice);
        this.txtLimitPrice.setBounds(60, 70, 80, 20);
        this.txtAccount.setEditable(false);
        this.txtAccount.setFocusable(false);
        this.add(this.txtAccount);
        this.txtAccount.setBounds(60, 100, 80, 20);
        this.txtVolume.setEditable(false);
        this.txtVolume.setHorizontalAlignment(4);
        this.txtVolume.setFocusable(false);
        this.add(this.txtVolume);
        this.txtVolume.setBounds(220, 40, 80, 20);
        this.txtOrderType.setEditable(false);
        this.txtOrderType.setFocusable(false);
        this.add(this.txtOrderType);
        this.txtOrderType.setBounds(220, 10, 80, 20);
        this.btnExecute.setText("Execute");
        this.btnExecute.setName("PMEX_OrderConfirmation -> btnExecute");
        this.btnExecute.setOpaque(false);
        this.btnExecute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PMEX_OrderConfirmation.this.btnExecuteActionPerformed(evt);
            }
        });
        this.add(this.btnExecute);
        this.btnExecute.setBounds(140, 160, 80, 23);
        this.btnDecline.setText("Decline");
        this.btnDecline.setName("PMEX_OrderConfirmation -> btnDecline");
        this.btnDecline.setOpaque(false);
        this.btnDecline.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PMEX_OrderConfirmation.this.btnDeclineActionPerformed(evt);
            }
        });
        this.add(this.btnDecline);
        this.btnDecline.setBounds(225, 160, 80, 23);
        cbShowPrompt.setText("Always open this order confirmation window");
        cbShowPrompt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PMEX_OrderConfirmation.this.cbShowPromptActionPerformed(evt);
            }
        });
        this.add(cbShowPrompt);
        cbShowPrompt.setBounds(10, 123, 280, 23);
        this.txtTriggerPrice.setEditable(false);
        this.txtTriggerPrice.setHorizontalAlignment(4);
        this.txtTriggerPrice.setFocusable(false);
        this.add(this.txtTriggerPrice);
        this.txtTriggerPrice.setBounds(220, 70, 80, 20);
        this.jLabel8.setHorizontalAlignment(4);
        this.jLabel8.setText("GTC");
        this.add(this.jLabel8);
        this.jLabel8.setBounds(140, 100, 70, 20);
        this.add(this.jSeparator1);
        this.jSeparator1.setBounds(0, 152, 370, 3);
        this.jLabel7.setHorizontalAlignment(4);
        this.jLabel7.setText(" Account");
        this.add(this.jLabel7);
        this.jLabel7.setBounds(5, 100, 50, 20);
        this.lblTriggerPrice.setHorizontalAlignment(4);
        this.lblTriggerPrice.setText("Trigger Price");
        this.add(this.lblTriggerPrice);
        this.lblTriggerPrice.setBounds(140, 70, 70, 20);
        this.isGTC.setEnabled(false);
        this.isGTC.setOpaque(false);
        this.add(this.isGTC);
        this.isGTC.setBounds(220, 100, 21, 21);
    }

    private void btnDeclineActionPerformed(ActionEvent evt) {
        if (this.bean != null) {
            if (this.owner != null) {
                if (this.owner instanceof PMEX_OrderBase) {
                    ((PMEX_OrderBase)this.owner).MessageSent(false);
                } else if (this.owner instanceof PMEX_MBP) {
                    ((PMEX_MBP)this.owner).MessageSent(false);
                } else if (this.owner instanceof PMEX_Ladder) {
                    ((PMEX_Ladder)((Object)this.owner)).MessageSent(false);
                } else if (this.owner instanceof PMEX_FastOrderPanel) {
                    ((PMEX_FastOrderPanel)this.owner).MessageSent(false);
                }
            } else {
                MyOptionPane.showMessage(MessageType.Error, "owner is null", true);
            }
            ((JDialog)this.getRootPane().getParent()).dispose();
        } else {
            MyOptionPane.showMessage(MessageType.Error, "bean is null", true);
        }
    }

    private void cbShowPromptActionPerformed(ActionEvent evt) {
        LogCommon.isConfirmation = cbShowPrompt.isSelected();
    }

    private void btnExecuteActionPerformed(ActionEvent evt) {
        if (this.bean != null) {
            if (this.owner != null) {
                if (this.owner instanceof PMEX_OrderBase) {
                    ((PMEX_OrderBase)this.owner).MessageSent(true);
                } else if (this.owner instanceof PMEX_MBP) {
                    ((PMEX_MBP)this.owner).MessageSent(true);
                } else if (this.owner instanceof PMEX_Ladder) {
                    ((PMEX_Ladder)((Object)this.owner)).MessageSent(true);
                } else if (this.owner instanceof PMEX_FastOrderPanel) {
                    ((PMEX_FastOrderPanel)this.owner).MessageSent(true);
                }
            }
            ((JDialog)this.getRootPane().getParent()).dispose();
        }
    }
}

