/*
 * Decompiled with CFR 0.152.
 */
package windows.pmex.watches;

import CATALYST.Control.MarketWatch;
import CustomComponent.ToolBarArrowButton;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import Utilities.FormsProperties;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.gui.component.NxGLink;
import common.gui.util.FormName;
import common.interfaces.AddContract;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import pmex.gui.util.LogsPMEX;
import pmex.gui.util.UtilPMEX;
import pmex.interfaces.ContractBarInterface;
import windows.pmex.PMEX_ContractBrowseDialog;

public class PMEX_ContractBar
extends JPanel
implements AddContract,
ActionListener {
    private AutoCompleteSupport autoCom;
    private MarketWatch marketWatch = null;
    private TradeCast tradeCast = TradeCast.getInstance();
    private final ContractBarInterface contractBarInterface;
    private JToggleButton btnQuantity = new JToggleButton("Quantity");
    private final FormName formName;
    private final String prompt = "Please Select a Contract";
    public static PMEX_ContractBrowseDialog contractBrowseDialog = null;
    private JButton btnSave;
    private JComboBox cbContract;
    private JLabel lblContract;
    private JLabel lblContractBrowse;
    private JToolBar toolBar;

    public PMEX_ContractBar(MarketWatch marketWatch, final ContractBarInterface contractBarInterface, FormName formName) {
        this.marketWatch = marketWatch;
        this.contractBarInterface = contractBarInterface;
        this.initComponents();
        this.formName = formName;
        this.addContract();
        this.cbContract.setMaximumRowCount(30);
        LogsPMEX.CONTRACT_HOLDER.add(this);
        this.toolBar.add(this.btnQuantity);
        ((ToolBarArrowButton)this.btnSave).RegisterPopMenu(new String[]{"Save Profile", "Reload Profile"}, new String[]{"/Images/save.png", "/Images/reload.png"});
        ((ToolBarArrowButton)this.btnSave).addListener(new ToolBarArrowButton.ArrowButtonActionListener(){

            @Override
            public void popupActionPerformed(ToolBarArrowButton.ArrowButtonActionEvent e) {
            }

            @Override
            public void actionPerformed(ToolBarArrowButton.ArrowButtonActionEvent e) {
                if (e.Text.equalsIgnoreCase("Save Profile")) {
                    if (contractBarInterface != null) {
                        contractBarInterface.saveProfile();
                    }
                } else if (e.Text.equalsIgnoreCase("Reload Profile") && contractBarInterface != null) {
                    contractBarInterface.reloadProfile();
                }
            }
        });
        this.setThis();
        try {
            this.lblContractBrowse.setIcon(new ImageIcon(this.getClass().getResource("/common/gui/images/contractBrowse16.png")));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void setThis() {
        this.btnQuantity.addActionListener(this);
        this.cbContract.addActionListener(this);
    }

    public void showQuantityButton(boolean isShow) {
        this.btnQuantity.setVisible(isShow);
    }

    public void setContract(String symbol) {
        this.cbContract.removeActionListener(this);
        this.cbContract.setSelectedItem(symbol);
        this.cbContract.addActionListener(this);
    }

    private void openContratBrowseWindow(FormName formName) {
        if (this.tradeCast.htFormsProperties.containsKey(FormName.ContractBrowse)) {
            if (contractBrowseDialog == null) {
                FormsProperties fp = this.tradeCast.htFormsProperties.get(FormName.ContractBrowse);
                contractBrowseDialog = new PMEX_ContractBrowseDialog(this.tradeCast.frame, false, this.contractBarInterface, fp.getSize(), formName);
                contractBrowseDialog.setLocation(fp.getLocation());
                contractBrowseDialog.setVisible(true);
            } else {
                contractBrowseDialog.setVisible(true);
                contractBrowseDialog.toFront();
            }
        } else if (contractBrowseDialog == null) {
            contractBrowseDialog = new PMEX_ContractBrowseDialog(this.tradeCast.frame, false, this.contractBarInterface, new Dimension(600, 400), formName);
            contractBrowseDialog.setVisible(true);
        } else {
            contractBrowseDialog.setVisible(true);
            contractBrowseDialog.toFront();
        }
    }

    private void initComponents() {
        this.lblContractBrowse = new NxGLink("Contract Browse");
        this.lblContract = new JLabel();
        this.cbContract = new JComboBox();
        this.toolBar = new JToolBar();
        this.btnSave = new ToolBarArrowButton(5);
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
        this.setMinimumSize(new Dimension(10, 0));
        this.setPreferredSize(new Dimension(421, 30));
        this.lblContractBrowse.setFont(new Font("Tahoma", 1, 11));
        this.lblContractBrowse.setHorizontalAlignment(0);
        this.lblContractBrowse.setIcon(new ImageIcon(this.getClass().getResource("/Images/TC.png")));
        this.lblContractBrowse.setText("Contract Browse");
        this.lblContractBrowse.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                PMEX_ContractBar.this.lblContractBrowseMousePressed(evt);
            }
        });
        this.lblContract.setFont(new Font("Tahoma", 1, 11));
        this.lblContract.setIcon(new ImageIcon(this.getClass().getResource("/Images/search12.png")));
        this.lblContract.setText("Contract");
        this.lblContract.setHorizontalTextPosition(2);
        this.lblContract.setPreferredSize(new Dimension(65, 20));
        this.cbContract.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbContract.setOpaque(false);
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.btnSave.setIcon(new ImageIcon(this.getClass().getResource("/Images/save.png")));
        this.btnSave.setFocusable(false);
        this.btnSave.setHorizontalTextPosition(4);
        this.btnSave.setMaximumSize(new Dimension(100, 23));
        this.btnSave.setMinimumSize(new Dimension(100, 23));
        this.btnSave.setName("PMEX_ContractBar -> btnSave");
        this.btnSave.setVerticalTextPosition(3);
        this.toolBar.add(this.btnSave);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.lblContractBrowse, -2, 120, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblContract, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbContract, -2, 165, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 22, Short.MAX_VALUE).addComponent(this.toolBar, -2, -1, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblContractBrowse, -2, 20, -2).addComponent(this.lblContract, -2, -1, -2).addComponent(this.cbContract, -2, -1, -2)).addGap(5, 5, 5)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.toolBar, -2, 30, -2).addGap(0, 0, Short.MAX_VALUE)));
    }

    private void lblContractBrowseMousePressed(MouseEvent evt) {
        this.openContratBrowseWindow(this.formName);
    }

    public void addContract() {
        if (this.autoCom != null && this.autoCom.isInstalled()) {
            this.autoCom.uninstall();
        }
        ArrayList v = new ArrayList(LogsPMEX.PMEX_CONTRACT_ALL.keySet());
        Collections.sort(v);
        v.add(0, "Please Select a Contract");
        this.autoCom = AutoCompleteSupport.install((JComboBox)this.cbContract, (EventList)GlazedLists.eventListOf((Object[])v.toArray()));
        this.autoCom.setStrict(false);
        this.cbContract.setSelectedItem("Please Select a Contract");
        this.contractBarInterface.checkExpireContract();
        if (Mediator.getInstance().PMEX_Matrix != null) {
            Mediator.getInstance().PMEX_Matrix.checkExpireContract();
        }
        if (this.marketWatch != null) {
            this.marketWatch.PMEX_CONTRACT_ALL.putAll(LogsPMEX.PMEX_CONTRACT_ALL);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String contract;
        if (e.getSource() == this.btnQuantity) {
            if (this.contractBarInterface != null && this.btnQuantity.isVisible()) {
                this.contractBarInterface.showQuantity();
            }
        } else if (e.getSource() == this.cbContract && (e.getModifiers() == 16 || e.getActionCommand().equalsIgnoreCase("comboBoxEdited")) && this.cbContract.getSelectedItem() != null && !(contract = this.cbContract.getSelectedItem().toString()).equalsIgnoreCase("Please Select a Contract")) {
            if (UtilPMEX.isContractExpire((String)contract)) {
                JOptionPane.showMessageDialog((Component)this.marketWatch, "Invalid Contract", "Error", 0);
                return;
            }
            this.contractBarInterface.addContractToWatch(contract, false);
        }
    }
}

