/*
 * Decompiled with CFR 0.152.
 */
package windows.pmex.watches;

import CATALYST.Control.MarketFeed;
import CATALYST.Control.MarketWatch;
import CATALYST.Control.MarketWatchEvent;
import CATALYST.Control.Utilities;
import MyDocking.Mediator;
import common.gui.util.LogCommon;
import common.gui.util.MyColors;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pmex.gui.bean.PMEXMarketFeedBean;
import pmex.gui.util.LogsPMEX;
import windows.pmex.watches.PMEX_MyMarketWatch;

public class PMEX_MarketWatchPanel
extends JPanel {
    public JTabbedPane tabbedPane = null;
    public PMEX_MyMarketWatch MyMarketWatch1 = null;
    public PMEX_MyMarketWatch MyMarketWatch2 = null;
    public PMEX_MyMarketWatch MyMarketWatch3 = null;
    public String _1stProfile = "1st Profile";
    public String _2ndProfile = "2nd Profile";
    public String _3rdProfile = "3rd Profile";
    private JPanel Panel_1;
    private JPanel Panel_2;
    private JPanel Panel_3;
    private JScrollPane ScrollPane_1;
    private JScrollPane ScrollPane_2;
    private JScrollPane ScrollPane_3;
    public String tabName = this._1stProfile;
    private Mediator mediator;

    public PMEX_MarketWatchPanel() {
        this.initComponents();
        this.init();
        this.mediator = Mediator.getInstance();
        this.mediator.setPMEX_MarketWatchPanel(this);
    }

    public void init() {
        this.MyMarketWatch1 = new PMEX_MyMarketWatch(this, this._1stProfile);
        this.Panel_1 = new JPanel();
        this.Panel_1.setLayout(new BorderLayout());
        this.ScrollPane_1 = new JScrollPane();
        this.ScrollPane_1.getViewport().add(this.MyMarketWatch1);
        this.Panel_1.add((Component)this.ScrollPane_1, "Center");
        this.MyMarketWatch2 = new PMEX_MyMarketWatch(this, this._2ndProfile);
        this.Panel_2 = new JPanel();
        this.Panel_2.setLayout(new BorderLayout());
        this.ScrollPane_2 = new JScrollPane();
        this.ScrollPane_2.getViewport().add(this.MyMarketWatch2);
        this.Panel_2.add((Component)this.ScrollPane_2, "Center");
        this.MyMarketWatch3 = new PMEX_MyMarketWatch(this, this._3rdProfile);
        this.Panel_3 = new JPanel();
        this.Panel_3.setLayout(new BorderLayout());
        this.ScrollPane_3 = new JScrollPane();
        this.ScrollPane_3.getViewport().add(this.MyMarketWatch3);
        this.Panel_3.add((Component)this.ScrollPane_3, "Center");
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.add(this._1stProfile, this.Panel_1);
        this.tabbedPane.add(this._2ndProfile, this.Panel_2);
        this.tabbedPane.add(this._3rdProfile, this.Panel_3);
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.tabbedPane);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                PMEX_MarketWatchPanel.this.sendSymbolForFeed();
            }
        });
        String style = "PLAIN";
        if (LogCommon.MarketWatchFont.getStyle() == 1) {
            style = "BOLD";
        } else if (LogCommon.MarketWatchFont.getStyle() == 2) {
            style = "ITALIC";
        } else if (LogCommon.MarketWatchFont.getStyle() == 0) {
            style = "PLAIN";
        }
        this.MyMarketWatch1.Mwh.ChangeFont(LogCommon.MarketWatchFont.getFamily(), style, LogCommon.MarketWatchFont.getSize());
    }

    public MarketFeed GetSingleFeed(String contract, String Market) {
        MarketFeed MktFeed = null;
        String Key2 = contract + ";" + Market;
        if (this.MyMarketWatch1.Mwh.liveMarket.containsKey(Key2)) {
            MktFeed = (MarketFeed)this.MyMarketWatch1.Mwh.liveMarket.get(Key2);
        } else if (this.MyMarketWatch2.Mwh.liveMarket.containsKey(Key2)) {
            MktFeed = (MarketFeed)this.MyMarketWatch2.Mwh.liveMarket.get(Key2);
        } else if (this.MyMarketWatch3.Mwh.liveMarket.containsKey(Key2)) {
            MktFeed = (MarketFeed)this.MyMarketWatch3.Mwh.liveMarket.get(Key2);
        }
        return MktFeed;
    }

    public void SymbolChange(MarketWatchEvent event) {
        if (this.getSelectedTab().equalsIgnoreCase(this._1stProfile) && event.getSource() == this.MyMarketWatch1.Mwh) {
            LogsPMEX.SelectedSymbol = event.getmessage().split(":", -1)[0];
            LogsPMEX.SelectedMarket = event.getmessage().split(":", -1)[1];
            this.MyMarketWatch1.SetSymbol(event.getmessage().split(":", -1)[0]);
        } else if (this.getSelectedTab().equalsIgnoreCase(this._2ndProfile) && event.getSource() == this.MyMarketWatch2.Mwh) {
            LogsPMEX.SelectedSymbol = event.getmessage().split(":", -1)[0];
            LogsPMEX.SelectedMarket = event.getmessage().split(":", -1)[1];
            this.MyMarketWatch2.SetSymbol(event.getmessage().split(":", -1)[0]);
        } else if (this.getSelectedTab().equalsIgnoreCase(this._3rdProfile) && event.getSource() == this.MyMarketWatch3.Mwh) {
            LogsPMEX.SelectedSymbol = event.getmessage().split(":", -1)[0];
            LogsPMEX.SelectedMarket = event.getmessage().split(":", -1)[1];
            this.MyMarketWatch3.SetSymbol(event.getmessage().split(":", -1)[0]);
        }
    }

    public MarketWatch getSelectedMarketWatch() {
        if (this.getSelectedTab().equalsIgnoreCase(this._1stProfile)) {
            return this.MyMarketWatch1.Mwh;
        }
        if (this.getSelectedTab().equalsIgnoreCase(this._2ndProfile)) {
            return this.MyMarketWatch2.Mwh;
        }
        if (this.getSelectedTab().equalsIgnoreCase(this._3rdProfile)) {
            return this.MyMarketWatch3.Mwh;
        }
        return null;
    }

    public void sendSymbolForFeed() {
        this.mediator.sendFeedContract("", "PMEX MArket Watch : sendSymbolForFeed");
    }

    public String getSelectedTab() {
        return this.tabbedPane.getTitleAt(this.tabbedPane.getSelectedIndex());
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public void SetColumnToSave() {
        try {
            LogCommon.PMEX_Profile1Col = this.MyMarketWatch1.Mwh.getColumOrder();
            LogCommon.PMEX_Profile2Col = this.MyMarketWatch2.Mwh.getColumOrder();
            LogCommon.PMEX_Profile3Col = this.MyMarketWatch3.Mwh.getColumOrder();
        }
        catch (Exception e) {
            this.mediator.PrintLog(e, "");
        }
    }

    public void SetMWColumnFromFile() {
        try {
            this.MyMarketWatch1.Mwh.setColumOrder(LogCommon.PMEX_Profile1Col);
            this.MyMarketWatch2.Mwh.setColumOrder(LogCommon.PMEX_Profile2Col);
            this.MyMarketWatch3.Mwh.setColumOrder(LogCommon.PMEX_Profile3Col);
        }
        catch (Exception e) {
            this.mediator.PrintLog(e, "");
        }
    }

    public synchronized void feedReceived(String feed) {
        if (feed.indexOf("|") > 0) {
            String[] allFeeds = feed.split("\\|", -1);
            for (int i = 0; i < allFeeds.length; ++i) {
                String singleFeed = allFeeds[i];
                if (singleFeed.trim().length() <= 0) continue;
                PMEXMarketFeedBean bean = PMEXMarketFeedBean.parse((String)singleFeed);
                String tab = this.getSelectedTab();
                if (tab.equalsIgnoreCase(this._1stProfile)) {
                    this.MyMarketWatch1.Mwh.NotifyMKTFeedRecieved(bean.getKSEString());
                    continue;
                }
                if (tab.equalsIgnoreCase(this._2ndProfile)) {
                    this.MyMarketWatch2.Mwh.NotifyMKTFeedRecieved(bean.getKSEString());
                    continue;
                }
                if (!tab.equalsIgnoreCase(this._3rdProfile)) continue;
                this.MyMarketWatch3.Mwh.NotifyMKTFeedRecieved(bean.getKSEString());
            }
        }
    }

    public void AddContractInWatch(String str) {
        this.tabName = this.tabbedPane.getTitleAt(this.tabbedPane.getSelectedIndex());
        if (this.tabName.equalsIgnoreCase(this._1stProfile)) {
            this.MyMarketWatch1.addContractToWatch(str, false);
        } else if (this.tabName.equalsIgnoreCase(this._2ndProfile)) {
            this.MyMarketWatch2.addContractToWatch(str, false);
        } else if (this.tabName.equalsIgnoreCase(this._3rdProfile)) {
            this.MyMarketWatch3.addContractToWatch(str, false);
        }
    }

    public void SetAllWatchFonts(Font F) {
        String style = "PLAIN";
        if (F.getStyle() == 1) {
            style = "BOLD";
        } else if (F.getStyle() == 2) {
            style = "ITALIC";
        } else if (F.getStyle() == 0) {
            style = "PLAIN";
        }
        if (this.MyMarketWatch1 != null) {
            this.MyMarketWatch1.Mwh.ChangeFont(F.getFamily(), style, F.getSize());
            this.MyMarketWatch1.Mwh.setRowBackGroundColor(MyColors.MarketWatchRowColor);
            this.MyMarketWatch1.Mwh.SetSelectedrowColor(MyColors.MarketWatchSelectedRowColor);
            this.MyMarketWatch1.Mwh.ChangeIncreaseColor(MyColors.MarketWatchIncreaseColor);
            this.MyMarketWatch1.Mwh.ChangeDecreaseColor(MyColors.MarketWatchDecreaseColor);
        }
        if (this.MyMarketWatch2 != null) {
            this.MyMarketWatch2.Mwh.ChangeFont(F.getFamily(), style, F.getSize());
            this.MyMarketWatch2.Mwh.setRowBackGroundColor(MyColors.MarketWatchRowColor);
            this.MyMarketWatch2.Mwh.SetSelectedrowColor(MyColors.MarketWatchSelectedRowColor);
            this.MyMarketWatch2.Mwh.ChangeIncreaseColor(MyColors.MarketWatchIncreaseColor);
            this.MyMarketWatch2.Mwh.ChangeDecreaseColor(MyColors.MarketWatchDecreaseColor);
        }
        if (this.MyMarketWatch3 != null) {
            this.MyMarketWatch3.Mwh.ChangeFont(F.getFamily(), style, F.getSize());
            this.MyMarketWatch3.Mwh.setRowBackGroundColor(MyColors.MarketWatchRowColor);
            this.MyMarketWatch3.Mwh.SetSelectedrowColor(MyColors.MarketWatchSelectedRowColor);
            this.MyMarketWatch3.Mwh.ChangeIncreaseColor(MyColors.MarketWatchIncreaseColor);
            this.MyMarketWatch3.Mwh.ChangeDecreaseColor(MyColors.MarketWatchDecreaseColor);
        }
    }

    public void SymbolRemove(MarketWatchEvent event) {
        if (event.getSource() == this.MyMarketWatch1.Mwh) {
            this.MyMarketWatch1.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0], Utilities.split((String)event.getmessage(), (char)':')[1]);
        } else if (event.getSource() == this.MyMarketWatch2.Mwh) {
            this.MyMarketWatch2.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0], Utilities.split((String)event.getmessage(), (char)':')[1]);
        } else if (event.getSource() == this.MyMarketWatch3.Mwh) {
            this.MyMarketWatch3.SymbolRemove(Utilities.split((String)event.getmessage(), (char)':')[0], Utilities.split((String)event.getmessage(), (char)':')[1]);
        }
    }
}

